/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.trinketsandbaubles.capability.mana.hud;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.jinqinxixi.trinketsandbaubles.config.ModConfig;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Quaternionf;

@OnlyIn(value=Dist.CLIENT)
public class ManaHudOverlay {
    private static final ResourceLocation GUI_ICONS_LOCATION = new ResourceLocation("trinketsandbaubles", "textures/gui/mana_gui.png");
    private boolean initialSyncReceived = false;
    private float cachedMana = -1.0f;
    private float cachedMaxMana = -1.0f;
    private static ManaHudOverlay instance;
    private boolean isVertical = false;
    public boolean canDrag = false;
    private double currentX = -1.0;
    private double currentY = -1.0;
    private double dragOffsetX;
    private double dragOffsetY;
    private boolean isFollowingMouse = false;
    private static final int HORIZONTAL_BAR_WIDTH = 182;
    private static final int HORIZONTAL_BAR_HEIGHT = 5;
    private static final int VERTICAL_BAR_WIDTH = 5;
    private static final int VERTICAL_BAR_HEIGHT = 182;
    private static final Gson GSON;

    private boolean shouldShowManaHud() {
        if (!this.initialSyncReceived) {
            return false;
        }
        try {
            if (((Boolean)ModConfig.USE_IRONS_SPELLS_MANA.get()).booleanValue() && Class.forName("io.redspace.ironsspellbooks.api.magic.MagicData") != null) {
                return false;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return true;
    }

    public static ManaHudOverlay getInstance() {
        if (instance == null) {
            instance = new ManaHudOverlay();
        }
        return instance;
    }

    private ManaHudOverlay() {
        this.loadConfig();
    }

    public void handleEscapeKey() {
        if (this.canDrag) {
            this.toggleDragMode();
        }
    }

    private void saveConfig() {
        HudConfig config = new HudConfig();
        config.x = this.currentX;
        config.y = this.currentY;
        config.vertical = this.isVertical;
        File configFile = new File("config/trinketsandbaubles_mana_hud.json");
        try {
            configFile.getParentFile().mkdirs();
            try (FileWriter writer = new FileWriter(configFile);){
                GSON.toJson((Object)config, (Appendable)writer);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void loadConfig() {
        File configFile = new File("config/trinketsandbaubles_mana_hud.json");
        if (configFile.exists()) {
            try (FileReader reader = new FileReader(configFile);){
                HudConfig config = (HudConfig)GSON.fromJson((Reader)reader, HudConfig.class);
                if (config != null) {
                    this.currentX = config.x;
                    this.currentY = config.y;
                    this.isVertical = config.vertical;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void toggleDragMode() {
        this.canDrag = !this.canDrag;
        this.isFollowingMouse = false;
        Minecraft minecraft = Minecraft.m_91087_();
        if (this.canDrag) {
            minecraft.f_91067_.m_91602_();
        } else {
            minecraft.f_91067_.m_91601_();
            this.saveConfig();
        }
        if (minecraft.f_91074_ != null) {
            MutableComponent message = Component.m_237115_((String)(this.canDrag ? "message.trinketsandbaubles.mana_hud.drag_mode.enabled" : "message.trinketsandbaubles.mana_hud.drag_mode.disabled")).m_130940_(this.canDrag ? ChatFormatting.GREEN : ChatFormatting.RED);
            minecraft.f_91074_.m_5661_((Component)message, true);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        boolean isOver;
        if (!this.canDrag) {
            return false;
        }
        int currentWidth = this.isVertical ? 5 : 182;
        int currentHeight = this.isVertical ? 182 : 5;
        boolean bl = isOver = mouseX >= this.currentX && mouseX <= this.currentX + (double)currentWidth && mouseY >= this.currentY && mouseY <= this.currentY + (double)currentHeight;
        if (isOver || this.isFollowingMouse) {
            if (button == 0) {
                boolean bl2 = this.isFollowingMouse = !this.isFollowingMouse;
                if (this.isFollowingMouse) {
                    this.dragOffsetX = mouseX - this.currentX;
                    this.dragOffsetY = mouseY - this.currentY;
                }
            } else if (button == 1) {
                boolean wasFollowing = this.isFollowingMouse;
                double relativeX = (mouseX - this.currentX) / (double)currentWidth;
                double relativeY = (mouseY - this.currentY) / (double)currentHeight;
                this.isVertical = !this.isVertical;
                int newWidth = this.isVertical ? 5 : 182;
                int newHeight = this.isVertical ? 182 : 5;
                double centerX = this.currentX + (double)currentWidth / 2.0;
                double centerY = this.currentY + (double)currentHeight / 2.0;
                this.currentX = centerX - (double)newWidth / 2.0;
                this.currentY = centerY - (double)newHeight / 2.0;
                this.isFollowingMouse = wasFollowing;
                if (this.isFollowingMouse) {
                    double newMouseX = this.currentX + relativeX * (double)newWidth;
                    double newMouseY = this.currentY + relativeY * (double)newHeight;
                    this.dragOffsetX = newMouseX - this.currentX;
                    this.dragOffsetY = newMouseY - this.currentY;
                    this.mouseDragged(mouseX, mouseY);
                }
            }
            return true;
        }
        if (button == 0) {
            this.isFollowingMouse = false;
        }
        return false;
    }

    public boolean mouseDragged(double mouseX, double mouseY) {
        if (!this.canDrag || !this.isFollowingMouse) {
            return false;
        }
        double newX = mouseX - this.dragOffsetX;
        double newY = mouseY - this.dragOffsetY;
        Window window = Minecraft.m_91087_().m_91268_();
        int screenWidth = window.m_85445_();
        int screenHeight = window.m_85446_();
        int currentWidth = this.isVertical ? 5 : 182;
        int currentHeight = this.isVertical ? 182 : 5;
        this.currentX = Math.max(0.0, Math.min(newX, (double)(screenWidth - currentWidth)));
        this.currentY = Math.max(0.0, Math.min(newY, (double)(screenHeight - currentHeight)));
        return true;
    }

    public void render(GuiGraphics guiGraphics) {
        float scaledY;
        float scaledX;
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91074_ == null || !this.initialSyncReceived) {
            return;
        }
        if (!this.shouldShowManaHud() && !this.canDrag) {
            return;
        }
        if (this.cachedMana >= this.cachedMaxMana && !this.canDrag) {
            return;
        }
        int TEXTURE_WIDTH = 182;
        int TEXTURE_HEIGHT = 10;
        Window window = minecraft.m_91268_();
        int screenWidth = window.m_85445_();
        int screenHeight = window.m_85446_();
        if (this.currentX == -1.0 || this.currentY == -1.0) {
            this.currentX = screenWidth / 2 - 91;
            this.currentY = screenHeight - 50;
        }
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        int renderX = (int)Math.round(this.currentX);
        int renderY = (int)Math.round(this.currentY);
        if (!this.isVertical) {
            if (this.canDrag) {
                guiGraphics.m_280509_(renderX - 1, renderY - 1, renderX + 182 + 1, renderY + 5 + 1, -2130706433);
            }
            guiGraphics.m_280163_(GUI_ICONS_LOCATION, renderX, renderY, 0.0f, 0.0f, 182, 5, 182, 10);
            if (this.cachedMana > 0.0f) {
                manaWidth = (int)(this.cachedMana / this.cachedMaxMana * 182.0f);
                guiGraphics.m_280163_(GUI_ICONS_LOCATION, renderX, renderY, 0.0f, 5.0f, manaWidth, 5, 182, 10);
            }
        } else {
            if (this.canDrag) {
                guiGraphics.m_280509_(renderX - 1, renderY - 1, renderX + 5 + 1, renderY + 182 + 1, -2130706433);
            }
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_252880_((float)renderX, (float)(renderY + 182), 0.0f);
            guiGraphics.m_280168_().m_252781_(new Quaternionf().rotationZ(-1.5707964f));
            guiGraphics.m_280163_(GUI_ICONS_LOCATION, 0, 0, 0.0f, 0.0f, 182, 5, 182, 10);
            if (this.cachedMana > 0.0f) {
                manaWidth = (int)(this.cachedMana / this.cachedMaxMana * 182.0f);
                guiGraphics.m_280163_(GUI_ICONS_LOCATION, 0, 0, 0.0f, 5.0f, manaWidth, 5, 182, 10);
            }
            guiGraphics.m_280168_().m_85849_();
        }
        String manaText = String.format("%.1f/%.1f", Float.valueOf(this.cachedMana), Float.valueOf(this.cachedMaxMana));
        float scale = 0.75f;
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_85841_(scale, scale, 1.0f);
        if (!this.isVertical) {
            scaledX = ((float)(renderX + 91) - (float)minecraft.f_91062_.m_92895_(manaText) * scale / 2.0f) / scale;
            scaledY = (float)(renderY + 5 + 5) / scale;
        } else {
            scaledX = ((float)(renderX + 2) - (float)minecraft.f_91062_.m_92895_(manaText) * scale / 2.0f) / scale;
            scaledY = (float)(renderY + 182 + 5) / scale;
        }
        guiGraphics.m_280056_(minecraft.f_91062_, manaText, (int)scaledX, (int)scaledY, -14840076, true);
        guiGraphics.m_280168_().m_85849_();
        if (this.canDrag) {
            MutableComponent statusText = Component.m_237115_((String)"message.trinketsandbaubles.mana_hud.drag_mode.tooltip").m_130940_(ChatFormatting.GREEN);
            int textX = 5;
            int textY = 5;
            int padding = 2;
            int n = textX + minecraft.f_91062_.m_92852_((FormattedText)statusText) + padding;
            Objects.requireNonNull(minecraft.f_91062_);
            guiGraphics.m_280509_(textX - padding, textY - padding, n, textY + 9 + padding, Integer.MIN_VALUE);
            guiGraphics.m_280614_(minecraft.f_91062_, (Component)statusText, textX, textY, 0xFFFFFF, true);
        }
        RenderSystem.disableBlend();
    }

    public void updateManaData(float mana, float maxMana) {
        this.cachedMana = mana;
        this.cachedMaxMana = maxMana;
        this.initialSyncReceived = true;
    }

    public void reset() {
        this.initialSyncReceived = false;
        this.cachedMana = -1.0f;
        this.cachedMaxMana = -1.0f;
    }

    static {
        GSON = new GsonBuilder().setPrettyPrinting().create();
    }

    private static class HudConfig {
        double x = -1.0;
        double y = -1.0;
        boolean vertical = false;

        private HudConfig() {
        }
    }
}

