/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.trinketsandbaubles.capability.network;

import com.jinqinxixi.trinketsandbaubles.capability.api.IBaseRaceCapability;
import com.jinqinxixi.trinketsandbaubles.capability.network.ClientPacketHandler;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class SyncRaceCapabilityPacket {
    private final String raceId;
    private final boolean isActive;
    private final float scaleFactor;

    public SyncRaceCapabilityPacket(IBaseRaceCapability capability) {
        this.raceId = capability.getRaceId();
        this.isActive = capability.isActive();
        this.scaleFactor = capability.getScaleFactor();
    }

    public SyncRaceCapabilityPacket(FriendlyByteBuf buf) {
        this.raceId = buf.m_130277_();
        this.isActive = buf.readBoolean();
        this.scaleFactor = buf.readFloat();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130070_(this.raceId);
        buf.writeBoolean(this.isActive);
        buf.writeFloat(this.scaleFactor);
    }

    public static SyncRaceCapabilityPacket decode(FriendlyByteBuf buf) {
        return new SyncRaceCapabilityPacket(buf);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientPacketHandler.handlePacket(this)));
        ctx.get().setPacketHandled(true);
    }

    public String getRaceId() {
        return this.raceId;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public float getScaleFactor() {
        return this.scaleFactor;
    }
}

