/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.trinketsandbaubles.client.renderer;

import com.jinqinxixi.trinketsandbaubles.config.ModConfig;
import com.jinqinxixi.trinketsandbaubles.util.ScanSystem;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class DragonsEyeRenderer {
    private static final RenderType XRAY_LINES = RenderType.m_173215_((String)"xray_lines", (VertexFormat)DefaultVertexFormat.f_166851_, (VertexFormat.Mode)VertexFormat.Mode.DEBUG_LINES, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(new RenderStateShard.ShaderStateShard(GameRenderer::m_172811_)).m_110669_(new RenderStateShard.LayeringStateShard("no_layering", () -> {
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
    }, () -> {
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)true);
    })).m_110685_(new RenderStateShard.TransparencyStateShard("translucent_transparency", () -> {
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
    }, () -> {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    })).m_110675_(new RenderStateShard.OutputStateShard("outline_target", () -> {}, () -> {})).m_110691_(false));

    public static void onRenderWorld(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        ArrayList<BlockPos> targets = new ArrayList<BlockPos>();
        CompoundTag data = player.getPersistentData();
        if (data.m_128441_("Targets")) {
            ListTag targetsList = data.m_128437_("Targets", 10);
            for (int i = 0; i < targetsList.size(); ++i) {
                CompoundTag posTag = targetsList.m_128728_(i);
                targets.add(new BlockPos(posTag.m_128451_("X"), posTag.m_128451_("Y"), posTag.m_128451_("Z")));
            }
        }
        if (!targets.isEmpty()) {
            DragonsEyeRenderer.renderCustomOutlines(event.getPoseStack(), (Player)player, targets);
        }
    }

    private static void renderCustomOutlines(PoseStack poseStack, Player player, List<BlockPos> positions) {
        MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
        VertexConsumer lines = buffer.m_6299_(XRAY_LINES);
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        RenderSystem.setShader(GameRenderer::m_172811_);
        RenderSystem.lineWidth((float)3.0f);
        poseStack.m_85836_();
        Camera camera = Minecraft.m_91087_().f_91063_.m_109153_();
        Vec3 cameraPos = camera.m_90583_();
        poseStack.m_85837_(-cameraPos.f_82479_, -cameraPos.f_82480_, -cameraPos.f_82481_);
        Matrix4f pose = poseStack.m_85850_().m_252922_();
        int maxRender = (Integer)ModConfig.MAX_RENDER_BLOCKS.get();
        int rangeSqr = (Integer)ModConfig.RENDER_RANGE.get() * (Integer)ModConfig.RENDER_RANGE.get();
        positions.stream().filter(pos -> player.m_20183_().m_123331_((Vec3i)pos) <= (double)rangeSqr).sorted(Comparator.comparingDouble(pos -> player.m_20183_().m_123331_((Vec3i)pos))).limit(maxRender).forEach(pos -> {
            AABB box = new AABB(pos).m_82400_(0.001);
            double distance = Math.sqrt(player.m_20183_().m_123331_((Vec3i)pos));
            int adjustedAlpha = Math.max(96, (int)(255.0 * (1.0 - distance / Math.sqrt(rangeSqr))));
            DragonsEyeRenderer.renderBox(lines, pose, box, player, adjustedAlpha);
        });
        poseStack.m_85849_();
        buffer.m_109912_(XRAY_LINES);
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.lineWidth((float)1.0f);
    }

    private static void renderBox(VertexConsumer consumer, Matrix4f pose, AABB box, Player player, int alpha) {
        int[] colors = ScanSystem.getColorForGroup(ScanSystem.getOreGroupIndex(player), ScanSystem.isTargetMode(player));
        DragonsEyeRenderer.drawBoxWithDoublePass(consumer, pose, box, colors[0], colors[1], colors[2], alpha);
    }

    private static void drawBoxWithDoublePass(VertexConsumer consumer, Matrix4f pose, AABB box, int r, int g, int b, int alpha) {
        DragonsEyeRenderer.drawBoxLines(consumer, pose, box.m_82400_(0.002), r, g, b, alpha, 0.0f);
        float innerAlpha = (float)alpha * 0.5f;
        DragonsEyeRenderer.drawBoxLines(consumer, pose, box, (int)((double)r * 0.7), (int)((double)g * 0.7), (int)((double)b * 0.7), (int)innerAlpha, 0.0f);
    }

    private static void drawBoxLines(VertexConsumer consumer, Matrix4f pose, AABB box, int r, int g, int b, int alpha, float offset) {
        DragonsEyeRenderer.drawLine(consumer, pose, box.f_82288_, box.f_82289_, box.f_82290_, box.f_82291_, box.f_82289_, box.f_82290_, r, g, b, alpha, offset);
        DragonsEyeRenderer.drawLine(consumer, pose, box.f_82291_, box.f_82289_, box.f_82290_, box.f_82291_, box.f_82289_, box.f_82293_, r, g, b, alpha, offset);
        DragonsEyeRenderer.drawLine(consumer, pose, box.f_82291_, box.f_82289_, box.f_82293_, box.f_82288_, box.f_82289_, box.f_82293_, r, g, b, alpha, offset);
        DragonsEyeRenderer.drawLine(consumer, pose, box.f_82288_, box.f_82289_, box.f_82293_, box.f_82288_, box.f_82289_, box.f_82290_, r, g, b, alpha, offset);
        DragonsEyeRenderer.drawLine(consumer, pose, box.f_82288_, box.f_82292_, box.f_82290_, box.f_82291_, box.f_82292_, box.f_82290_, r, g, b, alpha, offset);
        DragonsEyeRenderer.drawLine(consumer, pose, box.f_82291_, box.f_82292_, box.f_82290_, box.f_82291_, box.f_82292_, box.f_82293_, r, g, b, alpha, offset);
        DragonsEyeRenderer.drawLine(consumer, pose, box.f_82291_, box.f_82292_, box.f_82293_, box.f_82288_, box.f_82292_, box.f_82293_, r, g, b, alpha, offset);
        DragonsEyeRenderer.drawLine(consumer, pose, box.f_82288_, box.f_82292_, box.f_82293_, box.f_82288_, box.f_82292_, box.f_82290_, r, g, b, alpha, offset);
        DragonsEyeRenderer.drawLine(consumer, pose, box.f_82288_, box.f_82289_, box.f_82290_, box.f_82288_, box.f_82292_, box.f_82290_, r, g, b, alpha, offset);
        DragonsEyeRenderer.drawLine(consumer, pose, box.f_82291_, box.f_82289_, box.f_82290_, box.f_82291_, box.f_82292_, box.f_82290_, r, g, b, alpha, offset);
        DragonsEyeRenderer.drawLine(consumer, pose, box.f_82291_, box.f_82289_, box.f_82293_, box.f_82291_, box.f_82292_, box.f_82293_, r, g, b, alpha, offset);
        DragonsEyeRenderer.drawLine(consumer, pose, box.f_82288_, box.f_82289_, box.f_82293_, box.f_82288_, box.f_82292_, box.f_82293_, r, g, b, alpha, offset);
    }

    private static void drawLine(VertexConsumer consumer, Matrix4f pose, double x1, double y1, double z1, double x2, double y2, double z2, int r, int g, int b, int alpha, float offset) {
        Vec3 normal = new Vec3(x2 - x1, y2 - y1, z2 - z1).m_82541_();
        int lightValue = 0xF000F0;
        consumer.m_252986_(pose, (float)x1 + offset * (float)normal.f_82479_, (float)y1 + offset * (float)normal.f_82480_, (float)z1 + offset * (float)normal.f_82481_).m_6122_(r, g, b, alpha).m_7120_(lightValue, lightValue).m_5601_((float)normal.f_82479_, (float)normal.f_82480_, (float)normal.f_82481_).m_5752_();
        consumer.m_252986_(pose, (float)x2 + offset * (float)normal.f_82479_, (float)y2 + offset * (float)normal.f_82480_, (float)z2 + offset * (float)normal.f_82481_).m_6122_(r, g, b, alpha).m_7120_(lightValue, lightValue).m_5601_((float)normal.f_82479_, (float)normal.f_82480_, (float)normal.f_82481_).m_5752_();
    }
}

