/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.trinketsandbaubles.config;

import com.jinqinxixi.trinketsandbaubles.TrinketsandBaublesMod;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;

@Mod.EventBusSubscriber(modid="trinketsandbaubles", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModConfig {
    public static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec SPEC;
    private static final String BAUBLES_REFORKED_MOD_ID = "baublesreforked";
    private static boolean baublesReforkedLoaded;
    public static final ForgeConfigSpec.BooleanValue MODIFIER_ENABLED;
    public static final ForgeConfigSpec.IntValue ANVIL_RECAST_EXP_COST;
    public static final ForgeConfigSpec.IntValue ANVIL_RECAST_MATERIAL_COST;
    public static final ForgeConfigSpec.IntValue DEFAULT_MAX_MANA;
    public static final ForgeConfigSpec.IntValue MANA_REGEN_COOLDOWN;
    public static final ForgeConfigSpec.IntValue MANA_REGEN_RATE;
    public static final ForgeConfigSpec.IntValue MANA_REGEN_INTERVAL;
    public static final ForgeConfigSpec.IntValue CREATIVE_REGEN_RATE;
    public static final ForgeConfigSpec.BooleanValue USE_IRONS_SPELLS_MANA;
    public static final ForgeConfigSpec.BooleanValue USE_BOTANIA_MANA;
    public static final ForgeConfigSpec.DoubleValue SPEED_BOOST;
    public static final ForgeConfigSpec.DoubleValue CHARGE_RATE;
    public static final ForgeConfigSpec.DoubleValue MIN_CHARGE;
    public static final ForgeConfigSpec.DoubleValue MAX_CHARGE;
    public static final ForgeConfigSpec.DoubleValue DAMAGE_MULTIPLIER;
    public static final ForgeConfigSpec.DoubleValue DASH_DISTANCE;
    public static final ForgeConfigSpec.IntValue DASH_COOLDOWN;
    public static final ForgeConfigSpec.DoubleValue DASH_MANA_COST;
    public static final ForgeConfigSpec.DoubleValue DASH_JUMP_BOOST;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> VALUABLE_ORES;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> COMMON_ORES;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> REDSTONE_ORES;
    public static ForgeConfigSpec.IntValue MAX_RENDER_BLOCKS;
    public static ForgeConfigSpec.IntValue RENDER_RANGE;
    public static final ForgeConfigSpec.DoubleValue ENDERMAN_FOLLOW_RANGE;
    public static final ForgeConfigSpec.DoubleValue DAMAGE_IMMUNITY_CHANCE;
    public static final ForgeConfigSpec.DoubleValue TELEPORT_RANGE;
    public static final ForgeConfigSpec.BooleanValue WATER_DAMAGE_ENABLED;
    public static final ForgeConfigSpec.DoubleValue FAELIS_CLAW_DAMAGE_BOOST;
    public static final ForgeConfigSpec.DoubleValue FAELIS_CLAW_BLEED_CHANCE;
    public static final ForgeConfigSpec.IntValue FAELIS_CLAW_BLEED_DURATION;
    public static final ForgeConfigSpec.DoubleValue FAELIS_CLAW_NORMAL_DURATION_MULTIPLIER;
    public static final ForgeConfigSpec.IntValue MANA_CANDY_RESTORE;
    public static final ForgeConfigSpec.IntValue MANA_CRYSTAL_MAX_INCREASE;
    public static final ForgeConfigSpec.IntValue MANA_REAGENT_MAX_DECREASE;
    public static final ForgeConfigSpec.DoubleValue POISON_STONE_CHANCE;
    public static final ForgeConfigSpec.IntValue POISON_STONE_DURATION;
    public static final ForgeConfigSpec.IntValue POISON_STONE_AMPLIFIER;
    public static final ForgeConfigSpec.DoubleValue POISON_STONE_DAMAGE_MULTIPLIER;
    public static final ForgeConfigSpec.BooleanValue POISON_STONE_ACTIVATE_DAMAGE_EVENT;
    public static final ForgeConfigSpec.DoubleValue POLARIZED_STONE_ATTRACTION_RANGE;
    public static final ForgeConfigSpec.DoubleValue POLARIZED_STONE_ATTRACTION_SPEED;
    public static final ForgeConfigSpec.DoubleValue POLARIZED_STONE_DEFLECTION_RANGE;
    public static final ForgeConfigSpec.DoubleValue POLARIZED_STONE_DEFLECTION_MANA_COST;
    public static final ForgeConfigSpec.IntValue SHIELD_MAX_DAMAGE_COUNT;
    public static final ForgeConfigSpec.DoubleValue SHIELD_DAMAGE_REDUCTION;
    public static final ForgeConfigSpec.DoubleValue SHIELD_EXPLOSION_REDUCTION;
    public static ForgeConfigSpec.BooleanValue ENABLE_DAMAGE_SHIELD_EFFECT;
    public static ForgeConfigSpec.DoubleValue DAMAGE_SHIELD_TRIGGER_CHANCE;
    public static final ForgeConfigSpec.DoubleValue GREATER_INERTIA_KNOCKBACK_RESISTANCE;
    public static final ForgeConfigSpec.DoubleValue GREATER_INERTIA_MOVEMENT_SPEED;
    public static final ForgeConfigSpec.DoubleValue GREATER_INERTIA_JUMP_BOOST;
    public static final ForgeConfigSpec.DoubleValue GREATER_INERTIA_FALL_REDUCTION;
    public static final ForgeConfigSpec.DoubleValue GREATER_INERTIA_STEP_HEIGHT;
    public static final ForgeConfigSpec.DoubleValue WITHER_RING_CHANCE;
    public static final ForgeConfigSpec.IntValue WITHER_RING_DURATION;
    public static final ForgeConfigSpec.IntValue WITHER_RING_AMPLIFIER;
    public static final ForgeConfigSpec.ConfigValue<String> DESERT_PYRAMID_LOOT;
    public static final ForgeConfigSpec.ConfigValue<String> JUNGLE_TEMPLE_LOOT;
    public static final ForgeConfigSpec.ConfigValue<String> ABANDONED_MINESHAFT_LOOT;
    public static final ForgeConfigSpec.ConfigValue<String> STRONGHOLD_LIBRARY_LOOT;
    public static final ForgeConfigSpec.ConfigValue<String> WOODLAND_MANSION_LOOT;
    public static final ForgeConfigSpec.ConfigValue<String> VILLAGE_TEMPLE_LOOT;
    public static final ForgeConfigSpec.ConfigValue<String> SHIPWRECK_TREASURE_LOOT;
    public static final ForgeConfigSpec.ConfigValue<String> PILLAGER_OUTPOST_LOOT;
    public static final ForgeConfigSpec.ConfigValue<String> BURIED_TREASURE_LOOT;
    public static final ForgeConfigSpec.ConfigValue<String> UNDERWATER_RUIN_BIG_LOOT;
    public static final ForgeConfigSpec.ConfigValue<String> UNDERWATER_RUIN_SMALL_LOOT;
    public static final ForgeConfigSpec.ConfigValue<String> IGLOO_CHEST_LOOT;
    public static final ForgeConfigSpec.ConfigValue<String> BASTION_TREASURE_LOOT;
    public static final ForgeConfigSpec.ConfigValue<String> BASTION_BRIDGE_LOOT;
    public static final ForgeConfigSpec.ConfigValue<String> BASTION_HOUSING_LOOT;
    public static final ForgeConfigSpec.ConfigValue<String> BASTION_OTHER_LOOT;
    public static final ForgeConfigSpec.ConfigValue<String> RUINED_PORTAL_LOOT;
    public static final ForgeConfigSpec.ConfigValue<String> END_CITY_LOOT;
    public static final ForgeConfigSpec.ConfigValue<String> ANCIENT_CITY_LOOT;
    public static final ForgeConfigSpec.ConfigValue<String> SIMPLE_DUNGEON_LOOT;
    public static final ForgeConfigSpec.ConfigValue<String> STRONGHOLD_CORRIDOR_LOOT;
    public static final ForgeConfigSpec.ConfigValue<String> FOSSIL_DINOSAUR_LOOT;
    public static final ForgeConfigSpec.ConfigValue<String> FOSSIL_MAMMAL_LOOT;
    public static final ForgeConfigSpec.ConfigValue<String> SHIPWRECK_SUPPLY_LOOT;
    public static final ForgeConfigSpec.ConfigValue<String> WOODLAND_CARTOGRAPHY_LOOT;
    public static final ForgeConfigSpec.ConfigValue<String> STRONGHOLD_CROSSING_LOOT;
    public static final ForgeConfigSpec.ConfigValue<String> SHIPWRECK_MAP_LOOT;
    public static final ForgeConfigSpec.ConfigValue<String> VILLAGE_ARMORER_LOOT;
    public static final ForgeConfigSpec.ConfigValue<String> VILLAGE_BUTCHER_LOOT;
    public static final ForgeConfigSpec.ConfigValue<String> VILLAGE_CARTOGRAPHER_LOOT;
    public static final ForgeConfigSpec.ConfigValue<String> VILLAGE_PLAINS_HOUSE_LOOT;
    public static final ForgeConfigSpec.ConfigValue<String> VILLAGE_FISHER_LOOT;
    public static final ForgeConfigSpec.ConfigValue<String> VILLAGE_FLETCHER_LOOT;
    public static final ForgeConfigSpec.ConfigValue<String> VILLAGE_TANNERY_LOOT;
    public static final ForgeConfigSpec.ConfigValue<String> VILLAGE_LIBRARY_LOOT;
    public static final ForgeConfigSpec.ConfigValue<String> VILLAGE_MASON_LOOT;
    public static final ForgeConfigSpec.ConfigValue<String> VILLAGE_SHEPHERD_LOOT;
    public static final ForgeConfigSpec.ConfigValue<String> VILLAGE_TOOLSMITH_LOOT;
    public static final ForgeConfigSpec.ConfigValue<String> VILLAGE_WEAPONSMITH_LOOT;
    public static final ForgeConfigSpec.ConfigValue<String> VILLAGE_DESERT_HOUSE_LOOT;
    public static final ForgeConfigSpec.ConfigValue<String> VILLAGE_SNOWY_HOUSE_LOOT;
    public static final ForgeConfigSpec.ConfigValue<String> VILLAGE_SAVANNA_HOUSE_LOOT;
    public static final ForgeConfigSpec.ConfigValue<String> VILLAGE_TAIGA_HOUSE_LOOT;
    private static final Map<ResourceLocation, ForgeConfigSpec.ConfigValue<String>> LOOT_MAPPING;
    public static Map<ResourceLocation, List<LootEntry>> lootConfig;

    private ForgeConfigSpec.ConfigValue<String> defineLoot(ForgeConfigSpec.Builder builder, String configKey, String structureId, String comment, String defaultValue) {
        return builder.comment(comment + "\n\u683c\u5f0f\uff1a\u7269\u54c1ID,\u6743\u91cd,\u6700\u5c0f\u6570\u91cf,\u6700\u5927\u6570\u91cf\uff08\u591a\u4e2a\u6761\u76ee\u7528\u5206\u53f7\u5206\u9694\uff09\n\u7ed3\u6784ID\uff1a" + structureId).define(configKey + "Loot", (Object)defaultValue);
    }

    public static void loadLootConfig() {
        lootConfig.clear();
        LOOT_MAPPING.forEach((tableId, config) -> {
            String value = (String)config.get();
            if (value.isEmpty()) {
                return;
            }
            List<LootEntry> entries = ModConfig.parseLootEntries(value);
            if (!entries.isEmpty()) {
                lootConfig.put((ResourceLocation)tableId, entries);
            }
        });
    }

    private static List<LootEntry> parseLootEntries(String configValue) {
        ArrayList<LootEntry> entries = new ArrayList<LootEntry>();
        for (String entry : configValue.split(";")) {
            String[] parts = entry.split(",");
            if (parts.length != 4) {
                TrinketsandBaublesMod.LOGGER.warn("Invalid loot entry format: {}", (Object)entry);
                continue;
            }
            try {
                ResourceLocation itemId = new ResourceLocation(parts[0].trim());
                entries.add(new LootEntry(itemId, Integer.parseInt(parts[1].trim()), Integer.parseInt(parts[2].trim()), Integer.parseInt(parts[3].trim())));
            }
            catch (Exception e) {
                TrinketsandBaublesMod.LOGGER.error("Invalid loot entry: {}", (Object)entry, (Object)e);
            }
        }
        return entries;
    }

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading configEvent) {
        if (configEvent.getConfig().getModId().equals("trinketsandbaubles")) {
            TrinketsandBaublesMod.LOGGER.info("Loaded Trinkets and Baubles config file {}", (Object)configEvent.getConfig().getFileName());
            ModConfig.loadLootConfig();
        }
    }

    @SubscribeEvent
    public static void onReload(ModConfigEvent.Reloading configEvent) {
        if (configEvent.getConfig().getModId().equals("trinketsandbaubles")) {
            TrinketsandBaublesMod.LOGGER.debug("Trinkets and Baubles config reloaded!");
            ModConfig.loadLootConfig();
        }
    }

    public static boolean isModifierEnabled() {
        return (Boolean)MODIFIER_ENABLED.get();
    }

    public static int getAnvilRecastExpCost() {
        return (Integer)ANVIL_RECAST_EXP_COST.get();
    }

    public static int getAnvilRecastMaterialCost() {
        return (Integer)ANVIL_RECAST_MATERIAL_COST.get();
    }

    static {
        baublesReforkedLoaded = ModList.get().isLoaded(BAUBLES_REFORKED_MOD_ID);
        BUILDER.comment("\u4fee\u9970\u7cfb\u7edf\u914d\u7f6e").push("modifiers");
        MODIFIER_ENABLED = BUILDER.comment(new String[]{"\u662f\u5426\u542f\u7528\u9970\u54c1\u4fee\u9970\u7cfb\u7edf", "\u6ce8\u610f\uff1a\u5982\u679c\u68c0\u6d4b\u5230\u5b89\u88c5\u4e86 Baubles Reforked \u6a21\u7ec4\uff0c\u6b64\u9009\u9879\u9ed8\u8ba4\u4e3a false", "\u4f60\u4ecd\u7136\u53ef\u4ee5\u624b\u52a8\u542f\u7528\u6b64\u9009\u9879\uff0c\u4f46\u4e0d\u5efa\u8bae\u540c\u65f6\u4f7f\u7528\u4e24\u4e2a\u6a21\u7ec4\u7684\u4fee\u9970\u7b26\u7cfb\u7edf"}).define("enabled", !baublesReforkedLoaded);
        BUILDER.pop();
        BUILDER.comment("\u94c1\u7827\u91cd\u94f8\u7cfb\u7edf\u914d\u7f6e").push("anvilRecast");
        ANVIL_RECAST_EXP_COST = BUILDER.comment("\u91cd\u94f8\u6240\u9700\u7ecf\u9a8c\u7b49\u7ea7").defineInRange("expCost", 3, 1, 100);
        ANVIL_RECAST_MATERIAL_COST = BUILDER.comment("\u91cd\u94f8\u6d88\u8017\u7684\u6750\u6599\u6570\u91cf").defineInRange("materialCost", 1, 1, 64);
        BUILDER.pop();
        DEFAULT_MAX_MANA = BUILDER.comment("\u9ed8\u8ba4\u6700\u5927\u9b54\u529b\u503c").defineInRange("mana.defaultMaxMana", 100, 10, 100000);
        MANA_REGEN_COOLDOWN = BUILDER.comment("\u9b54\u529b\u6062\u590d\u51b7\u5374\u65f6\u95f4\uff08\u4ee5tick\u4e3a\u5355\u4f4d\uff0c20 tick = 1\u79d2\uff09").defineInRange("mana.manaRegenCooldown", 20, 0, 20000);
        MANA_REGEN_RATE = BUILDER.comment("\u6bcf\u6b21\u6062\u590d\u7684\u9b54\u529b\u91cf").defineInRange("mana.manaRegenRate", 3, 1, 10000);
        MANA_REGEN_INTERVAL = BUILDER.comment("\u9b54\u529b\u6062\u590d\u95f4\u9694\uff08\u4ee5tick\u4e3a\u5355\u4f4d\uff09").defineInRange("mana.manaRegenInterval", 20, 1, 20000);
        CREATIVE_REGEN_RATE = BUILDER.comment("\u521b\u9020\u6a21\u5f0f\u6bcftick\u6062\u590d\u7684\u9b54\u529b\u91cf").defineInRange("mana.creativeRegenRate", 5, 1, 10000);
        USE_IRONS_SPELLS_MANA = BUILDER.comment("\u82e5\u5df2\u5b89\u88c5 Iron's Spells \u6a21\u7ec4\uff0c\u662f\u5426\u4f7f\u7528\u5176\u9b54\u529b\u7cfb\u7edf").define("mana.useIronsSpellsMana", false);
        USE_BOTANIA_MANA = BUILDER.comment("\u82e5\u5df2\u5b89\u88c5 Botania \u6a21\u7ec4\uff0c\u662f\u5426\u4f7f\u7528\u5176\u9b54\u529b\u7cfb\u7edf").define("mana.useBotaniaMana", false);
        SPEED_BOOST = BUILDER.comment("\u79fb\u52a8\u901f\u5ea6\u589e\u76ca\u500d\u7387").defineInRange("arcingOrb.speedBoost", 0.25, 0.0, 1000.0);
        CHARGE_RATE = BUILDER.comment("\u6bcftick\u7684\u5145\u80fd\u901f\u7387\u548c\u9b54\u529b\u6d88\u8017").defineInRange("arcingOrb.chargeRate", 0.5, 0.1, 5000.0);
        MIN_CHARGE = BUILDER.comment("\u6700\u5c0f\u5145\u80fd\u9700\u6c42").defineInRange("arcingOrb.minCharge", 5.0, 1.0, 5000.0);
        MAX_CHARGE = BUILDER.comment("\u6700\u5927\u5145\u80fd\u503c").defineInRange("arcingOrb.maxCharge", 100.0, 10.0, 10000.0);
        DAMAGE_MULTIPLIER = BUILDER.comment("\u4f24\u5bb3\u7cfb\u6570").defineInRange("arcingOrb.damageMultiplier", 0.133, 0.01, 100.0);
        DASH_DISTANCE = BUILDER.comment("\u95ea\u907f\u6280\u80fd\u7684\u4f4d\u79fb\u8ddd\u79bb").defineInRange("arcingOrb.dashDistance", 5.0, 1.0, 2000.0);
        DASH_COOLDOWN = BUILDER.comment("\u95ea\u907f\u6280\u80fd\u51b7\u5374\u65f6\u95f4\uff08\u5355\u4f4d\uff1atick\uff09").defineInRange("arcingOrb.dashCooldown", 20, 1, 20000);
        DASH_MANA_COST = BUILDER.comment("\u95ea\u907f\u6280\u80fd\u6d88\u8017\u7684\u9b54\u529b\u503c").defineInRange("arcingOrb.dashManaCost", 10.0, 1.0, 10000.0);
        DASH_JUMP_BOOST = BUILDER.comment("\u8df3\u8dc3\u65f6\u95ea\u907f\u7684\u989d\u5916\u63a8\u529b\u7cfb\u6570").defineInRange("arcingOrb.dashJumpBoost", 0.3, 0.0, 1.0);
        MAX_RENDER_BLOCKS = BUILDER.comment("\u6700\u5927\u6e32\u67d3\u65b9\u5757\u6570\u91cf\n\u66f4\u5927\u7684\u6570\u503c\u53ef\u80fd\u4f1a\u5f71\u54cd\u6027\u80fd\n\u8303\u56f4: 50-10000").defineInRange("dragonsEye.max_render_blocks", 200, 50, 10000);
        RENDER_RANGE = BUILDER.comment("\u6e32\u67d3\u8303\u56f4\uff08\u4ee5\u65b9\u5757\u4e3a\u5355\u4f4d\uff09\n\u8fd9\u4e2a\u503c\u4f1a\u88ab\u5e73\u65b9\u6765\u8ba1\u7b97\u5b9e\u9645\u8303\u56f4\n\u9ed8\u8ba4\u503c12\u8868\u793a12*12\u7684\u8303\u56f4\n\u8303\u56f4: 1-128").defineInRange("dragonsEye.render_range", 12, 1, 128);
        VALUABLE_ORES = BUILDER.comment("\u8d35\u91cd\u77ff\u7269\u7ec4 - \u5728\u8fd9\u91cc\u6dfb\u52a0\u8981\u63a2\u6d4b\u7684\u989d\u5916\u8d35\u91cd\u77ff\u77f3\n\u6dfb\u52a0\u65b9\u5f0f\u793a\u4f8b\uff1a\n[\"minecraft:ancient_debris\", \"create:zinc_ore\", \"thermal:silver_ore\"]\n\u6216\u8005\u6bcf\u4e2a\u77ff\u77f3\u5355\u72ec\u4e00\u884c\uff1a\n[\n    \"minecraft:ancient_debris\",\n    \"create:zinc_ore\",\n    \"thermal:silver_ore\"\n]").defineList("dragonsEye.valuable.ores", Arrays.asList(new String[0]), entry -> entry instanceof String);
        COMMON_ORES = BUILDER.comment("\u5e38\u89c1\u77ff\u7269\u7ec4 - \u5728\u8fd9\u91cc\u6dfb\u52a0\u8981\u63a2\u6d4b\u7684\u989d\u5916\u666e\u901a\u77ff\u77f3\n\u6dfb\u52a0\u65b9\u5f0f\u793a\u4f8b\uff1a\n[\"create:copper_ore\", \"thermal:tin_ore\", \"mekanism:osmium_ore\"]\n\u6ce8\u610f\uff1a\u6bcf\u4e2a\u77ff\u77f3ID\u4e4b\u95f4\u9700\u8981\u7528\u9017\u53f7\u5206\u9694\uff0c\u6700\u540e\u4e00\u4e2a\u4e0d\u9700\u8981\u52a0\u9017\u53f7").defineList("dragonsEye.common.ores", Arrays.asList(new String[0]), entry -> entry instanceof String);
        REDSTONE_ORES = BUILDER.comment("\u7ea2\u77f3\u77ff\u7269\u7ec4 - \u5728\u8fd9\u91cc\u6dfb\u52a0\u8981\u63a2\u6d4b\u7684\u989d\u5916\u7ea2\u77f3\u7c7b\u77ff\u77f3\n\u6dfb\u52a0\u65b9\u5f0f\u793a\u4f8b\uff1a\n[\"thermal:cinnabar_ore\", \"projectred:electrotine_ore\"]\n\u6ce8\u610f\uff1a\u77ff\u77f3ID\u683c\u5f0f\u5fc5\u987b\u662f \u6a21\u7ec4id:\u65b9\u5757id").defineList("dragonsEye.redstone.ores", Arrays.asList(new String[0]), entry -> entry instanceof String);
        ENDERMAN_FOLLOW_RANGE = BUILDER.comment("\u672b\u5f71\u4eba\u8ddf\u968f\u8303\u56f4").defineInRange("enderCrown.followRange", 16.0, 8.0, 32.0);
        DAMAGE_IMMUNITY_CHANCE = BUILDER.comment("\u4f24\u5bb3\u514d\u75ab\u89e6\u53d1\u6982\u7387").defineInRange("enderCrown.immunityChance", 0.02, 0.0, 1.0);
        TELEPORT_RANGE = BUILDER.comment("\u4f20\u9001\u8303\u56f4").defineInRange("enderCrown.teleportRange", 32.0, 8.0, 64.0);
        WATER_DAMAGE_ENABLED = BUILDER.comment("\u662f\u5426\u542f\u7528\u6c34\u4f24\u5bb3").define("enderCrown.waterDamageEnabled", false);
        FAELIS_CLAW_DAMAGE_BOOST = BUILDER.comment("\u653b\u51fb\u529b\u589e\u76ca\u767e\u5206\u6bd4").defineInRange("faelisClaw.damageBoost", 0.25, 0.0, 100.0);
        FAELIS_CLAW_BLEED_CHANCE = BUILDER.comment("\u6d41\u8840\u6548\u679c\u89e6\u53d1\u6982\u7387").defineInRange("faelisClaw.bleedChance", 0.25, 0.0, 1.0);
        FAELIS_CLAW_BLEED_DURATION = BUILDER.comment("\u6d41\u8840\u6548\u679c\u6301\u7eed\u65f6\u95f4(tick)").defineInRange("faelisClaw.bleedDuration", 300, 20, 12000);
        FAELIS_CLAW_NORMAL_DURATION_MULTIPLIER = BUILDER.comment("\u666e\u901a\u72b6\u6001\u4e0b\u6d41\u8840\u6301\u7eed\u65f6\u95f4\u500d\u7387").defineInRange("faelisClaw.normalDurationMultiplier", 0.3333333333333333, 0.1, 100.0);
        MANA_CANDY_RESTORE = BUILDER.comment("\u9b54\u529b\u7cd6\u679c\u6062\u590d\u7684\u9b54\u529b\u503c").defineInRange("manaCandy.restore", 50, 1, 20000);
        MANA_CRYSTAL_MAX_INCREASE = BUILDER.comment("\u9b54\u529b\u6c34\u6676\u589e\u52a0\u7684\u9b54\u529b\u4e0a\u9650\u503c").defineInRange("manaCrystal.maxIncrease", 10, 1, 50000);
        MANA_REAGENT_MAX_DECREASE = BUILDER.comment("\u9b54\u529b\u8bd5\u5242\u51cf\u5c11\u7684\u9b54\u529b\u4e0a\u9650\u503c").defineInRange("manaReagent.maxDecrease", 10, 1, 50000);
        POISON_STONE_CHANCE = BUILDER.comment("\u6bd2\u77f3\u89e6\u53d1\u4e2d\u6bd2\u6548\u679c\u7684\u6982\u7387").defineInRange("poisonStone.chance", 0.2, 0.0, 1.0);
        POISON_STONE_DURATION = BUILDER.comment("\u4e2d\u6bd2\u6548\u679c\u6301\u7eed\u65f6\u95f4(tick)").defineInRange("poisonStone.duration", 60, 20, 40000);
        POISON_STONE_AMPLIFIER = BUILDER.comment("\u4e2d\u6bd2\u6548\u679c\u7b49\u7ea7").defineInRange("poisonStone.amplifier", 0, 0, 255);
        POISON_STONE_DAMAGE_MULTIPLIER = BUILDER.comment("\u5bf9\u4e2d\u6bd2\u76ee\u6807\u7684\u4f24\u5bb3\u500d\u7387").defineInRange("poisonStone.damageMultiplier", 2.0, 1.0, 500.0);
        POISON_STONE_ACTIVATE_DAMAGE_EVENT = BUILDER.comment("\u662f\u5426\u542f\u7528\u6bd2\u77f3\u7684\u4f24\u5bb3\u52a0\u6210\u6548\u679c").define("poisonStone.activateDamageEvent", true);
        POLARIZED_STONE_ATTRACTION_RANGE = BUILDER.comment("\u7269\u54c1\u5438\u5f15\u8303\u56f4").defineInRange("polarizedStone.attractionRange", 12.0, 4.0, 64.0);
        POLARIZED_STONE_ATTRACTION_SPEED = BUILDER.comment("\u7269\u54c1\u5438\u5f15\u901f\u5ea6").defineInRange("polarizedStone.attractionSpeed", 0.5, 0.1, 10.0);
        POLARIZED_STONE_DEFLECTION_RANGE = BUILDER.comment("\u5f39\u5c04\u7269\u9632\u5fa1\u8303\u56f4").defineInRange("polarizedStone.deflectionRange", 2.0, 1.0, 10.0);
        POLARIZED_STONE_DEFLECTION_MANA_COST = BUILDER.comment("\u6bcf\u79d2\u9632\u5fa1\u6d88\u8017\u9b54\u529b/\u79d2").defineInRange("polarizedStone.deflectionManaCost", 5.0, 0.0, 5000.0);
        SHIELD_MAX_DAMAGE_COUNT = BUILDER.comment("\u5b8c\u5168\u514d\u4f24\u6240\u9700\u7684\u4f24\u5bb3\u8ba1\u6570").defineInRange("shield.maxDamageCount", 3, 1, 100);
        SHIELD_DAMAGE_REDUCTION = BUILDER.comment("\u57fa\u7840\u4f24\u5bb3\u51cf\u514d\u767e\u5206\u6bd4").defineInRange("shield.damageReduction", 0.2, 0.0, 1.0);
        SHIELD_EXPLOSION_REDUCTION = BUILDER.comment("\u7206\u70b8\u4f24\u5bb3\u51cf\u514d\u7cfb\u6570").defineInRange("shield.explosionReduction", 0.25, 0.0, 1.0);
        ENABLE_DAMAGE_SHIELD_EFFECT = BUILDER.comment("\u662f\u5426\u542f\u7528\u4f24\u5bb3\u62a4\u76fe\u6548\u679c\n\u9700\u8981\u5b89\u88c5\u524d\u7f6e\u6a21\u7ec4 First Aid \u624d\u80fd\u751f\u6548\ntrue - \u542f\u7528\nfalse - \u7981\u7528\n\u6ce8\u610f\uff1a\u6b64\u529f\u80fd\u9700\u8981\u5b89\u88c5 First Aid \u6a21\u7ec4\u624d\u80fd\u6b63\u5e38\u5de5\u4f5c\uff0c\u5982\u679c\u6ca1\u5b89\u88c5\u53ef\u4ee5\u5ffd\u7565\u6b64\u914d\u7f6e").define("shield.enable_effect", true);
        DAMAGE_SHIELD_TRIGGER_CHANCE = BUILDER.comment("\u4f24\u5bb3\u62a4\u76fe\u89e6\u53d1\u6982\u7387\n\u9700\u8981\u5b89\u88c5\u524d\u7f6e\u6a21\u7ec4 First Aid \u624d\u80fd\u751f\u6548\n\u8303\u56f4: 0.0 \u5230 1.0\n\u4f8b\u5982: 0.1 \u8868\u793a 10% \u7684\u89e6\u53d1\u6982\u7387\n\u6ce8\u610f\uff1a\u6b64\u529f\u80fd\u9700\u8981\u5b89\u88c5 First Aid \u6a21\u7ec4\u624d\u80fd\u6b63\u5e38\u5de5\u4f5c\uff0c\u5982\u679c\u6ca1\u5b89\u88c5\u53ef\u4ee5\u5ffd\u7565\u6b64\u914d\u7f6e").defineInRange("shield.trigger_chance", 0.1, 0.0, 1.0);
        GREATER_INERTIA_KNOCKBACK_RESISTANCE = BUILDER.comment("\u51fb\u9000\u6297\u6027\u589e\u52a0\u503c").defineInRange("greaterInertiaStone.knockbackResistance", 0.4, 0.0, 1.0);
        GREATER_INERTIA_MOVEMENT_SPEED = BUILDER.comment("\u79fb\u52a8\u901f\u5ea6\u589e\u52a0\u767e\u5206\u6bd4").defineInRange("greaterInertiaStone.movementSpeed", 1.5, -1.0, 30.0);
        GREATER_INERTIA_JUMP_BOOST = BUILDER.comment("\u8df3\u8dc3\u9ad8\u5ea6\u63d0\u5347\u503c").defineInRange("greaterInertiaStone.jumpBoost", 0.4, 0.0, 100.0);
        GREATER_INERTIA_FALL_REDUCTION = BUILDER.comment("\u6454\u843d\u4f24\u5bb3\u51cf\u514d\u7cfb\u6570(0.25\u8868\u793a\u51cf\u514d75%)").defineInRange("greaterInertiaStone.fallReduction", 0.25, 0.0, 1.0);
        GREATER_INERTIA_STEP_HEIGHT = BUILDER.comment("\u8de8\u6b65\u9ad8\u5ea6\u589e\u52a0\u503c").defineInRange("greaterInertiaStone.stepHeight", 0.4, -1.0, 10.0);
        WITHER_RING_CHANCE = BUILDER.comment("\u51cb\u96f6\u6548\u679c\u89e6\u53d1\u6982\u7387").defineInRange("witherRing.chance", 0.2, 0.0, 1.0);
        WITHER_RING_DURATION = BUILDER.comment("\u51cb\u96f6\u6548\u679c\u6301\u7eed\u65f6\u95f4(tick)").defineInRange("witherRing.duration", 100, 20, 6000);
        WITHER_RING_AMPLIFIER = BUILDER.comment("\u51cb\u96f6\u6548\u679c\u7b49\u7ea7").defineInRange("witherRing.amplifier", 0, 0, 4);
        BUILDER.comment("\u7ed3\u6784\u6218\u5229\u54c1\u914d\u7f6e\n\u914d\u7f6e\u683c\u5f0f\uff1a\u7269\u54c1ID,\u6743\u91cd,\u6700\u5c0f\u6570\u91cf,\u6700\u5927\u6570\u91cf;\u591a\u4e2a\u7269\u54c1\u7528\u5206\u53f7\u5206\u9694").push("Loot Settings");
        DESERT_PYRAMID_LOOT = BUILDER.comment("\u6c99\u6f20\u795e\u6bbf\u6218\u5229\u54c1\u914d\u7f6e\n\u683c\u5f0f\uff1a\u7269\u54c1ID,\u6743\u91cd,\u6700\u5c0f\u6570\u91cf,\u6700\u5927\u6570\u91cf\uff08\u7528\u5206\u53f7\u5206\u9694\uff09").define("desertPyramidLoot", (Object)"trinketsandbaubles:glowing_powder,10,1,2;trinketsandbaubles:glowing_ingot,1,1,1");
        JUNGLE_TEMPLE_LOOT = BUILDER.comment("\u4e1b\u6797\u795e\u5e99\u6218\u5229\u54c1\u914d\u7f6e\n\u683c\u5f0f\uff1a\u7269\u54c1ID,\u6743\u91cd,\u6700\u5c0f\u6570\u91cf,\u6700\u5927\u6570\u91cf\uff08\u7528\u5206\u53f7\u5206\u9694\uff09").define("jungleTempleLoot", (Object)"trinketsandbaubles:glowing_powder,10,1,2;trinketsandbaubles:glowing_ingot,1,1,1");
        ABANDONED_MINESHAFT_LOOT = BUILDER.comment("\u5e9f\u5f03\u77ff\u4e95\u6218\u5229\u54c1\u914d\u7f6e\n\u683c\u5f0f\uff1a\u7269\u54c1ID,\u6743\u91cd,\u6700\u5c0f\u6570\u91cf,\u6700\u5927\u6570\u91cf\uff08\u7528\u5206\u53f7\u5206\u9694\uff09").define("abandonedMineshaftLoot", (Object)"trinketsandbaubles:glowing_powder,10,1,2;trinketsandbaubles:glowing_ingot,1,1,1");
        STRONGHOLD_LIBRARY_LOOT = BUILDER.comment("\u8981\u585e\u56fe\u4e66\u9986\u6218\u5229\u54c1\u914d\u7f6e\n\u683c\u5f0f\uff1a\u7269\u54c1ID,\u6743\u91cd,\u6700\u5c0f\u6570\u91cf,\u6700\u5927\u6570\u91cf\uff08\u7528\u5206\u53f7\u5206\u9694\uff09").define("strongholdLibraryLoot", (Object)"trinketsandbaubles:glowing_powder,10,1,2;trinketsandbaubles:glowing_ingot,1,1,1");
        WOODLAND_MANSION_LOOT = BUILDER.comment("\u6797\u5730\u5e9c\u90b8\u6218\u5229\u54c1\u914d\u7f6e\n\u683c\u5f0f\uff1a\u7269\u54c1ID,\u6743\u91cd,\u6700\u5c0f\u6570\u91cf,\u6700\u5927\u6570\u91cf\uff08\u7528\u5206\u53f7\u5206\u9694\uff09").define("woodlandMansionLoot", (Object)"trinketsandbaubles:glowing_powder,10,1,2;trinketsandbaubles:glowing_ingot,1,1,1");
        VILLAGE_TEMPLE_LOOT = BUILDER.comment("\u6751\u5e84\u6559\u5802\u6218\u5229\u54c1\u914d\u7f6e\n\u683c\u5f0f\uff1a\u7269\u54c1ID,\u6743\u91cd,\u6700\u5c0f\u6570\u91cf,\u6700\u5927\u6570\u91cf\uff08\u7528\u5206\u53f7\u5206\u9694\uff09").define("villageTempleLoot", (Object)"trinketsandbaubles:glowing_powder,10,1,2;trinketsandbaubles:glowing_ingot,1,1,1");
        SHIPWRECK_TREASURE_LOOT = BUILDER.comment("\u6c89\u8239\u5b9d\u85cf\u914d\u7f6e\n\u683c\u5f0f\uff1a\u7269\u54c1ID,\u6743\u91cd,\u6700\u5c0f\u6570\u91cf,\u6700\u5927\u6570\u91cf\uff08\u7528\u5206\u53f7\u5206\u9694\uff09").define("shipwreckTreasureLoot", (Object)"trinketsandbaubles:glowing_powder,10,1,2;trinketsandbaubles:glowing_ingot,1,1,1");
        PILLAGER_OUTPOST_LOOT = BUILDER.comment("\u63a0\u593a\u8005\u524d\u54e8\u7ad9\u914d\u7f6e\n\u683c\u5f0f\uff1a\u7269\u54c1ID,\u6743\u91cd,\u6700\u5c0f\u6570\u91cf,\u6700\u5927\u6570\u91cf\uff08\u7528\u5206\u53f7\u5206\u9694\uff09").define("pillagerOutpostLoot", (Object)"trinketsandbaubles:glowing_powder,10,1,2;trinketsandbaubles:glowing_ingot,1,1,1");
        BURIED_TREASURE_LOOT = BUILDER.comment("\u57cb\u85cf\u5b9d\u85cf\u914d\u7f6e\n\u683c\u5f0f\uff1a\u7269\u54c1ID,\u6743\u91cd,\u6700\u5c0f\u6570\u91cf,\u6700\u5927\u6570\u91cf\uff08\u7528\u5206\u53f7\u5206\u9694\uff09").define("buriedTreasureLoot", (Object)"trinketsandbaubles:glowing_powder,10,1,2;trinketsandbaubles:glowing_ingot,1,1,1");
        UNDERWATER_RUIN_BIG_LOOT = BUILDER.comment("\u5927\u578b\u6c34\u4e0b\u5e9f\u589f\u914d\u7f6e\n\u683c\u5f0f\uff1a\u7269\u54c1ID,\u6743\u91cd,\u6700\u5c0f\u6570\u91cf,\u6700\u5927\u6570\u91cf\uff08\u7528\u5206\u53f7\u5206\u9694\uff09").define("underwaterRuinBigLoot", (Object)"trinketsandbaubles:glowing_powder,10,1,2;trinketsandbaubles:glowing_ingot,1,1,1");
        UNDERWATER_RUIN_SMALL_LOOT = BUILDER.comment("\u5c0f\u578b\u6c34\u4e0b\u5e9f\u589f\u914d\u7f6e\n\u683c\u5f0f\uff1a\u7269\u54c1ID,\u6743\u91cd,\u6700\u5c0f\u6570\u91cf,\u6700\u5927\u6570\u91cf\uff08\u7528\u5206\u53f7\u5206\u9694\uff09").define("underwaterRuinSmallLoot", (Object)"trinketsandbaubles:glowing_powder,10,1,2;trinketsandbaubles:glowing_ingot,1,1,1");
        IGLOO_CHEST_LOOT = BUILDER.comment("\u96ea\u5c4b\u5730\u4e0b\u5ba4\u914d\u7f6e\n\u683c\u5f0f\uff1a\u7269\u54c1ID,\u6743\u91cd,\u6700\u5c0f\u6570\u91cf,\u6700\u5927\u6570\u91cf\uff08\u7528\u5206\u53f7\u5206\u9694\uff09").define("iglooChestLoot", (Object)"trinketsandbaubles:glowing_powder,10,1,2;trinketsandbaubles:glowing_ingot,1,1,1");
        BASTION_TREASURE_LOOT = BUILDER.comment("\u5821\u5792\u9057\u8ff9-\u5b9d\u85cf\u5ba4\u914d\u7f6e\n\u683c\u5f0f\uff1a\u7269\u54c1ID,\u6743\u91cd,\u6700\u5c0f\u6570\u91cf,\u6700\u5927\u6570\u91cf\uff08\u7528\u5206\u53f7\u5206\u9694\uff09").define("bastionTreasureLoot", (Object)"trinketsandbaubles:glowing_powder,10,1,2;trinketsandbaubles:glowing_ingot,1,1,1");
        BASTION_BRIDGE_LOOT = BUILDER.comment("\u5821\u5792\u9057\u8ff9-\u6865\u6881\u914d\u7f6e\n\u683c\u5f0f\uff1a\u7269\u54c1ID,\u6743\u91cd,\u6700\u5c0f\u6570\u91cf,\u6700\u5927\u6570\u91cf\uff08\u7528\u5206\u53f7\u5206\u9694\uff09").define("bastionBridgeLoot", (Object)"trinketsandbaubles:glowing_powder,10,1,2;trinketsandbaubles:glowing_ingot,1,1,1");
        BASTION_HOUSING_LOOT = BUILDER.comment("\u5821\u5792\u9057\u8ff9-\u5c45\u4f4f\u533a\u914d\u7f6e\n\u683c\u5f0f\uff1a\u7269\u54c1ID,\u6743\u91cd,\u6700\u5c0f\u6570\u91cf,\u6700\u5927\u6570\u91cf\uff08\u7528\u5206\u53f7\u5206\u9694\uff09").define("bastionHousingLoot", (Object)"trinketsandbaubles:glowing_powder,10,1,2;trinketsandbaubles:glowing_ingot,1,1,1");
        BASTION_OTHER_LOOT = BUILDER.comment("\u5821\u5792\u9057\u8ff9-\u6742\u9879\u914d\u7f6e\n\u683c\u5f0f\uff1a\u7269\u54c1ID,\u6743\u91cd,\u6700\u5c0f\u6570\u91cf,\u6700\u5927\u6570\u91cf\uff08\u7528\u5206\u53f7\u5206\u9694\uff09").define("bastionOtherLoot", (Object)"trinketsandbaubles:glowing_powder,10,1,2;trinketsandbaubles:glowing_ingot,1,1,1");
        RUINED_PORTAL_LOOT = BUILDER.comment("\u5e9f\u5f03\u4f20\u9001\u95e8\u914d\u7f6e\n\u683c\u5f0f\uff1a\u7269\u54c1ID,\u6743\u91cd,\u6700\u5c0f\u6570\u91cf,\u6700\u5927\u6570\u91cf\uff08\u7528\u5206\u53f7\u5206\u9694\uff09").define("ruinedPortalLoot", (Object)"trinketsandbaubles:glowing_powder,10,1,2;trinketsandbaubles:glowing_ingot,1,1,1");
        END_CITY_LOOT = BUILDER.comment("\u672b\u5730\u57ce\u6218\u5229\u54c1\u914d\u7f6e\n\u683c\u5f0f\uff1a\u7269\u54c1ID,\u6743\u91cd,\u6700\u5c0f\u6570\u91cf,\u6700\u5927\u6570\u91cf\uff08\u7528\u5206\u53f7\u5206\u9694\uff09").define("endCityLoot", (Object)"trinketsandbaubles:glowing_powder,10,1,2;trinketsandbaubles:glowing_ingot,1,1,1");
        ANCIENT_CITY_LOOT = BUILDER.comment("\u8fdc\u53e4\u57ce\u5e02\u914d\u7f6e\n\u683c\u5f0f\uff1a\u7269\u54c1ID,\u6743\u91cd,\u6700\u5c0f\u6570\u91cf,\u6700\u5927\u6570\u91cf\uff08\u7528\u5206\u53f7\u5206\u9694\uff09").define("ancientCityLoot", (Object)"trinketsandbaubles:glowing_powder,10,1,2;trinketsandbaubles:glowing_ingot,1,1,1");
        SIMPLE_DUNGEON_LOOT = BUILDER.comment("\u5c0f\u578b\u5730\u7262\u914d\u7f6e\n\u683c\u5f0f\uff1a\u7269\u54c1ID,\u6743\u91cd,\u6700\u5c0f\u6570\u91cf,\u6700\u5927\u6570\u91cf\uff08\u7528\u5206\u53f7\u5206\u9694\uff09").define("simpleDungeonLoot", (Object)"trinketsandbaubles:glowing_powder,10,1,2;trinketsandbaubles:glowing_ingot,1,1,1");
        STRONGHOLD_CORRIDOR_LOOT = BUILDER.comment("\u8981\u585e\u8d70\u5eca\u914d\u7f6e\n\u683c\u5f0f\uff1a\u7269\u54c1ID,\u6743\u91cd,\u6700\u5c0f\u6570\u91cf,\u6700\u5927\u6570\u91cf\uff08\u7528\u5206\u53f7\u5206\u9694\uff09").define("strongholdCorridorLoot", (Object)"trinketsandbaubles:glowing_powder,10,1,2;trinketsandbaubles:glowing_ingot,1,1,1");
        FOSSIL_DINOSAUR_LOOT = BUILDER.comment("\u6050\u9f99\u5316\u77f3\u914d\u7f6e\n\u683c\u5f0f\uff1a\u7269\u54c1ID,\u6743\u91cd,\u6700\u5c0f\u6570\u91cf,\u6700\u5927\u6570\u91cf\uff08\u7528\u5206\u53f7\u5206\u9694\uff09").define("fossilDinosaurLoot", (Object)"");
        FOSSIL_MAMMAL_LOOT = BUILDER.comment("\u54fa\u4e73\u52a8\u7269\u5316\u77f3\u914d\u7f6e\n\u683c\u5f0f\uff1a\u7269\u54c1ID,\u6743\u91cd,\u6700\u5c0f\u6570\u91cf,\u6700\u5927\u6570\u91cf\uff08\u7528\u5206\u53f7\u5206\u9694\uff09").define("fossilMammalLoot", (Object)"");
        SHIPWRECK_SUPPLY_LOOT = BUILDER.comment("\u6c89\u8239\u8865\u7ed9\u914d\u7f6e\n\u683c\u5f0f\uff1a\u7269\u54c1ID,\u6743\u91cd,\u6700\u5c0f\u6570\u91cf,\u6700\u5927\u6570\u91cf\uff08\u7528\u5206\u53f7\u5206\u9694\uff09").define("shipwreckSupplyLoot", (Object)"trinketsandbaubles:glowing_powder,10,1,2;trinketsandbaubles:glowing_ingot,1,1,1");
        WOODLAND_CARTOGRAPHY_LOOT = BUILDER.comment("\u6797\u5730\u5236\u56fe\u5ba4\u914d\u7f6e\n\u683c\u5f0f\uff1a\u7269\u54c1ID,\u6743\u91cd,\u6700\u5c0f\u6570\u91cf,\u6700\u5927\u6570\u91cf\uff08\u7528\u5206\u53f7\u5206\u9694\uff09").define("woodlandCartographyLoot", (Object)"trinketsandbaubles:glowing_powder,10,1,2;trinketsandbaubles:glowing_ingot,1,1,1");
        STRONGHOLD_CROSSING_LOOT = BUILDER.comment("\u8981\u585e\u5341\u5b57\u5385\u914d\u7f6e\n\u683c\u5f0f\uff1a\u7269\u54c1ID,\u6743\u91cd,\u6700\u5c0f\u6570\u91cf,\u6700\u5927\u6570\u91cf\uff08\u7528\u5206\u53f7\u5206\u9694\uff09").define("strongholdCrossingLoot", (Object)"trinketsandbaubles:glowing_powder,10,1,2;trinketsandbaubles:glowing_ingot,1,1,1");
        SHIPWRECK_MAP_LOOT = BUILDER.comment("\u6c89\u8239\u5730\u56fe\u914d\u7f6e\n\u683c\u5f0f\uff1a\u7269\u54c1ID,\u6743\u91cd,\u6700\u5c0f\u6570\u91cf,\u6700\u5927\u6570\u91cf\uff08\u7528\u5206\u53f7\u5206\u9694\uff09").define("shipwreckMapLoot", (Object)"trinketsandbaubles:glowing_powder,10,1,2;trinketsandbaubles:glowing_ingot,1,1,1");
        VILLAGE_ARMORER_LOOT = BUILDER.comment("\u76d4\u7532\u5320\u6218\u5229\u54c1\u914d\u7f6e\n\u683c\u5f0f\uff1a\u7269\u54c1ID,\u6743\u91cd,\u6700\u5c0f\u6570\u91cf,\u6700\u5927\u6570\u91cf\uff08\u7528\u5206\u53f7\u5206\u9694\uff09").define("villageArmorerLoot", (Object)"");
        VILLAGE_BUTCHER_LOOT = BUILDER.comment("\u5c60\u592b\u6218\u5229\u54c1\u914d\u7f6e\n\u683c\u5f0f\uff1a\u7269\u54c1ID,\u6743\u91cd,\u6700\u5c0f\u6570\u91cf,\u6700\u5927\u6570\u91cf\uff08\u7528\u5206\u53f7\u5206\u9694\uff09").define("villageButcherLoot", (Object)"");
        VILLAGE_CARTOGRAPHER_LOOT = BUILDER.comment("\u5236\u56fe\u5e08\u6218\u5229\u54c1\u914d\u7f6e\n\u683c\u5f0f\uff1a\u7269\u54c1ID,\u6743\u91cd,\u6700\u5c0f\u6570\u91cf,\u6700\u5927\u6570\u91cf\uff08\u7528\u5206\u53f7\u5206\u9694\uff09").define("villageCartographerLoot", (Object)"");
        VILLAGE_PLAINS_HOUSE_LOOT = BUILDER.comment("\u5e73\u539f\u6751\u5e84\u623f\u5c4b\u914d\u7f6e\n\u683c\u5f0f\uff1a\u7269\u54c1ID,\u6743\u91cd,\u6700\u5c0f\u6570\u91cf,\u6700\u5927\u6570\u91cf\uff08\u7528\u5206\u53f7\u5206\u9694\uff09").define("villagePlainsHouseLoot", (Object)"");
        VILLAGE_FISHER_LOOT = BUILDER.comment("\u6e14\u592b\u6218\u5229\u54c1\u914d\u7f6e\n\u683c\u5f0f\uff1a\u7269\u54c1ID,\u6743\u91cd,\u6700\u5c0f\u6570\u91cf,\u6700\u5927\u6570\u91cf\uff08\u7528\u5206\u53f7\u5206\u9694\uff09").define("villageFisherLoot", (Object)"");
        VILLAGE_FLETCHER_LOOT = BUILDER.comment("\u5236\u7bad\u5e08\u6218\u5229\u54c1\u914d\u7f6e\n\u683c\u5f0f\uff1a\u7269\u54c1ID,\u6743\u91cd,\u6700\u5c0f\u6570\u91cf,\u6700\u5927\u6570\u91cf\uff08\u7528\u5206\u53f7\u5206\u9694\uff09").define("villageFletcherLoot", (Object)"");
        VILLAGE_TANNERY_LOOT = BUILDER.comment("\u5236\u9769\u5382\u6218\u5229\u54c1\u914d\u7f6e\n\u683c\u5f0f\uff1a\u7269\u54c1ID,\u6743\u91cd,\u6700\u5c0f\u6570\u91cf,\u6700\u5927\u6570\u91cf\uff08\u7528\u5206\u53f7\u5206\u9694\uff09").define("villageTanneryLoot", (Object)"");
        VILLAGE_LIBRARY_LOOT = BUILDER.comment("\u6751\u5e84\u56fe\u4e66\u9986\u914d\u7f6e\n\u683c\u5f0f\uff1a\u7269\u54c1ID,\u6743\u91cd,\u6700\u5c0f\u6570\u91cf,\u6700\u5927\u6570\u91cf\uff08\u7528\u5206\u53f7\u5206\u9694\uff09").define("villageLibraryLoot", (Object)"");
        VILLAGE_MASON_LOOT = BUILDER.comment("\u77f3\u5320\u6218\u5229\u54c1\u914d\u7f6e\n\u683c\u5f0f\uff1a\u7269\u54c1ID,\u6743\u91cd,\u6700\u5c0f\u6570\u91cf,\u6700\u5927\u6570\u91cf\uff08\u7528\u5206\u53f7\u5206\u9694\uff09").define("villageMasonLoot", (Object)"");
        VILLAGE_SHEPHERD_LOOT = BUILDER.comment("\u7267\u7f8a\u4eba\u6218\u5229\u54c1\u914d\u7f6e\n\u683c\u5f0f\uff1a\u7269\u54c1ID,\u6743\u91cd,\u6700\u5c0f\u6570\u91cf,\u6700\u5927\u6570\u91cf\uff08\u7528\u5206\u53f7\u5206\u9694\uff09").define("villageShepherdLoot", (Object)"");
        VILLAGE_TOOLSMITH_LOOT = BUILDER.comment("\u5de5\u5177\u5320\u6218\u5229\u54c1\u914d\u7f6e\n\u683c\u5f0f\uff1a\u7269\u54c1ID,\u6743\u91cd,\u6700\u5c0f\u6570\u91cf,\u6700\u5927\u6570\u91cf\uff08\u7528\u5206\u53f7\u5206\u9694\uff09").define("villageToolsmithLoot", (Object)"");
        VILLAGE_WEAPONSMITH_LOOT = BUILDER.comment("\u6b66\u5668\u5320\u6218\u5229\u54c1\u914d\u7f6e\n\u683c\u5f0f\uff1a\u7269\u54c1ID,\u6743\u91cd,\u6700\u5c0f\u6570\u91cf,\u6700\u5927\u6570\u91cf\uff08\u7528\u5206\u53f7\u5206\u9694\uff09").define("villageWeaponsmithLoot", (Object)"");
        VILLAGE_DESERT_HOUSE_LOOT = BUILDER.comment("\u6c99\u6f20\u6751\u5e84\u623f\u5c4b\u914d\u7f6e\n\u683c\u5f0f\uff1a\u7269\u54c1ID,\u6743\u91cd,\u6700\u5c0f\u6570\u91cf,\u6700\u5927\u6570\u91cf\uff08\u7528\u5206\u53f7\u5206\u9694\uff09").define("villageDesertHouseLoot", (Object)"");
        VILLAGE_SNOWY_HOUSE_LOOT = BUILDER.comment("\u96ea\u539f\u6751\u5e84\u623f\u5c4b\u914d\u7f6e\n\u683c\u5f0f\uff1a\u7269\u54c1ID,\u6743\u91cd,\u6700\u5c0f\u6570\u91cf,\u6700\u5927\u6570\u91cf\uff08\u7528\u5206\u53f7\u5206\u9694\uff09").define("villageSnowyHouseLoot", (Object)"");
        VILLAGE_SAVANNA_HOUSE_LOOT = BUILDER.comment("\u70ed\u5e26\u8349\u539f\u6751\u5e84\u623f\u5c4b\u914d\u7f6e\n\u683c\u5f0f\uff1a\u7269\u54c1ID,\u6743\u91cd,\u6700\u5c0f\u6570\u91cf,\u6700\u5927\u6570\u91cf\uff08\u7528\u5206\u53f7\u5206\u9694\uff09").define("villageSavannaHouseLoot", (Object)"");
        VILLAGE_TAIGA_HOUSE_LOOT = BUILDER.comment("\u9488\u53f6\u6797\u6751\u5e84\u623f\u5c4b\u914d\u7f6e\n\u683c\u5f0f\uff1a\u7269\u54c1ID,\u6743\u91cd,\u6700\u5c0f\u6570\u91cf,\u6700\u5927\u6570\u91cf\uff08\u7528\u5206\u53f7\u5206\u9694\uff09").define("villageTaigaHouseLoot", (Object)"");
        SPEC = BUILDER.build();
        LOOT_MAPPING = new HashMap<ResourceLocation, ForgeConfigSpec.ConfigValue<String>>();
        LOOT_MAPPING.put(new ResourceLocation("minecraft:chests/desert_pyramid"), DESERT_PYRAMID_LOOT);
        LOOT_MAPPING.put(new ResourceLocation("minecraft:chests/jungle_temple"), JUNGLE_TEMPLE_LOOT);
        LOOT_MAPPING.put(new ResourceLocation("minecraft:chests/abandoned_mineshaft"), ABANDONED_MINESHAFT_LOOT);
        LOOT_MAPPING.put(new ResourceLocation("minecraft:chests/stronghold_library"), STRONGHOLD_LIBRARY_LOOT);
        LOOT_MAPPING.put(new ResourceLocation("minecraft:chests/woodland_mansion"), WOODLAND_MANSION_LOOT);
        LOOT_MAPPING.put(new ResourceLocation("minecraft:chests/village/village_temple"), VILLAGE_TEMPLE_LOOT);
        LOOT_MAPPING.put(new ResourceLocation("minecraft:chests/shipwreck_treasure"), SHIPWRECK_TREASURE_LOOT);
        LOOT_MAPPING.put(new ResourceLocation("minecraft:chests/pillager_outpost"), PILLAGER_OUTPOST_LOOT);
        LOOT_MAPPING.put(new ResourceLocation("minecraft:chests/buried_treasure"), BURIED_TREASURE_LOOT);
        LOOT_MAPPING.put(new ResourceLocation("minecraft:chests/underwater_ruin_big"), UNDERWATER_RUIN_BIG_LOOT);
        LOOT_MAPPING.put(new ResourceLocation("minecraft:chests/underwater_ruin_small"), UNDERWATER_RUIN_SMALL_LOOT);
        LOOT_MAPPING.put(new ResourceLocation("minecraft:chests/igloo_chest"), IGLOO_CHEST_LOOT);
        LOOT_MAPPING.put(new ResourceLocation("minecraft:chests/bastion_treasure"), BASTION_TREASURE_LOOT);
        LOOT_MAPPING.put(new ResourceLocation("minecraft:chests/bastion_bridge"), BASTION_BRIDGE_LOOT);
        LOOT_MAPPING.put(new ResourceLocation("minecraft:chests/bastion_housing"), BASTION_HOUSING_LOOT);
        LOOT_MAPPING.put(new ResourceLocation("minecraft:chests/bastion_other"), BASTION_OTHER_LOOT);
        LOOT_MAPPING.put(new ResourceLocation("minecraft:chests/ruined_portal"), RUINED_PORTAL_LOOT);
        LOOT_MAPPING.put(new ResourceLocation("minecraft:chests/end_city_treasure"), END_CITY_LOOT);
        LOOT_MAPPING.put(new ResourceLocation("minecraft:chests/ancient_city"), ANCIENT_CITY_LOOT);
        LOOT_MAPPING.put(new ResourceLocation("minecraft:chests/simple_dungeon"), SIMPLE_DUNGEON_LOOT);
        LOOT_MAPPING.put(new ResourceLocation("minecraft:chests/stronghold_corridor"), STRONGHOLD_CORRIDOR_LOOT);
        LOOT_MAPPING.put(new ResourceLocation("minecraft:chests/fossil_dinosaur"), FOSSIL_DINOSAUR_LOOT);
        LOOT_MAPPING.put(new ResourceLocation("minecraft:chests/fossil_mammal"), FOSSIL_MAMMAL_LOOT);
        LOOT_MAPPING.put(new ResourceLocation("minecraft:chests/shipwreck_supply"), SHIPWRECK_SUPPLY_LOOT);
        LOOT_MAPPING.put(new ResourceLocation("minecraft:chests/woodland_mansion_cartography"), WOODLAND_CARTOGRAPHY_LOOT);
        LOOT_MAPPING.put(new ResourceLocation("minecraft:chests/stronghold_crossing"), STRONGHOLD_CROSSING_LOOT);
        LOOT_MAPPING.put(new ResourceLocation("minecraft:chests/shipwreck_map"), SHIPWRECK_MAP_LOOT);
        LOOT_MAPPING.put(new ResourceLocation("minecraft:chests/village/village_armorer"), VILLAGE_ARMORER_LOOT);
        LOOT_MAPPING.put(new ResourceLocation("minecraft:chests/village/village_butcher"), VILLAGE_BUTCHER_LOOT);
        LOOT_MAPPING.put(new ResourceLocation("minecraft:chests/village/village_cartographer"), VILLAGE_CARTOGRAPHER_LOOT);
        LOOT_MAPPING.put(new ResourceLocation("minecraft:chests/village/village_plains_house"), VILLAGE_PLAINS_HOUSE_LOOT);
        LOOT_MAPPING.put(new ResourceLocation("minecraft:chests/village/village_fisher"), VILLAGE_FISHER_LOOT);
        LOOT_MAPPING.put(new ResourceLocation("minecraft:chests/village/village_fletcher"), VILLAGE_FLETCHER_LOOT);
        LOOT_MAPPING.put(new ResourceLocation("minecraft:chests/village/village_tannery"), VILLAGE_TANNERY_LOOT);
        LOOT_MAPPING.put(new ResourceLocation("minecraft:chests/village/village_library"), VILLAGE_LIBRARY_LOOT);
        LOOT_MAPPING.put(new ResourceLocation("minecraft:chests/village/village_mason"), VILLAGE_MASON_LOOT);
        LOOT_MAPPING.put(new ResourceLocation("minecraft:chests/village/village_shepherd"), VILLAGE_SHEPHERD_LOOT);
        LOOT_MAPPING.put(new ResourceLocation("minecraft:chests/village/village_toolsmith"), VILLAGE_TOOLSMITH_LOOT);
        LOOT_MAPPING.put(new ResourceLocation("minecraft:chests/village/village_weaponsmith"), VILLAGE_WEAPONSMITH_LOOT);
        LOOT_MAPPING.put(new ResourceLocation("minecraft:chests/village/village_desert_house"), VILLAGE_DESERT_HOUSE_LOOT);
        LOOT_MAPPING.put(new ResourceLocation("minecraft:chests/village/village_snowy_house"), VILLAGE_SNOWY_HOUSE_LOOT);
        LOOT_MAPPING.put(new ResourceLocation("minecraft:chests/village/village_savanna_house"), VILLAGE_SAVANNA_HOUSE_LOOT);
        LOOT_MAPPING.put(new ResourceLocation("minecraft:chests/village/village_taiga_house"), VILLAGE_TAIGA_HOUSE_LOOT);
        lootConfig = new HashMap<ResourceLocation, List<LootEntry>>();
    }

    public static class LootEntry {
        public final ResourceLocation itemId;
        public final int weight;
        public final int minRolls;
        public final int maxRolls;

        public LootEntry(ResourceLocation itemId, int weight, int minRolls, int maxRolls) {
            this.itemId = itemId;
            this.weight = weight;
            this.minRolls = minRolls;
            this.maxRolls = maxRolls;
        }
    }
}

