/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.trinketsandbaubles.config;

import net.minecraftforge.common.ForgeConfigSpec;

public class RaceAttributesConfig {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec SPEC;
    public static final DwarvesAttributes DWARVES;
    public static final DragonAttributes DRAGON;
    public static final ElvesAttributes ELVES;
    public static final FaelesAttributes FAELES;
    public static final FairyAttributes FAIRY;
    public static final GoblinsAttributes GOBLINS;
    public static final TitanAttributes TITAN;

    static {
        BUILDER.comment("\u79cd\u65cf\u5c5e\u6027\u914d\u7f6e\u7cfb\u7edf").push("races");
        DWARVES = new DwarvesAttributes(BUILDER);
        DRAGON = new DragonAttributes(BUILDER);
        ELVES = new ElvesAttributes(BUILDER);
        FAELES = new FaelesAttributes(BUILDER);
        FAIRY = new FairyAttributes(BUILDER);
        GOBLINS = new GoblinsAttributes(BUILDER);
        TITAN = new TitanAttributes(BUILDER);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }

    public static class DwarvesAttributes {
        public final ForgeConfigSpec.DoubleValue MAX_HEALTH;
        public final ForgeConfigSpec.DoubleValue FOLLOW_RANGE;
        public final ForgeConfigSpec.DoubleValue KNOCKBACK_RESISTANCE;
        public final ForgeConfigSpec.DoubleValue MOVEMENT_SPEED;
        public final ForgeConfigSpec.DoubleValue FLYING_SPEED;
        public final ForgeConfigSpec.DoubleValue ATTACK_DAMAGE;
        public final ForgeConfigSpec.DoubleValue ATTACK_KNOCKBACK;
        public final ForgeConfigSpec.DoubleValue ATTACK_SPEED;
        public final ForgeConfigSpec.DoubleValue ARMOR;
        public final ForgeConfigSpec.DoubleValue ARMOR_TOUGHNESS;
        public final ForgeConfigSpec.DoubleValue LUCK;
        public final ForgeConfigSpec.DoubleValue SWIM_SPEED;
        public final ForgeConfigSpec.DoubleValue NAMETAG_DISTANCE;
        public final ForgeConfigSpec.DoubleValue ENTITY_GRAVITY;
        public final ForgeConfigSpec.DoubleValue STEP_HEIGHT;
        public final ForgeConfigSpec.DoubleValue BLOCK_REACH;
        public final ForgeConfigSpec.DoubleValue ENTITY_REACH;
        public final ForgeConfigSpec.DoubleValue DWARVES_SCALE_FACTOR;
        public final ForgeConfigSpec.DoubleValue DWARVES_MANA_BONUS;

        public DwarvesAttributes(ForgeConfigSpec.Builder builder) {
            builder.comment("\u77ee\u4eba\u65cf\u5c5e\u6027\u914d\u7f6e").push("dwarves");
            this.MAX_HEALTH = builder.comment("\u751f\u547d\u503c\u500d\u7387").defineInRange("max_health", -0.3, -10.0, 10.0);
            this.FOLLOW_RANGE = builder.comment("\u8ddf\u968f\u8303\u56f4\u500d\u7387").defineInRange("follow_range", 0.0, -10.0, 10.0);
            this.KNOCKBACK_RESISTANCE = builder.comment("\u51fb\u9000\u6297\u6027").defineInRange("knockback_resistance", 0.2, -10.0, 1.0);
            this.MOVEMENT_SPEED = builder.comment("\u79fb\u52a8\u901f\u5ea6\u500d\u7387").defineInRange("movement_speed", 0.25, -10.0, 10.0);
            this.FLYING_SPEED = builder.comment("\u98de\u884c\u901f\u5ea6\u500d\u7387").defineInRange("flying_speed", 0.0, -10.0, 10.0);
            this.ATTACK_DAMAGE = builder.comment("\u653b\u51fb\u4f24\u5bb3\u500d\u7387").defineInRange("attack_damage", 0.25, -10.0, 10.0);
            this.ATTACK_KNOCKBACK = builder.comment("\u653b\u51fb\u51fb\u9000\u529b\u5ea6").defineInRange("attack_knockback", 0.0, -10.0, 10.0);
            this.ATTACK_SPEED = builder.comment("\u653b\u51fb\u901f\u5ea6\u500d\u7387").defineInRange("attack_speed", -0.25, -10.0, 10.0);
            this.ARMOR = builder.comment("\u62a4\u7532\u503c\u52a0\u6210").defineInRange("armor", 0.0, -10.0, 50.0);
            this.ARMOR_TOUGHNESS = builder.comment("\u62a4\u7532\u97e7\u6027\u52a0\u6210").defineInRange("armor_toughness", 0.25, -10.0, 50.0);
            this.LUCK = builder.comment("\u5e78\u8fd0\u503c\u52a0\u6210").defineInRange("luck", 1.0, -10.0, 10.0);
            this.SWIM_SPEED = builder.comment("\u6e38\u6cf3\u901f\u5ea6\u500d\u7387").defineInRange("swim_speed", 0.0, -10.0, 10.0);
            this.NAMETAG_DISTANCE = builder.comment("\u540d\u79f0\u6807\u7b7e\u663e\u793a\u8ddd\u79bb\u500d\u7387").defineInRange("nametag_distance", 0.0, -10.0, 10.0);
            this.ENTITY_GRAVITY = builder.comment("\u91cd\u529b\u5f71\u54cd\u500d\u7387").defineInRange("entity_gravity", 0.0, -10.0, 10.0);
            this.STEP_HEIGHT = builder.comment("\u6b65\u9ad8\u589e\u52a0\u503c").defineInRange("step_height", 0.0, -10.0, 10.0);
            this.BLOCK_REACH = builder.comment("\u65b9\u5757\u4ea4\u4e92\u8ddd\u79bb\u500d\u7387").defineInRange("block_reach", 0.0, -10.0, 10.0);
            this.ENTITY_REACH = builder.comment("\u5b9e\u4f53\u4ea4\u4e92\u8ddd\u79bb\u500d\u7387").defineInRange("entity_reach", 0.0, -10.0, 10.0);
            this.DWARVES_SCALE_FACTOR = BUILDER.comment("\u77ee\u4eba\u65cf\u4f53\u578b\u7f29\u653e 1 \u4e3a\u6b63\u5e38\u4f53\u578b").defineInRange("scale", 0.75, 0.1, 10.0);
            this.DWARVES_MANA_BONUS = BUILDER.comment("\u77ee\u4eba\u6548\u679c\u9b54\u529b\u503c\u589e\u52a0\u91cf").defineInRange("manaBonus", 0.0, 0.0, 10000.0);
            builder.pop();
        }
    }

    public static class DragonAttributes {
        public final ForgeConfigSpec.DoubleValue MAX_HEALTH;
        public final ForgeConfigSpec.DoubleValue FOLLOW_RANGE;
        public final ForgeConfigSpec.DoubleValue KNOCKBACK_RESISTANCE;
        public final ForgeConfigSpec.DoubleValue MOVEMENT_SPEED;
        public final ForgeConfigSpec.DoubleValue FLYING_SPEED;
        public final ForgeConfigSpec.DoubleValue ATTACK_DAMAGE;
        public final ForgeConfigSpec.DoubleValue ATTACK_KNOCKBACK;
        public final ForgeConfigSpec.DoubleValue ATTACK_SPEED;
        public final ForgeConfigSpec.DoubleValue ARMOR;
        public final ForgeConfigSpec.DoubleValue ARMOR_TOUGHNESS;
        public final ForgeConfigSpec.DoubleValue LUCK;
        public final ForgeConfigSpec.DoubleValue SWIM_SPEED;
        public final ForgeConfigSpec.DoubleValue NAMETAG_DISTANCE;
        public final ForgeConfigSpec.DoubleValue ENTITY_GRAVITY;
        public final ForgeConfigSpec.DoubleValue STEP_HEIGHT;
        public final ForgeConfigSpec.DoubleValue BLOCK_REACH;
        public final ForgeConfigSpec.DoubleValue ENTITY_REACH;
        public final ForgeConfigSpec.DoubleValue DRAGON_FLIGHT_SPEED;
        public final ForgeConfigSpec.DoubleValue DRAGON_MANA_BONUS;
        public final ForgeConfigSpec.DoubleValue DRAGON_FLIGHT_MANA_COST;
        public final ForgeConfigSpec.DoubleValue DRAGON_MANA_CHECK_INTERVAL;
        public final ForgeConfigSpec.DoubleValue DRAGON_BREATH_MANA_COST;
        public final ForgeConfigSpec.DoubleValue DRAGON_BREATH_BASE_DAMAGE;
        public final ForgeConfigSpec.DoubleValue DRAGON_BREATH_MIN_DAMAGE;
        public final ForgeConfigSpec.DoubleValue DRAGON_BREATH_DECAY_RATE;
        public final ForgeConfigSpec.DoubleValue DRAGON_SCALE_FACTOR;

        public DragonAttributes(ForgeConfigSpec.Builder builder) {
            builder.comment("\u9f99\u65cf\u5c5e\u6027\u914d\u7f6e").push("dragon");
            this.MAX_HEALTH = builder.comment("\u751f\u547d\u503c\u500d\u7387").defineInRange("max_health", 0.25, -10.0, 10.0);
            this.FOLLOW_RANGE = builder.comment("\u8ddf\u968f\u8303\u56f4\u500d\u7387").defineInRange("follow_range", 0.0, -10.0, 10.0);
            this.KNOCKBACK_RESISTANCE = builder.comment("\u51fb\u9000\u6297\u6027").defineInRange("knockback_resistance", 0.0, -10.0, 1.0);
            this.MOVEMENT_SPEED = builder.comment("\u79fb\u52a8\u901f\u5ea6\u500d\u7387").defineInRange("movement_speed", 0.0, -10.0, 10.0);
            this.FLYING_SPEED = builder.comment("\u98de\u884c\u901f\u5ea6\u500d\u7387").defineInRange("flying_speed", 0.0, -10.0, 10.0);
            this.ATTACK_DAMAGE = builder.comment("\u653b\u51fb\u4f24\u5bb3\u500d\u7387").defineInRange("attack_damage", 0.5, -10.0, 10.0);
            this.ATTACK_KNOCKBACK = builder.comment("\u653b\u51fb\u51fb\u9000\u529b\u5ea6").defineInRange("attack_knockback", 0.0, -10.0, 10.0);
            this.ATTACK_SPEED = builder.comment("\u653b\u51fb\u901f\u5ea6\u500d\u7387").defineInRange("attack_speed", 0.0, -10.0, 10.0);
            this.ARMOR = builder.comment("\u62a4\u7532\u503c\u52a0\u6210").defineInRange("armor", 0.0, -10.0, 50.0);
            this.ARMOR_TOUGHNESS = builder.comment("\u62a4\u7532\u97e7\u6027\u52a0\u6210").defineInRange("armor_toughness", 0.5, -10.0, 50.0);
            this.LUCK = builder.comment("\u5e78\u8fd0\u503c\u52a0\u6210").defineInRange("luck", 0.0, -10.0, 10.0);
            this.SWIM_SPEED = builder.comment("\u6e38\u6cf3\u901f\u5ea6\u500d\u7387").defineInRange("swim_speed", 0.0, -10.0, 10.0);
            this.NAMETAG_DISTANCE = builder.comment("\u540d\u79f0\u6807\u7b7e\u663e\u793a\u8ddd\u79bb\u500d\u7387").defineInRange("nametag_distance", 0.0, -10.0, 10.0);
            this.ENTITY_GRAVITY = builder.comment("\u91cd\u529b\u5f71\u54cd\u500d\u7387").defineInRange("entity_gravity", 0.0, -10.0, 10.0);
            this.STEP_HEIGHT = builder.comment("\u6b65\u9ad8\u589e\u52a0\u503c").defineInRange("step_height", 0.0, -10.0, 10.0);
            this.BLOCK_REACH = builder.comment("\u65b9\u5757\u4ea4\u4e92\u8ddd\u79bb\u500d\u7387").defineInRange("block_reach", 0.0, -10.0, 10.0);
            this.ENTITY_REACH = builder.comment("\u5b9e\u4f53\u4ea4\u4e92\u8ddd\u79bb\u500d\u7387").defineInRange("entity_reach", 0.0, -10.0, 10.0);
            this.DRAGON_FLIGHT_SPEED = BUILDER.comment("\u98de\u884c\u901f\u5ea6\u500d\u7387").defineInRange("flightSpeed", 0.3, -1.0, 2.0);
            this.DRAGON_MANA_BONUS = BUILDER.comment("\u9b54\u529b\u503c\u52a0\u6210").defineInRange("manaBonus", 300.0, 0.0, 10000.0);
            this.DRAGON_FLIGHT_MANA_COST = BUILDER.comment("\u6bcf\u79d2\u98de\u884c\u6d88\u8017\u9b54\u529b\u503c").defineInRange("flightManaCost", 5.0, 0.0, 1000.0);
            this.DRAGON_MANA_CHECK_INTERVAL = BUILDER.comment("\u9b54\u529b\u68c0\u67e5\u95f4\u9694(tick)").defineInRange("manaCheckInterval", 20.0, 1.0, 200.0);
            this.DRAGON_BREATH_MANA_COST = BUILDER.comment("\u6bcf\u79d2\u9f99\u606f\u6d88\u8017\u9b54\u529b").defineInRange("breathManaCost", 5.0, 0.0, 5000.0);
            this.DRAGON_BREATH_BASE_DAMAGE = BUILDER.comment("\u9f99\u606f\u57fa\u7840\u4f24\u5bb3").defineInRange("BreathBaseDamage", 4.0, 0.0, 100.0);
            this.DRAGON_BREATH_MIN_DAMAGE = BUILDER.comment("\u9f99\u606f\u6700\u5c0f\u4f24\u5bb3").defineInRange("BreathMinDamage", 2.0, 0.0, 100.0);
            this.DRAGON_BREATH_DECAY_RATE = BUILDER.comment("\u9f99\u606f\u4f24\u5bb3\u8870\u51cf\u7387").defineInRange("BreathDecayRate", 0.7, 0.0, 1.0);
            this.DRAGON_SCALE_FACTOR = BUILDER.comment("\u9f99\u65cf\u4f53\u578b\u7f29\u653e 1 \u4e3a\u6b63\u5e38\u4f53\u578b").defineInRange("scale", 1.2, 0.1, 10.0);
            builder.pop();
        }
    }

    public static class ElvesAttributes {
        public final ForgeConfigSpec.DoubleValue MAX_HEALTH;
        public final ForgeConfigSpec.DoubleValue FOLLOW_RANGE;
        public final ForgeConfigSpec.DoubleValue KNOCKBACK_RESISTANCE;
        public final ForgeConfigSpec.DoubleValue MOVEMENT_SPEED;
        public final ForgeConfigSpec.DoubleValue FLYING_SPEED;
        public final ForgeConfigSpec.DoubleValue ATTACK_DAMAGE;
        public final ForgeConfigSpec.DoubleValue ATTACK_KNOCKBACK;
        public final ForgeConfigSpec.DoubleValue ATTACK_SPEED;
        public final ForgeConfigSpec.DoubleValue ARMOR;
        public final ForgeConfigSpec.DoubleValue ARMOR_TOUGHNESS;
        public final ForgeConfigSpec.DoubleValue LUCK;
        public final ForgeConfigSpec.DoubleValue SWIM_SPEED;
        public final ForgeConfigSpec.DoubleValue NAMETAG_DISTANCE;
        public final ForgeConfigSpec.DoubleValue ENTITY_GRAVITY;
        public final ForgeConfigSpec.DoubleValue STEP_HEIGHT;
        public final ForgeConfigSpec.DoubleValue BLOCK_REACH;
        public final ForgeConfigSpec.DoubleValue ENTITY_REACH;
        public final ForgeConfigSpec.DoubleValue ELVES_FOREST_ATTACK_SPEED;
        public final ForgeConfigSpec.DoubleValue ELVES_FOREST_MOVEMENT_SPEED;
        public final ForgeConfigSpec.DoubleValue ELVES_MANA_BONUS;
        public final ForgeConfigSpec.DoubleValue ELVES_BOW_DAMAGE_BOOST;
        public final ForgeConfigSpec.DoubleValue ELVES_SCALE_FACTOR;

        public ElvesAttributes(ForgeConfigSpec.Builder builder) {
            builder.comment("\u7cbe\u7075\u65cf\u5c5e\u6027\u914d\u7f6e").push("elves");
            this.MAX_HEALTH = builder.comment("\u751f\u547d\u503c\u500d\u7387").defineInRange("max_health", 0.0, -10.0, 10.0);
            this.FOLLOW_RANGE = builder.comment("\u8ddf\u968f\u8303\u56f4\u500d\u7387").defineInRange("follow_range", 0.0, -10.0, 10.0);
            this.KNOCKBACK_RESISTANCE = builder.comment("\u51fb\u9000\u6297\u6027").defineInRange("knockback_resistance", 0.0, -10.0, 1.0);
            this.MOVEMENT_SPEED = builder.comment("\u79fb\u52a8\u901f\u5ea6\u500d\u7387").defineInRange("movement_speed", 0.1, -10.0, 10.0);
            this.FLYING_SPEED = builder.comment("\u98de\u884c\u901f\u5ea6\u500d\u7387").defineInRange("flying_speed", 0.0, -10.0, 10.0);
            this.ATTACK_DAMAGE = builder.comment("\u653b\u51fb\u4f24\u5bb3\u500d\u7387").defineInRange("attack_damage", -0.25, -10.0, 10.0);
            this.ATTACK_KNOCKBACK = builder.comment("\u653b\u51fb\u51fb\u9000\u529b\u5ea6").defineInRange("attack_knockback", 0.0, -10.0, 10.0);
            this.ATTACK_SPEED = builder.comment("\u653b\u51fb\u901f\u5ea6\u500d\u7387").defineInRange("attack_speed", 0.3, -10.0, 10.0);
            this.ARMOR = builder.comment("\u62a4\u7532\u503c\u52a0\u6210").defineInRange("armor", 0.0, -10.0, 50.0);
            this.ARMOR_TOUGHNESS = builder.comment("\u62a4\u7532\u97e7\u6027\u52a0\u6210").defineInRange("armor_toughness", 0.0, -10.0, 50.0);
            this.LUCK = builder.comment("\u5e78\u8fd0\u503c\u52a0\u6210").defineInRange("luck", 0.0, -10.0, 10.0);
            this.SWIM_SPEED = builder.comment("\u6e38\u6cf3\u901f\u5ea6\u500d\u7387").defineInRange("swim_speed", 0.0, -10.0, 10.0);
            this.NAMETAG_DISTANCE = builder.comment("\u540d\u79f0\u6807\u7b7e\u663e\u793a\u8ddd\u79bb\u500d\u7387").defineInRange("nametag_distance", 0.0, -10.0, 10.0);
            this.ENTITY_GRAVITY = builder.comment("\u91cd\u529b\u5f71\u54cd\u500d\u7387").defineInRange("entity_gravity", 0.0, -10.0, 10.0);
            this.STEP_HEIGHT = builder.comment("\u6b65\u9ad8\u589e\u52a0\u503c").defineInRange("step_height", 0.0, -10.0, 10.0);
            this.BLOCK_REACH = builder.comment("\u65b9\u5757\u4ea4\u4e92\u8ddd\u79bb\u500d\u7387").defineInRange("block_reach", 0.0, -10.0, 10.0);
            this.ENTITY_REACH = builder.comment("\u5b9e\u4f53\u4ea4\u4e92\u8ddd\u79bb\u500d\u7387").defineInRange("entity_reach", 0.0, -10.0, 10.0);
            this.ELVES_FOREST_ATTACK_SPEED = BUILDER.comment("\u68ee\u6797\u4e2d\u989d\u5916\u653b\u51fb\u901f\u5ea6\u52a0\u6210").defineInRange("forestAttackSpeed", 0.15, -1.0, 10.0);
            this.ELVES_FOREST_MOVEMENT_SPEED = BUILDER.comment("\u68ee\u6797\u4e2d\u989d\u5916\u79fb\u52a8\u901f\u5ea6\u52a0\u6210").defineInRange("forestMovementSpeed", 0.15, -1.0, 10.0);
            this.ELVES_MANA_BONUS = BUILDER.comment("\u7cbe\u7075\u6548\u679c\u9b54\u529b\u503c\u589e\u52a0\u91cf").defineInRange("manaBonus", 100.0, 0.0, 10000.0);
            this.ELVES_BOW_DAMAGE_BOOST = BUILDER.comment("\u6f5c\u884c\u65f6\u5f13\u7bad\u4f24\u5bb3\u589e\u52a0\u500d\u7387").defineInRange("bowDamageBoost", 1.5, 1.0, 50.0);
            this.ELVES_SCALE_FACTOR = BUILDER.comment("\u7cbe\u7075\u65cf\u4f53\u578b\u7f29\u653e 1 \u4e3a\u6b63\u5e38\u4f53\u578b").defineInRange("scale", 1.0, 0.1, 10.0);
            builder.pop();
        }
    }

    public static class FaelesAttributes {
        public final ForgeConfigSpec.DoubleValue MAX_HEALTH;
        public final ForgeConfigSpec.DoubleValue FOLLOW_RANGE;
        public final ForgeConfigSpec.DoubleValue KNOCKBACK_RESISTANCE;
        public final ForgeConfigSpec.DoubleValue MOVEMENT_SPEED;
        public final ForgeConfigSpec.DoubleValue FLYING_SPEED;
        public final ForgeConfigSpec.DoubleValue ATTACK_DAMAGE;
        public final ForgeConfigSpec.DoubleValue ATTACK_KNOCKBACK;
        public final ForgeConfigSpec.DoubleValue ATTACK_SPEED;
        public final ForgeConfigSpec.DoubleValue ARMOR;
        public final ForgeConfigSpec.DoubleValue ARMOR_TOUGHNESS;
        public final ForgeConfigSpec.DoubleValue LUCK;
        public final ForgeConfigSpec.DoubleValue SWIM_SPEED;
        public final ForgeConfigSpec.DoubleValue NAMETAG_DISTANCE;
        public final ForgeConfigSpec.DoubleValue ENTITY_GRAVITY;
        public final ForgeConfigSpec.DoubleValue STEP_HEIGHT;
        public final ForgeConfigSpec.DoubleValue BLOCK_REACH;
        public final ForgeConfigSpec.DoubleValue ENTITY_REACH;
        public final ForgeConfigSpec.DoubleValue FAELES_UNARMED_DAMAGE;
        public final ForgeConfigSpec.DoubleValue FAELES_ARMOR_SPEED_PENALTY;
        public final ForgeConfigSpec.DoubleValue FAELES_MANA_BONUS;
        public final ForgeConfigSpec.BooleanValue FAELES_WALL_CLIMB;
        public final ForgeConfigSpec.DoubleValue FAELES_CLIMB_SPEED;
        public final ForgeConfigSpec.DoubleValue FAELES_CLIMB_HORIZONTAL_DRAG;
        public final ForgeConfigSpec.DoubleValue FAELES_SCALE_FACTOR;
        public final ForgeConfigSpec.DoubleValue FAELES_JUMP_BOOST;

        public FaelesAttributes(ForgeConfigSpec.Builder builder) {
            builder.comment("\u732b\u65cf\u5c5e\u6027\u914d\u7f6e").push("faeles");
            this.MAX_HEALTH = builder.comment("\u751f\u547d\u503c\u500d\u7387").defineInRange("max_health", -0.25, -10.0, 10.0);
            this.FOLLOW_RANGE = builder.comment("\u8ddf\u968f\u8303\u56f4\u500d\u7387").defineInRange("follow_range", 0.0, -10.0, 10.0);
            this.KNOCKBACK_RESISTANCE = builder.comment("\u51fb\u9000\u6297\u6027").defineInRange("knockback_resistance", 0.0, -10.0, 1.0);
            this.MOVEMENT_SPEED = builder.comment("\u79fb\u52a8\u901f\u5ea6\u500d\u7387").defineInRange("movement_speed", 0.15, -10.0, 10.0);
            this.FLYING_SPEED = builder.comment("\u98de\u884c\u901f\u5ea6\u500d\u7387").defineInRange("flying_speed", 0.0, -10.0, 10.0);
            this.ATTACK_DAMAGE = builder.comment("\u653b\u51fb\u4f24\u5bb3\u500d\u7387").defineInRange("attack_damage", -0.25, -10.0, 10.0);
            this.ATTACK_KNOCKBACK = builder.comment("\u653b\u51fb\u51fb\u9000\u529b\u5ea6").defineInRange("attack_knockback", 0.0, -10.0, 10.0);
            this.ATTACK_SPEED = builder.comment("\u653b\u51fb\u901f\u5ea6\u500d\u7387").defineInRange("attack_speed", 0.15, -10.0, 10.0);
            this.ARMOR = builder.comment("\u62a4\u7532\u503c\u52a0\u6210").defineInRange("armor", 0.0, -10.0, 50.0);
            this.ARMOR_TOUGHNESS = builder.comment("\u62a4\u7532\u97e7\u6027\u52a0\u6210").defineInRange("armor_toughness", -0.15, -10.0, 50.0);
            this.LUCK = builder.comment("\u5e78\u8fd0\u503c\u52a0\u6210").defineInRange("luck", 2.0, -10.0, 10.0);
            this.SWIM_SPEED = builder.comment("\u6e38\u6cf3\u901f\u5ea6\u500d\u7387").defineInRange("swim_speed", 0.3, -10.0, 10.0);
            this.NAMETAG_DISTANCE = builder.comment("\u540d\u79f0\u6807\u7b7e\u663e\u793a\u8ddd\u79bb\u500d\u7387").defineInRange("nametag_distance", 0.0, -10.0, 10.0);
            this.ENTITY_GRAVITY = builder.comment("\u91cd\u529b\u5f71\u54cd\u500d\u7387").defineInRange("entity_gravity", 0.0, -10.0, 10.0);
            this.STEP_HEIGHT = builder.comment("\u6b65\u9ad8\u589e\u52a0\u503c").defineInRange("step_height", 0.6, -10.0, 10.0);
            this.BLOCK_REACH = builder.comment("\u65b9\u5757\u4ea4\u4e92\u8ddd\u79bb\u500d\u7387").defineInRange("block_reach", -0.1, -10.0, 10.0);
            this.ENTITY_REACH = builder.comment("\u5b9e\u4f53\u4ea4\u4e92\u8ddd\u79bb\u500d\u7387").defineInRange("entity_reach", 0.0, -10.0, 10.0);
            this.FAELES_UNARMED_DAMAGE = BUILDER.comment("\u7a7a\u624b\u4f24\u5bb3\u589e\u52a0\u503c").defineInRange("unarmedDamage", 6.0, -100.0, 2000.0);
            this.FAELES_ARMOR_SPEED_PENALTY = BUILDER.comment("\u6bcf\u4ef6\u975e\u76ae\u9769\u62a4\u7532\u7684\u901f\u5ea6\u60e9\u7f5a").defineInRange("armorSpeedPenalty", -0.04, -1.0, 0.0);
            this.FAELES_MANA_BONUS = BUILDER.comment("\u9b54\u529b\u503c\u589e\u52a0\u91cf").defineInRange("manaBonus", 25.0, 0.0, 10000.0);
            this.FAELES_JUMP_BOOST = BUILDER.comment("\u8df3\u8dc3\u9ad8\u5ea6\u4fee\u6539\u503c").defineInRange("jumpStrength", 0.6, -1.0, 200.0);
            this.FAELES_WALL_CLIMB = BUILDER.comment("\u732b\u732b\u6548\u679c\u662f\u5426\u5141\u8bb8\u6500\u722c\u5899\u58c1").define("fwallClimb", true);
            this.FAELES_CLIMB_SPEED = BUILDER.comment("\u732b\u732b\u6548\u679c\u722c\u5899\u901f\u5ea6\uff08\u539f\u7248\u68af\u5b50\u901f\u5ea6\u7ea6\u4e3a0.11\uff09").defineInRange("climbSpeed", 0.11, 0.05, 0.3);
            this.FAELES_CLIMB_HORIZONTAL_DRAG = BUILDER.comment("\u732b\u732b\u6548\u679c\u722c\u5899\u65f6\u7684\u6c34\u5e73\u79fb\u52a8\u963b\u529b").defineInRange("climbHorizontalDrag", 0.7, 0.5, 1.0);
            this.FAELES_SCALE_FACTOR = BUILDER.comment("\u732b\u65cf\u4f53\u578b\u7f29\u653e 1 \u4e3a\u6b63\u5e38\u4f53\u578b").defineInRange("scale", 0.85, 0.1, 10.0);
            builder.pop();
        }
    }

    public static class FairyAttributes {
        public final ForgeConfigSpec.DoubleValue MAX_HEALTH;
        public final ForgeConfigSpec.DoubleValue FOLLOW_RANGE;
        public final ForgeConfigSpec.DoubleValue KNOCKBACK_RESISTANCE;
        public final ForgeConfigSpec.DoubleValue MOVEMENT_SPEED;
        public final ForgeConfigSpec.DoubleValue FLYING_SPEED;
        public final ForgeConfigSpec.DoubleValue ATTACK_DAMAGE;
        public final ForgeConfigSpec.DoubleValue ATTACK_KNOCKBACK;
        public final ForgeConfigSpec.DoubleValue ATTACK_SPEED;
        public final ForgeConfigSpec.DoubleValue ARMOR;
        public final ForgeConfigSpec.DoubleValue ARMOR_TOUGHNESS;
        public final ForgeConfigSpec.DoubleValue LUCK;
        public final ForgeConfigSpec.DoubleValue SWIM_SPEED;
        public final ForgeConfigSpec.DoubleValue NAMETAG_DISTANCE;
        public final ForgeConfigSpec.DoubleValue ENTITY_GRAVITY;
        public final ForgeConfigSpec.DoubleValue STEP_HEIGHT;
        public final ForgeConfigSpec.DoubleValue BLOCK_REACH;
        public final ForgeConfigSpec.DoubleValue ENTITY_REACH;
        public final ForgeConfigSpec.DoubleValue FAIRY_DEW_FLIGHT_SPEED;
        public final ForgeConfigSpec.DoubleValue FAIRY_DEW_MANA_BONUS;
        public final ForgeConfigSpec.DoubleValue FAIRY_DEW_JUMP_BOOST;
        public final ForgeConfigSpec.BooleanValue FAIRY_DEW_WALL_CLIMB;
        public final ForgeConfigSpec.DoubleValue FAIRY_DEW_CLIMB_SPEED;
        public final ForgeConfigSpec.DoubleValue FAIRY_DEW_CLIMB_HORIZONTAL_DRAG;
        public final ForgeConfigSpec.DoubleValue FAIRY_DEW_SCALE_FACTOR;

        public FairyAttributes(ForgeConfigSpec.Builder builder) {
            builder.comment("\u4ed9\u5973\u65cf\u5c5e\u6027\u914d\u7f6e").push("fairy");
            this.MAX_HEALTH = builder.comment("\u751f\u547d\u503c\u500d\u7387").defineInRange("max_health", -0.6, -10.0, 10.0);
            this.FOLLOW_RANGE = builder.comment("\u8ddf\u968f\u8303\u56f4\u500d\u7387").defineInRange("follow_range", 0.0, -10.0, 10.0);
            this.KNOCKBACK_RESISTANCE = builder.comment("\u51fb\u9000\u6297\u6027").defineInRange("knockback_resistance", 0.0, -10.0, 1.0);
            this.MOVEMENT_SPEED = builder.comment("\u79fb\u52a8\u901f\u5ea6\u500d\u7387").defineInRange("movement_speed", -0.25, -10.0, 10.0);
            this.FLYING_SPEED = builder.comment("\u98de\u884c\u901f\u5ea6\u500d\u7387").defineInRange("flying_speed", 0.0, -10.0, 10.0);
            this.ATTACK_DAMAGE = builder.comment("\u653b\u51fb\u4f24\u5bb3\u500d\u7387").defineInRange("attack_damage", -0.75, -10.0, 10.0);
            this.ATTACK_KNOCKBACK = builder.comment("\u653b\u51fb\u51fb\u9000\u529b\u5ea6").defineInRange("attack_knockback", 0.0, -10.0, 10.0);
            this.ATTACK_SPEED = builder.comment("\u653b\u51fb\u901f\u5ea6\u500d\u7387").defineInRange("attack_speed", 0.0, -10.0, 10.0);
            this.ARMOR = builder.comment("\u62a4\u7532\u503c\u52a0\u6210").defineInRange("armor", -0.5, -10.0, 50.0);
            this.ARMOR_TOUGHNESS = builder.comment("\u62a4\u7532\u97e7\u6027\u52a0\u6210").defineInRange("armor_toughness", -0.25, -10.0, 50.0);
            this.LUCK = builder.comment("\u5e78\u8fd0\u503c\u52a0\u6210").defineInRange("luck", 0.0, -10.0, 10.0);
            this.SWIM_SPEED = builder.comment("\u6e38\u6cf3\u901f\u5ea6\u500d\u7387").defineInRange("swim_speed", -0.25, -10.0, 10.0);
            this.NAMETAG_DISTANCE = builder.comment("\u540d\u79f0\u6807\u7b7e\u663e\u793a\u8ddd\u79bb\u500d\u7387").defineInRange("nametag_distance", 0.0, -10.0, 10.0);
            this.ENTITY_GRAVITY = builder.comment("\u91cd\u529b\u5f71\u54cd\u500d\u7387").defineInRange("entity_gravity", 0.0, -10.0, 10.0);
            this.STEP_HEIGHT = builder.comment("\u6b65\u9ad8\u589e\u52a0\u503c").defineInRange("step_height", -0.35, -10.0, 10.0);
            this.BLOCK_REACH = builder.comment("\u65b9\u5757\u4ea4\u4e92\u8ddd\u79bb\u500d\u7387").defineInRange("block_reach", -0.35, -10.0, 10.0);
            this.ENTITY_REACH = builder.comment("\u5b9e\u4f53\u4ea4\u4e92\u8ddd\u79bb\u500d\u7387").defineInRange("entity_reach", 0.0, -10.0, 10.0);
            this.FAIRY_DEW_FLIGHT_SPEED = BUILDER.comment("\u98de\u884c\u901f\u5ea6\u500d\u7387").defineInRange("flightSpeed", 0.3, -1.0, 2.0);
            this.FAIRY_DEW_MANA_BONUS = BUILDER.comment("\u9b54\u529b\u503c\u589e\u52a0\u91cf").defineInRange("manaBonus", 400.0, 0.0, 20000.0);
            this.FAIRY_DEW_JUMP_BOOST = BUILDER.comment("\u8df3\u8dc3\u91cd\u529b\u4fee\u6539\u503c").defineInRange("jumpStrength", -0.25, -1.0, 200.0);
            this.FAIRY_DEW_WALL_CLIMB = BUILDER.comment("\u4ed9\u5973\u6548\u679c\u662f\u5426\u5141\u8bb8\u6500\u722c\u5899\u58c1").define("wallClimb", true);
            this.FAIRY_DEW_CLIMB_SPEED = BUILDER.comment("\u4ed9\u5973\u6548\u679c\u722c\u5899\u901f\u5ea6\uff08\u539f\u7248\u68af\u5b50\u901f\u5ea6\u7ea6\u4e3a0.11\uff09").defineInRange("climbSpeed", 0.11, 0.05, 0.3);
            this.FAIRY_DEW_CLIMB_HORIZONTAL_DRAG = BUILDER.comment("\u4ed9\u5973\u6548\u679c\u722c\u5899\u65f6\u7684\u6c34\u5e73\u79fb\u52a8\u963b\u529b").defineInRange("climbHorizontalDrag", 0.7, 0.5, 1.0);
            this.FAIRY_DEW_SCALE_FACTOR = BUILDER.comment("\u4ed9\u5973\u65cf\u4f53\u578b\u7f29\u653e 1 \u4e3a\u6b63\u5e38\u4f53\u578b").defineInRange("scale", 0.25, 0.1, 10.0);
            builder.pop();
        }
    }

    public static class GoblinsAttributes {
        public final ForgeConfigSpec.DoubleValue MAX_HEALTH;
        public final ForgeConfigSpec.DoubleValue FOLLOW_RANGE;
        public final ForgeConfigSpec.DoubleValue KNOCKBACK_RESISTANCE;
        public final ForgeConfigSpec.DoubleValue MOVEMENT_SPEED;
        public final ForgeConfigSpec.DoubleValue FLYING_SPEED;
        public final ForgeConfigSpec.DoubleValue ATTACK_DAMAGE;
        public final ForgeConfigSpec.DoubleValue ATTACK_KNOCKBACK;
        public final ForgeConfigSpec.DoubleValue ATTACK_SPEED;
        public final ForgeConfigSpec.DoubleValue ARMOR;
        public final ForgeConfigSpec.DoubleValue ARMOR_TOUGHNESS;
        public final ForgeConfigSpec.DoubleValue LUCK;
        public final ForgeConfigSpec.DoubleValue SWIM_SPEED;
        public final ForgeConfigSpec.DoubleValue NAMETAG_DISTANCE;
        public final ForgeConfigSpec.DoubleValue ENTITY_GRAVITY;
        public final ForgeConfigSpec.DoubleValue STEP_HEIGHT;
        public final ForgeConfigSpec.DoubleValue BLOCK_REACH;
        public final ForgeConfigSpec.DoubleValue ENTITY_REACH;
        public final ForgeConfigSpec.DoubleValue GOBLIN_MANA_PENALTY;
        public final ForgeConfigSpec.DoubleValue GOBLIN_DAMAGE_REDUCTION;
        public final ForgeConfigSpec.DoubleValue GOBLIN_SCALE_FACTOR;

        public GoblinsAttributes(ForgeConfigSpec.Builder builder) {
            builder.comment("\u54e5\u5e03\u6797\u65cf\u5c5e\u6027\u914d\u7f6e").push("goblins");
            this.MAX_HEALTH = builder.comment("\u751f\u547d\u503c\u500d\u7387").defineInRange("max_health", -0.4, -10.0, 10.0);
            this.FOLLOW_RANGE = builder.comment("\u8ddf\u968f\u8303\u56f4\u500d\u7387").defineInRange("follow_range", 0.0, -10.0, 10.0);
            this.KNOCKBACK_RESISTANCE = builder.comment("\u51fb\u9000\u6297\u6027").defineInRange("knockback_resistance", 0.0, -10.0, 1.0);
            this.MOVEMENT_SPEED = builder.comment("\u79fb\u52a8\u901f\u5ea6\u500d\u7387").defineInRange("movement_speed", 0.2, -10.0, 10.0);
            this.FLYING_SPEED = builder.comment("\u98de\u884c\u901f\u5ea6\u500d\u7387").defineInRange("flying_speed", 0.0, -10.0, 10.0);
            this.ATTACK_DAMAGE = builder.comment("\u653b\u51fb\u4f24\u5bb3\u500d\u7387").defineInRange("attack_damage", -0.5, -10.0, 10.0);
            this.ATTACK_KNOCKBACK = builder.comment("\u653b\u51fb\u51fb\u9000\u529b\u5ea6").defineInRange("attack_knockback", 0.0, -10.0, 10.0);
            this.ATTACK_SPEED = builder.comment("\u653b\u51fb\u901f\u5ea6\u500d\u7387").defineInRange("attack_speed", 0.0, -10.0, 10.0);
            this.ARMOR = builder.comment("\u62a4\u7532\u503c\u52a0\u6210").defineInRange("armor", 0.0, -10.0, 50.0);
            this.ARMOR_TOUGHNESS = builder.comment("\u62a4\u7532\u97e7\u6027\u52a0\u6210").defineInRange("armor_toughness", 0.0, -10.0, 50.0);
            this.LUCK = builder.comment("\u5e78\u8fd0\u503c\u52a0\u6210").defineInRange("luck", 1.0, -10.0, 10.0);
            this.SWIM_SPEED = builder.comment("\u6e38\u6cf3\u901f\u5ea6\u500d\u7387").defineInRange("swim_speed", 0.1, -10.0, 10.0);
            this.NAMETAG_DISTANCE = builder.comment("\u540d\u79f0\u6807\u7b7e\u663e\u793a\u8ddd\u79bb\u500d\u7387").defineInRange("nametag_distance", 0.0, -10.0, 10.0);
            this.ENTITY_GRAVITY = builder.comment("\u91cd\u529b\u5f71\u54cd\u500d\u7387").defineInRange("entity_gravity", 0.0, -10.0, 10.0);
            this.STEP_HEIGHT = builder.comment("\u6b65\u9ad8\u589e\u52a0\u503c").defineInRange("step_height", 0.0, -10.0, 10.0);
            this.BLOCK_REACH = builder.comment("\u65b9\u5757\u4ea4\u4e92\u8ddd\u79bb\u500d\u7387").defineInRange("block_reach", 0.0, -10.0, 10.0);
            this.ENTITY_REACH = builder.comment("\u5b9e\u4f53\u4ea4\u4e92\u8ddd\u79bb\u500d\u7387").defineInRange("entity_reach", 0.0, -10.0, 10.0);
            this.GOBLIN_MANA_PENALTY = BUILDER.comment("\u9b54\u529b\u503c\u4fee\u6539\u91cf").defineInRange("manaPenalty", -25.0, -10000.0, 10000.0);
            this.GOBLIN_DAMAGE_REDUCTION = BUILDER.comment("\u706b\u7130\u548c\u7206\u70b8\u4f24\u5bb3\u51cf\u514d\u6bd4\u4f8b").defineInRange("damageReduction", 0.75, 0.0, 1.0);
            this.GOBLIN_SCALE_FACTOR = BUILDER.comment("\u54e5\u5e03\u6797\u65cf\u4f53\u578b\u7f29\u653e 1 \u4e3a\u6b63\u5e38\u4f53\u578b").defineInRange("scale", 0.5, 0.1, 10.0);
            builder.pop();
        }
    }

    public static class TitanAttributes {
        public final ForgeConfigSpec.DoubleValue MAX_HEALTH;
        public final ForgeConfigSpec.DoubleValue FOLLOW_RANGE;
        public final ForgeConfigSpec.DoubleValue KNOCKBACK_RESISTANCE;
        public final ForgeConfigSpec.DoubleValue MOVEMENT_SPEED;
        public final ForgeConfigSpec.DoubleValue FLYING_SPEED;
        public final ForgeConfigSpec.DoubleValue ATTACK_DAMAGE;
        public final ForgeConfigSpec.DoubleValue ATTACK_KNOCKBACK;
        public final ForgeConfigSpec.DoubleValue ATTACK_SPEED;
        public final ForgeConfigSpec.DoubleValue ARMOR;
        public final ForgeConfigSpec.DoubleValue ARMOR_TOUGHNESS;
        public final ForgeConfigSpec.DoubleValue LUCK;
        public final ForgeConfigSpec.DoubleValue SWIM_SPEED;
        public final ForgeConfigSpec.DoubleValue NAMETAG_DISTANCE;
        public final ForgeConfigSpec.DoubleValue ENTITY_GRAVITY;
        public final ForgeConfigSpec.DoubleValue STEP_HEIGHT;
        public final ForgeConfigSpec.DoubleValue BLOCK_REACH;
        public final ForgeConfigSpec.DoubleValue ENTITY_REACH;
        public final ForgeConfigSpec.DoubleValue TITAN_JUMP_BOOST;
        public final ForgeConfigSpec.DoubleValue TITAN_MANA_MODIFIER;
        public final ForgeConfigSpec.DoubleValue TITAN_WATER_SINK_SPEED;
        public final ForgeConfigSpec.DoubleValue TITAN_SCALE_FACTOR;

        public TitanAttributes(ForgeConfigSpec.Builder builder) {
            builder.comment("\u6cf0\u5766\u65cf\u5c5e\u6027\u914d\u7f6e").push("titan");
            this.MAX_HEALTH = builder.comment("\u751f\u547d\u503c\u500d\u7387").defineInRange("max_health", 1.0, -10.0, 10.0);
            this.FOLLOW_RANGE = builder.comment("\u8ddf\u968f\u8303\u56f4\u500d\u7387").defineInRange("follow_range", 0.0, -10.0, 10.0);
            this.KNOCKBACK_RESISTANCE = builder.comment("\u51fb\u9000\u6297\u6027").defineInRange("knockback_resistance", 1.0, -10.0, 1.0);
            this.MOVEMENT_SPEED = builder.comment("\u79fb\u52a8\u901f\u5ea6\u500d\u7387").defineInRange("movement_speed", 0.0, -10.0, 10.0);
            this.FLYING_SPEED = builder.comment("\u98de\u884c\u901f\u5ea6\u500d\u7387").defineInRange("flying_speed", 0.0, -10.0, 10.0);
            this.ATTACK_DAMAGE = builder.comment("\u653b\u51fb\u4f24\u5bb3\u500d\u7387").defineInRange("attack_damage", 0.5, -10.0, 10.0);
            this.ATTACK_KNOCKBACK = builder.comment("\u653b\u51fb\u51fb\u9000\u529b\u5ea6").defineInRange("attack_knockback", 0.0, -10.0, 10.0);
            this.ATTACK_SPEED = builder.comment("\u653b\u51fb\u901f\u5ea6\u500d\u7387").defineInRange("attack_speed", -0.5, -10.0, 10.0);
            this.ARMOR = builder.comment("\u62a4\u7532\u503c\u52a0\u6210").defineInRange("armor", 0.0, -10.0, 50.0);
            this.ARMOR_TOUGHNESS = builder.comment("\u62a4\u7532\u97e7\u6027\u52a0\u6210").defineInRange("armor_toughness", 0.0, -10.0, 50.0);
            this.LUCK = builder.comment("\u5e78\u8fd0\u503c\u52a0\u6210").defineInRange("luck", 0.0, -10.0, 10.0);
            this.SWIM_SPEED = builder.comment("\u6e38\u6cf3\u901f\u5ea6\u500d\u7387").defineInRange("swim_speed", 0.0, -10.0, 10.0);
            this.NAMETAG_DISTANCE = builder.comment("\u540d\u79f0\u6807\u7b7e\u663e\u793a\u8ddd\u79bb\u500d\u7387").defineInRange("nametag_distance", 0.0, -10.0, 10.0);
            this.ENTITY_GRAVITY = builder.comment("\u91cd\u529b\u5f71\u54cd\u500d\u7387").defineInRange("entity_gravity", 0.0, -10.0, 10.0);
            this.STEP_HEIGHT = builder.comment("\u6b65\u9ad8\u589e\u52a0\u503c").defineInRange("step_height", 1.4, -10.0, 10.0);
            this.BLOCK_REACH = builder.comment("\u65b9\u5757\u4ea4\u4e92\u8ddd\u79bb\u500d\u7387").defineInRange("block_reach", 1.0, -10.0, 10.0);
            this.ENTITY_REACH = builder.comment("\u5b9e\u4f53\u4ea4\u4e92\u8ddd\u79bb\u500d\u7387").defineInRange("entity_reach", 0.0, -10.0, 10.0);
            this.TITAN_JUMP_BOOST = BUILDER.comment("\u8df3\u8dc3\u529b\u91cf\u4fee\u6539\u503c").defineInRange("jumpStrength", 0.75, -1.0, 2.0);
            this.TITAN_MANA_MODIFIER = BUILDER.comment("\u9b54\u529b\u503c\u4fee\u6539\u91cf").defineInRange("manaModifier", -50.0, -10000.0, 10000.0);
            this.TITAN_WATER_SINK_SPEED = BUILDER.comment("\u6c34\u4e2d\u4e0b\u6c89\u901f\u5ea6").defineInRange("waterSinkSpeed", 0.1, 0.0, 1.0);
            this.TITAN_SCALE_FACTOR = BUILDER.comment("\u6cf0\u5766\u65cf\u4f53\u578b\u7f29\u653e 1 \u4e3a\u6b63\u5e38\u4f53\u578b").defineInRange("scale", 3.0, 0.1, 10.0);
            builder.pop();
        }
    }
}

