/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.trinketsandbaubles.event;

import com.jinqinxixi.trinketsandbaubles.TrinketsandBaublesMod;
import com.jinqinxixi.trinketsandbaubles.capability.impl.DragonCapability;
import com.jinqinxixi.trinketsandbaubles.capability.impl.FairyCapability;
import com.jinqinxixi.trinketsandbaubles.capability.mana.hud.ManaHudOverlay;
import com.jinqinxixi.trinketsandbaubles.capability.registry.ModCapabilities;
import com.jinqinxixi.trinketsandbaubles.client.keybind.KeyBindings;
import com.jinqinxixi.trinketsandbaubles.network.handler.ClientNetworkHandler;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="trinketsandbaubles", value={Dist.CLIENT})
public class ClientForgeEvents {
    private static boolean wasCharging = false;
    private static boolean wasBreathing = false;

    @SubscribeEvent
    public static void onKeyInput(InputEvent.Key event) {
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        if (player == null || minecraft.m_91403_() == null) {
            return;
        }
        ClientForgeEvents.handleEscapeAndManaHUD(event, minecraft);
        ClientForgeEvents.handleMovementKeys((Player)player);
        ClientForgeEvents.handleDragonCapability(event, minecraft, (Player)player);
        ClientForgeEvents.handleFairyCapability((Player)player);
        ClientForgeEvents.handleItemToggles((Player)player);
        ClientForgeEvents.handlePolarizedStoneToggles();
    }

    private static void handleEscapeAndManaHUD(InputEvent.Key event, Minecraft minecraft) {
        if (event.getKey() == 256 && event.getAction() == 1) {
            ManaHudOverlay.getInstance().handleEscapeKey();
        }
        if (KeyBindings.MANA_HUD_POSITION_KEY.m_90859_()) {
            ManaHudOverlay.getInstance().toggleDragMode();
        }
    }

    private static void handleMovementKeys(Player player) {
        while (KeyBindings.DASH_KEY.m_90859_()) {
            ClientNetworkHandler.sendDashKeyPress();
        }
        boolean isCharging = KeyBindings.CHARGE_KEY.m_90857_();
        if (isCharging != wasCharging) {
            if (isCharging) {
                ClientNetworkHandler.sendChargeKey();
            } else {
                ClientNetworkHandler.sendStopCharge();
            }
            wasCharging = isCharging;
        }
    }

    private static void handleDragonCapability(InputEvent.Key event, Minecraft minecraft, Player player) {
        player.getCapability(ModCapabilities.DRAGON_CAPABILITY).ifPresent(cap -> {
            DragonCapability dragonCap;
            if (cap instanceof DragonCapability && (dragonCap = (DragonCapability)cap).isActive()) {
                boolean isBreathing;
                if (KeyBindings.DRAGON_FLIGHT_TOGGLE_KEY.m_90859_()) {
                    ClientNetworkHandler.sendDragonFlightToggle();
                }
                if ((isBreathing = KeyBindings.DRAGON_BREATH_KEY.m_90857_()) != wasBreathing) {
                    TrinketsandBaublesMod.LOGGER.info("Dragon breath key state changed. isBreathing: {}, wasBreathing: {}", (Object)isBreathing, (Object)wasBreathing);
                    if (isBreathing) {
                        if (!dragonCap.isDragonBreathActive()) {
                            TrinketsandBaublesMod.LOGGER.info("Sending dragon breath activation");
                            ClientNetworkHandler.sendDragonBreath();
                        }
                    } else if (dragonCap.isDragonBreathActive()) {
                        TrinketsandBaublesMod.LOGGER.info("Sending dragon breath deactivation");
                        ClientNetworkHandler.sendStopDragonBreath();
                    }
                    wasBreathing = isBreathing;
                }
            }
        });
    }

    private static void handleFairyCapability(Player player) {
        player.getCapability(ModCapabilities.FAIRY_CAPABILITY).ifPresent(cap -> {
            FairyCapability fairyCap;
            if (cap instanceof FairyCapability && (fairyCap = (FairyCapability)cap).isActive() && KeyBindings.DRAGON_FLIGHT_TOGGLE_KEY.m_90859_()) {
                ClientNetworkHandler.sendDragonFlightToggle();
            }
        });
    }

    private static void handleItemToggles(Player player) {
        AtomicBoolean hasDragonCapability = new AtomicBoolean(false);
        player.getCapability(ModCapabilities.DRAGON_CAPABILITY).ifPresent(cap -> {
            DragonCapability dragonCap;
            if (cap instanceof DragonCapability && (dragonCap = (DragonCapability)cap).isActive()) {
                hasDragonCapability.set(true);
            }
        });
        if (KeyBindings.DRAGON_NIGHT_VISION_KEY.m_90859_()) {
            TrinketsandBaublesMod.LOGGER.info("Night vision toggle requested");
            ClientNetworkHandler.sendDragonsEyeToggle(1);
        }
    }

    private static void handlePolarizedStoneToggles() {
        while (KeyBindings.ATTRACTION_TOGGLE_KEY.m_90859_()) {
            ClientNetworkHandler.sendPolarizedStoneToggle(false);
        }
        while (KeyBindings.DEFLECTION_TOGGLE_KEY.m_90859_()) {
            ClientNetworkHandler.sendPolarizedStoneToggle(true);
        }
    }
}

