/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.trinketsandbaubles.event;

import com.jinqinxixi.trinketsandbaubles.capability.impl.DragonCapability;
import com.jinqinxixi.trinketsandbaubles.capability.mana.ManaData;
import com.jinqinxixi.trinketsandbaubles.capability.registry.ModCapabilities;
import com.jinqinxixi.trinketsandbaubles.config.ModConfig;
import com.jinqinxixi.trinketsandbaubles.config.RaceAttributesConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import vazkii.botania.api.mana.ManaItemHandler;

@Mod.EventBusSubscriber(modid="trinketsandbaubles")
public class DragonCapabilityServerHandler {
    private static ManaSystem getManaSystem() {
        if (DragonCapabilityServerHandler.shouldUseIronsSpellsMana()) {
            return new IronsSpellsManaSystem();
        }
        if (DragonCapabilityServerHandler.shouldUseBotaniaMana()) {
            return new BotaniaManaSystem();
        }
        return new InternalManaSystem();
    }

    private static boolean shouldUseBotaniaMana() {
        return ModList.get().isLoaded("botania") && (Boolean)ModConfig.USE_BOTANIA_MANA.get() != false;
    }

    private static boolean shouldUseIronsSpellsMana() {
        try {
            Class.forName("io.redspace.ironsspellbooks.api.magic.MagicData");
            return (Boolean)ModConfig.USE_IRONS_SPELLS_MANA.get();
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        for (ServerLevel level : event.getServer().m_129785_()) {
            for (ServerPlayer player : level.m_6907_()) {
                player.getCapability(ModCapabilities.DRAGON_CAPABILITY).ifPresent(cap -> {
                    if (cap instanceof DragonCapability) {
                        DragonCapability dragonCap = (DragonCapability)cap;
                        if (!dragonCap.isActive() || !dragonCap.isDragonBreathActive()) {
                            return;
                        }
                        ManaSystem manaSystem = DragonCapabilityServerHandler.getManaSystem();
                        float manaCost = ((Double)RaceAttributesConfig.DRAGON.DRAGON_BREATH_MANA_COST.get()).floatValue();
                        boolean hasSufficientMana = false;
                        if (manaSystem instanceof BotaniaManaSystem) {
                            if ((double)player.f_19797_ % (Double)RaceAttributesConfig.DRAGON.DRAGON_MANA_CHECK_INTERVAL.get() == 0.0) {
                                if (manaSystem.hasMana((Player)player, manaCost, BotaniaManaSystem.DUMMY_RECEIVER)) {
                                    manaSystem.consumeMana((Player)player, manaCost, BotaniaManaSystem.DUMMY_RECEIVER);
                                    hasSufficientMana = true;
                                }
                            } else {
                                hasSufficientMana = true;
                            }
                        } else {
                            float tickCost = Math.max(1.0f, manaCost / 20.0f);
                            if (manaSystem.hasMana((Player)player, tickCost, BotaniaManaSystem.DUMMY_RECEIVER)) {
                                manaSystem.consumeMana((Player)player, tickCost, BotaniaManaSystem.DUMMY_RECEIVER);
                                hasSufficientMana = true;
                            }
                        }
                        if (!hasSufficientMana) {
                            dragonCap.toggleDragonBreath();
                            return;
                        }
                        DragonCapabilityServerHandler.handleDragonBreathDamage((Player)player, level);
                    }
                });
            }
        }
    }

    private static void handleDragonBreathDamage(Player player, ServerLevel level) {
        Vec3 look = player.m_20154_();
        Vec3 playerPos = player.m_146892_();
        double range = 15.0;
        double baseSpread = 1.0;
        double startDistance = 1.0;
        double maxSpreadMultiplier = 2.0;
        level.m_6249_((Entity)player, player.m_20191_().m_82400_(range + 2.0), entity -> {
            double distanceRatio;
            double currentSpread;
            if (!(entity instanceof LivingEntity) || entity == player) {
                return false;
            }
            Vec3 targetPos = entity.m_20182_().m_82520_(0.0, (double)entity.m_20206_() * 0.5, 0.0);
            Vec3 toTarget = targetPos.m_82546_(playerPos);
            double projectionLength = toTarget.m_82526_(look);
            if (projectionLength < startDistance || projectionLength > range) {
                return false;
            }
            Vec3 projection = playerPos.m_82549_(look.m_82490_(projectionLength));
            double distanceFromLine = targetPos.m_82554_(projection);
            return distanceFromLine <= (currentSpread = baseSpread * (1.0 + (distanceRatio = projectionLength / range) * maxSpreadMultiplier));
        }).forEach(target -> {
            if (target instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)target;
                double distance = target.m_20182_().m_82546_(playerPos).m_82553_();
                float damage = ((Double)RaceAttributesConfig.DRAGON.DRAGON_BREATH_BASE_DAMAGE.get()).floatValue() * (float)(1.0 - distance / range * (Double)RaceAttributesConfig.DRAGON.DRAGON_BREATH_DECAY_RATE.get());
                damage = Math.max(((Double)RaceAttributesConfig.DRAGON.DRAGON_BREATH_MIN_DAMAGE.get()).floatValue(), damage);
                target.m_7311_(100);
                target.m_6469_(player.m_269291_().m_269075_(player), damage);
            }
        });
    }

    @SubscribeEvent
    public static void onLivingUpdate(LivingEvent.LivingTickEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        player.getCapability(ModCapabilities.DRAGON_CAPABILITY).ifPresent(cap -> {
            if (cap instanceof DragonCapability) {
                Level patt9471$temp;
                DragonCapability dragonCap = (DragonCapability)cap;
                if (!dragonCap.isActive() || !dragonCap.isDragonBreathActive()) {
                    return;
                }
                if (!player.m_9236_().f_46443_ && (patt9471$temp = player.m_9236_()) instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)patt9471$temp;
                    DragonCapabilityServerHandler.spawnDragonBreathParticles(player, serverLevel);
                }
            }
        });
    }

    private static void spawnDragonBreathParticles(Player player, ServerLevel serverLevel) {
        RandomSource random = player.m_217043_();
        Vec3 look = player.m_20154_();
        Vec3 eyePos = player.m_20299_(1.0f);
        Vec3 startPos = eyePos.m_82520_(look.f_82479_, look.f_82480_, look.f_82481_);
        double range = 15.0;
        double spread = 0.5;
        double startDistance = 0.0;
        int i = 1;
        while ((double)i <= range - startDistance) {
            DragonCapabilityServerHandler.createFireParticles(serverLevel, random, look, startPos, i, range, spread);
            ++i;
        }
        DragonCapabilityServerHandler.createDragonBreathParticles(serverLevel, random, look, startPos);
        DragonCapabilityServerHandler.playDragonBreathSounds(serverLevel, random, player);
    }

    private static void createFireParticles(ServerLevel serverLevel, RandomSource random, Vec3 look, Vec3 startPos, int i, double range, double spread) {
        double distance = (double)i / 2.0;
        int particles = 5 + i / 2;
        for (int p = 0; p < particles; ++p) {
            double spreadFactor = spread * ((double)i / range);
            double angle = random.m_188500_() * Math.PI * 2.0;
            double offsetX = Math.cos(angle) * spreadFactor * random.m_188500_();
            double offsetY = Math.sin(angle) * spreadFactor * random.m_188500_();
            double offsetZ = Math.cos(angle) * spreadFactor * random.m_188500_();
            double x = startPos.f_82479_ + look.f_82479_ * distance + offsetX;
            double y = startPos.f_82480_ + look.f_82480_ * distance + offsetY;
            double z = startPos.f_82481_ + look.f_82481_ * distance + offsetZ;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123744_, x, y, z, 1, (random.m_188500_() - 0.5) * 0.1, (random.m_188500_() - 0.5) * 0.1, (random.m_188500_() - 0.5) * 0.1, 0.01);
            if ((double)random.m_188501_() < 0.3) {
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123762_, x, y, z, 1, 0.0, 0.1, 0.0, 0.01);
            }
            if (!((double)random.m_188501_() < 0.1)) continue;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123756_, x, y, z, 1, (random.m_188500_() - 0.5) * 0.2, (random.m_188500_() - 0.5) * 0.2, (random.m_188500_() - 0.5) * 0.2, 0.01);
        }
        if (i % 1 == 0) {
            DragonCapabilityServerHandler.createSoulFireParticles(serverLevel, random, look, startPos, distance);
        }
    }

    private static void createSoulFireParticles(ServerLevel serverLevel, RandomSource random, Vec3 look, Vec3 startPos, double distance) {
        for (int centerParticles = 0; centerParticles < 3; ++centerParticles) {
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123745_, startPos.f_82479_ + look.f_82479_ * distance + (random.m_188500_() - 0.5) * 0.2, startPos.f_82480_ + look.f_82480_ * distance + (random.m_188500_() - 0.5) * 0.2, startPos.f_82481_ + look.f_82481_ * distance + (random.m_188500_() - 0.5) * 0.2, 1, (random.m_188500_() - 0.5) * 0.02, (random.m_188500_() - 0.5) * 0.02, (random.m_188500_() - 0.5) * 0.02, 0.01);
        }
    }

    private static void createDragonBreathParticles(ServerLevel serverLevel, RandomSource random, Vec3 look, Vec3 startPos) {
        Vec3 dragonBreathPos = startPos.m_82549_(look.m_82542_(0.5, 0.5, 0.5));
        for (int i = 0; i < 2; ++i) {
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123799_, dragonBreathPos.f_82479_ + (random.m_188500_() - 0.5) * 0.5, dragonBreathPos.f_82480_ + (random.m_188500_() - 0.5) * 0.5, dragonBreathPos.f_82481_ + (random.m_188500_() - 0.5) * 0.5, 1, look.f_82479_ * 0.2 + (random.m_188500_() - 0.5) * 0.1, look.f_82480_ * 0.2 + (random.m_188500_() - 0.5) * 0.1, look.f_82481_ * 0.2 + (random.m_188500_() - 0.5) * 0.1, 0.01);
        }
    }

    private static void playDragonBreathSounds(ServerLevel serverLevel, RandomSource random, Player player) {
        if (random.m_188501_() < 0.4f) {
            serverLevel.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11705_, SoundSource.PLAYERS, 0.3f, 0.7f + random.m_188501_() * 0.3f);
        }
        if (random.m_188501_() < 0.4f) {
            serverLevel.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11936_, SoundSource.PLAYERS, 0.2f, 0.8f + random.m_188501_() * 0.2f);
        }
    }

    private static class IronsSpellsManaSystem
    implements ManaSystem {
        private IronsSpellsManaSystem() {
        }

        @Override
        public float getMana(Player player, ItemStack stack) {
            return MagicData.getPlayerMagicData((LivingEntity)player).getMana();
        }

        @Override
        public void consumeMana(Player player, float amount, ItemStack stack) {
            float actualAmount = Math.max(1.0f, amount);
            MagicData.getPlayerMagicData((LivingEntity)player).addMana(-actualAmount);
        }

        @Override
        public boolean hasMana(Player player, float amount, ItemStack stack) {
            float actualAmount = Math.max(1.0f, amount);
            return this.getMana(player, stack) >= actualAmount;
        }
    }

    private static class BotaniaManaSystem
    implements ManaSystem {
        public static final ItemStack DUMMY_RECEIVER = new ItemStack((ItemLike)Items.f_42398_);

        private BotaniaManaSystem() {
        }

        @Override
        public float getMana(Player player, ItemStack stack) {
            ManaItemHandler handler = ManaItemHandler.instance();
            return handler.requestMana(DUMMY_RECEIVER, player, Integer.MAX_VALUE, false);
        }

        @Override
        public void consumeMana(Player player, float amount, ItemStack stack) {
            ManaItemHandler handler = ManaItemHandler.instance();
            handler.requestMana(DUMMY_RECEIVER, player, (int)amount, true);
        }

        @Override
        public boolean hasMana(Player player, float amount, ItemStack stack) {
            ManaItemHandler handler = ManaItemHandler.instance();
            return (float)handler.requestMana(DUMMY_RECEIVER, player, (int)amount, false) >= amount;
        }
    }

    private static class InternalManaSystem
    implements ManaSystem {
        private InternalManaSystem() {
        }

        @Override
        public float getMana(Player player, ItemStack stack) {
            return ManaData.getMana(player);
        }

        @Override
        public void consumeMana(Player player, float amount, ItemStack stack) {
            ManaData.consumeMana(player, amount);
        }

        @Override
        public boolean hasMana(Player player, float amount, ItemStack stack) {
            return ManaData.hasMana(player, amount);
        }
    }

    private static interface ManaSystem {
        public float getMana(Player var1, ItemStack var2);

        public void consumeMana(Player var1, float var2, ItemStack var3);

        public boolean hasMana(Player var1, float var2, ItemStack var3);
    }
}

