/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.trinketsandbaubles.items.baubles;

import com.jinqinxixi.trinketsandbaubles.capability.mana.ManaData;
import com.jinqinxixi.trinketsandbaubles.client.keybind.KeyBindings;
import com.jinqinxixi.trinketsandbaubles.config.ModConfig;
import com.jinqinxixi.trinketsandbaubles.modifier.ModifiableBaubleItem;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import vazkii.botania.api.mana.ManaItemHandler;

@Mod.EventBusSubscriber(modid="trinketsandbaubles")
public class ArcingOrbItem
extends ModifiableBaubleItem {
    private static final String DASH_COOLDOWN_TAG = "DashCooldown";
    private static final String ARCING_ORB_CHARGING_TAG = "ArcingOrbCharging";
    private static final String CHARGE_AMOUNT_TAG = "ChargeAmount";
    private static final UUID SPEED_MODIFIER_UUID = UUID.fromString("c9e57654-f302-4bed-97c1-f49d895e8667");
    private static final ModifiableBaubleItem.Modifier[] MODIFIERS = ModifiableBaubleItem.Modifier.values();

    private ManaSystem getManaSystem() {
        if (this.shouldUseIronsSpellsMana()) {
            return new IronsSpellsManaSystem();
        }
        if (this.shouldUseBotaniaMana()) {
            return new BotaniaManaSystem();
        }
        return new InternalManaSystem();
    }

    private boolean shouldUseBotaniaMana() {
        return ModList.get().isLoaded("botania") && (Boolean)ModConfig.USE_BOTANIA_MANA.get() != false;
    }

    private boolean shouldUseIronsSpellsMana() {
        try {
            Class.forName("io.redspace.ironsspellbooks.api.magic.MagicData");
            return (Boolean)ModConfig.USE_IRONS_SPELLS_MANA.get();
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    @Override
    public ModifiableBaubleItem.Modifier[] getModifiers() {
        return MODIFIERS;
    }

    public ArcingOrbItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public void applyModifier(Player player, ItemStack stack) {
        super.applyModifier(player, stack);
        this.applySpeedAttribute(player);
    }

    @Override
    public void removeModifier(Player player, ItemStack stack) {
        super.removeModifier(player, stack);
        if (!this.hasSameItemEquipped(player)) {
            this.removeSpeedAttribute(player);
        }
    }

    private void applySpeedAttribute(Player player) {
        AttributeInstance attribute = player.m_21051_(Attributes.f_22279_);
        if (attribute == null) {
            return;
        }
        AttributeModifier existing = attribute.m_22111_(SPEED_MODIFIER_UUID);
        if (existing == null) {
            attribute.m_22125_(new AttributeModifier(SPEED_MODIFIER_UUID, "trinketsandbaubles.arcing_orb_speed", ((Double)ModConfig.SPEED_BOOST.get()).doubleValue(), AttributeModifier.Operation.MULTIPLY_TOTAL));
        } else if (existing.m_22218_() != ((Double)ModConfig.SPEED_BOOST.get()).doubleValue()) {
            attribute.m_22120_(SPEED_MODIFIER_UUID);
            attribute.m_22125_(new AttributeModifier(SPEED_MODIFIER_UUID, "trinketsandbaubles.arcing_orb_speed", ((Double)ModConfig.SPEED_BOOST.get()).doubleValue(), AttributeModifier.Operation.MULTIPLY_TOTAL));
        }
    }

    private void removeSpeedAttribute(Player player) {
        AttributeInstance attribute = player.m_21051_(Attributes.f_22279_);
        if (attribute != null) {
            attribute.m_22120_(SPEED_MODIFIER_UUID);
        }
    }

    private boolean hasSameItemEquipped(Player player) {
        return CuriosApi.getCuriosInventory((LivingEntity)player).resolve().map(handler -> {
            int count = 0;
            for (String identifier : handler.getCurios().keySet()) {
                ICurioStacksHandler stackHandler = (ICurioStacksHandler)handler.getCurios().get(identifier);
                if (stackHandler == null) continue;
                for (int i = 0; i < stackHandler.getSlots(); ++i) {
                    ItemStack stack = stackHandler.getStacks().getStackInSlot(i);
                    if (!(stack.m_41720_() instanceof ArcingOrbItem) || ++count < 2) continue;
                    return true;
                }
            }
            return count >= 2;
        }).orElse(false);
    }

    public void handleDash(Player player, ItemStack stack) {
        float cooldownTicks = stack.m_41784_().m_128457_(DASH_COOLDOWN_TAG);
        if (cooldownTicks > 0.0f) {
            return;
        }
        ManaSystem manaSystem = this.getManaSystem();
        float manaCost = ((Double)ModConfig.DASH_MANA_COST.get()).floatValue();
        if (manaSystem instanceof IronsSpellsManaSystem) {
            manaCost = Math.max(1.0f, (float)Math.ceil(manaCost));
        }
        if (manaSystem.hasMana(player, manaCost, stack)) {
            this.performDash(player);
            manaSystem.consumeMana(player, manaCost, stack);
            stack.m_41784_().m_128350_(DASH_COOLDOWN_TAG, ((Integer)ModConfig.DASH_COOLDOWN.get()).floatValue());
            this.playDashEffects(player);
        }
    }

    public void handleCharge(Player player, ItemStack stack) {
        if (!stack.m_41784_().m_128471_(ARCING_ORB_CHARGING_TAG)) {
            this.startCharging(stack);
        }
        this.updateCharging(stack, player);
    }

    private void performDash(Player player) {
        Vec3 lookVec = player.m_20154_();
        double x = lookVec.f_82479_;
        double z = lookVec.f_82481_;
        double horizontalLength = Math.sqrt(x * x + z * z);
        if (horizontalLength > 0.0) {
            x /= horizontalLength;
            z /= horizontalLength;
        }
        Vec3 startPos = player.m_20182_();
        double dashVelocity = 0.3;
        double pushFactor = 0.075;
        double upwardBoost = 0.05;
        double currentVerticalSpeed = player.m_20184_().f_82480_;
        if (currentVerticalSpeed < 0.0) {
            upwardBoost += Math.min(Math.abs(currentVerticalSpeed) * (Double)ModConfig.DASH_JUMP_BOOST.get(), 0.1);
        }
        player.m_20334_(x * dashVelocity * (Double)ModConfig.DASH_DISTANCE.get(), currentVerticalSpeed + upwardBoost, z * dashVelocity * (Double)ModConfig.DASH_DISTANCE.get());
        player.m_5997_(x * (Double)ModConfig.DASH_DISTANCE.get() * pushFactor, 0.0, z * (Double)ModConfig.DASH_DISTANCE.get() * pushFactor);
        if (!player.m_9236_().f_46443_) {
            Vec3 endPos = startPos.m_82520_(x * (Double)ModConfig.DASH_DISTANCE.get(), 0.0, z * (Double)ModConfig.DASH_DISTANCE.get());
            AABB dashBox = new AABB(Math.min(startPos.f_82479_, endPos.f_82479_) - 0.5, startPos.f_82480_ - 0.5, Math.min(startPos.f_82481_, endPos.f_82481_) - 0.5, Math.max(startPos.f_82479_, endPos.f_82479_) + 0.5, startPos.f_82480_ + 2.0, Math.max(startPos.f_82481_, endPos.f_82481_) + 0.5);
            List entities = player.m_9236_().m_6249_((Entity)player, dashBox, entity -> entity instanceof LivingEntity && entity != player);
            for (Entity entity2 : entities) {
                if (!this.isOnDashPath(startPos, endPos, entity2.m_20182_(), 1.0) || !(entity2 instanceof LivingEntity)) continue;
                LivingEntity living = (LivingEntity)entity2;
                living.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 60, 4));
                living.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 60, 255));
            }
        }
        player.f_19812_ = true;
        player.f_19864_ = true;
        player.f_19789_ = 0.0f;
        player.f_19802_ = 5;
        if (!player.m_20096_()) {
            player.m_20242_(true);
            Level level = player.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_7654_().m_6937_((Runnable)new TickTask(serverLevel.m_7654_().m_129921_() + 5, () -> player.m_20242_(false)));
            }
        }
    }

    private boolean isOnDashPath(Vec3 start, Vec3 end, Vec3 point, double threshold) {
        Vec3 path = end.m_82546_(start);
        Vec3 toPoint = point.m_82546_(start);
        double pathLength = path.m_82553_();
        double dot = toPoint.m_82526_(path.m_82541_());
        if (dot < 0.0 || dot > pathLength) {
            return false;
        }
        Vec3 projection = start.m_82549_(path.m_82541_().m_82490_(dot));
        return point.m_82554_(projection) <= threshold;
    }

    private void playDashEffects(Player player) {
        Level level = player.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12230_, SoundSource.PLAYERS, 1.0f, 1.5f);
            Vec3 pos = player.m_20182_();
            for (int i = 0; i < 20; ++i) {
                double offsetX = (Math.random() - 0.5) * 0.5;
                double offsetY = (Math.random() - 0.5) * 0.5;
                double offsetZ = (Math.random() - 0.5) * 0.5;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123796_, pos.f_82479_ + offsetX, pos.f_82480_ + offsetY, pos.f_82481_ + offsetZ, 1, 0.0, 0.0, 0.0, 0.1);
            }
        }
    }

    public int m_8105_(ItemStack pStack) {
        return 72000;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    private void startCharging(ItemStack stack) {
        stack.m_41784_().m_128379_(ARCING_ORB_CHARGING_TAG, true);
        stack.m_41784_().m_128350_(CHARGE_AMOUNT_TAG, 0.0f);
    }

    public void stopCharging(ItemStack stack, Player player) {
        if (stack.m_41784_().m_128471_(ARCING_ORB_CHARGING_TAG)) {
            float chargeAmount = stack.m_41784_().m_128457_(CHARGE_AMOUNT_TAG);
            if (chargeAmount >= ((Double)ModConfig.MIN_CHARGE.get()).floatValue()) {
                ManaSystem manaSystem = this.getManaSystem();
                float manaCost = chargeAmount;
                if (manaSystem instanceof BotaniaManaSystem) {
                    if (manaSystem.hasMana(player, manaCost, stack)) {
                        manaSystem.consumeMana(player, manaCost, stack);
                        this.releaseEnergyBeam(player, chargeAmount);
                    }
                } else {
                    this.releaseEnergyBeam(player, chargeAmount);
                }
            }
            stack.m_41784_().m_128379_(ARCING_ORB_CHARGING_TAG, false);
            stack.m_41784_().m_128350_(CHARGE_AMOUNT_TAG, 0.0f);
        }
    }

    private void updateCharging(ItemStack stack, Player player) {
        if (stack.m_41784_().m_128471_(ARCING_ORB_CHARGING_TAG)) {
            Level chargeRate2;
            float currentCharge = stack.m_41784_().m_128457_(CHARGE_AMOUNT_TAG);
            if ((double)currentCharge < (Double)ModConfig.MAX_CHARGE.get()) {
                ManaSystem manaSystem = this.getManaSystem();
                float chargeRate2 = ((Double)ModConfig.CHARGE_RATE.get()).floatValue();
                if (manaSystem instanceof BotaniaManaSystem) {
                    if (manaSystem.hasMana(player, chargeRate2, stack)) {
                        chargeToAdd = Math.min(chargeRate2, ((Double)ModConfig.MAX_CHARGE.get()).floatValue() - currentCharge);
                        stack.m_41784_().m_128350_(CHARGE_AMOUNT_TAG, currentCharge + chargeToAdd);
                    }
                } else {
                    if (manaSystem instanceof IronsSpellsManaSystem) {
                        chargeRate2 = Math.max(1.0f, (float)Math.ceil(chargeRate2));
                    }
                    if (manaSystem.hasMana(player, chargeRate2, stack)) {
                        manaSystem.consumeMana(player, chargeRate2, stack);
                        chargeToAdd = Math.min(chargeRate2, ((Double)ModConfig.MAX_CHARGE.get()).floatValue() - currentCharge);
                        stack.m_41784_().m_128350_(CHARGE_AMOUNT_TAG, currentCharge + chargeToAdd);
                    }
                }
            }
            if ((chargeRate2 = player.m_9236_()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)chargeRate2;
                Vec3 lookVec = player.m_20154_();
                float playerScale = player.m_6134_();
                Vec3 circleCenter = player.m_146892_().m_82549_(lookVec.m_82542_((double)(2.0f * playerScale), (double)(2.0f * playerScale), (double)(2.0f * playerScale)));
                this.createMagicCircle(serverLevel, circleCenter, currentCharge, player);
            }
        }
    }

    private void createMagicCircle(ServerLevel level, Vec3 center, float chargeAmount, Player player) {
        Vec3 up;
        float playerScale = player.m_6134_();
        double radius = (1.2 + (double)(chargeAmount / ((Double)ModConfig.MAX_CHARGE.get()).floatValue()) * 0.5) * (double)playerScale;
        float time = (float)level.m_46467_() / 20.0f;
        Vec3 normal = player.m_20154_();
        Vec3 right = normal.m_82537_(up = new Vec3(0.0, 1.0, 0.0)).m_82541_();
        if (right.m_82553_() < 0.001) {
            right = new Vec3(1.0, 0.0, 0.0);
        }
        Vec3 top = right.m_82537_(normal).m_82541_();
        center = player.m_146892_().m_82549_(normal.m_82542_((double)(2.0f * playerScale), (double)(2.0f * playerScale), (double)(2.0f * playerScale)));
        this.createDoubleRing(level, center, radius, time, right, top);
        this.createHexagram(level, center, (float)(radius * 0.8), time, right, top);
        this.createRunicRing(level, center, (float)(radius * 0.9), time, right, top);
        this.createEnergyPulse(level, center, radius, time, right, top, chargeAmount);
        this.createEnergyVortex(level, center, radius, time, right, top);
    }

    private void createDoubleRing(ServerLevel level, Vec3 center, double radius, float time, Vec3 right, Vec3 top) {
        double angle;
        int i;
        int points = 16;
        for (i = 0; i < points; ++i) {
            angle = (double)(i * 2) * Math.PI / (double)points + (double)time;
            Vec3 outerPos = center.m_82549_(right.m_82490_(Math.cos(angle) * radius).m_82549_(top.m_82490_(Math.sin(angle) * radius)));
            if (i % 2 != 0) continue;
            level.m_8767_((ParticleOptions)ParticleTypes.f_123810_, outerPos.f_82479_, outerPos.f_82480_, outerPos.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
        }
        for (i = 0; i < points; ++i) {
            angle = (double)(i * 2) * Math.PI / (double)points - (double)time * 1.5;
            Vec3 innerPos = center.m_82549_(right.m_82490_(Math.cos(angle) * (radius * 0.85)).m_82549_(top.m_82490_(Math.sin(angle) * (radius * 0.85))));
            if (i % 2 != 0) continue;
            level.m_8767_((ParticleOptions)ParticleTypes.f_123745_, innerPos.f_82479_, innerPos.f_82480_, innerPos.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    private void createHexagram(ServerLevel level, Vec3 center, float radius, float time, Vec3 right, Vec3 top) {
        int i;
        int points = 6;
        Vec3[] triangle1 = new Vec3[points / 2];
        Vec3[] triangle2 = new Vec3[points / 2];
        for (i = 0; i < points / 2; ++i) {
            double angle1 = (double)(i * 2) * Math.PI / (double)(points / 2) + (double)time;
            double angle2 = (double)(i * 2) * Math.PI / (double)(points / 2) - (double)time + Math.PI / (double)points;
            triangle1[i] = center.m_82549_(right.m_82490_(Math.cos(angle1) * (double)radius).m_82549_(top.m_82490_(Math.sin(angle1) * (double)radius)));
            triangle2[i] = center.m_82549_(right.m_82490_(Math.cos(angle2) * (double)radius).m_82549_(top.m_82490_(Math.sin(angle2) * (double)radius)));
        }
        for (i = 0; i < points / 2; ++i) {
            int next = (i + 1) % (points / 2);
            this.drawLine(level, triangle1[i], triangle1[next], (ParticleOptions)ParticleTypes.f_175830_, 5);
            this.drawLine(level, triangle2[i], triangle2[next], (ParticleOptions)ParticleTypes.f_175830_, 5);
        }
    }

    private void createRunicRing(ServerLevel level, Vec3 center, float radius, float time, Vec3 right, Vec3 top) {
        int runeCount = 8;
        for (int i = 0; i < runeCount; ++i) {
            double angle = (double)(i * 2) * Math.PI / (double)runeCount + (double)time * 0.5;
            Vec3 runePos = center.m_82549_(right.m_82490_(Math.cos(angle) * (double)radius).m_82549_(top.m_82490_(Math.sin(angle) * (double)radius)));
            this.createRune(level, runePos, angle, right, top, radius * 0.15f);
        }
    }

    private void createRune(ServerLevel level, Vec3 center, double angle, Vec3 right, Vec3 top, float size) {
        Vec3[] runePoints = new Vec3[4];
        for (int i = 0; i < 4; ++i) {
            Vec3 point;
            double runeAngle = angle + (double)i * Math.PI / 2.0;
            runePoints[i] = point = center.m_82549_(right.m_82490_(Math.cos(runeAngle) * (double)size).m_82549_(top.m_82490_(Math.sin(runeAngle) * (double)size)));
            level.m_8767_((ParticleOptions)ParticleTypes.f_123789_, point.f_82479_, point.f_82480_, point.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    private void createEnergyPulse(ServerLevel level, Vec3 center, double radius, float time, Vec3 right, Vec3 top, float chargeAmount) {
        double pulseRadius = radius * (0.5 + Math.sin(time * 4.0f) * 0.2);
        int pulsePoints = 12;
        float intensity = chargeAmount / ((Double)ModConfig.MAX_CHARGE.get()).floatValue();
        for (int i = 0; i < pulsePoints; ++i) {
            double angle = (double)(i * 2) * Math.PI / (double)pulsePoints + (double)(time * 2.0f);
            Vec3 pulsePos = center.m_82549_(right.m_82490_(Math.cos(angle) * pulseRadius).m_82549_(top.m_82490_(Math.sin(angle) * pulseRadius)));
            if (i % 2 != 0) continue;
            level.m_8767_((ParticleOptions)(intensity > 0.7f ? ParticleTypes.f_123745_ : ParticleTypes.f_175830_), pulsePos.f_82479_, pulsePos.f_82480_, pulsePos.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    private void createEnergyVortex(ServerLevel level, Vec3 center, double radius, float time, Vec3 right, Vec3 top) {
        int spiralPoints = 2;
        int pointsPerSpiral = 6;
        for (int spiral = 0; spiral < spiralPoints; ++spiral) {
            double spiralOffset = Math.PI * 2 / (double)spiralPoints * (double)spiral;
            for (int i = 0; i < pointsPerSpiral; ++i) {
                double t = (double)i / (double)pointsPerSpiral;
                double angle = t * Math.PI * 4.0 + (double)(time * 2.0f) + spiralOffset;
                double spiralRadius = radius * (0.4 + t * 0.6);
                Vec3 spiralPos = center.m_82549_(right.m_82490_(Math.cos(angle) * spiralRadius).m_82549_(top.m_82490_(Math.sin(angle) * spiralRadius)));
                if (i % 2 != 0) continue;
                level.m_8767_((ParticleOptions)ParticleTypes.f_175830_, spiralPos.f_82479_, spiralPos.f_82480_, spiralPos.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    private void drawLine(ServerLevel level, Vec3 start, Vec3 end, ParticleOptions particle, int points) {
        for (int i = 0; i <= points; ++i) {
            double t = (double)i / (double)points;
            Vec3 pos = new Vec3(start.f_82479_ + (end.f_82479_ - start.f_82479_) * t, start.f_82480_ + (end.f_82480_ - start.f_82480_) * t, start.f_82481_ + (end.f_82481_ - start.f_82481_) * t);
            level.m_8767_(particle, pos.f_82479_, pos.f_82480_, pos.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    private void releaseEnergyBeam(Player player, float chargeAmount) {
        Level level = player.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        Vec3 lookVec = player.m_20154_();
        Vec3 playerPos = player.m_146892_();
        float playerScale = player.m_6134_();
        double range = 40.0 * (double)playerScale;
        double baseRadius = 1.2 * (double)playerScale;
        Vec3 beamStart = playerPos.m_82549_(lookVec.m_82490_(2.0));
        Vec3 beamEnd = beamStart.m_82549_(lookVec.m_82490_(range));
        this.createAdvancedEnergyBeam(serverLevel, beamStart, beamEnd, baseRadius, chargeAmount);
        AABB damageBox = new AABB(Math.min(beamStart.f_82479_, beamEnd.f_82479_) - baseRadius * 0.5, Math.min(beamStart.f_82480_, beamEnd.f_82480_) - baseRadius * 0.5, Math.min(beamStart.f_82481_, beamEnd.f_82481_) - baseRadius * 0.5, Math.max(beamStart.f_82479_, beamEnd.f_82479_) + baseRadius * 0.5, Math.max(beamStart.f_82480_, beamEnd.f_82480_) + baseRadius * 0.5, Math.max(beamStart.f_82481_, beamEnd.f_82481_) + baseRadius * 0.5).m_82400_(0.5);
        float damage = chargeAmount * ((Double)ModConfig.DAMAGE_MULTIPLIER.get()).floatValue() * 2.0f;
        List entities = level.m_6249_((Entity)player, damageBox, entity -> entity != player);
        for (Entity entity2 : entities) {
            Vec3 entityPos = entity2.m_20182_().m_82520_(0.0, (double)entity2.m_20206_() * 0.5, 0.0);
            if (!this.isInBeamPath(beamStart, beamEnd, entityPos, baseRadius * 3.0)) continue;
            entity2.m_6469_(level.m_269111_().m_269104_((Entity)player, (Entity)player), damage);
            this.createAdvancedHitEffect(serverLevel, entityPos);
        }
        level.m_6263_(null, playerPos.f_82479_, playerPos.f_82480_, playerPos.f_82481_, SoundEvents.f_215771_, SoundSource.PLAYERS, 0.8f, 0.5f);
        level.m_6263_(null, playerPos.f_82479_, playerPos.f_82480_, playerPos.f_82481_, SoundEvents.f_12090_, SoundSource.PLAYERS, 1.5f, 0.8f);
        level.m_6263_(null, playerPos.f_82479_, playerPos.f_82480_, playerPos.f_82481_, SoundEvents.f_11736_, SoundSource.PLAYERS, 1.0f, 2.0f);
    }

    private void createAdvancedEnergyBeam(ServerLevel level, Vec3 start, Vec3 end, double baseRadius, float chargeAmount) {
        double distance = start.m_82554_(end);
        int particles = (int)(distance * 20.0);
        Vec3 step = end.m_82546_(start).m_82490_(1.0 / (double)particles);
        float intensity = chargeAmount / ((Double)ModConfig.MAX_CHARGE.get()).floatValue();
        double time = (double)level.m_46467_() * 0.5;
        this.createPlasmaCore(level, start, particles, step, baseRadius, time);
        this.createEnergyShield(level, start, particles, step, baseRadius * 2.0, time, intensity);
        this.createIonicRings(level, start, particles, step, baseRadius * 3.0, time);
        this.createEnergyRipples(level, start, particles, step, baseRadius * 4.0, time);
        this.createFusionCore(level, start, baseRadius * 2.0);
        this.createAnnihilationPoint(level, end, baseRadius * 3.0);
    }

    private void createPlasmaCore(ServerLevel level, Vec3 start, int particles, Vec3 step, double radius, double time) {
        Vec3 end = start.m_82549_(step.m_82490_((double)particles));
        Vec3 direction = end.m_82546_(start).m_82541_();
        Vec3 prevPos = null;
        for (int i = 0; i < particles; i += 8) {
            Vec3 pos = start.m_82549_(step.m_82490_((double)i));
            double progress = (double)i / (double)particles;
            this.createEnergyCannonCore(level, pos, radius * 0.5, direction, progress, time);
            if (prevPos != null) {
                this.createEnergyConnection(level, prevPos, pos, radius * 0.3, time);
            }
            prevPos = pos;
            if (i % 16 != 0) continue;
            this.createEnergyVortex(level, pos, radius * 0.8, direction, time);
        }
    }

    private void createEnergyCannonCore(ServerLevel level, Vec3 pos, double radius, Vec3 direction, double progress, double time) {
        int i;
        int segments = 8;
        double segmentAngle = Math.PI * 2 / (double)segments;
        double baseRadius = radius * (0.3 + Math.sin(time * 4.0 + progress * Math.PI) * 0.1);
        for (i = 0; i < segments; ++i) {
            double angle = (double)i * segmentAngle + time * 2.0;
            double x = Math.cos(angle) * baseRadius;
            double y = Math.sin(angle) * baseRadius;
            Vec3 offset = new Vec3(x, y, 0.0);
            Vec3 particlePos = pos.m_82549_(offset);
            level.m_8767_((ParticleOptions)ParticleTypes.f_123810_, particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, 1, direction.f_82479_ * 0.01, direction.f_82480_ * 0.01, direction.f_82481_ * 0.01, 0.01);
            if (i % 2 != 0) continue;
            level.m_8767_((ParticleOptions)ParticleTypes.f_123745_, particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, 1, direction.f_82479_ * 0.02, direction.f_82480_ * 0.02, direction.f_82481_ * 0.02, 0.02);
        }
        for (i = 0; i < 4; ++i) {
            level.m_8767_((ParticleOptions)ParticleTypes.f_123747_, pos.f_82479_, pos.f_82480_, pos.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    private void createEnergyConnection(ServerLevel level, Vec3 start, Vec3 end, double radius, double time) {
        int points = 5;
        Vec3 diff = end.m_82546_(start);
        for (int i = 0; i <= points; ++i) {
            double progress = (double)i / (double)points;
            double offset = Math.sin(progress * Math.PI + time * 3.0) * radius;
            Vec3 basePos = start.m_82549_(diff.m_82490_(progress));
            double spiralX = Math.cos(progress * Math.PI * 4.0 + time * 2.0) * offset;
            double spiralY = Math.sin(progress * Math.PI * 4.0 + time * 2.0) * offset;
            Vec3 particlePos = basePos.m_82549_(new Vec3(spiralX, spiralY, 0.0));
            level.m_8767_((ParticleOptions)ParticleTypes.f_175830_, particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    private void createEnergyVortex(ServerLevel level, Vec3 pos, double radius, Vec3 direction, double time) {
        int vortexPoints = 12;
        double vortexAngle = Math.PI * 2 / (double)vortexPoints;
        for (int i = 0; i < vortexPoints; ++i) {
            double angle = (double)i * vortexAngle + time * 3.0;
            double x = Math.cos(angle) * radius;
            double y = Math.sin(angle) * radius;
            Vec3 vortexPos = pos.m_82549_(new Vec3(x, y, 0.0));
            level.m_8767_((ParticleOptions)(i % 2 == 0 ? ParticleTypes.f_123745_ : ParticleTypes.f_123810_), vortexPos.f_82479_, vortexPos.f_82480_, vortexPos.f_82481_, 1, direction.f_82479_ * 0.05, direction.f_82480_ * 0.05, direction.f_82481_ * 0.05, 0.05);
        }
    }

    private void createEnergyMatrix(ServerLevel level, Vec3 pos, double radius, double progress, double time) {
        int edges = 8;
        double rotationSpeed = time * 2.0;
        double pulseScale = 1.0 + Math.sin(time * 3.0) * 0.2;
        for (int i = 0; i < edges; ++i) {
            double angle1 = (double)i * Math.PI * 2.0 / (double)edges + rotationSpeed;
            double angle2 = (double)(i + 1) * Math.PI * 2.0 / (double)edges + rotationSpeed;
            this.createMatrixEdge(level, pos, radius * 0.6 * pulseScale, angle1, angle2, time, true);
            this.createMatrixEdge(level, pos, radius * pulseScale, angle1, angle2, time, false);
            if (i % 2 != 0) continue;
            this.createEnergyConnection(level, pos, radius * 0.6 * pulseScale, radius * pulseScale, angle1, time);
        }
        this.createMatrixCore(level, pos, radius * 0.3, time);
    }

    private void createMatrixEdge(ServerLevel level, Vec3 pos, double radius, double angle1, double angle2, double time, boolean isInner) {
        int points = 5;
        for (int i = 0; i <= points; ++i) {
            double blend = (double)i / (double)points;
            double currentAngle = angle1 * (1.0 - blend) + angle2 * blend;
            double x = Math.cos(currentAngle) * radius;
            double y = Math.sin(currentAngle) * radius;
            Vec3 edgePos = pos.m_82549_(new Vec3(x, y, 0.0));
            level.m_8767_((ParticleOptions)(isInner ? ParticleTypes.f_123810_ : ParticleTypes.f_175830_), edgePos.f_82479_, edgePos.f_82480_, edgePos.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
            if (!(Math.random() < 0.3)) continue;
            level.m_8767_((ParticleOptions)ParticleTypes.f_123745_, edgePos.f_82479_, edgePos.f_82480_, edgePos.f_82481_, 1, (Math.random() - 0.5) * 0.02, (Math.random() - 0.5) * 0.02, (Math.random() - 0.5) * 0.02, 0.02);
        }
    }

    private void createEnergyConnection(ServerLevel level, Vec3 pos, double innerRadius, double outerRadius, double angle, double time) {
        int points = 3;
        for (int i = 0; i <= points; ++i) {
            double progress = (double)i / (double)points;
            double currentRadius = innerRadius * (1.0 - progress) + outerRadius * progress;
            double x = Math.cos(angle) * currentRadius;
            double y = Math.sin(angle) * currentRadius;
            Vec3 connectionPos = pos.m_82549_(new Vec3(x, y, 0.0));
            level.m_8767_((ParticleOptions)ParticleTypes.f_175830_, connectionPos.f_82479_, connectionPos.f_82480_, connectionPos.f_82481_, 1, 0.0, 0.0, 0.0, 0.01);
        }
    }

    private void createMatrixCore(ServerLevel level, Vec3 pos, double radius, double time) {
        int corePoints = 12;
        for (int i = 0; i < corePoints; ++i) {
            double angle = (double)i * Math.PI * 2.0 / (double)corePoints + time * 3.0;
            double layerRadius = radius * (0.5 + Math.sin(time * 4.0 + (double)i) * 0.3);
            for (int layer = 0; layer < 3; ++layer) {
                double layerOffset = (double)layer * Math.PI / 6.0;
                double x = Math.cos(angle + layerOffset) * layerRadius;
                double y = Math.sin(angle + layerOffset) * layerRadius;
                Vec3 corePos = pos.m_82549_(new Vec3(x, y, 0.0));
                level.m_8767_((ParticleOptions)(layer == 0 ? ParticleTypes.f_123810_ : (layer == 1 ? ParticleTypes.f_123745_ : ParticleTypes.f_175830_)), corePos.f_82479_, corePos.f_82480_, corePos.f_82481_, 1, 0.0, 0.0, 0.0, 0.02);
            }
        }
    }

    private void createEnergyCrystals(ServerLevel level, Vec3 pos, double radius, double progress, double time) {
        int crystalSets = 4;
        for (int set = 0; set < crystalSets; ++set) {
            double setAngle = (double)set * Math.PI * 2.0 / (double)crystalSets + time;
            double crystalRadius = radius * (0.7 + Math.sin(time * 2.0 + (double)set) * 0.3);
            this.createCrystalFormation(level, pos, crystalRadius, setAngle, time);
        }
    }

    private void createCrystalFormation(ServerLevel level, Vec3 pos, double radius, double baseAngle, double time) {
        int points = 5;
        double crystalTime = time * 2.0 + baseAngle;
        for (int i = 0; i < points; ++i) {
            double angle = baseAngle + (double)i * Math.PI * 2.0 / (double)points;
            double x = Math.cos(angle) * radius;
            double y = Math.sin(angle) * radius;
            Vec3 crystalPos = pos.m_82549_(new Vec3(x, y, 0.0));
            level.m_8767_((ParticleOptions)ParticleTypes.f_123810_, crystalPos.f_82479_, crystalPos.f_82480_, crystalPos.f_82481_, 1, Math.cos(crystalTime) * 0.02, Math.sin(crystalTime) * 0.02, 0.0, 0.02);
            if (i % 2 != 0) continue;
            level.m_8767_((ParticleOptions)ParticleTypes.f_123745_, crystalPos.f_82479_, crystalPos.f_82480_, crystalPos.f_82481_, 1, Math.cos(angle) * 0.03, Math.sin(angle) * 0.03, 0.0, 0.01);
        }
    }

    private void createQuantumEntanglement(ServerLevel level, Vec3 pos, double radius, double progress, double time) {
        int entanglementPoints = 6;
        for (int i = 0; i < entanglementPoints; ++i) {
            double angle = (double)i * Math.PI * 2.0 / (double)entanglementPoints + time * 1.5;
            double entanglementRadius = radius * (0.8 + Math.sin(time * 3.0 + (double)i) * 0.2);
            this.createEntanglementPair(level, pos, entanglementRadius, angle, time);
        }
    }

    private void createEntanglementPair(ServerLevel level, Vec3 pos, double radius, double angle, double time) {
        double x1 = Math.cos(angle) * radius;
        double y1 = Math.sin(angle) * radius;
        double x2 = Math.cos(angle + Math.PI) * radius;
        double y2 = Math.sin(angle + Math.PI) * radius;
        Vec3 pos1 = pos.m_82549_(new Vec3(x1, y1, 0.0));
        Vec3 pos2 = pos.m_82549_(new Vec3(x2, y2, 0.0));
        level.m_8767_((ParticleOptions)ParticleTypes.f_123810_, pos1.f_82479_, pos1.f_82480_, pos1.f_82481_, 1, Math.cos(time) * 0.02, Math.sin(time) * 0.02, 0.0, 0.02);
        level.m_8767_((ParticleOptions)ParticleTypes.f_123745_, pos2.f_82479_, pos2.f_82480_, pos2.f_82481_, 1, -Math.cos(time) * 0.02, -Math.sin(time) * 0.02, 0.0, 0.02);
        int connectionPoints = 3;
        for (int i = 0; i <= connectionPoints; ++i) {
            double progress = (double)i / (double)connectionPoints;
            Vec3 connectionPos = pos1.m_82549_(pos2.m_82546_(pos1).m_82490_(progress));
            level.m_8767_((ParticleOptions)ParticleTypes.f_175830_, connectionPos.f_82479_, connectionPos.f_82480_, connectionPos.f_82481_, 1, 0.0, 0.0, 0.0, 0.01);
        }
    }

    private void createEnergyShield(ServerLevel level, Vec3 start, int particles, Vec3 step, double radius, double time, float intensity) {
        for (int i = 0; i < particles; i += 2) {
            Vec3 pos = start.m_82549_(step.m_82490_((double)i));
            double progress = (double)i / (double)particles;
            double shieldRadius = radius * (1.0 + Math.sin(progress * Math.PI * 4.0 + time) * 0.3);
            int points = 8 + (int)(intensity * 8.0f);
            for (int v = 0; v < points / 2; ++v) {
                double phi = (double)v * Math.PI / (double)(points / 2);
                for (int h = 0; h < points; ++h) {
                    double theta = (double)(h * 2) * Math.PI / (double)points + time * 2.0;
                    double x = Math.sin(phi) * Math.cos(theta) * shieldRadius;
                    double y = Math.sin(phi) * Math.sin(theta) * shieldRadius;
                    double z = Math.cos(phi) * shieldRadius;
                    Vec3 offset = new Vec3(x, y, z);
                    Vec3 particlePos = pos.m_82549_(offset);
                    level.m_8767_((ParticleOptions)ParticleTypes.f_175830_, particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, 1, Math.cos(theta) * 0.01, Math.sin(phi) * 0.01, Math.sin(theta) * 0.01, 0.05);
                }
            }
        }
    }

    private void createIonicRings(ServerLevel level, Vec3 start, int particles, Vec3 step, double radius, double time) {
        for (int i = 0; i < particles; i += 15) {
            Vec3 pos = start.m_82549_(step.m_82490_((double)i));
            double ringRadius = radius * (1.0 + Math.cos((double)i * 0.1) * 0.2);
            for (int ring = 0; ring < 3; ++ring) {
                double ringAngle = (double)ring * Math.PI / 3.0;
                int ringParticles = 16;
                for (int j = 0; j < ringParticles; ++j) {
                    double angle = (double)(j * 2) * Math.PI / (double)ringParticles + time;
                    double x = Math.cos(angle) * ringRadius;
                    double y = Math.sin(angle) * ringRadius * Math.cos(ringAngle);
                    double z = Math.sin(angle) * ringRadius * Math.sin(ringAngle);
                    Vec3 offset = new Vec3(x, y, z);
                    Vec3 particlePos = pos.m_82549_(offset);
                    level.m_8767_((ParticleOptions)(j % 2 == 0 ? ParticleTypes.f_123745_ : ParticleTypes.f_123810_), particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, 1, Math.cos(angle) * 0.02, Math.sin(angle) * 0.02, Math.sin(ringAngle) * 0.02, 0.02);
                }
            }
        }
    }

    private void createEnergyRipples(ServerLevel level, Vec3 start, int particles, Vec3 step, double radius, double time) {
        for (int i = 0; i < particles; i += 4) {
            Vec3 pos = start.m_82549_(step.m_82490_((double)i));
            double progress = (double)i / (double)particles;
            double rippleRadius = radius * (1.0 + Math.sin(progress * Math.PI * 6.0 + time) * 0.4);
            int spirals = 4;
            for (int spiral = 0; spiral < spirals; ++spiral) {
                double spiralOffset = (double)spiral * Math.PI / (double)spirals;
                for (int j = 0; j < 8; ++j) {
                    double angle = (double)j * Math.PI / 4.0 + time * 1.5;
                    double heightOffset = Math.sin(angle + spiralOffset) * rippleRadius * 0.3;
                    double x = Math.cos(angle) * rippleRadius;
                    double y = Math.sin(angle) * rippleRadius;
                    double z = heightOffset;
                    Vec3 offset = new Vec3(x, y, z);
                    Vec3 particlePos = pos.m_82549_(offset);
                    level.m_8767_((ParticleOptions)ParticleTypes.f_175830_, particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, 1, Math.cos(angle) * 0.03, Math.sin(angle) * 0.03, Math.cos(time) * 0.03, 0.1);
                }
            }
        }
    }

    private void createFusionCore(ServerLevel level, Vec3 pos, double radius) {
        for (int i = 0; i < 60; ++i) {
            double angle1 = Math.random() * Math.PI * 2.0;
            double angle2 = Math.random() * Math.PI;
            double r = radius * Math.random();
            double x = Math.sin(angle2) * Math.cos(angle1) * r;
            double y = Math.sin(angle2) * Math.sin(angle1) * r;
            double z = Math.cos(angle2) * r;
            Vec3 particlePos = pos.m_82520_(x, y, z);
            Vec3 toCenter = pos.m_82546_(particlePos).m_82541_().m_82490_(0.1);
            level.m_8767_((ParticleOptions)(i % 3 == 0 ? ParticleTypes.f_123810_ : (i % 3 == 1 ? ParticleTypes.f_123745_ : ParticleTypes.f_175830_)), particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, 1, toCenter.f_82479_, toCenter.f_82480_, toCenter.f_82481_, 0.1);
        }
    }

    private void createAnnihilationPoint(ServerLevel level, Vec3 pos, double radius) {
        for (int i = 0; i < 80; ++i) {
            double angle1 = Math.random() * Math.PI * 2.0;
            double angle2 = Math.random() * Math.PI;
            double x = Math.sin(angle2) * Math.cos(angle1);
            double y = Math.sin(angle2) * Math.sin(angle1);
            double z = Math.cos(angle2);
            Vec3 direction = new Vec3(x, y, z);
            level.m_8767_((ParticleOptions)(i % 3 == 0 ? ParticleTypes.f_123810_ : (i % 3 == 1 ? ParticleTypes.f_123745_ : ParticleTypes.f_175830_)), pos.f_82479_, pos.f_82480_, pos.f_82481_, 1, direction.f_82479_ * 0.3, direction.f_82480_ * 0.3, direction.f_82481_ * 0.3, 0.2);
        }
    }

    private void createAdvancedHitEffect(ServerLevel level, Vec3 pos) {
        for (int i = 0; i < 40; ++i) {
            double angle = Math.random() * Math.PI * 2.0;
            double radius = Math.random() * 0.8;
            double height = Math.random() * 0.8;
            double x = Math.cos(angle) * radius;
            double y = height;
            double z = Math.sin(angle) * radius;
            level.m_8767_((ParticleOptions)(i % 3 == 0 ? ParticleTypes.f_123810_ : (i % 3 == 1 ? ParticleTypes.f_123745_ : ParticleTypes.f_175830_)), pos.f_82479_, pos.f_82480_, pos.f_82481_, 1, x, y, z, 0.2);
        }
    }

    private boolean isInBeamPath(Vec3 start, Vec3 end, Vec3 point, double threshold) {
        Vec3 beamDir = end.m_82546_(start).m_82541_();
        Vec3 pointDir = point.m_82546_(start);
        double projectionLength = pointDir.m_82526_(beamDir);
        if (projectionLength < 0.0 || projectionLength > start.m_82554_(end)) {
            return false;
        }
        Vec3 projection = start.m_82549_(beamDir.m_82490_(projectionLength));
        return point.m_82554_(projection) <= threshold;
    }

    @Override
    public void m_6883_(ItemStack stack, Level level, Entity entity, int slot, boolean selected) {
        super.m_6883_(stack, level, entity, slot, selected);
        if (!ArcingOrbItem.isEquipped((LivingEntity)entity) && stack.m_41784_().m_128471_(ARCING_ORB_CHARGING_TAG)) {
            ArcingOrbItem.resetChargingState(stack);
        }
        if (!level.f_46443_ && entity instanceof Player) {
            Player player = (Player)entity;
            this.updateCharging(stack, player);
        }
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        super.curioTick(slotContext, stack);
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (!player.m_9236_().f_46443_) {
                float cooldownTicks = stack.m_41784_().m_128457_(DASH_COOLDOWN_TAG);
                if (cooldownTicks > 0.0f) {
                    stack.m_41784_().m_128350_(DASH_COOLDOWN_TAG, cooldownTicks - 1.0f);
                }
                this.updateCharging(stack, player);
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237110_((String)"item.trinketsandbaubles.arcing_orb.speed_boost", (Object[])new Object[]{String.format("%.0f", (Double)ModConfig.SPEED_BOOST.get() * 100.0)}).m_130940_(ChatFormatting.BLUE));
        String chargeKeyName = KeyBindings.CHARGE_KEY.getKey().m_84875_().getString();
        tooltip.add((Component)Component.m_237110_((String)"item.trinketsandbaubles.arcing_orb.damage_multiplier", (Object[])new Object[]{String.format("%.3f", ModConfig.DAMAGE_MULTIPLIER.get()), chargeKeyName}).m_130940_(ChatFormatting.GOLD));
        String dashKeyName = KeyBindings.DASH_KEY.getKey().m_84875_().getString();
        tooltip.add((Component)Component.m_237110_((String)"item.trinketsandbaubles.arcing_orb.dash_cost", (Object[])new Object[]{String.format("%.1f", ModConfig.DASH_MANA_COST.get()), dashKeyName}).m_130940_(ChatFormatting.AQUA));
        if (stack.m_41784_().m_128471_(ARCING_ORB_CHARGING_TAG)) {
            float chargeAmount = stack.m_41784_().m_128457_(CHARGE_AMOUNT_TAG);
            tooltip.add((Component)Component.m_237110_((String)"item.trinketsandbaubles.arcing_orb.charging", (Object[])new Object[]{String.format("%.1f", Float.valueOf(chargeAmount))}).m_130940_(ChatFormatting.YELLOW));
        }
        if (((Boolean)ModConfig.USE_BOTANIA_MANA.get()).booleanValue() && ModList.get().isLoaded("botania")) {
            LocalPlayer player;
            tooltip.add((Component)Component.m_237110_((String)"item.trinketsandbaubles.arcing_orb.mana_system", (Object[])new Object[]{"Botania"}).m_130940_(ChatFormatting.GOLD));
            if (level != null && level.f_46443_ && (player = Minecraft.m_91087_().f_91074_) != null) {
                float currentMana = this.getManaSystem().getMana((Player)player, stack);
                tooltip.add((Component)Component.m_237110_((String)"item.trinketsandbaubles.arcing_orb.current_mana", (Object[])new Object[]{(int)currentMana}).m_130940_(ChatFormatting.AQUA));
            }
        }
        super.m_7373_(stack, level, tooltip, flag);
    }

    @Override
    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        super.onEquip(slotContext, prevStack, stack);
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (prevStack.m_41619_() || !this.hasSameModifier(prevStack, stack)) {
                this.applySpeedAttribute(player);
            }
        }
    }

    @Override
    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (!(!newStack.m_41619_() && this.hasSameModifier(newStack, stack) || this.hasSameItemEquipped(player))) {
                this.removeSpeedAttribute(player);
            }
        }
        super.onUnequip(slotContext, newStack, stack);
    }

    public static boolean isEquipped(LivingEntity entity) {
        return CuriosApi.getCuriosInventory((LivingEntity)entity).resolve().flatMap(curios -> curios.findFirstCurio(stack -> stack.m_41720_() instanceof ArcingOrbItem)).isPresent();
    }

    public int m_6473_() {
        return 0;
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }

    @SubscribeEvent
    public static void onPlayerDeath(PlayerEvent.Clone event) {
        if (event.isWasDeath()) {
            Player original = event.getOriginal();
            CuriosApi.getCuriosInventory((LivingEntity)original).ifPresent(handler -> handler.findFirstCurio(item -> item.m_41720_() instanceof ArcingOrbItem).ifPresent(found -> {
                ItemStack stack = found.stack();
                ArcingOrbItem.resetChargingState(stack);
            }));
        }
    }

    @SubscribeEvent
    public static void onItemPickup(EntityItemPickupEvent event) {
        ItemStack stack = event.getItem().m_32055_();
        if (stack.m_41720_() instanceof ArcingOrbItem) {
            ArcingOrbItem.resetChargingState(stack);
        }
    }

    private static void resetChargingState(ItemStack stack) {
        if (stack.m_41782_()) {
            CompoundTag tag = stack.m_41783_();
            tag.m_128379_(ARCING_ORB_CHARGING_TAG, false);
            tag.m_128350_(CHARGE_AMOUNT_TAG, 0.0f);
        }
    }

    private class IronsSpellsManaSystem
    implements ManaSystem {
        private IronsSpellsManaSystem() {
        }

        @Override
        public float getMana(Player player, ItemStack stack) {
            return MagicData.getPlayerMagicData((LivingEntity)player).getMana();
        }

        @Override
        public void consumeMana(Player player, float amount, ItemStack stack) {
            float actualAmount = Math.max(1.0f, (float)Math.ceil(amount));
            MagicData.getPlayerMagicData((LivingEntity)player).addMana(-actualAmount);
        }

        @Override
        public boolean hasMana(Player player, float amount, ItemStack stack) {
            float actualAmount = Math.max(1.0f, (float)Math.ceil(amount));
            return this.getMana(player, stack) >= actualAmount;
        }
    }

    private class BotaniaManaSystem
    implements ManaSystem {
        private BotaniaManaSystem() {
        }

        @Override
        public float getMana(Player player, ItemStack stack) {
            return ManaItemHandler.instance().requestMana(stack, player, Integer.MAX_VALUE, false);
        }

        @Override
        public void consumeMana(Player player, float amount, ItemStack stack) {
            ManaItemHandler.instance().requestManaExactForTool(stack, player, (int)amount, true);
        }

        @Override
        public boolean hasMana(Player player, float amount, ItemStack stack) {
            return ManaItemHandler.instance().requestManaExact(stack, player, (int)amount, false);
        }
    }

    private class InternalManaSystem
    implements ManaSystem {
        private InternalManaSystem() {
        }

        @Override
        public float getMana(Player player, ItemStack stack) {
            return ManaData.getMana(player);
        }

        @Override
        public void consumeMana(Player player, float amount, ItemStack stack) {
            ManaData.consumeMana(player, amount);
        }

        @Override
        public boolean hasMana(Player player, float amount, ItemStack stack) {
            return ManaData.hasMana(player, amount);
        }
    }

    private static interface ManaSystem {
        public float getMana(Player var1, ItemStack var2);

        public void consumeMana(Player var1, float var2, ItemStack var3);

        public boolean hasMana(Player var1, float var2, ItemStack var3);
    }
}

