/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.trinketsandbaubles.items.baubles;

import com.jinqinxixi.trinketsandbaubles.items.baubles.DragonsEyeItem;
import com.jinqinxixi.trinketsandbaubles.modeffects.ModEffects;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import top.theillusivec4.curios.api.SlotContext;

public class DragonsEyeIceItem
extends DragonsEyeItem {
    private static final int FROST_RANGE = 2;
    private static BlockPos lastFrostPos = null;

    public DragonsEyeIceItem(Item.Properties properties) {
        super(properties);
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        Player player;
        block7: {
            block6: {
                super.curioTick(slotContext, stack);
                LivingEntity livingEntity = slotContext.entity();
                if (!(livingEntity instanceof Player)) break block6;
                player = (Player)livingEntity;
                if (!player.m_9236_().f_46443_) break block7;
            }
            return;
        }
        Level level = player.m_9236_();
        BlockPos currentPos = player.m_20183_().m_7495_();
        if (lastFrostPos != null && !lastFrostPos.equals((Object)currentPos)) {
            if (level.m_8055_(lastFrostPos).m_60713_(Blocks.f_50449_)) {
                level.m_7731_(lastFrostPos, Blocks.f_49990_.m_49966_(), 3);
            }
            lastFrostPos = null;
        }
        if (DragonsEyeIceItem.canFreezeWater(level, currentPos)) {
            DragonsEyeIceItem.createFrostPath(player);
            lastFrostPos = currentPos.m_7949_();
        }
    }

    private static boolean canFreezeWater(Level level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        if (!state.m_60713_(Blocks.f_49990_)) {
            return false;
        }
        if (!state.m_60819_().m_76170_()) {
            return false;
        }
        return level.m_8055_(pos.m_7494_()).m_60795_();
    }

    private static void createFrostPath(Player player) {
        Level level = player.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        BlockPos playerPos = player.m_20183_();
        for (int x = -2; x <= 2; ++x) {
            for (int z = -2; z <= 2; ++z) {
                BlockPos pos = playerPos.m_7918_(x, -1, z);
                if (!DragonsEyeIceItem.canFreezeWater((Level)serverLevel, pos)) continue;
                serverLevel.m_7731_(pos, Blocks.f_50449_.m_49966_(), 3);
            }
        }
    }

    @Override
    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        super.onEquip(slotContext, prevStack, stack);
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            player.m_7292_(new MobEffectInstance((MobEffect)ModEffects.ICE_RESISTANCE.get(), -1, 0, true, true));
        }
    }

    @Override
    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        super.onUnequip(slotContext, newStack, stack);
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            player.m_21195_((MobEffect)ModEffects.ICE_RESISTANCE.get());
            if (lastFrostPos != null && !player.m_9236_().f_46443_) {
                if (player.m_9236_().m_8055_(lastFrostPos).m_60713_(Blocks.f_50449_)) {
                    player.m_9236_().m_7731_(lastFrostPos, Blocks.f_49990_.m_49966_(), 3);
                }
                lastFrostPos = null;
            }
        }
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"tooltip.trinketsandbaubles.dragons_eye_ice.effect").m_130940_(ChatFormatting.AQUA));
        tooltip.add((Component)Component.m_237115_((String)"tooltip.trinketsandbaubles.dragons_eye_ice.effect1").m_130940_(ChatFormatting.DARK_AQUA));
        super.m_7373_(stack, level, tooltip, flag);
    }
}

