/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.trinketsandbaubles.items.baubles;

import com.jinqinxixi.trinketsandbaubles.capability.attribute.AttributeRegistry;
import com.jinqinxixi.trinketsandbaubles.capability.base.AbstractRaceCapability;
import com.jinqinxixi.trinketsandbaubles.capability.impl.DragonCapability;
import com.jinqinxixi.trinketsandbaubles.capability.registry.ModCapabilities;
import com.jinqinxixi.trinketsandbaubles.client.keybind.KeyBindings;
import com.jinqinxixi.trinketsandbaubles.config.ModConfig;
import com.jinqinxixi.trinketsandbaubles.config.RaceAttributesConfig;
import com.jinqinxixi.trinketsandbaubles.modifier.ModifiableBaubleItem;
import com.jinqinxixi.trinketsandbaubles.util.RaceRingUtil;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.ModList;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class DragonsRingItem
extends ModifiableBaubleItem {
    private static final ModifiableBaubleItem.Modifier[] MODIFIERS = ModifiableBaubleItem.Modifier.values();

    @Override
    public ModifiableBaubleItem.Modifier[] getModifiers() {
        return MODIFIERS;
    }

    public DragonsRingItem(Item.Properties properties) {
        super(properties);
    }

    private static boolean isEquipped(LivingEntity entity) {
        return CuriosApi.getCuriosInventory((LivingEntity)entity).resolve().flatMap(curios -> curios.findFirstCurio(stack -> stack.m_41720_() instanceof DragonsRingItem)).isPresent();
    }

    private void applyFaelisBuff(LivingEntity entity) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            if (RaceRingUtil.hasMultipleRaceRings((Player)serverPlayer)) {
                serverPlayer.getCapability(ModCapabilities.DRAGON_CAPABILITY).ifPresent(cap -> {
                    if (cap.isActive()) {
                        cap.setActive(false);
                    }
                });
                return;
            }
            serverPlayer.getCapability(ModCapabilities.DRAGON_CAPABILITY).ifPresent(cap -> {
                if (!cap.isActive()) {
                    AbstractRaceCapability.clearAllRaceAbilities((Player)serverPlayer);
                    cap.setActive(true);
                }
            });
        }
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        super.curioTick(slotContext, stack);
        LivingEntity entity = slotContext.entity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            if (RaceRingUtil.hasMultipleRaceRings((Player)serverPlayer)) {
                serverPlayer.getCapability(ModCapabilities.DRAGON_CAPABILITY).ifPresent(cap -> {
                    if (cap.isActive()) {
                        cap.setActive(false);
                    }
                });
                return;
            }
            if (DragonsRingItem.isEquipped(entity)) {
                serverPlayer.getCapability(ModCapabilities.DRAGON_CAPABILITY).ifPresent(cap -> {
                    if (!cap.isActive()) {
                        this.applyFaelisBuff(entity);
                    }
                });
            }
        }
    }

    @Override
    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        super.onEquip(slotContext, prevStack, stack);
        LivingEntity entity = slotContext.entity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            if ((prevStack.m_41619_() || !this.hasSameModifier(prevStack, stack)) && !RaceRingUtil.hasMultipleRaceRings((Player)serverPlayer) && DragonsRingItem.isEquipped(entity)) {
                this.applyFaelisBuff(entity);
            }
        }
    }

    @Override
    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        LivingEntity entity = slotContext.entity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            if (!(!newStack.m_41619_() && this.hasSameModifier(newStack, stack) || DragonsRingItem.isEquipped(entity))) {
                serverPlayer.getCapability(ModCapabilities.DRAGON_CAPABILITY).ifPresent(cap -> {
                    if (cap.isActive()) {
                        if (serverPlayer.m_21224_()) {
                            cap.setActive(false);
                            CompoundTag playerData = serverPlayer.getPersistentData();
                            if (playerData.m_128441_("DragonCapability")) {
                                playerData.m_128473_("DragonCapability");
                            }
                        } else {
                            cap.setActive(false);
                            CompoundTag playerData = serverPlayer.getPersistentData();
                            String savedRace = playerData.m_128461_("SavedRace");
                            if (!savedRace.isEmpty()) {
                                RaceRingUtil.activateRace(serverPlayer, savedRace);
                            }
                        }
                    }
                });
            }
        }
        super.onUnequip(slotContext, newStack, stack);
    }

    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return true;
    }

    public ICurio.SoundInfo getEquipSound(SlotContext slotContext, ItemStack stack) {
        return new ICurio.SoundInfo(SoundEvents.f_144243_, 1.0f, 1.0f);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        if (Screen.m_96638_()) {
            for (Map.Entry<String, AttributeRegistry.AttributeEntry> entry : AttributeRegistry.getAll().entrySet()) {
                try {
                    String attributeName = entry.getKey();
                    double value = 0.0;
                    switch (attributeName) {
                        case "MAX_HEALTH": {
                            value = (Double)RaceAttributesConfig.DRAGON.MAX_HEALTH.get();
                            break;
                        }
                        case "FOLLOW_RANGE": {
                            value = (Double)RaceAttributesConfig.DRAGON.FOLLOW_RANGE.get();
                            break;
                        }
                        case "MOVEMENT_SPEED": {
                            value = (Double)RaceAttributesConfig.DRAGON.MOVEMENT_SPEED.get();
                            break;
                        }
                        case "ATTACK_SPEED": {
                            value = (Double)RaceAttributesConfig.DRAGON.ATTACK_SPEED.get();
                            break;
                        }
                        case "ATTACK_DAMAGE": {
                            value = (Double)RaceAttributesConfig.DRAGON.ATTACK_DAMAGE.get();
                            break;
                        }
                        case "SWIM_SPEED": {
                            value = (Double)RaceAttributesConfig.DRAGON.SWIM_SPEED.get();
                            break;
                        }
                        case "FLYING_SPEED": {
                            value = (Double)RaceAttributesConfig.DRAGON.FLYING_SPEED.get();
                            break;
                        }
                        case "ENTITY_GRAVITY": {
                            value = (Double)RaceAttributesConfig.DRAGON.ENTITY_GRAVITY.get();
                            break;
                        }
                        case "BLOCK_REACH": {
                            value = (Double)RaceAttributesConfig.DRAGON.BLOCK_REACH.get();
                            break;
                        }
                        case "ENTITY_REACH": {
                            value = (Double)RaceAttributesConfig.DRAGON.ENTITY_REACH.get();
                            break;
                        }
                        case "NAMETAG_DISTANCE": {
                            value = (Double)RaceAttributesConfig.DRAGON.NAMETAG_DISTANCE.get();
                            break;
                        }
                        case "ARMOR": {
                            value = (Double)RaceAttributesConfig.DRAGON.ARMOR.get();
                            break;
                        }
                        case "ARMOR_TOUGHNESS": {
                            value = (Double)RaceAttributesConfig.DRAGON.ARMOR_TOUGHNESS.get();
                            break;
                        }
                        case "KNOCKBACK_RESISTANCE": {
                            value = (Double)RaceAttributesConfig.DRAGON.KNOCKBACK_RESISTANCE.get();
                            break;
                        }
                        case "ATTACK_KNOCKBACK": {
                            value = (Double)RaceAttributesConfig.DRAGON.ATTACK_KNOCKBACK.get();
                            break;
                        }
                        case "LUCK": {
                            value = (Double)RaceAttributesConfig.DRAGON.LUCK.get();
                            break;
                        }
                        case "STEP_HEIGHT": {
                            value = (Double)RaceAttributesConfig.DRAGON.STEP_HEIGHT.get();
                        }
                    }
                    if (value == 0.0) continue;
                    AttributeRegistry.AttributeEntry attr = entry.getValue();
                    String displayText = attr.isPercentage() ? String.format("%s %s%.1f%%", Component.m_237115_((String)attr.getTranslationKey()).getString(), value > 0.0 ? "+" : "", value * 100.0) : String.format("%s %s%.2f", Component.m_237115_((String)attr.getTranslationKey()).getString(), value > 0.0 ? "+" : "", value);
                    tooltip.add((Component)Component.m_237113_((String)displayText).m_130940_(value > 0.0 ? ChatFormatting.GREEN : ChatFormatting.RED));
                }
                catch (Exception attributeName) {}
            }
        } else {
            LocalPlayer player;
            String dragonBreathKeyName = KeyBindings.DRAGON_BREATH_KEY.getKey().m_84875_().getString();
            String nightVisionKeyName = KeyBindings.DRAGON_NIGHT_VISION_KEY.getKey().m_84875_().getString();
            String toggleModeKeyName = KeyBindings.TOGGLE_DRAGONS_EYE_MODE.getKey().m_84875_().getString();
            String flightToggleKeyName = KeyBindings.DRAGON_FLIGHT_TOGGLE_KEY.getKey().m_84875_().getString();
            tooltip.add((Component)Component.m_237115_((String)"item.trinketsandbaubles.dragons_ring.tooltip11").m_130940_(ChatFormatting.GOLD));
            tooltip.add((Component)Component.m_237110_((String)"item.trinketsandbaubles.dragons_ring.tooltip12", (Object[])new Object[]{dragonBreathKeyName}).m_130940_(ChatFormatting.RED));
            tooltip.add((Component)Component.m_237115_((String)"item.trinketsandbaubles.dragons_ring.tooltip13").m_130940_(ChatFormatting.GREEN));
            tooltip.add((Component)Component.m_237110_((String)"item.trinketsandbaubles.dragons_ring.tooltip14", (Object[])new Object[]{nightVisionKeyName}).m_130940_(ChatFormatting.DARK_GREEN));
            tooltip.add((Component)Component.m_237110_((String)"item.trinketsandbaubles.dragons_ring.tooltip15", (Object[])new Object[]{toggleModeKeyName}).m_130940_(ChatFormatting.AQUA));
            tooltip.add((Component)Component.m_237110_((String)"item.trinketsandbaubles.dragons_ring.tooltip16", (Object[])new Object[]{flightToggleKeyName}).m_130940_(ChatFormatting.DARK_AQUA));
            tooltip.add((Component)Component.m_237115_((String)"item.trinketsandbaubles.dragons_ring.press_shift").m_130940_(ChatFormatting.GRAY));
            if (level != null && level.f_46443_ && (player = Minecraft.m_91087_().f_91074_) != null) {
                player.getCapability(ModCapabilities.DRAGON_CAPABILITY).ifPresent(cap -> {
                    if (cap instanceof DragonCapability) {
                        DragonCapability dragonCap = (DragonCapability)cap;
                        if (((Boolean)ModConfig.USE_BOTANIA_MANA.get()).booleanValue() && ModList.get().isLoaded("botania")) {
                            tooltip.add((Component)Component.m_237110_((String)"item.trinketsandbaubles.dragons_ring.mana_system", (Object[])new Object[]{"Botania"}).m_130940_(ChatFormatting.GOLD));
                            float currentMana = dragonCap.getCurrentMana();
                            tooltip.add((Component)Component.m_237110_((String)"item.trinketsandbaubles.dragons_ring.current_mana", (Object[])new Object[]{(int)currentMana}).m_130940_(ChatFormatting.AQUA));
                        }
                    }
                });
            }
        }
        super.m_7373_(stack, level, tooltip, flag);
    }

    public int m_6473_() {
        return 0;
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }
}

