/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.trinketsandbaubles.items.baubles;

import com.jinqinxixi.trinketsandbaubles.config.ModConfig;
import com.jinqinxixi.trinketsandbaubles.modifier.ModifiableBaubleItem;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;

public class EnderQueensCrownItem
extends ModifiableBaubleItem {
    public static final String CROWN_CONTROLLED_TAG = "CrownControlled";
    public static final String CROWN_SUMMONED_TAG = "CrownSummoned";
    public static final String FRIENDLY_ENDERMAN_TAG = "FriendlyEnderman";
    private static final ModifiableBaubleItem.Modifier[] MODIFIERS = ModifiableBaubleItem.Modifier.values();

    public EnderQueensCrownItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public ModifiableBaubleItem.Modifier[] getModifiers() {
        return MODIFIERS;
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"item.trinketsandbaubles.ender_queens_crown.tooltip.enderman_follow"));
        tooltip.add((Component)Component.m_237110_((String)"item.trinketsandbaubles.ender_queens_crown.tooltip.damage_immunity", (Object[])new Object[]{(int)((Double)ModConfig.DAMAGE_IMMUNITY_CHANCE.get() * 100.0)}).m_130940_(ChatFormatting.DARK_RED));
        if (((Boolean)ModConfig.WATER_DAMAGE_ENABLED.get()).booleanValue()) {
            tooltip.add((Component)Component.m_237115_((String)"item.trinketsandbaubles.ender_queens_crown.tooltip.water_damage"));
        }
        super.m_7373_(stack, level, tooltip, flag);
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        super.curioTick(slotContext, stack);
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (!player.m_9236_().f_46443_) {
                if (((Boolean)ModConfig.WATER_DAMAGE_ENABLED.get()).booleanValue() && player.m_20069_()) {
                    player.m_6469_(player.m_269291_().m_269063_(), 1.0f);
                }
                AABB searchBox = player.m_20191_().m_82400_(((Double)ModConfig.ENDERMAN_FOLLOW_RANGE.get()).doubleValue());
                player.m_9236_().m_45976_(EnderMan.class, searchBox).forEach(enderman -> {
                    if (enderman.m_5448_() == player) {
                        enderman.m_6710_(null);
                        EnderQueensCrownItem.setEndermanToFollow(enderman, player);
                    }
                    boolean isControlled = enderman.getPersistentData().m_128471_(CROWN_CONTROLLED_TAG);
                    boolean isSummoned = enderman.getPersistentData().m_128471_(CROWN_SUMMONED_TAG);
                    if (!isControlled && !isSummoned) {
                        EnderQueensCrownItem.setEndermanToFollow(enderman, player);
                    } else if (enderman.m_5448_() == null || enderman.m_5448_().m_21224_()) {
                        enderman.m_6710_(null);
                        double followDistance = enderman.m_20280_((Entity)player);
                        if (followDistance > 256.0) {
                            enderman.m_20984_(player.m_20185_() + (player.m_217043_().m_188500_() - 0.5) * 8.0, player.m_20186_(), player.m_20189_() + (player.m_217043_().m_188500_() - 0.5) * 8.0, true);
                        } else if (followDistance > 25.0) {
                            enderman.m_21573_().m_5624_((Entity)player, 1.0);
                        }
                    }
                });
            }
        }
    }

    private static void setEndermanToFollow(EnderMan enderman, Player player) {
        enderman.m_6710_(null);
        enderman.m_21530_();
        enderman.getPersistentData().m_128379_(CROWN_CONTROLLED_TAG, true);
        enderman.getPersistentData().m_128379_(FRIENDLY_ENDERMAN_TAG, true);
        enderman.m_21573_().m_7008_(true);
        enderman.m_20049_("crown_controlled");
        if (enderman.m_20280_((Entity)player) > 100.0) {
            enderman.m_20984_(player.m_20185_() + (player.m_217043_().m_188500_() - 0.5) * 4.0, player.m_20186_(), player.m_20189_() + (player.m_217043_().m_188500_() - 0.5) * 4.0, true);
        }
    }

    public static boolean isEquipped(LivingEntity entity) {
        return CuriosApi.getCuriosInventory((LivingEntity)entity).resolve().flatMap(curios -> curios.findFirstCurio(stack -> stack.m_41720_() instanceof EnderQueensCrownItem)).isPresent();
    }

    public static boolean onDamage(LivingEntity entity, DamageSource source) {
        if (!EnderQueensCrownItem.isEquipped(entity) || entity.m_9236_().f_46443_) {
            return false;
        }
        if (!EnderQueensCrownItem.canImmuneDamageType(source)) {
            return false;
        }
        if ((double)entity.m_217043_().m_188501_() < (Double)ModConfig.DAMAGE_IMMUNITY_CHANCE.get()) {
            EnderQueensCrownItem.teleportRandomly(entity);
            EnderQueensCrownItem.summonEnderman(entity);
            Entity entity2 = source.m_7639_();
            if (entity2 instanceof LivingEntity) {
                LivingEntity attacker = (LivingEntity)entity2;
                EnderQueensCrownItem.aggroNearbyEndermen(entity, attacker);
            }
            return true;
        }
        return false;
    }

    private static boolean canImmuneDamageType(DamageSource source) {
        return !source.m_276093_(DamageTypes.f_268671_) && !source.m_276093_(DamageTypes.f_268631_) && !source.m_276093_(DamageTypes.f_268468_) && !source.m_276093_(DamageTypes.f_268722_) && !source.m_276093_(DamageTypes.f_268493_) && !source.m_276093_(DamageTypes.f_268515_);
    }

    private static void teleportRandomly(LivingEntity entity) {
        double d2;
        double d1;
        RandomSource random = entity.m_217043_();
        double range = (Double)ModConfig.TELEPORT_RANGE.get();
        double d0 = entity.m_20185_() + (random.m_188500_() - 0.5) * range;
        if (entity.m_20984_(d0, d1 = entity.m_20186_() + (random.m_188500_() - 0.5) * range, d2 = entity.m_20189_() + (random.m_188500_() - 0.5) * range, true)) {
            entity.m_9236_().m_6263_(null, entity.f_19854_, entity.f_19855_, entity.f_19856_, SoundEvents.f_11852_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    private static void summonEnderman(LivingEntity entity) {
        Level level = entity.m_9236_();
        EnderMan enderman = (EnderMan)EntityType.f_20566_.m_20615_(level);
        if (enderman != null) {
            enderman.m_6027_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
            enderman.getPersistentData().m_128379_(CROWN_SUMMONED_TAG, true);
            enderman.getPersistentData().m_128379_(FRIENDLY_ENDERMAN_TAG, true);
            if (entity instanceof Player) {
                Player player = (Player)entity;
                EnderQueensCrownItem.setEndermanToFollow(enderman, player);
            }
            level.m_7967_((Entity)enderman);
        }
    }

    public static void aggroNearbyEndermen(LivingEntity defender, LivingEntity attacker) {
        EnderMan attackerEnderman;
        boolean isAttackerFriendly;
        EnderMan defenderEnderman;
        boolean isDefenderFriendly;
        if (defender.m_9236_().f_46443_) {
            return;
        }
        if (attacker instanceof Player && defender instanceof EnderMan && (isDefenderFriendly = (defenderEnderman = (EnderMan)defender).getPersistentData().m_128471_(FRIENDLY_ENDERMAN_TAG))) {
            return;
        }
        if (attacker instanceof EnderMan && (isAttackerFriendly = (attackerEnderman = (EnderMan)attacker).getPersistentData().m_128471_(FRIENDLY_ENDERMAN_TAG))) {
            return;
        }
        AABB searchBox = defender.m_20191_().m_82400_(((Double)ModConfig.ENDERMAN_FOLLOW_RANGE.get()).doubleValue());
        defender.m_9236_().m_45976_(EnderMan.class, searchBox).forEach(enderman -> {
            boolean isControlled = enderman.getPersistentData().m_128471_(CROWN_CONTROLLED_TAG);
            boolean isSummoned = enderman.getPersistentData().m_128471_(CROWN_SUMMONED_TAG);
            if (!(!isControlled && !isSummoned || attacker instanceof Player || attacker instanceof EnderMan && ((EnderMan)attacker).getPersistentData().m_128471_(FRIENDLY_ENDERMAN_TAG))) {
                enderman.m_6710_(attacker);
                if (enderman.m_20280_((Entity)attacker) > 100.0) {
                    enderman.m_20984_(attacker.m_20185_() + (attacker.m_217043_().m_188500_() - 0.5) * 4.0, attacker.m_20186_(), attacker.m_20189_() + (attacker.m_217043_().m_188500_() - 0.5) * 4.0, true);
                }
            }
        });
    }

    public int m_6473_() {
        return 0;
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }

    @Override
    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        super.onEquip(slotContext, prevStack, stack);
    }

    @Override
    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        super.onUnequip(slotContext, newStack, stack);
    }
}

