/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.trinketsandbaubles.items.baubles;

import com.jinqinxixi.trinketsandbaubles.capability.registry.ModCapabilities;
import com.jinqinxixi.trinketsandbaubles.config.ModConfig;
import com.jinqinxixi.trinketsandbaubles.modeffects.ModEffects;
import com.jinqinxixi.trinketsandbaubles.modifier.ModifiableBaubleItem;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;

@Mod.EventBusSubscriber(modid="trinketsandbaubles")
public class FaelisClawItem
extends ModifiableBaubleItem {
    private static final ModifiableBaubleItem.Modifier[] MODIFIERS = ModifiableBaubleItem.Modifier.values();
    private static final UUID ATTACK_DAMAGE_UUID = UUID.fromString("c0c52c20-4015-11ee-be56-0242ac120002");

    @Override
    public ModifiableBaubleItem.Modifier[] getModifiers() {
        return MODIFIERS;
    }

    private static AttributeModifier getAttackDamageModifier() {
        return new AttributeModifier(ATTACK_DAMAGE_UUID, "FaelisClawDamageBoost", ((Double)ModConfig.FAELIS_CLAW_DAMAGE_BOOST.get()).doubleValue(), AttributeModifier.Operation.MULTIPLY_BASE);
    }

    public FaelisClawItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        super.onEquip(slotContext, prevStack, stack);
        if (slotContext.entity() instanceof LivingEntity) {
            LivingEntity living = slotContext.entity();
            FaelisClawItem.applyAttributes(living);
        }
    }

    @Override
    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        super.onUnequip(slotContext, newStack, stack);
        if (slotContext.entity() instanceof LivingEntity) {
            LivingEntity living = slotContext.entity();
            FaelisClawItem.removeAttributes(living);
        }
    }

    private static void applyAttributes(LivingEntity entity) {
        AttributeInstance instance = entity.m_21051_(Attributes.f_22281_);
        if (instance != null) {
            instance.m_22120_(ATTACK_DAMAGE_UUID);
            instance.m_22125_(FaelisClawItem.getAttackDamageModifier());
        }
    }

    private static void removeAttributes(LivingEntity entity) {
        AttributeInstance instance = entity.m_21051_(Attributes.f_22281_);
        if (instance != null) {
            instance.m_22120_(ATTACK_DAMAGE_UUID);
        }
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity living;
        AttributeInstance instance;
        super.curioTick(slotContext, stack);
        if (slotContext.entity() instanceof LivingEntity && (instance = (living = slotContext.entity()).m_21051_(Attributes.f_22281_)) != null) {
            boolean hasOurModifier = instance.m_22122_().stream().anyMatch(mod -> mod.m_22209_().equals(ATTACK_DAMAGE_UUID));
            if (!hasOurModifier) {
                FaelisClawItem.applyAttributes(living);
            }
            instance.m_22122_().stream().filter(mod -> mod.m_22209_().equals(ATTACK_DAMAGE_UUID)).findFirst().ifPresent(existingMod -> {
                if (Math.abs(existingMod.m_22218_() - (Double)ModConfig.FAELIS_CLAW_DAMAGE_BOOST.get()) > 1.0E-4) {
                    FaelisClawItem.removeAttributes(living);
                    FaelisClawItem.applyAttributes(living);
                }
            });
        }
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237110_((String)"item.trinketsandbaubles.faelis_claw.tooltip.damage_boost", (Object[])new Object[]{String.format("%.0f", (Double)ModConfig.FAELIS_CLAW_DAMAGE_BOOST.get() * 100.0)}).m_130940_(ChatFormatting.RED));
        tooltip.add((Component)Component.m_237110_((String)"item.trinketsandbaubles.faelis_claw.tooltip.bleed_chance", (Object[])new Object[]{String.format("%.0f", (Double)ModConfig.FAELIS_CLAW_BLEED_CHANCE.get() * 100.0)}).m_130940_(ChatFormatting.DARK_RED));
        tooltip.add((Component)Component.m_237110_((String)"item.trinketsandbaubles.faelis_claw.tooltip.bleed_info", (Object[])new Object[]{Float.valueOf(1.0f), (Integer)ModConfig.FAELIS_CLAW_BLEED_DURATION.get() / 20}).m_130940_(ChatFormatting.DARK_GREEN));
        super.m_7373_(stack, level, tooltip, flag);
    }

    private static boolean isEquipped(LivingEntity entity) {
        return CuriosApi.getCuriosInventory((LivingEntity)entity).resolve().flatMap(curios -> curios.findFirstCurio(stack -> stack.m_41720_() instanceof FaelisClawItem)).isPresent();
    }

    @SubscribeEvent
    public static void onLivingDamage(LivingDamageEvent event) {
        Player player;
        if (event.getSource().m_7639_() instanceof Player && FaelisClawItem.isEquipped((LivingEntity)(player = (Player)event.getSource().m_7639_())) && event.getEntity() instanceof LivingEntity) {
            LivingEntity target = event.getEntity();
            player.getCapability(ModCapabilities.FAELES_CAPABILITY).ifPresent(cap -> {
                if ((double)player.m_217043_().m_188501_() < (Double)ModConfig.FAELIS_CLAW_BLEED_CHANCE.get()) {
                    int baseDuration = (Integer)ModConfig.FAELIS_CLAW_BLEED_DURATION.get();
                    int duration = cap.isActive() ? baseDuration : (int)((double)baseDuration * (Double)ModConfig.FAELIS_CLAW_NORMAL_DURATION_MULTIPLIER.get());
                    target.m_7292_(new MobEffectInstance((MobEffect)ModEffects.BLEEDING.get(), duration));
                }
            });
        }
    }

    public int m_6473_() {
        return 0;
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }
}

