/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.trinketsandbaubles.items.baubles;

import com.jinqinxixi.trinketsandbaubles.config.ModConfig;
import com.jinqinxixi.trinketsandbaubles.modifier.ModifiableBaubleItem;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;

@Mod.EventBusSubscriber
public class PoisonStoneItem
extends ModifiableBaubleItem {
    private static final ModifiableBaubleItem.Modifier[] MODIFIERS = ModifiableBaubleItem.Modifier.values();

    @Override
    public ModifiableBaubleItem.Modifier[] getModifiers() {
        return MODIFIERS;
    }

    public PoisonStoneItem(Item.Properties properties) {
        super(properties);
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        super.curioTick(slotContext, stack);
        slotContext.entity().m_21195_(MobEffects.f_19614_);
        slotContext.entity().m_21195_(MobEffects.f_19612_);
    }

    private static boolean isEquipped(LivingEntity entity) {
        return CuriosApi.getCuriosInventory((LivingEntity)entity).resolve().flatMap(curios -> curios.findFirstCurio(stack -> stack.m_41720_() instanceof PoisonStoneItem)).isPresent();
    }

    private static void onAttack(LivingEntity attacker, LivingEntity target) {
        if (PoisonStoneItem.isEquipped(attacker) && (double)attacker.m_217043_().m_188501_() < (Double)ModConfig.POISON_STONE_CHANCE.get()) {
            target.m_7292_(new MobEffectInstance(MobEffects.f_19614_, ((Integer)ModConfig.POISON_STONE_DURATION.get()).intValue(), ((Integer)ModConfig.POISON_STONE_AMPLIFIER.get()).intValue(), false, true));
        }
    }

    private static float getExtraDamageMultiplier(LivingEntity attacker, LivingEntity target) {
        if (PoisonStoneItem.isEquipped(attacker) && target.m_21023_(MobEffects.f_19614_)) {
            return ((Double)ModConfig.POISON_STONE_DAMAGE_MULTIPLIER.get()).floatValue();
        }
        return 1.0f;
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        Entity entity;
        if (((Boolean)ModConfig.POISON_STONE_ACTIVATE_DAMAGE_EVENT.get()).booleanValue() && (entity = event.getSource().m_7639_()) instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)entity;
            LivingEntity target = event.getEntity();
            PoisonStoneItem.onAttack(attacker, target);
            float multiplier = PoisonStoneItem.getExtraDamageMultiplier(attacker, target);
            if (multiplier > 1.0f) {
                event.setAmount(event.getAmount() * multiplier);
            }
        }
    }

    @Override
    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        super.onEquip(slotContext, prevStack, stack);
    }

    @Override
    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        super.onUnequip(slotContext, newStack, stack);
    }

    public int m_6473_() {
        return 0;
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"item.trinketsandbaubles.poison_stone.tooltip.immunity_poison").m_130940_(ChatFormatting.GREEN));
        tooltip.add((Component)Component.m_237115_((String)"item.trinketsandbaubles.poison_stone.tooltip.immunity_hunger").m_130940_(ChatFormatting.GREEN));
        tooltip.add((Component)Component.m_237110_((String)"item.trinketsandbaubles.poison_stone.tooltip.poison_chance", (Object[])new Object[]{(int)((Double)ModConfig.POISON_STONE_CHANCE.get() * 100.0)}).m_130940_(ChatFormatting.DARK_RED));
        tooltip.add((Component)Component.m_237110_((String)"item.trinketsandbaubles.poison_stone.tooltip.damage_bonus", (Object[])new Object[]{String.format("%.1f", ModConfig.POISON_STONE_DAMAGE_MULTIPLIER.get())}).m_130940_(ChatFormatting.AQUA));
        super.m_7373_(stack, level, tooltip, flag);
    }
}

