/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.trinketsandbaubles.items.baubles;

import com.jinqinxixi.trinketsandbaubles.capability.mana.ManaData;
import com.jinqinxixi.trinketsandbaubles.client.keybind.KeyBindings;
import com.jinqinxixi.trinketsandbaubles.config.ModConfig;
import com.jinqinxixi.trinketsandbaubles.modifier.ModifiableBaubleItem;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Fireball;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.ModList;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import vazkii.botania.api.mana.ManaItemHandler;

public class PolarizedStoneItem
extends ModifiableBaubleItem {
    public static final String DEFLECTION_MODE_TAG = "DeflectionMode";
    public static final String ATTRACTION_MODE_TAG = "AttractionMode";
    private static final ModifiableBaubleItem.Modifier[] MODIFIERS = ModifiableBaubleItem.Modifier.values();

    @Override
    public ModifiableBaubleItem.Modifier[] getModifiers() {
        return MODIFIERS;
    }

    public PolarizedStoneItem(Item.Properties properties) {
        super(properties);
    }

    private ManaSystem getManaSystem() {
        if (this.shouldUseIronsSpellsMana()) {
            return new IronsSpellsManaSystem();
        }
        if (this.shouldUseBotaniaMana()) {
            return new BotaniaManaSystem();
        }
        return new InternalManaSystem();
    }

    private boolean shouldUseIronsSpellsMana() {
        return ModList.get().isLoaded("irons_spellbooks") && (Boolean)ModConfig.USE_IRONS_SPELLS_MANA.get() != false;
    }

    private boolean shouldUseBotaniaMana() {
        return ModList.get().isLoaded("botania") && (Boolean)ModConfig.USE_BOTANIA_MANA.get() != false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        boolean deflectionActive = this.isDeflectionActive(stack);
        boolean attractionActive = this.isAttractionActive(stack);
        tooltip.add((Component)Component.m_237110_((String)"item.trinketsandbaubles.polarized_stone.mana_cost", (Object[])new Object[]{ModConfig.POLARIZED_STONE_DEFLECTION_MANA_COST.get()}).m_130940_(ChatFormatting.BLUE));
        tooltip.add((Component)Component.m_237110_((String)"item.trinketsandbaubles.polarized_stone.deflection_status", (Object[])new Object[]{Component.m_237115_((String)("item.trinketsandbaubles.polarized_stone." + (deflectionActive ? "enabled" : "disabled")))}).m_130940_(deflectionActive ? ChatFormatting.GREEN : ChatFormatting.GRAY));
        tooltip.add((Component)Component.m_237110_((String)"item.trinketsandbaubles.polarized_stone.attraction_status", (Object[])new Object[]{Component.m_237115_((String)("item.trinketsandbaubles.polarized_stone." + (attractionActive ? "enabled" : "disabled")))}).m_130940_(attractionActive ? ChatFormatting.GREEN : ChatFormatting.GRAY));
        String attractionKeyName = KeyBindings.ATTRACTION_TOGGLE_KEY.getKey().m_84875_().getString();
        String deflectionKeyName = KeyBindings.DEFLECTION_TOGGLE_KEY.getKey().m_84875_().getString();
        tooltip.add((Component)Component.m_237110_((String)"item.trinketsandbaubles.polarized_stone.usage.attraction", (Object[])new Object[]{attractionKeyName}).m_130940_(ChatFormatting.YELLOW));
        tooltip.add((Component)Component.m_237110_((String)"item.trinketsandbaubles.polarized_stone.usage.deflection", (Object[])new Object[]{deflectionKeyName}).m_130940_(ChatFormatting.YELLOW));
        if (((Boolean)ModConfig.USE_BOTANIA_MANA.get()).booleanValue() && ModList.get().isLoaded("botania")) {
            LocalPlayer player;
            tooltip.add((Component)Component.m_237110_((String)"item.trinketsandbaubles.polarized_stone.mana_system", (Object[])new Object[]{"Botania"}).m_130940_(ChatFormatting.GOLD));
            if (level != null && level.f_46443_ && (player = Minecraft.m_91087_().f_91074_) != null) {
                float currentMana = this.getCurrentMana((Player)player, stack);
                tooltip.add((Component)Component.m_237110_((String)"item.trinketsandbaubles.polarized_stone.current_mana", (Object[])new Object[]{(int)currentMana}).m_130940_(ChatFormatting.AQUA));
            }
        }
        super.m_7373_(stack, level, tooltip, flag);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!level.f_46443_) {
            if (player.m_6144_()) {
                this.toggleDeflectionMode(stack, player);
            } else {
                this.toggleAttractionMode(stack, player);
            }
        }
        return InteractionResultHolder.m_19092_((Object)stack, (boolean)level.m_5776_());
    }

    private void toggleDeflectionMode(ItemStack stack, Player player) {
        boolean newDeflection = !stack.m_41784_().m_128471_(DEFLECTION_MODE_TAG);
        stack.m_41784_().m_128379_(DEFLECTION_MODE_TAG, newDeflection);
        player.m_5661_((Component)Component.m_237115_((String)("item.trinketsandbaubles.polarized_stone.deflection_" + (newDeflection ? "on" : "off"))), true);
    }

    private void toggleAttractionMode(ItemStack stack, Player player) {
        boolean newAttraction = !stack.m_41784_().m_128471_(ATTRACTION_MODE_TAG);
        stack.m_41784_().m_128379_(ATTRACTION_MODE_TAG, newAttraction);
        player.m_5661_((Component)Component.m_237115_((String)("item.trinketsandbaubles.polarized_stone.attraction_" + (newAttraction ? "on" : "off"))), true);
    }

    @Override
    public void m_6883_(ItemStack stack, Level level, Entity entity, int slot, boolean selected) {
        super.m_6883_(stack, level, entity, slot, selected);
        if (!level.f_46443_ && entity instanceof Player) {
            Player player = (Player)entity;
            boolean isInCurio = CuriosApi.getCuriosInventory((LivingEntity)player).resolve().flatMap(curios -> curios.findFirstCurio(item -> item == stack)).isPresent();
            if (!isInCurio) {
                this.updateManaConsumption(player, stack);
            }
            if (this.isAttractionActive(stack)) {
                this.attractItemsAndXP(level, player);
            }
            if (this.isDeflectionActive(stack)) {
                this.deflectProjectiles(level, player);
            }
        }
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        super.curioTick(slotContext, stack);
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (!player.m_9236_().f_46443_) {
                this.updateManaConsumption(player, stack);
                if (this.isAttractionActive(stack)) {
                    this.attractItemsAndXP(player.m_9236_(), player);
                }
                if (this.isDeflectionActive(stack)) {
                    this.deflectProjectiles(player.m_9236_(), player);
                }
            }
        }
    }

    private boolean isAttractionActive(ItemStack stack) {
        return stack.m_41784_().m_128471_(ATTRACTION_MODE_TAG);
    }

    private boolean isDeflectionActive(ItemStack stack) {
        return stack.m_41784_().m_128471_(DEFLECTION_MODE_TAG);
    }

    private void updateManaConsumption(Player player, ItemStack stack) {
        if (!this.isDeflectionActive(stack)) {
            return;
        }
        if (player.f_19797_ % 20 == 0) {
            float manaCost = ((Double)ModConfig.POLARIZED_STONE_DEFLECTION_MANA_COST.get()).floatValue();
            ManaSystem manaSystem = this.getManaSystem();
            float currentMana = manaSystem.getMana(player, stack);
            if (manaSystem instanceof IronsSpellsManaSystem) {
                manaCost = Math.max(1.0f, (float)Math.ceil(manaCost));
            }
            if (currentMana < manaCost) {
                stack.m_41784_().m_128379_(DEFLECTION_MODE_TAG, false);
                player.m_5661_((Component)Component.m_237115_((String)"item.trinketsandbaubles.polarized_stone.no_mana"), true);
            } else {
                manaSystem.consumeMana(player, manaCost, stack);
            }
        }
    }

    private float getCurrentMana(Player player, ItemStack stack) {
        return this.getManaSystem().getMana(player, stack);
    }

    private void attractItemsAndXP(Level level, Player player) {
        Vec3 playerPos = player.m_20182_().m_82520_(0.0, 0.75, 0.0);
        double range = (Double)ModConfig.POLARIZED_STONE_ATTRACTION_RANGE.get();
        AABB attractionBox = new AABB(playerPos.f_82479_ - range, playerPos.f_82480_ - range, playerPos.f_82481_ - range, playerPos.f_82479_ + range, playerPos.f_82480_ + range, playerPos.f_82481_ + range);
        level.m_45976_(ItemEntity.class, attractionBox).forEach(item -> {
            if (!item.m_213877_() && item.m_19749_() != player) {
                Vec3 motion = playerPos.m_82546_(item.m_20182_()).m_82541_().m_82490_(((Double)ModConfig.POLARIZED_STONE_ATTRACTION_SPEED.get()).doubleValue());
                item.m_20256_(motion);
                item.f_19812_ = true;
            }
        });
        level.m_45976_(ExperienceOrb.class, attractionBox).forEach(orb -> {
            if (!orb.m_213877_()) {
                Vec3 motion = playerPos.m_82546_(orb.m_20182_()).m_82541_().m_82490_(((Double)ModConfig.POLARIZED_STONE_ATTRACTION_SPEED.get()).doubleValue());
                orb.m_20256_(motion);
                orb.f_19812_ = true;
            }
        });
    }

    private void deflectProjectiles(Level level, Player player) {
        AABB deflectionBox = player.m_20191_().m_82400_(((Double)ModConfig.POLARIZED_STONE_DEFLECTION_RANGE.get()).doubleValue());
        level.m_45976_(Projectile.class, deflectionBox).forEach(projectile -> {
            if (!projectile.m_213877_() && this.isHostileProjectile((Projectile)projectile, player)) {
                Vec3 position = projectile.m_20182_();
                Vec3 motion = projectile.m_20184_();
                this.convertProjectileToParticles(level, position, motion);
                projectile.m_146870_();
                level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_144243_, SoundSource.PLAYERS, 1.0f, 1.0f + (float)level.m_213780_().m_188500_() * 0.2f);
            }
        });
    }

    private boolean isHostileProjectile(Projectile projectile, Player player) {
        if (projectile instanceof AbstractArrow) {
            AbstractArrow arrow = (AbstractArrow)projectile;
            return arrow.m_19749_() != player;
        }
        if (projectile instanceof Fireball) {
            Fireball fireball = (Fireball)projectile;
            return fireball.m_19749_() != player;
        }
        return false;
    }

    private void convertProjectileToParticles(Level level, Vec3 projectilePos, Vec3 motion) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            int rings = 3;
            int particlesPerRing = 20;
            double maxRadius = 1.5;
            double expandSpeed = 0.6;
            Vec3 normal = motion.m_82541_();
            Vec3 basis = Math.abs(normal.f_82480_) < 0.999 ? new Vec3(0.0, 1.0, 0.0).m_82537_(normal).m_82541_() : new Vec3(1.0, 0.0, 0.0).m_82537_(normal).m_82541_();
            Vec3 perpendicular = normal.m_82537_(basis);
            for (int ring = 0; ring < rings; ++ring) {
                double radius = (double)(ring + 1) * (maxRadius / (double)rings);
                double progress = (double)ring / (double)rings;
                for (int i = 0; i < particlesPerRing; ++i) {
                    double angle = (double)(i * 2) * Math.PI / (double)particlesPerRing;
                    Vec3 offset = basis.m_82490_(Math.cos(angle) * radius).m_82549_(perpendicular.m_82490_(Math.sin(angle) * radius));
                    SimpleParticleType particle = switch (ring % 3) {
                        case 0 -> ParticleTypes.f_123810_;
                        case 1 -> ParticleTypes.f_123745_;
                        default -> ParticleTypes.f_123799_;
                    };
                    Vec3 particleVelocity = offset.m_82541_().m_82490_(expandSpeed * (1.0 - progress));
                    serverLevel.m_8767_((ParticleOptions)particle, projectilePos.f_82479_ + offset.f_82479_, projectilePos.f_82480_ + offset.f_82480_, projectilePos.f_82481_ + offset.f_82481_, 0, particleVelocity.f_82479_, particleVelocity.f_82480_, particleVelocity.f_82481_, 0.02);
                }
            }
            level.m_6263_(null, projectilePos.f_82479_, projectilePos.f_82480_, projectilePos.f_82481_, SoundEvents.f_144243_, SoundSource.NEUTRAL, 0.7f, 1.2f);
        }
    }

    public int m_6473_() {
        return 0;
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }

    private class IronsSpellsManaSystem
    implements ManaSystem {
        private IronsSpellsManaSystem() {
        }

        @Override
        public float getMana(Player player, ItemStack stack) {
            return MagicData.getPlayerMagicData((LivingEntity)player).getMana();
        }

        @Override
        public void consumeMana(Player player, float amount, ItemStack stack) {
            float actualAmount = Math.max(1.0f, (float)Math.ceil(amount));
            MagicData.getPlayerMagicData((LivingEntity)player).addMana(-actualAmount);
        }
    }

    private class BotaniaManaSystem
    implements ManaSystem {
        private BotaniaManaSystem() {
        }

        @Override
        public float getMana(Player player, ItemStack stack) {
            return ManaItemHandler.instance().requestMana(stack, player, Integer.MAX_VALUE, false);
        }

        @Override
        public void consumeMana(Player player, float amount, ItemStack stack) {
            ManaItemHandler.instance().requestManaExactForTool(stack, player, (int)amount, true);
        }
    }

    private class InternalManaSystem
    implements ManaSystem {
        private InternalManaSystem() {
        }

        @Override
        public float getMana(Player player, ItemStack stack) {
            return ManaData.getMana(player);
        }

        @Override
        public void consumeMana(Player player, float amount, ItemStack stack) {
            ManaData.consumeMana(player, amount);
        }
    }

    private static interface ManaSystem {
        public float getMana(Player var1, ItemStack var2);

        public void consumeMana(Player var1, float var2, ItemStack var3);
    }
}

