/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.trinketsandbaubles.items.baubles;

import com.jinqinxixi.trinketsandbaubles.config.ModConfig;
import com.jinqinxixi.trinketsandbaubles.modifier.ModifiableBaubleItem;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import top.theillusivec4.curios.api.CuriosApi;

public class ShieldofHonorItem
extends ModifiableBaubleItem {
    private static final ModifiableBaubleItem.Modifier[] MODIFIERS = ModifiableBaubleItem.Modifier.values();

    @Override
    public ModifiableBaubleItem.Modifier[] getModifiers() {
        return MODIFIERS;
    }

    public ShieldofHonorItem(Item.Properties properties) {
        super(properties);
    }

    private static void spawnProtectionParticles(Player player) {
        Level level = player.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        RandomSource random = level.m_213780_();
        for (int i = 0; i < 16; ++i) {
            double d0 = random.m_188583_() * 0.02;
            double d1 = random.m_188583_() * 0.02;
            double d2 = random.m_188583_() * 0.02;
            double x = player.m_20185_() + (random.m_188500_() - 0.5) * (double)player.m_20205_();
            double y = player.m_20186_() + 0.5 + (random.m_188500_() - 0.5) * (double)player.m_20206_();
            double z = player.m_20189_() + (random.m_188500_() - 0.5) * (double)player.m_20205_();
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123810_, x, y, z, 1, d0, d1, d2, 0.0);
        }
    }

    private static boolean isEquipped(LivingEntity entity) {
        return CuriosApi.getCuriosInventory((LivingEntity)entity).resolve().flatMap(curios -> curios.findFirstCurio(stack -> stack.m_41720_() instanceof ShieldofHonorItem)).isPresent();
    }

    public static float onDamage(LivingEntity entity, DamageSource source, float amount) {
        int damageCount;
        if (!ShieldofHonorItem.isEquipped(entity) || entity.m_9236_().m_5776_()) {
            return amount;
        }
        if (!ShieldofHonorItem.canImmuneDamageType(source)) {
            return amount;
        }
        if (!entity.m_21023_(MobEffects.f_19606_)) {
            amount *= 1.0f - ((Double)ModConfig.SHIELD_DAMAGE_REDUCTION.get()).floatValue();
        }
        if (source.m_276093_(DamageTypes.f_268565_) || source.m_276093_(DamageTypes.f_268448_) || source.m_276093_(DamageTypes.f_268428_)) {
            amount *= ((Double)ModConfig.SHIELD_EXPLOSION_REDUCTION.get()).floatValue();
        }
        if ((damageCount = entity.getPersistentData().m_128451_("shield_damage_count")) >= (Integer)ModConfig.SHIELD_MAX_DAMAGE_COUNT.get()) {
            if (entity instanceof Player) {
                Player player = (Player)entity;
                ShieldofHonorItem.spawnProtectionParticles(player);
                player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11668_, SoundSource.PLAYERS, 0.5f, 1.5f);
            }
            entity.getPersistentData().m_128405_("shield_damage_count", 0);
            return 0.0f;
        }
        entity.getPersistentData().m_128405_("shield_damage_count", damageCount + 1);
        return amount;
    }

    private static boolean canImmuneDamageType(DamageSource source) {
        return !source.m_276093_(DamageTypes.f_268671_) && !source.m_276093_(DamageTypes.f_268631_) && !source.m_276093_(DamageTypes.f_268468_) && !source.m_276093_(DamageTypes.f_268493_) && !source.m_276093_(DamageTypes.f_268515_) && !source.m_276093_(DamageTypes.f_268722_);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"item.trinketsandbaubles.shield_of_honor.tooltip1").m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)Component.m_237115_((String)"item.trinketsandbaubles.shield_of_honor.tooltip2").m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)Component.m_237110_((String)"item.trinketsandbaubles.shield_of_honor.tooltip.explosion", (Object[])new Object[]{String.format("%.0f", (1.0 - (Double)ModConfig.SHIELD_EXPLOSION_REDUCTION.get()) * 100.0)}).m_130940_(ChatFormatting.BLUE));
        tooltip.add((Component)Component.m_237110_((String)"item.trinketsandbaubles.shield_of_honor.tooltip4", (Object[])new Object[]{ModConfig.SHIELD_MAX_DAMAGE_COUNT.get()}).m_130940_(ChatFormatting.AQUA));
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            boolean hasResistance = player.m_21023_(MobEffects.f_19606_);
            if (!hasResistance) {
                tooltip.add((Component)Component.m_237110_((String)"item.trinketsandbaubles.shield_of_honor.tooltip.active", (Object[])new Object[]{(int)((Double)ModConfig.SHIELD_DAMAGE_REDUCTION.get() * 100.0)}).m_130940_(ChatFormatting.GREEN));
            } else {
                tooltip.add((Component)Component.m_237115_((String)"item.trinketsandbaubles.shield_of_honor.tooltip.inactive").m_130940_(ChatFormatting.GRAY));
            }
        } else {
            tooltip.add((Component)Component.m_237110_((String)"item.trinketsandbaubles.shield_of_honor.tooltip.base", (Object[])new Object[]{(int)((Double)ModConfig.SHIELD_DAMAGE_REDUCTION.get() * 100.0)}).m_130940_(ChatFormatting.GOLD));
        }
        super.m_7373_(stack, level, tooltip, flag);
    }

    public int m_6473_() {
        return 0;
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }
}

