/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.trinketsandbaubles.items.baubles;

import com.jinqinxixi.trinketsandbaubles.config.ModConfig;
import com.jinqinxixi.trinketsandbaubles.modifier.ModifiableBaubleItem;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;

@Mod.EventBusSubscriber
public class StoneofGreaterInertiaItem
extends ModifiableBaubleItem {
    private static final ModifiableBaubleItem.Modifier[] MODIFIERS = ModifiableBaubleItem.Modifier.values();
    private static final UUID KNOCKBACK_RESIST_UUID = UUID.fromString("d7184e46-5b46-4c99-9ea3-7e2987bf4c81");
    private static final UUID MOVEMENT_SPEED_UUID = UUID.fromString("d7184e46-5b46-4c99-9ea3-7e2987bf4c82");
    private static final UUID STEP_HEIGHT_UUID = UUID.fromString("d7184e46-5b46-4c99-9ea3-7e2987bf4c83");

    @Override
    public ModifiableBaubleItem.Modifier[] getModifiers() {
        return MODIFIERS;
    }

    public StoneofGreaterInertiaItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public void applyModifier(Player player, ItemStack stack) {
        super.applyModifier(player, stack);
        this.applyFixedAttributes(player);
    }

    @Override
    public void removeModifier(Player player, ItemStack stack) {
        super.removeModifier(player, stack);
        if (!this.hasSameItemEquipped(player)) {
            this.removeFixedAttributes(player);
        }
    }

    private void applyFixedAttributes(Player player) {
        this.applyAttribute(player, Attributes.f_22278_, KNOCKBACK_RESIST_UUID, "trinketsandbaubles.knockback_resist", (Double)ModConfig.GREATER_INERTIA_KNOCKBACK_RESISTANCE.get(), AttributeModifier.Operation.ADDITION);
        this.applyAttribute(player, Attributes.f_22279_, MOVEMENT_SPEED_UUID, "trinketsandbaubles.movement_speed", (Double)ModConfig.GREATER_INERTIA_MOVEMENT_SPEED.get(), AttributeModifier.Operation.MULTIPLY_BASE);
        this.applyAttribute(player, (Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get(), STEP_HEIGHT_UUID, "trinketsandbaubles.step_height", (Double)ModConfig.GREATER_INERTIA_STEP_HEIGHT.get(), AttributeModifier.Operation.ADDITION);
    }

    private void removeFixedAttributes(Player player) {
        this.removeAttribute(player, Attributes.f_22278_, KNOCKBACK_RESIST_UUID);
        this.removeAttribute(player, Attributes.f_22279_, MOVEMENT_SPEED_UUID);
        this.removeAttribute(player, (Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get(), STEP_HEIGHT_UUID);
    }

    private void applyAttribute(Player player, Attribute attribute, UUID uuid, String name, double value, AttributeModifier.Operation operation) {
        AttributeInstance attrInstance = player.m_21051_(attribute);
        if (attrInstance == null) {
            return;
        }
        AttributeModifier existing = attrInstance.m_22111_(uuid);
        if (existing == null) {
            attrInstance.m_22125_(new AttributeModifier(uuid, name, value, operation));
        } else if (existing.m_22218_() != value) {
            attrInstance.m_22120_(uuid);
            attrInstance.m_22125_(new AttributeModifier(uuid, name, value, operation));
        }
    }

    private void removeAttribute(Player player, Attribute attribute, UUID uuid) {
        AttributeInstance attrInstance = player.m_21051_(attribute);
        if (attrInstance != null) {
            attrInstance.m_22120_(uuid);
        }
    }

    private boolean hasSameItemEquipped(Player player) {
        return CuriosApi.getCuriosInventory((LivingEntity)player).resolve().map(handler -> {
            int count = 0;
            for (String identifier : handler.getCurios().keySet()) {
                ICurioStacksHandler stackHandler = (ICurioStacksHandler)handler.getCurios().get(identifier);
                if (stackHandler == null) continue;
                for (int i = 0; i < stackHandler.getSlots(); ++i) {
                    ItemStack stack = stackHandler.getStacks().getStackInSlot(i);
                    if (!(stack.m_41720_() instanceof StoneofGreaterInertiaItem) || ++count < 2) continue;
                    return true;
                }
            }
            return count >= 2;
        }).orElse(false);
    }

    @SubscribeEvent
    public static void onLivingJump(LivingEvent.LivingJumpEvent event) {
        Player player;
        boolean hasItem;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && (hasItem = CuriosApi.getCuriosInventory((LivingEntity)(player = (Player)livingEntity)).resolve().flatMap(handler -> handler.findFirstCurio(item -> item.m_41720_() instanceof StoneofGreaterInertiaItem)).isPresent())) {
            player.m_20256_(player.m_20184_().m_82520_(0.0, ((Double)ModConfig.GREATER_INERTIA_JUMP_BOOST.get()).doubleValue(), 0.0));
        }
    }

    @SubscribeEvent
    public static void onLivingFall(LivingFallEvent event) {
        Player player;
        boolean hasItem;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && (hasItem = CuriosApi.getCuriosInventory((LivingEntity)(player = (Player)livingEntity)).resolve().flatMap(handler -> handler.findFirstCurio(item -> item.m_41720_() instanceof StoneofGreaterInertiaItem)).isPresent())) {
            event.setDamageMultiplier(event.getDamageMultiplier() * ((Double)ModConfig.GREATER_INERTIA_FALL_REDUCTION.get()).floatValue());
        }
    }

    @Override
    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"item.trinketsandbaubles.greater_inertia_stone.tooltip").m_130940_(ChatFormatting.GOLD));
        tooltip.add((Component)Component.m_237110_((String)"item.trinketsandbaubles.greater_inertia_stone.tooltip.knockback", (Object[])new Object[]{String.format("%.1f", (Double)ModConfig.GREATER_INERTIA_KNOCKBACK_RESISTANCE.get() * 100.0)}).m_130940_(ChatFormatting.BLUE));
        tooltip.add((Component)Component.m_237110_((String)"item.trinketsandbaubles.greater_inertia_stone.tooltip.speed", (Object[])new Object[]{String.format("%.0f", (Double)ModConfig.GREATER_INERTIA_MOVEMENT_SPEED.get() * 100.0)}).m_130940_(ChatFormatting.AQUA));
        tooltip.add((Component)Component.m_237110_((String)"item.trinketsandbaubles.greater_inertia_stone.tooltip.jump", (Object[])new Object[]{String.format("%.0f", (Double)ModConfig.GREATER_INERTIA_JUMP_BOOST.get() * 250.0)}).m_130940_(ChatFormatting.DARK_AQUA));
        tooltip.add((Component)Component.m_237110_((String)"item.trinketsandbaubles.greater_inertia_stone.tooltip.fall", (Object[])new Object[]{String.format("%.0f", (1.0 - (Double)ModConfig.GREATER_INERTIA_FALL_REDUCTION.get()) * 100.0)}).m_130940_(ChatFormatting.DARK_BLUE));
        tooltip.add((Component)Component.m_237115_((String)"item.trinketsandbaubles.greater_inertia_stone.tooltip4").m_130940_(ChatFormatting.DARK_GREEN));
        super.m_7373_(stack, level, tooltip, flag);
    }
}

