/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.trinketsandbaubles.items.baubles;

import com.jinqinxixi.trinketsandbaubles.TrinketsandBaublesMod;
import com.jinqinxixi.trinketsandbaubles.modifier.ModifiableBaubleItem;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;

@Mod.EventBusSubscriber
public class StoneofInertiaNullItem
extends ModifiableBaubleItem {
    private static final ModifiableBaubleItem.Modifier[] MODIFIERS = ModifiableBaubleItem.Modifier.values();
    private static final UUID KNOCKBACK_UUID = UUID.fromString("d7184e46-5b46-4c99-9ea3-7e2987bf4c84");

    @Override
    public ModifiableBaubleItem.Modifier[] getModifiers() {
        return MODIFIERS;
    }

    public StoneofInertiaNullItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public void applyModifier(Player player, ItemStack stack) {
        super.applyModifier(player, stack);
        if (!player.m_9236_().f_46443_) {
            this.applyKnockbackResistance(player);
        }
    }

    @Override
    public void removeModifier(Player player, ItemStack stack) {
        super.removeModifier(player, stack);
        if (!player.m_9236_().f_46443_ && !this.hasSameItemEquipped(player)) {
            this.removeKnockbackResistance(player);
        }
    }

    @Override
    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        super.onEquip(slotContext, prevStack, stack);
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            this.applyModifier(player, stack);
        }
    }

    @Override
    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        super.onUnequip(slotContext, newStack, stack);
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            this.removeModifier(player, stack);
        }
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        super.curioTick(slotContext, stack);
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            AttributeInstance attr;
            Player player = (Player)livingEntity;
            if (!player.m_9236_().f_46443_ && (attr = player.m_21051_(Attributes.f_22278_)) != null && attr.m_22111_(KNOCKBACK_UUID) == null) {
                this.applyKnockbackResistance(player);
            }
        }
    }

    private void applyKnockbackResistance(Player player) {
        AttributeInstance attr = player.m_21051_(Attributes.f_22278_);
        if (attr != null) {
            if (attr.m_22111_(KNOCKBACK_UUID) != null) {
                attr.m_22120_(KNOCKBACK_UUID);
            }
            AttributeModifier modifier = new AttributeModifier(KNOCKBACK_UUID, "trinketsandbaubles.knockback_resistance", 1.0, AttributeModifier.Operation.ADDITION);
            attr.m_22125_(modifier);
            TrinketsandBaublesMod.LOGGER.debug("Added knockback resistance to {}, new value: {}", (Object)player.m_7755_().getString(), (Object)attr.m_22135_());
        }
    }

    private void removeKnockbackResistance(Player player) {
        AttributeInstance attr = player.m_21051_(Attributes.f_22278_);
        if (attr != null) {
            attr.m_22120_(KNOCKBACK_UUID);
            TrinketsandBaublesMod.LOGGER.debug("Removed knockback resistance from {}, new value: {}", (Object)player.m_7755_().getString(), (Object)attr.m_22135_());
        }
    }

    private boolean hasSameItemEquipped(Player player) {
        return CuriosApi.getCuriosInventory((LivingEntity)player).resolve().map(handler -> {
            int count = 0;
            for (String identifier : handler.getCurios().keySet()) {
                ICurioStacksHandler stackHandler = (ICurioStacksHandler)handler.getCurios().get(identifier);
                if (stackHandler == null) continue;
                for (int i = 0; i < stackHandler.getSlots(); ++i) {
                    ItemStack stack = stackHandler.getStacks().getStackInSlot(i);
                    if (!(stack.m_41720_() instanceof StoneofInertiaNullItem) || ++count < 2) continue;
                    return true;
                }
            }
            return count >= 2;
        }).orElse(false);
    }

    @SubscribeEvent
    public static void onLivingFall(LivingFallEvent event) {
        Player player;
        boolean hasItem;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && (hasItem = CuriosApi.getCuriosInventory((LivingEntity)(player = (Player)livingEntity)).resolve().flatMap(handler -> handler.findFirstCurio(stack -> stack.m_41720_() instanceof StoneofInertiaNullItem)).isPresent())) {
            event.setDamageMultiplier(0.0f);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLivingAttack(LivingAttackEvent event) {
        Player player;
        boolean hasItem;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && (hasItem = CuriosApi.getCuriosInventory((LivingEntity)(player = (Player)livingEntity)).resolve().flatMap(handler -> handler.findFirstCurio(stack -> stack.m_41720_() instanceof StoneofInertiaNullItem)).isPresent()) && event.getSource().m_276093_(DamageTypes.f_268576_)) {
            event.setCanceled(true);
            TrinketsandBaublesMod.LOGGER.debug("Cancelled fly into wall damage for {}", (Object)player.m_7755_().getString());
        }
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"item.trinketsandbaubles.inertia_null_stone.tooltip"));
        tooltip.add((Component)Component.m_237115_((String)"item.trinketsandbaubles.inertia_null_stone.tooltip1"));
        tooltip.add((Component)Component.m_237115_((String)"item.trinketsandbaubles.inertia_null_stone.tooltip2"));
        tooltip.add((Component)Component.m_237115_((String)"item.trinketsandbaubles.inertia_null_stone.tooltip3"));
        super.m_7373_(stack, level, tooltip, flag);
    }

    public int m_6473_() {
        return 0;
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }
}

