/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.trinketsandbaubles.items.baubles;

import com.jinqinxixi.trinketsandbaubles.modifier.ModifiableBaubleItem;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fml.ModList;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;

public class StoneoftheSeaItem
extends ModifiableBaubleItem {
    private static final UUID WATER_SPEED_UUID = UUID.fromString("d7184e46-5b46-4c99-9ea3-7e2987bf4c84");
    private static final boolean TOUGH_AS_NAILS_LOADED = ModList.get().isLoaded("toughasnails");
    private static final ModifiableBaubleItem.Modifier[] MODIFIERS = ModifiableBaubleItem.Modifier.values();

    @Override
    public ModifiableBaubleItem.Modifier[] getModifiers() {
        return MODIFIERS;
    }

    public StoneoftheSeaItem(Item.Properties properties) {
        super(properties);
    }

    private static boolean isEquipped(LivingEntity entity) {
        return CuriosApi.getCuriosInventory((LivingEntity)entity).resolve().flatMap(curios -> curios.findFirstCurio(stack -> stack.m_41720_() instanceof StoneoftheSeaItem)).isPresent();
    }

    private void applyFixedAttributes(Player player) {
        this.applyAttribute(player, (Attribute)ForgeMod.SWIM_SPEED.get(), WATER_SPEED_UUID, "trinketsandbaubles.water_speed", 4.0, AttributeModifier.Operation.MULTIPLY_BASE);
    }

    private void removeFixedAttributes(Player player) {
        this.removeAttribute(player, (Attribute)ForgeMod.SWIM_SPEED.get(), WATER_SPEED_UUID);
    }

    private void applyAttribute(Player player, Attribute attribute, UUID uuid, String name, double value, AttributeModifier.Operation operation) {
        AttributeInstance attrInstance = player.m_21051_(attribute);
        if (attrInstance == null) {
            return;
        }
        AttributeModifier existing = attrInstance.m_22111_(uuid);
        if (existing == null) {
            attrInstance.m_22125_(new AttributeModifier(uuid, name, value, operation));
        }
    }

    private void removeAttribute(Player player, Attribute attribute, UUID uuid) {
        AttributeInstance attrInstance = player.m_21051_(attribute);
        if (attrInstance != null) {
            attrInstance.m_22120_(uuid);
        }
    }

    private void handleThirst(Player player) {
        ResourceLocation thirstId;
        MobEffect effect;
        if (TOUGH_AS_NAILS_LOADED && (effect = (MobEffect)BuiltInRegistries.f_256974_.m_7745_(thirstId = new ResourceLocation("toughasnails", "thirst"))) != null) {
            player.m_21195_(effect);
        }
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        super.curioTick(slotContext, stack);
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (player.m_20069_()) {
                player.m_20301_(player.m_6062_());
                this.applyFixedAttributes(player);
            } else {
                this.removeFixedAttributes(player);
            }
            if (TOUGH_AS_NAILS_LOADED) {
                this.handleThirst(player);
            }
        }
    }

    @Override
    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        Player player;
        super.onEquip(slotContext, prevStack, stack);
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player && (player = (Player)livingEntity).m_20069_()) {
            this.applyFixedAttributes(player);
        }
    }

    @Override
    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        super.onUnequip(slotContext, newStack, stack);
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            this.removeFixedAttributes(player);
        }
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"item.trinketsandbaubles.sea_stone.tooltip"));
        tooltip.add((Component)Component.m_237115_((String)"item.trinketsandbaubles.sea_stone.tooltip1"));
        tooltip.add((Component)Component.m_237115_((String)"item.trinketsandbaubles.sea_stone.tooltip2"));
        super.m_7373_(stack, level, tooltip, flag);
    }

    public int m_6473_() {
        return 0;
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }
}

