/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.trinketsandbaubles.items.baubles;

import com.jinqinxixi.trinketsandbaubles.capability.attribute.AttributeRegistry;
import com.jinqinxixi.trinketsandbaubles.capability.base.AbstractRaceCapability;
import com.jinqinxixi.trinketsandbaubles.capability.registry.ModCapabilities;
import com.jinqinxixi.trinketsandbaubles.config.RaceAttributesConfig;
import com.jinqinxixi.trinketsandbaubles.modifier.ModifiableBaubleItem;
import com.jinqinxixi.trinketsandbaubles.util.RaceRingUtil;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class TitanRingItem
extends ModifiableBaubleItem {
    private static final ModifiableBaubleItem.Modifier[] MODIFIERS = ModifiableBaubleItem.Modifier.values();

    @Override
    public ModifiableBaubleItem.Modifier[] getModifiers() {
        return MODIFIERS;
    }

    public TitanRingItem(Item.Properties properties) {
        super(properties);
    }

    private static boolean isEquipped(LivingEntity entity) {
        return CuriosApi.getCuriosInventory((LivingEntity)entity).resolve().flatMap(curios -> curios.findFirstCurio(stack -> stack.m_41720_() instanceof TitanRingItem)).isPresent();
    }

    private void applyFaelisBuff(LivingEntity entity) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            if (RaceRingUtil.hasMultipleRaceRings((Player)serverPlayer)) {
                serverPlayer.getCapability(ModCapabilities.TITAN_CAPABILITY).ifPresent(cap -> {
                    if (cap.isActive()) {
                        cap.setActive(false);
                    }
                });
                return;
            }
            serverPlayer.getCapability(ModCapabilities.TITAN_CAPABILITY).ifPresent(cap -> {
                if (!cap.isActive()) {
                    AbstractRaceCapability.clearAllRaceAbilities((Player)serverPlayer);
                    cap.setActive(true);
                }
            });
        }
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        super.curioTick(slotContext, stack);
        LivingEntity entity = slotContext.entity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            if (RaceRingUtil.hasMultipleRaceRings((Player)serverPlayer)) {
                serverPlayer.getCapability(ModCapabilities.TITAN_CAPABILITY).ifPresent(cap -> {
                    if (cap.isActive()) {
                        cap.setActive(false);
                    }
                });
                return;
            }
            if (TitanRingItem.isEquipped(entity)) {
                serverPlayer.getCapability(ModCapabilities.TITAN_CAPABILITY).ifPresent(cap -> {
                    if (!cap.isActive()) {
                        this.applyFaelisBuff(entity);
                    }
                });
            }
        }
    }

    @Override
    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        super.onEquip(slotContext, prevStack, stack);
        LivingEntity entity = slotContext.entity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            if (RaceRingUtil.hasMultipleRaceRings((Player)serverPlayer)) {
                return;
            }
            if (TitanRingItem.isEquipped(entity)) {
                this.applyFaelisBuff(entity);
            }
        }
    }

    @Override
    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        super.onUnequip(slotContext, newStack, stack);
        LivingEntity entity = slotContext.entity();
        if (!TitanRingItem.isEquipped(entity) && entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            serverPlayer.getCapability(ModCapabilities.TITAN_CAPABILITY).ifPresent(cap -> {
                if (cap.isActive()) {
                    if (serverPlayer.m_21224_()) {
                        cap.setActive(false);
                        CompoundTag playerData = serverPlayer.getPersistentData();
                        if (playerData.m_128441_("TitanCapability")) {
                            playerData.m_128473_("TitanCapability");
                        }
                    } else {
                        cap.setActive(false);
                        CompoundTag playerData = serverPlayer.getPersistentData();
                        String savedRace = playerData.m_128461_("SavedRace");
                        if (!savedRace.isEmpty()) {
                            RaceRingUtil.activateRace(serverPlayer, savedRace);
                        }
                    }
                }
            });
        }
    }

    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return true;
    }

    public ICurio.SoundInfo getEquipSound(SlotContext slotContext, ItemStack stack) {
        return new ICurio.SoundInfo(SoundEvents.f_144243_, 1.0f, 1.0f);
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        if (Screen.m_96638_()) {
            for (Map.Entry<String, AttributeRegistry.AttributeEntry> entry : AttributeRegistry.getAll().entrySet()) {
                try {
                    String attributeName = entry.getKey();
                    double value = 0.0;
                    switch (attributeName) {
                        case "MAX_HEALTH": {
                            value = (Double)RaceAttributesConfig.TITAN.MAX_HEALTH.get();
                            break;
                        }
                        case "FOLLOW_RANGE": {
                            value = (Double)RaceAttributesConfig.TITAN.FOLLOW_RANGE.get();
                            break;
                        }
                        case "MOVEMENT_SPEED": {
                            value = (Double)RaceAttributesConfig.TITAN.MOVEMENT_SPEED.get();
                            break;
                        }
                        case "ATTACK_SPEED": {
                            value = (Double)RaceAttributesConfig.TITAN.ATTACK_SPEED.get();
                            break;
                        }
                        case "ATTACK_DAMAGE": {
                            value = (Double)RaceAttributesConfig.TITAN.ATTACK_DAMAGE.get();
                            break;
                        }
                        case "SWIM_SPEED": {
                            value = (Double)RaceAttributesConfig.TITAN.SWIM_SPEED.get();
                            break;
                        }
                        case "FLYING_SPEED": {
                            value = (Double)RaceAttributesConfig.TITAN.FLYING_SPEED.get();
                            break;
                        }
                        case "ENTITY_GRAVITY": {
                            value = (Double)RaceAttributesConfig.TITAN.ENTITY_GRAVITY.get();
                            break;
                        }
                        case "BLOCK_REACH": {
                            value = (Double)RaceAttributesConfig.TITAN.BLOCK_REACH.get();
                            break;
                        }
                        case "ENTITY_REACH": {
                            value = (Double)RaceAttributesConfig.TITAN.ENTITY_REACH.get();
                            break;
                        }
                        case "NAMETAG_DISTANCE": {
                            value = (Double)RaceAttributesConfig.TITAN.NAMETAG_DISTANCE.get();
                            break;
                        }
                        case "ARMOR": {
                            value = (Double)RaceAttributesConfig.TITAN.ARMOR.get();
                            break;
                        }
                        case "ARMOR_TOUGHNESS": {
                            value = (Double)RaceAttributesConfig.TITAN.ARMOR_TOUGHNESS.get();
                            break;
                        }
                        case "KNOCKBACK_RESISTANCE": {
                            value = (Double)RaceAttributesConfig.TITAN.KNOCKBACK_RESISTANCE.get();
                            break;
                        }
                        case "ATTACK_KNOCKBACK": {
                            value = (Double)RaceAttributesConfig.TITAN.ATTACK_KNOCKBACK.get();
                            break;
                        }
                        case "LUCK": {
                            value = (Double)RaceAttributesConfig.TITAN.LUCK.get();
                            break;
                        }
                        case "STEP_HEIGHT": {
                            value = (Double)RaceAttributesConfig.TITAN.STEP_HEIGHT.get();
                        }
                    }
                    if (value == 0.0) continue;
                    AttributeRegistry.AttributeEntry attr = entry.getValue();
                    String displayText = attr.isPercentage() ? String.format("%s %s%.1f%%", Component.m_237115_((String)attr.getTranslationKey()).getString(), value > 0.0 ? "+" : "", value * 100.0) : String.format("%s %s%.2f", Component.m_237115_((String)attr.getTranslationKey()).getString(), value > 0.0 ? "+" : "", value);
                    tooltip.add((Component)Component.m_237113_((String)displayText).m_130940_(value > 0.0 ? ChatFormatting.GREEN : ChatFormatting.RED));
                }
                catch (Exception exception) {}
            }
        } else {
            tooltip.add((Component)Component.m_237115_((String)"item.trinketsandbaubles.titan_ring.tooltip11").m_130940_(ChatFormatting.GOLD));
            tooltip.add((Component)Component.m_237115_((String)"item.trinketsandbaubles.titan_ring.tooltip12").m_130940_(ChatFormatting.DARK_GREEN));
            tooltip.add((Component)Component.m_237115_((String)"item.trinketsandbaubles.titan_ring.tooltip13").m_130940_(ChatFormatting.RED));
            tooltip.add((Component)Component.m_237115_((String)"item.trinketsandbaubles.titan_ring.tooltip14").m_130940_(ChatFormatting.RED));
            tooltip.add((Component)Component.m_237115_((String)"item.trinketsandbaubles.titan_ring.press_shift").m_130940_(ChatFormatting.GRAY));
        }
        super.m_7373_(stack, level, tooltip, flag);
    }

    public int m_6473_() {
        return 0;
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }
}

