/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.trinketsandbaubles.loot;

import com.jinqinxixi.trinketsandbaubles.config.ModConfig;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod.EventBusSubscriber(modid="trinketsandbaubles")
public class LootTableHandler {
    private static final Logger log = LoggerFactory.getLogger(LootTableHandler.class);

    @SubscribeEvent
    public static void onLootTableLoad(LootTableLoadEvent event) {
        ResourceLocation tableId = event.getName();
        List<ModConfig.LootEntry> entries = ModConfig.lootConfig.get(tableId);
        if (entries != null && !entries.isEmpty()) {
            LootPool.Builder poolBuilder = LootPool.m_79043_().name("trinketsandbaubles_config_loot");
            for (ModConfig.LootEntry entry : entries) {
                Item item = (Item)BuiltInRegistries.f_257033_.m_7745_(entry.itemId);
                if (item != null) {
                    poolBuilder.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)item).m_79707_(entry.weight)).m_165133_((NumberProvider)UniformGenerator.m_165780_((float)entry.minRolls, (float)entry.maxRolls));
                    continue;
                }
                log.error("Invalid item in config: {}", (Object)entry.itemId);
            }
            event.getTable().addPool(poolBuilder.m_79082_());
            log.debug("Added custom loot to {}", (Object)tableId);
        }
    }
}

