/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.trinketsandbaubles.mixin;

import com.jinqinxixi.trinketsandbaubles.capability.registry.ModCapabilities;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Player.class})
public abstract class BlockStateMixin {
    @Inject(method={"hasCorrectToolForDrops"}, at={@At(value="HEAD")}, cancellable=true)
    private void onHasCorrectToolForDrops(BlockState state, CallbackInfoReturnable<Boolean> cir) {
        int requiredTier;
        Player player = (Player)this;
        boolean hasDwarvesCapability = player.getCapability(ModCapabilities.DWARVES_CAPABILITY).map(cap -> cap.isActive()).orElse(false);
        if (hasDwarvesCapability && (requiredTier = this.getRequiredTier(state)) > 0) {
            int adjustedTier = requiredTier - 1;
            ItemStack tool = player.m_21205_();
            int toolTier = this.getToolTier(tool);
            if (toolTier >= adjustedTier) {
                cir.setReturnValue((Object)true);
            }
        }
    }

    private int getRequiredTier(BlockState state) {
        if (state.m_204336_(BlockTags.f_144284_)) {
            return 4;
        }
        if (state.m_204336_(BlockTags.f_144285_)) {
            return 3;
        }
        if (state.m_204336_(BlockTags.f_144286_)) {
            return 2;
        }
        return 0;
    }

    private int getToolTier(ItemStack tool) {
        Item item = tool.m_41720_();
        if (item instanceof DiggerItem) {
            DiggerItem diggerItem = (DiggerItem)item;
            return this.getTierLevel(diggerItem.m_43314_());
        }
        return 0;
    }

    private int getTierLevel(Tier tier) {
        if (tier == Tiers.NETHERITE) {
            return 5;
        }
        if (tier == Tiers.DIAMOND) {
            return 4;
        }
        if (tier == Tiers.IRON) {
            return 3;
        }
        if (tier == Tiers.STONE) {
            return 2;
        }
        if (tier == Tiers.WOOD || tier == Tiers.GOLD) {
            return 1;
        }
        return 0;
    }
}

