/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.trinketsandbaubles.mixin;

import com.jinqinxixi.trinketsandbaubles.capability.registry.ModCapabilities;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.level.block.state.BlockState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Player.class})
public class PlayerMixin {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"TrinketsAndBaubles");
    private long lastLogTime = 0L;

    @Inject(method={"getDigSpeed(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/core/BlockPos;)F"}, at={@At(value="RETURN")}, cancellable=true, remap=false)
    private void onGetDigSpeed(BlockState state, @Nullable BlockPos pos, CallbackInfoReturnable<Float> cir) {
        Player player = (Player)this;
        if (player.m_9236_() == null) {
            return;
        }
        boolean hasDwarvesCapability = player.getCapability(ModCapabilities.DWARVES_CAPABILITY).map(cap -> cap.isActive()).orElse(false);
        if (hasDwarvesCapability) {
            float originalSpeed = ((Float)cir.getReturnValue()).floatValue();
            float hardnessMultiplier = 1.0f;
            if (player.m_21205_().m_41720_() instanceof PickaxeItem) {
                float blockHardness = state.m_60734_().m_155943_();
                hardnessMultiplier += blockHardness * 0.5f;
                long currentTime = System.currentTimeMillis();
                if (currentTime - this.lastLogTime > 1000L) {
                    LOGGER.info("\u77ee\u4eba\u80fd\u529b\u89e6\u53d1 - \u65b9\u5757: {}, \u57fa\u7840\u901f\u5ea6: {}, \u786c\u5ea6: {}, \u6700\u7ec8\u4e58\u6570: {}, \u6700\u7ec8\u901f\u5ea6: {}", new Object[]{state.m_60734_().m_7705_(), Float.valueOf(originalSpeed), Float.valueOf(blockHardness), Float.valueOf(hardnessMultiplier), Float.valueOf(originalSpeed * hardnessMultiplier)});
                    this.lastLogTime = currentTime;
                }
            }
            cir.setReturnValue((Object)Float.valueOf(originalSpeed * hardnessMultiplier));
        }
    }

    @Inject(method={"isSwimming"}, at={@At(value="HEAD")}, cancellable=true)
    private void onIsSwimming(CallbackInfoReturnable<Boolean> cir) {
        Player player = (Player)this;
        boolean hasTitanCapability = player.getCapability(ModCapabilities.TITAN_CAPABILITY).map(cap -> cap.isActive()).orElse(false);
        if (hasTitanCapability) {
            cir.setReturnValue((Object)false);
        }
    }
}

