/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.trinketsandbaubles.modifier;

import com.jinqinxixi.trinketsandbaubles.config.ModConfig;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

@Mod.EventBusSubscriber
public abstract class ModifiableBaubleItem
extends Item
implements ICurioItem {
    public static final String MODIFIER_TAG = "BaubleModifier";
    public static final String INITIALIZED_TAG = "IsInitialized";
    protected static final Random RANDOM = new Random();
    private static final Logger LOGGER = LoggerFactory.getLogger(ModifiableBaubleItem.class);

    public ModifiableBaubleItem(Item.Properties properties) {
        super(properties);
    }

    public abstract Modifier[] getModifiers();

    protected UUID getModifierUUID(ItemStack stack) {
        CompoundTag modifierTag = stack.m_41737_(MODIFIER_TAG);
        if (modifierTag != null && modifierTag.m_128441_("UUID")) {
            return modifierTag.m_128342_("UUID");
        }
        return null;
    }

    protected boolean hasSameModifier(ItemStack stack1, ItemStack stack2) {
        if (stack1.m_41619_() || stack2.m_41619_()) {
            return false;
        }
        UUID uuid1 = this.getModifierUUID(stack1);
        UUID uuid2 = this.getModifierUUID(stack2);
        return uuid1 != null && uuid1.equals(uuid2);
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        if (!ModConfig.isModifierEnabled()) {
            return;
        }
        super.m_6883_(stack, world, entity, slot, selected);
        if (!world.f_46443_ && entity instanceof Player) {
            this.initializeModifier(stack);
        }
    }

    protected void initializeModifier(ItemStack stack) {
        if (!ModConfig.isModifierEnabled()) {
            return;
        }
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128471_(INITIALIZED_TAG)) {
            Modifier selected = this.getRandomModifier();
            UUID uniqueUUID = UUID.randomUUID();
            this.saveModifierToTag(stack, selected, uniqueUUID);
            tag.m_128379_(INITIALIZED_TAG, true);
        }
    }

    private Modifier getRandomModifier() {
        Modifier[] modifiers = this.getModifiers();
        return modifiers[RANDOM.nextInt(modifiers.length)];
    }

    private void saveModifierToTag(ItemStack stack, Modifier modifier, UUID uniqueUUID) {
        CompoundTag modifierTag = new CompoundTag();
        modifierTag.m_128359_("Attribute", ForgeRegistries.ATTRIBUTES.getKey((Object)modifier.attribute).toString());
        modifierTag.m_128359_("TranslationKey", modifier.translationKey);
        modifierTag.m_128347_("Value", modifier.value);
        modifierTag.m_128362_("UUID", uniqueUUID);
        stack.m_41700_(MODIFIER_TAG, (Tag)modifierTag);
    }

    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (!stack.m_41784_().m_128471_(INITIALIZED_TAG)) {
            this.initializeModifier(stack);
            stack.m_41784_().m_128379_(INITIALIZED_TAG, true);
            this.applyModifier(player, stack);
            return;
        }
        if (!prevStack.m_41619_() && this.hasSameModifier(prevStack, stack)) {
            return;
        }
        this.applyModifier(player, stack);
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (!newStack.m_41619_() && this.hasSameModifier(newStack, stack)) {
            return;
        }
        this.removeModifier(player, stack);
    }

    protected void applyModifier(Player player, ItemStack stack) {
        if (!ModConfig.isModifierEnabled()) {
            return;
        }
        CompoundTag modifierTag = stack.m_41737_(MODIFIER_TAG);
        if (modifierTag != null) {
            try {
                UUID uuid;
                ResourceLocation attributeId = new ResourceLocation(modifierTag.m_128461_("Attribute"));
                Attribute attribute = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(attributeId);
                if (attribute == null) {
                    LOGGER.error("Unknown attribute: {}", (Object)attributeId);
                    return;
                }
                UUID uUID = uuid = modifierTag.m_128441_("UUID") ? modifierTag.m_128342_("UUID") : UUID.randomUUID();
                if (!modifierTag.m_128441_("UUID")) {
                    modifierTag.m_128362_("UUID", uuid);
                }
                double value = modifierTag.m_128459_("Value");
                AttributeModifier.Operation operation = this.getOperationType(attribute);
                AttributeModifier mod = new AttributeModifier(uuid, "BaubleModifier_" + stack.hashCode(), value, operation);
                if (!player.m_21051_(attribute).m_22109_(mod)) {
                    player.m_21051_(attribute).m_22118_(mod);
                }
            }
            catch (Exception e) {
                LOGGER.error("Apply modifier failed: {}", (Object)e.getMessage());
            }
        }
    }

    protected void removeModifier(Player player, ItemStack stack) {
        CompoundTag modifierTag = stack.m_41737_(MODIFIER_TAG);
        if (modifierTag != null && modifierTag.m_128441_("UUID")) {
            try {
                ResourceLocation attributeId = new ResourceLocation(modifierTag.m_128461_("Attribute"));
                Attribute attribute = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(attributeId);
                if (attribute != null) {
                    UUID uuid = modifierTag.m_128342_("UUID");
                    player.m_21051_(attribute).m_22120_(uuid);
                    if (attribute == Attributes.f_22276_) {
                        player.m_21153_(Math.min(player.m_21223_(), player.m_21233_()));
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("Remove modifier failed: {}", (Object)e.getMessage());
            }
        }
    }

    AttributeModifier.Operation getOperationType(Attribute attribute) {
        return attribute == Attributes.f_22283_ || attribute == Attributes.f_22279_ || attribute == Attributes.f_22281_ ? AttributeModifier.Operation.MULTIPLY_BASE : AttributeModifier.Operation.ADDITION;
    }

    public ICapabilityProvider initCapabilities(final ItemStack stack, CompoundTag unused) {
        return CuriosApi.createCurioProvider((ICurio)new ICurio(){

            public ItemStack getStack() {
                return stack;
            }

            public void curioTick(SlotContext slotContext) {
                ModifiableBaubleItem.this.curioTick(slotContext, stack);
            }

            public void onEquip(SlotContext slotContext, ItemStack prevStack) {
                ModifiableBaubleItem.this.onEquip(slotContext, prevStack, stack);
            }

            public void onUnequip(SlotContext slotContext, ItemStack newStack) {
                ModifiableBaubleItem.this.onUnequip(slotContext, newStack, stack);
            }

            public boolean canEquip(SlotContext slotContext) {
                return true;
            }
        });
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        if (!ModConfig.isModifierEnabled()) {
            return;
        }
        CompoundTag modifierTag = stack.m_41737_(MODIFIER_TAG);
        if (modifierTag != null) {
            String translationKey = modifierTag.m_128461_("TranslationKey");
            double value = modifierTag.m_128459_("Value");
            String formattedValue = value == (double)((int)value) ? String.valueOf((int)value) : (value >= 1.0 ? String.format("%.1f", value) : String.format("%d%%", (int)(value * 100.0)));
            tooltip.add((Component)Component.m_237113_((String)"\u25c6 ").m_130940_(ChatFormatting.LIGHT_PURPLE).m_7220_((Component)Component.m_237115_((String)translationKey).m_130940_(ChatFormatting.LIGHT_PURPLE)).m_7220_((Component)Component.m_237113_((String)(" +" + formattedValue)).m_130940_(ChatFormatting.GREEN)));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.trinketsandbaubles.unidentified").m_130940_(ChatFormatting.GRAY));
        }
    }

    public static enum Modifier {
        HALF_HEARTED("half_hearted", 1.0, Attributes.f_22276_),
        HEARTY("hearty", 2.0, Attributes.f_22276_),
        HARD("hard", 1.0, Attributes.f_22284_),
        GUARDING("guarding", 1.5, Attributes.f_22284_),
        ARMORED("armored", 2.0, Attributes.f_22284_),
        WARDING("warding", 1.0, Attributes.f_22285_),
        JAGGED("jagged", 0.02, Attributes.f_22281_),
        SPIKED("spiked", 0.04, Attributes.f_22281_),
        ANGRY("angry", 0.06, Attributes.f_22281_),
        MENACING("menacing", 0.08, Attributes.f_22281_),
        BRISK("brisk", 0.01, Attributes.f_22279_),
        FLEETING("fleeting", 0.02, Attributes.f_22279_),
        HASTY("hasty", 0.03, Attributes.f_22279_),
        QUICK("quick", 0.04, Attributes.f_22279_),
        WILD("wild", 0.02, Attributes.f_22283_),
        RASH("rash", 0.04, Attributes.f_22283_),
        INTREPID("intrepid", 0.06, Attributes.f_22283_),
        VIOLENT("violent", 0.08, Attributes.f_22283_);

        final String translationKey;
        final double value;
        final Attribute attribute;

        private Modifier(String key, double value, Attribute attribute) {
            this.translationKey = "modifier.trinketsandbaubles." + key;
            this.value = value;
            this.attribute = attribute;
        }
    }
}

