/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.trinketsandbaubles.network.handler;

import com.jinqinxixi.trinketsandbaubles.network.message.DragonRingMessage.DragonBreathMessage;
import com.jinqinxixi.trinketsandbaubles.network.message.DragonRingMessage.DragonFlightToggleMessage;
import com.jinqinxixi.trinketsandbaubles.network.message.DragonRingMessage.StopDragonBreathMessage;
import com.jinqinxixi.trinketsandbaubles.network.message.DragonRingMessage.SyncAllDragonStatesMessage;
import com.jinqinxixi.trinketsandbaubles.network.message.DragonRingMessage.SyncDragonBreathMessage;
import com.jinqinxixi.trinketsandbaubles.network.message.DragonsEyeMessage.DragonsEyeToggleMessage;
import com.jinqinxixi.trinketsandbaubles.network.message.DragonsEyeMessage.UpdateEffectsMessage;
import com.jinqinxixi.trinketsandbaubles.network.message.DragonsEyeMessage.UpdateTargetsMessage;
import com.jinqinxixi.trinketsandbaubles.network.message.ManaMessage.ManaSyncMessage;
import com.jinqinxixi.trinketsandbaubles.network.message.Messages.ChargeKeyMessage;
import com.jinqinxixi.trinketsandbaubles.network.message.Messages.DashKeyPressMessage;
import com.jinqinxixi.trinketsandbaubles.network.message.Messages.PolarizedStoneToggleMessage;
import com.jinqinxixi.trinketsandbaubles.network.message.Messages.StopChargeMessage;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class NetworkHandler {
    private static final String PROTOCOL_VERSION = "1.0";
    private static int packetId = 0;
    public static final SimpleChannel INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("trinketsandbaubles", "main"), () -> "1.0", "1.0"::equals, "1.0"::equals);

    private static int nextId() {
        return packetId++;
    }

    public static void register() {
        boolean id = false;
        NetworkHandler.registerCommonMessages();
        NetworkHandler.registerServerBoundMessages();
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> NetworkHandler.registerClientOnlyMessages());
    }

    private static void registerCommonMessages() {
        INSTANCE.messageBuilder(ManaSyncMessage.class, NetworkHandler.nextId()).encoder(ManaSyncMessage::encode).decoder(ManaSyncMessage::decode).consumerMainThread(ManaSyncMessage::handle).add();
        INSTANCE.messageBuilder(SyncDragonBreathMessage.class, NetworkHandler.nextId()).encoder(SyncDragonBreathMessage::encode).decoder(SyncDragonBreathMessage::decode).consumerMainThread(SyncDragonBreathMessage::handle).add();
        INSTANCE.messageBuilder(UpdateTargetsMessage.class, NetworkHandler.nextId()).encoder(UpdateTargetsMessage::encode).decoder(UpdateTargetsMessage::decode).consumerMainThread(UpdateTargetsMessage::handle).add();
        INSTANCE.messageBuilder(DragonFlightToggleMessage.class, NetworkHandler.nextId()).encoder(DragonFlightToggleMessage::encode).decoder(DragonFlightToggleMessage::decode).consumerMainThread(DragonFlightToggleMessage::handle).add();
        INSTANCE.messageBuilder(SyncAllDragonStatesMessage.class, NetworkHandler.nextId()).encoder(SyncAllDragonStatesMessage::encode).decoder(SyncAllDragonStatesMessage::decode).consumerMainThread(SyncAllDragonStatesMessage::handle).add();
    }

    private static void registerServerBoundMessages() {
        INSTANCE.messageBuilder(DragonBreathMessage.class, NetworkHandler.nextId()).encoder(DragonBreathMessage::encode).decoder(DragonBreathMessage::decode).consumerMainThread(DragonBreathMessage::handle).add();
        INSTANCE.messageBuilder(StopDragonBreathMessage.class, NetworkHandler.nextId()).encoder(StopDragonBreathMessage::encode).decoder(StopDragonBreathMessage::decode).consumerMainThread(StopDragonBreathMessage::handle).add();
        INSTANCE.messageBuilder(DashKeyPressMessage.class, NetworkHandler.nextId()).encoder(DashKeyPressMessage::encode).decoder(DashKeyPressMessage::decode).consumerMainThread(DashKeyPressMessage::handle).add();
        INSTANCE.messageBuilder(StopChargeMessage.class, NetworkHandler.nextId()).encoder(StopChargeMessage::encode).decoder(StopChargeMessage::decode).consumerMainThread(StopChargeMessage::handle).add();
        INSTANCE.messageBuilder(ChargeKeyMessage.class, NetworkHandler.nextId()).encoder(ChargeKeyMessage::encode).decoder(ChargeKeyMessage::decode).consumerMainThread(ChargeKeyMessage::handle).add();
        INSTANCE.messageBuilder(DragonsEyeToggleMessage.class, NetworkHandler.nextId()).encoder(DragonsEyeToggleMessage::encode).decoder(DragonsEyeToggleMessage::decode).consumerMainThread(DragonsEyeToggleMessage::handle).add();
        INSTANCE.messageBuilder(UpdateEffectsMessage.class, NetworkHandler.nextId()).encoder(UpdateEffectsMessage::encode).decoder(UpdateEffectsMessage::decode).consumerMainThread(UpdateEffectsMessage::handle).add();
    }

    private static void registerClientOnlyMessages() {
        INSTANCE.messageBuilder(PolarizedStoneToggleMessage.class, NetworkHandler.nextId()).encoder(PolarizedStoneToggleMessage::encode).decoder(PolarizedStoneToggleMessage::decode).consumerMainThread(PolarizedStoneToggleMessage::handle).add();
    }

    public static void sendToClient(Object message, ServerPlayer player) {
        if (!player.m_9236_().m_5776_()) {
            INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), message);
        }
    }

    public static void sendToServer(Object message) {
        if (FMLEnvironment.dist == Dist.CLIENT) {
            INSTANCE.sendToServer(message);
        }
    }
}

