/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.trinketsandbaubles.network.message.DragonRingMessage;

import com.jinqinxixi.trinketsandbaubles.capability.registry.ModCapabilities;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class SyncAllDragonStatesMessage {
    private final boolean flightEnabled;
    private final boolean dragonBreathActive;
    private final int playerId;

    public SyncAllDragonStatesMessage(boolean flightEnabled, boolean dragonBreathActive, int playerId) {
        this.flightEnabled = flightEnabled;
        this.dragonBreathActive = dragonBreathActive;
        this.playerId = playerId;
    }

    public static SyncAllDragonStatesMessage decode(FriendlyByteBuf buf) {
        return new SyncAllDragonStatesMessage(buf.readBoolean(), buf.readBoolean(), buf.readInt());
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeBoolean(this.flightEnabled);
        buf.writeBoolean(this.dragonBreathActive);
        buf.writeInt(this.playerId);
    }

    public static void handle(SyncAllDragonStatesMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            Entity entity;
            Minecraft minecraft = Minecraft.m_91087_();
            if (minecraft.f_91073_ != null && (entity = minecraft.f_91073_.m_6815_(message.playerId)) instanceof Player) {
                Player player = (Player)entity;
                player.getCapability(ModCapabilities.DRAGON_CAPABILITY).ifPresent(dragonCap -> {
                    if (message.flightEnabled != dragonCap.isFlightEnabled()) {
                        dragonCap.toggleFlight();
                    }
                    if (message.dragonBreathActive != dragonCap.isDragonBreathActive()) {
                        dragonCap.toggleDragonBreath();
                    }
                });
                player.getCapability(ModCapabilities.FAIRY_CAPABILITY).ifPresent(fairyCap -> {
                    if (message.flightEnabled != fairyCap.isFlightEnabled()) {
                        fairyCap.toggleFlight();
                    }
                });
            }
        });
        context.setPacketHandled(true);
    }
}

