/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.trinketsandbaubles.network.message.DragonRingMessage;

import com.jinqinxixi.trinketsandbaubles.capability.impl.DragonCapability;
import com.jinqinxixi.trinketsandbaubles.capability.registry.ModCapabilities;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class SyncDragonBreathMessage {
    private final boolean isActive;
    private final int playerId;

    public SyncDragonBreathMessage(boolean isActive, int playerId) {
        this.isActive = isActive;
        this.playerId = playerId;
    }

    public static SyncDragonBreathMessage decode(FriendlyByteBuf buf) {
        return new SyncDragonBreathMessage(buf.readBoolean(), buf.readInt());
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeBoolean(this.isActive);
        buf.writeInt(this.playerId);
    }

    public static void handle(SyncDragonBreathMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            Entity entity;
            Minecraft minecraft = Minecraft.m_91087_();
            if (minecraft.f_91073_ != null && (entity = minecraft.f_91073_.m_6815_(message.playerId)) instanceof Player) {
                Player player = (Player)entity;
                player.getCapability(ModCapabilities.DRAGON_CAPABILITY).ifPresent(cap -> {
                    if (cap instanceof DragonCapability) {
                        DragonCapability dragonCap = (DragonCapability)cap;
                        dragonCap.dragonBreathActive = message.isActive;
                    }
                });
            }
        });
        context.setPacketHandled(true);
    }
}

