/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.trinketsandbaubles.network.message.DragonsEyeMessage;

import com.jinqinxixi.trinketsandbaubles.util.ScanSystem;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class UpdateTargetsMessage {
    private final ListTag targets;
    private final boolean isToggleRequest;
    private final boolean isTargetMode;
    private final int oreGroupIndex;

    public UpdateTargetsMessage(ListTag targets, boolean isTargetMode, int oreGroupIndex) {
        this.targets = targets;
        this.isToggleRequest = false;
        this.isTargetMode = isTargetMode;
        this.oreGroupIndex = oreGroupIndex;
    }

    public UpdateTargetsMessage() {
        this.targets = new ListTag();
        this.isToggleRequest = true;
        this.isTargetMode = false;
        this.oreGroupIndex = -1;
    }

    public static void encode(UpdateTargetsMessage message, FriendlyByteBuf buf) {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("Targets", (Tag)message.targets);
        tag.m_128379_("isToggleRequest", message.isToggleRequest);
        tag.m_128379_("isTargetMode", message.isTargetMode);
        tag.m_128405_("oreGroupIndex", message.oreGroupIndex);
        buf.m_130079_(tag);
    }

    public static UpdateTargetsMessage decode(FriendlyByteBuf buf) {
        CompoundTag tag = buf.m_130260_();
        if (tag != null && tag.m_128471_("isToggleRequest")) {
            return new UpdateTargetsMessage();
        }
        return new UpdateTargetsMessage(tag != null ? tag.m_128437_("Targets", 10) : new ListTag(), tag != null && tag.m_128471_("isTargetMode"), tag != null ? tag.m_128451_("oreGroupIndex") : -1);
    }

    public static void handle(UpdateTargetsMessage message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (message.isToggleRequest) {
                ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
                if (player != null) {
                    ScanSystem.handleScanToggleRequest(player);
                }
            } else {
                DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> UpdateTargetsMessage.handleClient(message));
            }
        });
        ctx.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handleClient(UpdateTargetsMessage message) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91074_ != null) {
            ScanSystem.PlayerScanState state = ScanSystem.getPlayerState((Player)minecraft.f_91074_);
            state.isTargetMode = message.isTargetMode();
            state.oreGroupIndex = message.getOreGroupIndex();
            state.lastTargets = message.getTargets();
            minecraft.f_91074_.getPersistentData().m_128365_("Targets", (Tag)message.getTargets());
        }
    }

    public boolean isTargetMode() {
        return this.isTargetMode;
    }

    public int getOreGroupIndex() {
        return this.oreGroupIndex;
    }

    public ListTag getTargets() {
        return this.targets;
    }
}

