/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.trinketsandbaubles.network.message.Messages;

import com.jinqinxixi.trinketsandbaubles.items.baubles.PolarizedStoneItem;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import top.theillusivec4.curios.api.CuriosApi;

public class PolarizedStoneToggleMessage {
    private final boolean isDeflectionToggle;

    public PolarizedStoneToggleMessage(boolean isDeflectionToggle) {
        this.isDeflectionToggle = isDeflectionToggle;
    }

    public static void encode(PolarizedStoneToggleMessage message, FriendlyByteBuf buf) {
        buf.writeBoolean(message.isDeflectionToggle);
    }

    public static PolarizedStoneToggleMessage decode(FriendlyByteBuf buf) {
        return new PolarizedStoneToggleMessage(buf.readBoolean());
    }

    public static void handle(PolarizedStoneToggleMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer serverPlayer = context.getSender();
            if (serverPlayer != null) {
                CuriosApi.getCuriosInventory((LivingEntity)serverPlayer).ifPresent(handler -> handler.findFirstCurio(item -> item.m_41720_() instanceof PolarizedStoneItem).ifPresent(slotResult -> {
                    ItemStack stack = slotResult.stack();
                    if (message.isDeflectionToggle) {
                        boolean newDeflection = !stack.m_41784_().m_128471_("DeflectionMode");
                        stack.m_41784_().m_128379_("DeflectionMode", newDeflection);
                        serverPlayer.m_5661_((Component)Component.m_237115_((String)("item.trinketsandbaubles.polarized_stone.deflection_" + (newDeflection ? "on" : "off"))), true);
                    } else {
                        boolean newAttraction = !stack.m_41784_().m_128471_("AttractionMode");
                        stack.m_41784_().m_128379_("AttractionMode", newAttraction);
                        serverPlayer.m_5661_((Component)Component.m_237115_((String)("item.trinketsandbaubles.polarized_stone.attraction_" + (newAttraction ? "on" : "off"))), true);
                    }
                }));
            }
        });
        context.setPacketHandled(true);
    }

    public boolean isDeflectionToggle() {
        return this.isDeflectionToggle;
    }
}

