/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.trinketsandbaubles.recast;

import com.jinqinxixi.trinketsandbaubles.config.ModConfig;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class AnvilRecastHandler {
    private static final Map<Item, RecastRecipe> RECIPES = new HashMap<Item, RecastRecipe>();

    private static int getExpCost() {
        return ModConfig.getAnvilRecastExpCost();
    }

    private static int getMaterialCost() {
        return ModConfig.getAnvilRecastMaterialCost();
    }

    public static void registerRecipe(Item baseItem, Item tokenItem, Item resultItem) {
        RECIPES.put(baseItem, new RecastRecipe(tokenItem, resultItem));
    }

    @SubscribeEvent
    public static void onAnvilUpdate(AnvilUpdateEvent event) {
        RecastRecipe recipe;
        if (!ModConfig.isModifierEnabled()) {
            return;
        }
        ItemStack left = event.getLeft();
        ItemStack right = event.getRight();
        if (!left.m_41619_() && !right.m_41619_() && (recipe = RECIPES.get(left.m_41720_())) != null && recipe.matches(right)) {
            ItemStack output = left.m_41777_();
            CompoundTag tag = output.m_41783_();
            if (tag != null) {
                if (tag.m_128441_("IsInitialized")) {
                    tag.m_128473_("IsInitialized");
                }
                if (tag.m_128441_("BaubleModifier")) {
                    tag.m_128473_("BaubleModifier");
                }
            }
            event.setOutput(output);
            event.setCost(AnvilRecastHandler.getExpCost());
            event.setMaterialCost(AnvilRecastHandler.getMaterialCost());
        }
    }

    public static class RecastRecipe {
        private final Item tokenItem;
        private final Item resultItem;

        public RecastRecipe(Item tokenItem, Item resultItem) {
            this.tokenItem = tokenItem;
            this.resultItem = resultItem;
        }

        public boolean matches(ItemStack rightStack) {
            return rightStack.m_41720_() == this.tokenItem;
        }
    }
}

