/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.trinketsandbaubles.util;

import com.jinqinxixi.trinketsandbaubles.capability.api.IBaseRaceCapability;
import com.jinqinxixi.trinketsandbaubles.capability.registry.ModCapabilities;
import com.jinqinxixi.trinketsandbaubles.util.RaceRingUtil;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class RaceHelper {
    public static final String SAVED_RACE_KEY = "SavedRace";

    public static void checkAndUpdateRaceState(Player player) {
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        boolean hasAnyRaceRing = RaceRingUtil.hasAnyRaceRing(player);
        if (hasAnyRaceRing) {
            return;
        }
        String currentRace = RaceHelper.getActiveRace(player);
        CompoundTag playerData = player.getPersistentData();
        String savedRace = playerData.m_128461_(SAVED_RACE_KEY);
        if (currentRace != null && !currentRace.equals(savedRace)) {
            RaceHelper.saveRace(serverPlayer, currentRace);
        }
    }

    private static String getActiveRace(Player player) {
        for (Map.Entry<String, Capability<? extends IBaseRaceCapability>> entry : ModCapabilities.RACE_CAPABILITIES.entrySet()) {
            String raceName = entry.getKey();
            LazyOptional optCap = player.getCapability(entry.getValue());
            if (!optCap.isPresent() || !((IBaseRaceCapability)optCap.resolve().get()).isActive()) continue;
            return raceName;
        }
        return null;
    }

    private static void saveRace(ServerPlayer player, String raceName) {
        CompoundTag playerData = player.getPersistentData();
        playerData.m_128359_(SAVED_RACE_KEY, raceName);
    }

    @Mod.EventBusSubscriber(modid="trinketsandbaubles")
    public static class EventHandler {
        @SubscribeEvent
        public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
            if (event.phase == TickEvent.Phase.END && !event.player.m_9236_().m_5776_()) {
                RaceHelper.checkAndUpdateRaceState(event.player);
            }
        }
    }
}

