/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.trinketsandbaubles.util;

import com.jinqinxixi.trinketsandbaubles.capability.registry.ModCapabilities;
import com.jinqinxixi.trinketsandbaubles.items.baubles.DragonsRingItem;
import com.jinqinxixi.trinketsandbaubles.items.baubles.DwarvesRingItem;
import com.jinqinxixi.trinketsandbaubles.items.baubles.ElvesRingItem;
import com.jinqinxixi.trinketsandbaubles.items.baubles.FaelesRingItem;
import com.jinqinxixi.trinketsandbaubles.items.baubles.FairiesRingItem;
import com.jinqinxixi.trinketsandbaubles.items.baubles.GoblinsRingItem;
import com.jinqinxixi.trinketsandbaubles.items.baubles.TitanRingItem;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import top.theillusivec4.curios.api.CuriosApi;

public class RaceRingUtil {
    public static boolean hasMultipleRaceRings(Player player) {
        AtomicInteger raceRingCount = new AtomicInteger(0);
        CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(inventory -> inventory.getCurios().forEach((identifier, slotInventory) -> {
            for (int i = 0; i < slotInventory.getSlots(); ++i) {
                if (!RaceRingUtil.isRaceRing(slotInventory.getStacks().getStackInSlot(i).m_41720_())) continue;
                raceRingCount.incrementAndGet();
            }
        }));
        return raceRingCount.get() > 1;
    }

    private static boolean isRaceRing(Item item) {
        return item instanceof FaelesRingItem || item instanceof FairiesRingItem || item instanceof DwarvesRingItem || item instanceof TitanRingItem || item instanceof GoblinsRingItem || item instanceof ElvesRingItem || item instanceof DragonsRingItem;
    }

    public static boolean hasAnyRaceRing(Player player) {
        AtomicInteger raceRingCount = new AtomicInteger(0);
        CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(inventory -> inventory.getCurios().forEach((identifier, slotInventory) -> {
            for (int i = 0; i < slotInventory.getSlots(); ++i) {
                if (!RaceRingUtil.isRaceRing(slotInventory.getStacks().getStackInSlot(i).m_41720_())) continue;
                raceRingCount.incrementAndGet();
                break;
            }
        }));
        return raceRingCount.get() > 0;
    }

    public static void activateRace(ServerPlayer player, String raceName) {
        if (raceName == null || raceName.isEmpty()) {
            return;
        }
        switch (raceName.toLowerCase()) {
            case "dwarves": {
                player.getCapability(ModCapabilities.DWARVES_CAPABILITY).ifPresent(capability -> capability.setActive(true));
                break;
            }
            case "dragon": {
                player.getCapability(ModCapabilities.DRAGON_CAPABILITY).ifPresent(capability -> capability.setActive(true));
                break;
            }
            case "elves": {
                player.getCapability(ModCapabilities.ELVES_CAPABILITY).ifPresent(capability -> capability.setActive(true));
                break;
            }
            case "faeles": {
                player.getCapability(ModCapabilities.FAELES_CAPABILITY).ifPresent(capability -> capability.setActive(true));
                break;
            }
            case "fairy": {
                player.getCapability(ModCapabilities.FAIRY_CAPABILITY).ifPresent(capability -> capability.setActive(true));
                break;
            }
            case "goblins": {
                player.getCapability(ModCapabilities.GOBLINS_CAPABILITY).ifPresent(capability -> capability.setActive(true));
                break;
            }
            case "titan": {
                player.getCapability(ModCapabilities.TITAN_CAPABILITY).ifPresent(capability -> capability.setActive(true));
            }
        }
    }
}

