/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.trinketsandbaubles.util;

import com.jinqinxixi.trinketsandbaubles.TrinketsandBaublesMod;
import com.jinqinxixi.trinketsandbaubles.capability.impl.DragonCapability;
import com.jinqinxixi.trinketsandbaubles.capability.registry.ModCapabilities;
import com.jinqinxixi.trinketsandbaubles.client.keybind.KeyBindings;
import com.jinqinxixi.trinketsandbaubles.config.ModConfig;
import com.jinqinxixi.trinketsandbaubles.items.baubles.DragonsEyeItem;
import com.jinqinxixi.trinketsandbaubles.network.handler.NetworkHandler;
import com.jinqinxixi.trinketsandbaubles.network.message.DragonsEyeMessage.UpdateTargetsMessage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import top.theillusivec4.curios.api.CuriosApi;

@Mod.EventBusSubscriber(modid="trinketsandbaubles")
public class ScanSystem {
    public static final String TAG_DRAGONS_EYE_TARGETS = "Targets";
    private static final List<Set<Block>> ORE_GROUPS = new ArrayList<Set<Block>>();
    private static final Set<Block> CHEST_BLOCKS = new HashSet<Block>();
    private static final Map<UUID, PlayerScanState> PLAYER_SCAN_STATES = new HashMap<UUID, PlayerScanState>();
    private static final List<String> ORE_GROUP_NAMES = Arrays.asList("valuables", "common", "redstone", "all");

    @SubscribeEvent
    public static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        PLAYER_SCAN_STATES.remove(event.getEntity().m_20148_());
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END || event.player.m_9236_().f_46443_) {
            return;
        }
        Player player = event.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            ScanSystem.checkAndUpdateScan(player2);
            ScanSystem.applyEffects(player2);
        }
    }

    public static void toggleNightVision(ServerPlayer player) {
        PlayerScanState state = ScanSystem.getPlayerState((Player)player);
        state.nightVisionEnabled = !state.nightVisionEnabled;
        player.m_5661_((Component)Component.m_237115_((String)("item.dragons_eye.night_vision." + (state.nightVisionEnabled ? "on" : "off"))), true);
        if (!state.nightVisionEnabled) {
            player.m_21195_(MobEffects.f_19611_);
        }
    }

    public static boolean hasNightVision(Player player) {
        return ScanSystem.getPlayerState((Player)player).nightVisionEnabled;
    }

    private static void applyEffects(ServerPlayer player) {
        boolean hasDragonCapability = player.getCapability(ModCapabilities.DRAGON_CAPABILITY).map(cap -> cap instanceof DragonCapability && cap.isActive()).orElse(false);
        boolean hasDragonsEye = CuriosApi.getCuriosInventory((LivingEntity)player).map(handler -> handler.findFirstCurio(stack -> stack.m_41720_() instanceof DragonsEyeItem).isPresent()).orElse(false);
        if (!hasDragonCapability && !hasDragonsEye) {
            return;
        }
        PlayerScanState state = ScanSystem.getPlayerState((Player)player);
        if (!player.m_21023_(MobEffects.f_19607_) || player.m_21124_(MobEffects.f_19607_).m_19557_() <= 20) {
            MobEffectInstance fireResistance = new MobEffectInstance(MobEffects.f_19607_, Integer.MAX_VALUE, 0, true, false);
            player.m_7292_(fireResistance);
        }
        if (state.nightVisionEnabled && (!player.m_21023_(MobEffects.f_19611_) || player.m_21124_(MobEffects.f_19611_).m_19557_() <= 20)) {
            MobEffectInstance nightVision = new MobEffectInstance(MobEffects.f_19611_, Integer.MAX_VALUE, 0, true, false);
            player.m_7292_(nightVision);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onKeyInput(InputEvent.Key event) {
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        if (player != null && KeyBindings.TOGGLE_DRAGONS_EYE_MODE.m_90859_()) {
            NetworkHandler.INSTANCE.sendToServer((Object)new UpdateTargetsMessage());
        }
    }

    public static void initializeOreGroups() {
        ORE_GROUPS.clear();
        HashSet<Block> valuableOres = new HashSet<Block>(Arrays.asList(Blocks.f_50089_, Blocks.f_152474_, Blocks.f_50264_, Blocks.f_152479_, Blocks.f_49995_, Blocks.f_152467_, Blocks.f_50722_));
        ScanSystem.addConfiguredBlocks((List)ModConfig.VALUABLE_ORES.get(), valuableOres);
        ORE_GROUPS.add(valuableOres);
        HashSet<Block> commonOres = new HashSet<Block>(Arrays.asList(Blocks.f_49996_, Blocks.f_152468_, Blocks.f_49997_, Blocks.f_152469_, Blocks.f_152505_, Blocks.f_152506_, Blocks.f_50331_, Blocks.f_49998_));
        ScanSystem.addConfiguredBlocks((List)ModConfig.COMMON_ORES.get(), commonOres);
        ORE_GROUPS.add(commonOres);
        HashSet<Block> redstoneOres = new HashSet<Block>(Arrays.asList(Blocks.f_50173_, Blocks.f_152473_, Blocks.f_50059_, Blocks.f_152472_));
        ScanSystem.addConfiguredBlocks((List)ModConfig.REDSTONE_ORES.get(), redstoneOres);
        ORE_GROUPS.add(redstoneOres);
        HashSet<Block> allOres = new HashSet<Block>();
        allOres.addAll(valuableOres);
        allOres.addAll(commonOres);
        allOres.addAll(redstoneOres);
        ORE_GROUPS.add(allOres);
        CHEST_BLOCKS.clear();
        BuiltInRegistries.f_256975_.m_123024_().filter(b -> b instanceof ShulkerBoxBlock || BuiltInRegistries.f_256975_.m_7981_(b).m_135815_().contains("chest") || BuiltInRegistries.f_256975_.m_7981_(b).m_135815_().contains("barrel")).forEach(CHEST_BLOCKS::add);
    }

    private static void addConfiguredBlocks(List<? extends String> configList, Set<Block> blockSet) {
        for (String string : configList) {
            try {
                ResourceLocation resourceLocation = new ResourceLocation(string);
                Block block = (Block)BuiltInRegistries.f_256975_.m_7745_(resourceLocation);
                if (block != Blocks.f_50016_) {
                    blockSet.add(block);
                    continue;
                }
                TrinketsandBaublesMod.LOGGER.warn("Could not find block with id: " + string);
            }
            catch (Exception e) {
                TrinketsandBaublesMod.LOGGER.error("Error adding configured block: " + string, (Throwable)e);
            }
        }
    }

    private static void checkAndUpdateScan(ServerPlayer player) {
        PlayerScanState state = ScanSystem.getPlayerState((Player)player);
        boolean canScanNow = ScanSystem.canPlayerScan((Player)player);
        if (state.scanEnabled != canScanNow) {
            state.scanEnabled = canScanNow;
            if (!canScanNow) {
                ScanSystem.clearTargets(player);
                return;
            }
        }
        if (canScanNow && state.oreGroupIndex != -1 || state.isTargetMode) {
            ScanSystem.updateTargets(player);
        }
    }

    public static boolean canPlayerScan(Player player) {
        boolean hasDragonCapability = player.getCapability(ModCapabilities.DRAGON_CAPABILITY).map(cap -> cap instanceof DragonCapability && cap.isActive()).orElse(false);
        boolean hasDragonsEye = CuriosApi.getCuriosInventory((LivingEntity)player).map(handler -> handler.findFirstCurio(stack -> stack.m_41720_() instanceof DragonsEyeItem).isPresent()).orElse(false);
        return hasDragonCapability || hasDragonsEye;
    }

    public static void handleScanToggleRequest(ServerPlayer player) {
        if (!ScanSystem.canPlayerScan((Player)player)) {
            return;
        }
        PlayerScanState state = ScanSystem.getPlayerState((Player)player);
        ScanSystem.toggleScanMode(player, state);
    }

    public static PlayerScanState getPlayerState(Player player) {
        return PLAYER_SCAN_STATES.computeIfAbsent(player.m_20148_(), k -> new PlayerScanState());
    }

    private static void toggleScanMode(ServerPlayer player, PlayerScanState state) {
        if (state.isTargetMode) {
            state.isTargetMode = false;
            state.oreGroupIndex = -1;
        } else if (state.oreGroupIndex == -1) {
            state.oreGroupIndex = 0;
        } else {
            state.oreGroupIndex = (state.oreGroupIndex + 1) % (ORE_GROUPS.size() + 1);
            if (state.oreGroupIndex == ORE_GROUPS.size()) {
                state.isTargetMode = true;
            } else if (state.oreGroupIndex == 0) {
                state.isTargetMode = false;
                state.oreGroupIndex = -1;
            }
        }
        ScanSystem.sendStatusMessage(player, state);
        ScanSystem.updateTargets(player);
    }

    private static void updateTargets(ServerPlayer player) {
        ListTag targets;
        if (player.m_9236_().f_46443_) {
            return;
        }
        PlayerScanState state = ScanSystem.getPlayerState((Player)player);
        state.lastTargets = targets = ScanSystem.scanForTargets(player, state);
        NetworkHandler.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player), (Object)new UpdateTargetsMessage(targets, state.isTargetMode, state.oreGroupIndex));
    }

    private static ListTag scanForTargets(ServerPlayer player, PlayerScanState state) {
        Set<Block> targetBlocks;
        if (player.m_9236_().f_46443_) {
            return new ListTag();
        }
        ListTag targetsList = new ListTag();
        if (state.oreGroupIndex == -1 && !state.isTargetMode) {
            return targetsList;
        }
        Set<Object> set = state.isTargetMode ? CHEST_BLOCKS : (targetBlocks = state.oreGroupIndex >= 0 && state.oreGroupIndex < ORE_GROUPS.size() ? ORE_GROUPS.get(state.oreGroupIndex) : null);
        if (targetBlocks != null && !targetBlocks.isEmpty()) {
            int scanRange = (Integer)ModConfig.RENDER_RANGE.get();
            BlockPos.m_121990_((BlockPos)player.m_20183_().m_7918_(-scanRange, -scanRange, -scanRange), (BlockPos)player.m_20183_().m_7918_(scanRange, scanRange, scanRange)).filter(pos -> {
                try {
                    return targetBlocks.contains(player.m_9236_().m_8055_(pos).m_60734_());
                }
                catch (Exception e) {
                    return false;
                }
            }).forEach(pos -> {
                CompoundTag posTag = new CompoundTag();
                posTag.m_128405_("X", pos.m_123341_());
                posTag.m_128405_("Y", pos.m_123342_());
                posTag.m_128405_("Z", pos.m_123343_());
                targetsList.add((Object)posTag);
            });
        }
        return targetsList;
    }

    private static void clearTargets(ServerPlayer player) {
        PlayerScanState state = ScanSystem.getPlayerState((Player)player);
        state.lastTargets = new ListTag();
        state.isTargetMode = false;
        state.oreGroupIndex = -1;
        state.nightVisionEnabled = false;
        player.m_21195_(MobEffects.f_19611_);
        ScanSystem.checkAndClearEffects(player);
        NetworkHandler.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player), (Object)new UpdateTargetsMessage(new ListTag(), false, -1));
    }

    private static void checkAndClearEffects(ServerPlayer player) {
        boolean hasDragonCapability = player.getCapability(ModCapabilities.DRAGON_CAPABILITY).map(cap -> cap instanceof DragonCapability && cap.isActive()).orElse(false);
        boolean hasDragonsEye = CuriosApi.getCuriosInventory((LivingEntity)player).map(handler -> handler.findFirstCurio(stack -> stack.m_41720_() instanceof DragonsEyeItem).isPresent()).orElse(false);
        if (!hasDragonCapability && !hasDragonsEye) {
            player.m_21195_(MobEffects.f_19607_);
        }
    }

    private static void sendStatusMessage(ServerPlayer player, PlayerScanState state) {
        Object key = state.oreGroupIndex == -1 && !state.isTargetMode ? "item.dragons_eye.mode.off" : (state.isTargetMode ? "item.dragons_eye.mode.chest" : "item.dragons_eye.mode.ore." + ORE_GROUP_NAMES.get(state.oreGroupIndex));
        player.m_5661_((Component)Component.m_237115_((String)key), true);
    }

    public static int[] getColorForGroup(int groupIndex, boolean isChestMode) {
        if (groupIndex == -1 && !isChestMode) {
            return new int[]{128, 128, 128};
        }
        if (isChestMode) {
            return new int[]{255, 0, 255};
        }
        switch (groupIndex) {
            case 0: {
                return new int[]{255, 255, 0};
            }
            case 1: {
                return new int[]{0, 255, 255};
            }
            case 2: {
                return new int[]{255, 0, 0};
            }
            case 3: {
                return new int[]{0, 255, 0};
            }
        }
        return new int[]{255, 255, 255};
    }

    public static boolean isTargetMode(Player player) {
        return ScanSystem.getPlayerState((Player)player).isTargetMode;
    }

    public static int getOreGroupIndex(Player player) {
        return ScanSystem.getPlayerState((Player)player).oreGroupIndex;
    }

    public static ListTag getCurrentTargets(Player player) {
        return ScanSystem.getPlayerState((Player)player).lastTargets;
    }

    public static class PlayerScanState {
        public boolean isTargetMode = false;
        public int oreGroupIndex = -1;
        public ListTag lastTargets = new ListTag();
        public boolean scanEnabled = false;
        public boolean nightVisionEnabled = false;
    }
}

