/*
 * Decompiled with CFR 0.152.
 */
package com.abdelaziz.canary.common.entity.block_tracking;

import com.abdelaziz.canary.common.block.BlockListeningSection;
import com.abdelaziz.canary.common.block.BlockStateFlags;
import com.abdelaziz.canary.common.block.ListeningBlockStatePredicate;
import com.abdelaziz.canary.common.entity.block_tracking.SectionedBlockChangeTracker;
import java.util.ArrayList;

public final class ChunkSectionChangeCallback {
    private final ArrayList<SectionedBlockChangeTracker>[] trackers = new ArrayList[BlockStateFlags.NUM_LISTENING_FLAGS];
    private short listeningMask = 0;

    public short onBlockChange(int flagIndex, BlockListeningSection section) {
        ArrayList<SectionedBlockChangeTracker> sectionedBlockChangeTrackers = this.trackers[flagIndex];
        this.trackers[flagIndex] = null;
        for (int i = 0; i < sectionedBlockChangeTrackers.size(); ++i) {
            sectionedBlockChangeTrackers.get(i).setChanged(section);
        }
        this.listeningMask = (short)(this.listeningMask & ~(1 << flagIndex));
        return this.listeningMask;
    }

    public short addTracker(SectionedBlockChangeTracker tracker, ListeningBlockStatePredicate blockGroup) {
        int blockGroupIndex = blockGroup.getIndex();
        ArrayList<SectionedBlockChangeTracker> sectionedBlockChangeTrackers = this.trackers[blockGroupIndex];
        if (sectionedBlockChangeTrackers == null) {
            this.trackers[blockGroupIndex] = sectionedBlockChangeTrackers = new ArrayList();
        }
        sectionedBlockChangeTrackers.add(tracker);
        this.listeningMask = (short)(this.listeningMask | 1 << blockGroupIndex);
        return this.listeningMask;
    }

    public short removeTracker(SectionedBlockChangeTracker tracker, ListeningBlockStatePredicate blockGroup) {
        int blockGroupIndex = blockGroup.getIndex();
        ArrayList<SectionedBlockChangeTracker> sectionedBlockChangeTrackers = this.trackers[blockGroupIndex];
        if (sectionedBlockChangeTrackers != null) {
            sectionedBlockChangeTrackers.remove(tracker);
            if (sectionedBlockChangeTrackers.isEmpty()) {
                this.listeningMask = (short)(this.listeningMask & ~(1 << blockGroup.getIndex()));
            }
        }
        return this.listeningMask;
    }
}

