/*
 * Decompiled with CFR 0.152.
 */
package net.werdenrc5.raidcounter;

import com.mojang.logging.LogUtils;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.SpellcasterIllager;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import net.werdenrc5.raidcounter.client.ConfigScreen;
import net.werdenrc5.raidcounter.client.HudOverlay;
import net.werdenrc5.raidcounter.config.ModConfig;
import net.werdenrc5.raidcounter.network.RaiderCountMessage;
import org.slf4j.Logger;

@Mod(value="raidcounter")
public class RaidCounterMod {
    public static final String MOD_ID = "raidcounter";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final SimpleChannel INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("raidcounter", "main"), () -> "1.0", "1.0"::equals, "1.0"::equals);

    public RaidCounterMod() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::setup);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ModConfig.SPEC);
        MinecraftForge.EVENT_BUS.register((Object)this);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            modEventBus.addListener(this::registerOverlays);
            ConfigScreen.register();
        }
    }

    private void setup(FMLCommonSetupEvent event) {
        INSTANCE.registerMessage(0, RaiderCountMessage.class, RaiderCountMessage::encode, RaiderCountMessage::decode, RaiderCountMessage::handle);
        LOGGER.info("RaidCounter network setup complete");
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START || !(event.player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)event.player;
        if (player.f_19797_ % 20 == 0) {
            BlockPos pos;
            ServerLevel level = (ServerLevel)player.m_9236_();
            Raid vanillaRaid = level.m_8832_(pos = player.m_20183_());
            boolean raidActive = vanillaRaid != null && vanillaRaid.m_37782_();
            int waveNumber = 0;
            int totalWaves = 0;
            HashMap<String, Integer> raiderMap = new HashMap<String, Integer>();
            if (raidActive && vanillaRaid != null) {
                this.checkAllRaiders(level, pos, raiderMap);
                waveNumber = vanillaRaid.m_37771_();
                Difficulty difficulty = level.m_46791_();
                int numGroups = vanillaRaid.m_37724_(difficulty);
                if (numGroups <= 0) {
                    int badOmenLevel = vanillaRaid.m_37773_();
                    numGroups = Math.max(1, Math.min(6, badOmenLevel + 1));
                    LOGGER.debug("getNumGroups returned invalid value, using fallback: {}", (Object)numGroups);
                }
                totalWaves = numGroups;
                LOGGER.debug("Current raid wave: {}/{}", (Object)waveNumber, (Object)totalWaves);
            }
            LOGGER.debug("Sending raid data to player: active={}, raiders={}, wave={}/{}", new Object[]{raidActive, raiderMap.size(), waveNumber, totalWaves});
            INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new RaiderCountMessage(raiderMap, raidActive, waveNumber, totalWaves));
        }
    }

    private void checkAllRaiders(ServerLevel level, BlockPos pos, Map<String, Integer> map) {
        Raid vanillaRaid = level.m_8832_(pos);
        if (vanillaRaid != null && vanillaRaid.m_37782_()) {
            vanillaRaid.m_150221_().forEach(raider -> {
                String id = EntityType.m_20613_((EntityType)raider.m_6095_()).toString();
                this.logRaiderInfo((Raider)raider, id);
                map.put(id, map.getOrDefault(id, 0) + 1);
            });
        }
        level.m_6249_((Entity)null, new AABB(pos).m_82400_(96.0), e -> e instanceof Raider && this.isPartOfAnyRaid((Entity)e) && (vanillaRaid == null || !vanillaRaid.m_150221_().contains(e))).forEach(entity -> {
            String id = EntityType.m_20613_((EntityType)entity.m_6095_()).toString();
            if (entity instanceof Raider) {
                this.logRaiderInfo((Raider)entity, id);
            }
            map.put(id, map.getOrDefault(id, 0) + 1);
        });
    }

    private void logRaiderInfo(Raider raider, String id) {
        String raiderType = "Unknown";
        if (raider instanceof SpellcasterIllager) {
            raiderType = "SpellcasterIllager";
        } else if (raider instanceof AbstractIllager) {
            raiderType = "AbstractIllager";
        } else if (raider instanceof Raider) {
            raiderType = "Raider (non-Illager)";
        }
        LOGGER.debug("Found raider: {} ({}), Class type: {}", new Object[]{id, raider.m_7755_().getString(), raiderType});
    }

    private boolean isPartOfAnyRaid(Entity entity) {
        Raider raider;
        return entity instanceof Raider && (raider = (Raider)entity).m_37885_() != null;
    }

    private void registerOverlays(RegisterGuiOverlaysEvent event) {
        LOGGER.info("Registering RaidCounter HUD overlay");
        event.registerAboveAll("raiders", HudOverlay.RAID_COUNTER);
    }

    @SubscribeEvent
    public void onEntityJoin(EntityJoinLevelEvent event) {
        Level level;
        if (!event.getLevel().m_5776_() && (level = event.getLevel()) instanceof ServerLevel) {
            Raider raider;
            Raid raid;
            ServerLevel serverLevel = (ServerLevel)level;
            level = event.getEntity();
            if (level instanceof Raider && (raid = serverLevel.m_8832_((raider = (Raider)level).m_20183_())) != null && raid.m_37782_()) {
                Difficulty difficulty = serverLevel.m_46791_();
                int numGroups = raid.m_37724_(difficulty);
                if (numGroups <= 0) {
                    int badOmenLevel = raid.m_37773_();
                    numGroups = Math.max(1, Math.min(6, badOmenLevel + 1));
                }
                String id = EntityType.m_20613_((EntityType)raider.m_6095_()).toString();
                this.logRaiderInfo(raider, id);
                LOGGER.debug("Detected raider joining an active raid: {}, wave {}/{}", new Object[]{id, raid.m_37771_(), numGroups});
            }
        }
    }
}

