/*
 * Decompiled with CFR 0.152.
 */
package net.werdenrc5.raidcounter.client;

import java.util.function.Consumer;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.OptionsList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.client.gui.widget.ForgeSlider;
import net.minecraftforge.fml.ModLoadingContext;
import net.werdenrc5.raidcounter.config.ModConfig;

public class ConfigScreen
extends Screen {
    private final Screen parentScreen;
    private OptionsList optionsList;
    private ColorWheelScreen currentColorScreen = null;
    private int illagerColorPreview;
    private int raiderColorPreview;
    private int spellcasterColorPreview;

    public ConfigScreen(Screen parentScreen) {
        super((Component)Component.m_237113_((String)"Raid Counter Settings"));
        this.parentScreen = parentScreen;
        this.illagerColorPreview = (Integer)ModConfig.ILLAGER_COLOR.get();
        this.raiderColorPreview = (Integer)ModConfig.RAIDER_COLOR.get();
        this.spellcasterColorPreview = (Integer)ModConfig.SPELLCASTER_COLOR.get();
    }

    protected void m_7856_() {
        this.optionsList = new OptionsList(this.f_96541_, this.f_96543_, this.f_96544_, 32, this.f_96544_ - 32, 25);
        this.optionsList.m_232528_(OptionInstance.m_257874_((String)"Show raider counter", (OptionInstance.TooltipSupplier)OptionInstance.m_231498_(), (boolean)((Boolean)ModConfig.SHOW_RAIDER_COUNTER.get()), value -> ModConfig.SHOW_RAIDER_COUNTER.set(value)));
        this.optionsList.m_232528_(OptionInstance.m_257874_((String)"Show wave counter", (OptionInstance.TooltipSupplier)OptionInstance.m_231498_(), (boolean)((Boolean)ModConfig.SHOW_WAVE_COUNTER.get()), value -> ModConfig.SHOW_WAVE_COUNTER.set(value)));
        this.optionsList.m_232528_(OptionInstance.m_257874_((String)"Show raider types", (OptionInstance.TooltipSupplier)OptionInstance.m_231498_(), (boolean)((Boolean)ModConfig.USE_COLOR_CODING.get()), value -> ModConfig.USE_COLOR_CODING.set(value)));
        this.optionsList.m_232528_(new OptionInstance("Raider Counter X", OptionInstance.m_231498_(), (component, value) -> Component.m_237113_((String)(component.getString() + ": " + value)), (OptionInstance.ValueSet)new OptionInstance.IntRange(0, 4000), (Object)((Integer)ModConfig.RAIDER_COUNTER_X.get()), value -> ModConfig.RAIDER_COUNTER_X.set(value)));
        this.optionsList.m_232528_(new OptionInstance("Raider Counter Y", OptionInstance.m_231498_(), (component, value) -> Component.m_237113_((String)(component.getString() + ": " + value)), (OptionInstance.ValueSet)new OptionInstance.IntRange(0, 4000), (Object)((Integer)ModConfig.RAIDER_COUNTER_Y.get()), value -> ModConfig.RAIDER_COUNTER_Y.set(value)));
        this.optionsList.m_232528_(new OptionInstance("Wave Counter X Offset", OptionInstance.m_231498_(), (component, value) -> Component.m_237113_((String)(component.getString() + ": " + value)), (OptionInstance.ValueSet)new OptionInstance.IntRange(-2000, 2000), (Object)((Integer)ModConfig.WAVE_COUNTER_X_OFFSET.get()), value -> ModConfig.WAVE_COUNTER_X_OFFSET.set(value)));
        this.optionsList.m_232528_(new OptionInstance("Wave Counter Y", OptionInstance.m_231498_(), (component, value) -> Component.m_237113_((String)(component.getString() + ": " + value)), (OptionInstance.ValueSet)new OptionInstance.IntRange(0, 4000), (Object)((Integer)ModConfig.WAVE_COUNTER_Y.get()), value -> ModConfig.WAVE_COUNTER_Y.set(value)));
        this.optionsList.m_232528_(new OptionInstance("HUD Scale", OptionInstance.m_231498_(), (component, value) -> Component.m_237113_((String)(component.getString() + ": " + String.format("%.1f", value))), (OptionInstance.ValueSet)OptionInstance.UnitDouble.INSTANCE.m_231750_(unitValue -> 0.5 + unitValue * 1.5, scaleValue -> (scaleValue - 0.5) / 1.5), (Object)((Double)ModConfig.HUD_SCALE.get()), value -> ModConfig.HUD_SCALE.set(value)));
        this.m_142416_((GuiEventListener)this.optionsList);
        Button colorSettingsButton = Button.m_253074_((Component)Component.m_237113_((String)"Color Settings"), button -> this.openColorSettingsScreen()).m_252987_(this.f_96543_ / 2 - 100, this.f_96544_ - 27, 90, 20).m_253136_();
        this.m_142416_((GuiEventListener)colorSettingsButton);
        Button resetButton = Button.m_253074_((Component)Component.m_237113_((String)"Reset to Defaults"), button -> this.resetToDefaults()).m_252987_(this.f_96543_ - 210, this.f_96544_ - 27, 90, 20).m_253136_();
        this.m_142416_((GuiEventListener)resetButton);
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Done"), button -> {
            ModConfig.SPEC.save();
            this.f_96541_.m_91152_(this.parentScreen);
        }).m_252987_(10, this.f_96544_ - 27, 90, 20).m_253136_());
    }

    private void optionsList(int i) {
    }

    private Component getColorText(String title, int color) {
        String hex = String.format("#%08X", color);
        return Component.m_237113_((String)(title + ": " + hex));
    }

    private void resetToDefaults() {
        ModConfig.SHOW_RAIDER_COUNTER.set((Object)true);
        ModConfig.SHOW_WAVE_COUNTER.set((Object)true);
        ModConfig.USE_COLOR_CODING.set((Object)true);
        ModConfig.RAIDER_COUNTER_X.set((Object)5);
        ModConfig.RAIDER_COUNTER_Y.set((Object)5);
        ModConfig.WAVE_COUNTER_X_OFFSET.set((Object)0);
        ModConfig.WAVE_COUNTER_Y.set((Object)30);
        ModConfig.HUD_SCALE.set((Object)1.0);
        ModConfig.ILLAGER_COLOR.set((Object)-1);
        ModConfig.RAIDER_COLOR.set((Object)-256);
        ModConfig.SPELLCASTER_COLOR.set((Object)-23296);
        this.illagerColorPreview = (Integer)ModConfig.ILLAGER_COLOR.get();
        this.raiderColorPreview = (Integer)ModConfig.RAIDER_COLOR.get();
        this.spellcasterColorPreview = (Integer)ModConfig.SPELLCASTER_COLOR.get();
        ModConfig.SPEC.save();
        this.f_96541_.m_91152_(null);
        this.f_96541_.m_91152_((Screen)new ConfigScreen(this.parentScreen));
    }

    private void updateIllagerColor(int color) {
        this.illagerColorPreview = color;
    }

    private void updateRaiderColor(int color) {
        this.raiderColorPreview = color;
    }

    private void updateSpellcasterColor(int color) {
        this.spellcasterColorPreview = color;
    }

    private void openColorWheel(String title, int initialColor, Consumer<Integer> previewHandler, Consumer<Integer> saveHandler) {
        this.f_96541_.m_91152_((Screen)new ColorWheelScreen(this, (Component)Component.m_237113_((String)title), initialColor, previewHandler, saveHandler));
    }

    private void openColorSettingsScreen() {
        this.f_96541_.m_91152_((Screen)new ColorSettingsScreen(this));
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        this.optionsList.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 20, 0xFFFFFF);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
    }

    public void m_7379_() {
        ModConfig.SPEC.save();
        this.f_96541_.m_91152_(this.parentScreen);
    }

    public static void register() {
        ModLoadingContext.get().registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory((minecraft, screen) -> new ConfigScreen((Screen)screen)));
    }

    public static class ColorWheelScreen
    extends Screen {
        private final Screen parentScreen;
        private int currentColor;
        private int hue = 0;
        private int saturation = 0;
        private int value = 100;
        private int alpha = 255;
        private ForgeSlider hueSlider;
        private ForgeSlider saturationSlider;
        private ForgeSlider valueSlider;
        private ForgeSlider alphaSlider;
        private final Consumer<Integer> previewHandler;
        private final Consumer<Integer> saveHandler;
        private final int initialColorValue;
        private static final int WHEEL_SIZE = 150;
        private static final int WHEEL_X_CENTER = 100;
        private static final int WHEEL_Y_CENTER = 100;

        public ColorWheelScreen(Screen parentScreen, Component title, int initialColor, Consumer<Integer> previewHandler, Consumer<Integer> saveHandler) {
            super(title);
            this.parentScreen = parentScreen;
            this.currentColor = initialColor;
            this.previewHandler = previewHandler;
            this.saveHandler = saveHandler;
            this.initialColorValue = initialColor;
            int r = initialColor >> 16 & 0xFF;
            int g = initialColor >> 8 & 0xFF;
            int b = initialColor & 0xFF;
            this.alpha = initialColor >> 24 & 0xFF;
            float[] hsv = this.rgbToHsv(r, g, b);
            this.hue = (int)(hsv[0] * 360.0f);
            this.saturation = (int)(hsv[1] * 100.0f);
            this.value = (int)(hsv[2] * 100.0f);
        }

        protected void m_7856_() {
            int sliderWidth = 180;
            int sliderX = this.f_96543_ / 2 - sliderWidth / 2;
            int startY = this.f_96544_ / 2 - 50;
            this.hueSlider = new ForgeSlider(sliderX, startY, sliderWidth, 20, (Component)Component.m_237113_((String)"Hue: "), (Component)Component.m_237113_((String)""), 0.0, 360.0, (double)this.hue, 1.0, 1, true);
            this.m_142416_((GuiEventListener)this.hueSlider);
            this.saturationSlider = new ForgeSlider(sliderX, startY + 25, sliderWidth, 20, (Component)Component.m_237113_((String)"Saturation: "), (Component)Component.m_237113_((String)"%"), 0.0, 100.0, (double)this.saturation, 1.0, 1, true);
            this.m_142416_((GuiEventListener)this.saturationSlider);
            this.valueSlider = new ForgeSlider(sliderX, startY + 50, sliderWidth, 20, (Component)Component.m_237113_((String)"Value: "), (Component)Component.m_237113_((String)"%"), 0.0, 100.0, (double)this.value, 1.0, 1, true);
            this.m_142416_((GuiEventListener)this.valueSlider);
            this.alphaSlider = new ForgeSlider(sliderX, startY + 75, sliderWidth, 20, (Component)Component.m_237113_((String)"Alpha: "), (Component)Component.m_237113_((String)""), 0.0, 255.0, (double)this.alpha, 1.0, 1, true);
            this.m_142416_((GuiEventListener)this.alphaSlider);
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Apply"), button -> {
                this.saveHandler.accept(this.currentColor);
                this.m_7379_();
            }).m_252987_(this.f_96543_ / 2 - 100, this.f_96544_ - 50, 90, 20).m_253136_());
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Cancel"), button -> {
                this.previewHandler.accept(this.initialColorValue);
                this.m_7379_();
            }).m_252987_(this.f_96543_ / 2 + 10, this.f_96544_ - 50, 90, 20).m_253136_());
        }

        public void m_86600_() {
            super.m_86600_();
            int newHue = (int)this.hueSlider.getValue();
            int newSaturation = (int)this.saturationSlider.getValue();
            int newValue = (int)this.valueSlider.getValue();
            int newAlpha = (int)this.alphaSlider.getValue();
            if (newHue != this.hue || newSaturation != this.saturation || newValue != this.value || newAlpha != this.alpha) {
                this.hue = newHue;
                this.saturation = newSaturation;
                this.value = newValue;
                this.alpha = newAlpha;
                float h = (float)this.hue / 360.0f;
                float s = (float)this.saturation / 100.0f;
                float v = (float)this.value / 100.0f;
                int rgb = this.hsvToRgb(h, s, v);
                this.currentColor = this.alpha << 24 | rgb & 0xFFFFFF;
                this.previewHandler.accept(this.currentColor);
            }
        }

        public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            this.m_280273_(guiGraphics);
            guiGraphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 20, 0xFFFFFF);
            int previewX = 10;
            int previewY = 40;
            int previewSize = 60;
            guiGraphics.m_280509_(previewX - 2, previewY - 2, previewX + previewSize + 2, previewY + previewSize + 2, -1);
            guiGraphics.m_280509_(previewX, previewY, previewX + previewSize, previewY + previewSize, this.currentColor);
            String hexString = String.format("#%08X", this.currentColor);
            guiGraphics.m_280488_(this.f_96547_, "Current Color:", previewX, previewY + previewSize + 10, 0xFFFFFF);
            guiGraphics.m_280488_(this.f_96547_, hexString, previewX, previewY + previewSize + 22, 0xFFFFFF);
            int wheelX = this.f_96543_ / 2 + 90;
            int wheelY = this.f_96544_ / 2 - 90;
            int wheelRadius = 30;
            for (int x = -wheelRadius; x <= wheelRadius; ++x) {
                for (int y = -wheelRadius; y <= wheelRadius; ++y) {
                    int distSquared = x * x + y * y;
                    if (distSquared > wheelRadius * wheelRadius) continue;
                    double angle = Math.atan2(y, x);
                    double distance = Math.sqrt(distSquared);
                    float h = (float)((angle / (Math.PI * 2) + 0.5) % 1.0);
                    float s = (float)(distance / (double)wheelRadius);
                    int color = this.hsvToRgb(h, s, 1.0f);
                    guiGraphics.m_280509_(wheelX + x, wheelY + y, wheelX + x + 1, wheelY + y + 1, 0xFF000000 | color);
                }
            }
            super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        }

        public void m_7379_() {
            this.f_96541_.m_91152_(this.parentScreen);
        }

        private float[] rgbToHsv(int r, int g, int b) {
            float rf = (float)r / 255.0f;
            float gf = (float)g / 255.0f;
            float bf = (float)b / 255.0f;
            float max = Math.max(rf, Math.max(gf, bf));
            float min = Math.min(rf, Math.min(gf, bf));
            float delta = max - min;
            float h = 0.0f;
            float s = 0.0f;
            float v = max;
            if (max != 0.0f) {
                s = delta / max;
                h = rf == max ? (gf - bf) / delta : (gf == max ? 2.0f + (bf - rf) / delta : 4.0f + (rf - gf) / delta);
                if ((h *= 60.0f) < 0.0f) {
                    h += 360.0f;
                }
            }
            return new float[]{h / 360.0f, s, v};
        }

        private int hsvToRgb(float h, float s, float v) {
            float g;
            float r;
            if (s == 0.0f) {
                int grey = Math.round(v * 255.0f);
                return grey << 16 | grey << 8 | grey;
            }
            int i = (int)Math.floor(h *= 6.0f);
            float f = h - (float)i;
            float p = v * (1.0f - s);
            float q = v * (1.0f - s * f);
            float t = v * (1.0f - s * (1.0f - f));
            float b = switch (i % 6) {
                case 0 -> {
                    r = v;
                    g = t;
                    yield p;
                }
                case 1 -> {
                    r = q;
                    g = v;
                    yield p;
                }
                case 2 -> {
                    r = p;
                    g = v;
                    yield t;
                }
                case 3 -> {
                    r = p;
                    g = q;
                    yield v;
                }
                case 4 -> {
                    r = t;
                    g = p;
                    yield v;
                }
                default -> {
                    r = v;
                    g = p;
                    yield q;
                }
            };
            int red = Math.round(r * 255.0f);
            int green = Math.round(g * 255.0f);
            int blue = Math.round(b * 255.0f);
            return red << 16 | green << 8 | blue;
        }
    }

    public static class ColorSettingsScreen
    extends Screen {
        private final Screen parentScreen;
        private int illagerColorPreview;
        private int raiderColorPreview;
        private int spellcasterColorPreview;

        public ColorSettingsScreen(Screen parentScreen) {
            super((Component)Component.m_237113_((String)"Color Settings"));
            this.parentScreen = parentScreen;
            this.illagerColorPreview = (Integer)ModConfig.ILLAGER_COLOR.get();
            this.raiderColorPreview = (Integer)ModConfig.RAIDER_COLOR.get();
            this.spellcasterColorPreview = (Integer)ModConfig.SPELLCASTER_COLOR.get();
        }

        protected void m_7856_() {
            int centerX = this.f_96543_ / 2;
            int buttonWidth = 200;
            int buttonHeight = 20;
            int startY = 50;
            int spacing = 30;
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)this.getColorText("Illager Color", this.illagerColorPreview), button -> this.openColorWheel("Illager Color", this.illagerColorPreview, this::updateIllagerColor, color -> {
                this.illagerColorPreview = color;
                button.m_93666_(this.getColorText("Illager Color", (int)color));
                ModConfig.ILLAGER_COLOR.set(color);
            })).m_252987_(centerX - buttonWidth / 2, startY, buttonWidth, buttonHeight).m_253136_());
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)this.getColorText("Raider Color", this.raiderColorPreview), button -> this.openColorWheel("Raider Color", this.raiderColorPreview, this::updateRaiderColor, color -> {
                this.raiderColorPreview = color;
                button.m_93666_(this.getColorText("Raider Color", (int)color));
                ModConfig.RAIDER_COLOR.set(color);
            })).m_252987_(centerX - buttonWidth / 2, startY + spacing, buttonWidth, buttonHeight).m_253136_());
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)this.getColorText("Spellcaster Color", this.spellcasterColorPreview), button -> this.openColorWheel("Spellcaster Color", this.spellcasterColorPreview, this::updateSpellcasterColor, color -> {
                this.spellcasterColorPreview = color;
                button.m_93666_(this.getColorText("Spellcaster Color", (int)color));
                ModConfig.SPELLCASTER_COLOR.set(color);
            })).m_252987_(centerX - buttonWidth / 2, startY + spacing * 2, buttonWidth, buttonHeight).m_253136_());
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Back"), button -> {
                ModConfig.SPEC.save();
                this.f_96541_.m_91152_(this.parentScreen);
            }).m_252987_(centerX - buttonWidth / 2, this.f_96544_ - 40, buttonWidth, buttonHeight).m_253136_());
        }

        private Component getColorText(String title, int color) {
            String hex = String.format("#%08X", color);
            return Component.m_237113_((String)(title + ": " + hex));
        }

        private void updateIllagerColor(int color) {
            this.illagerColorPreview = color;
        }

        private void updateRaiderColor(int color) {
            this.raiderColorPreview = color;
        }

        private void updateSpellcasterColor(int color) {
            this.spellcasterColorPreview = color;
        }

        private void openColorWheel(String title, int initialColor, Consumer<Integer> previewHandler, Consumer<Integer> saveHandler) {
            this.f_96541_.m_91152_((Screen)new ColorWheelScreen(this, (Component)Component.m_237113_((String)title), initialColor, previewHandler, saveHandler));
        }

        public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            this.m_280273_(guiGraphics);
            guiGraphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 20, 0xFFFFFF);
            int previewSize = 20;
            int previewY = 160;
            int spacing = 30;
            int labelOffset = 5;
            int illagerX = this.f_96543_ / 4;
            guiGraphics.m_280509_(illagerX - previewSize / 2, previewY - previewSize / 2, illagerX + previewSize / 2, previewY + previewSize / 2, this.illagerColorPreview);
            guiGraphics.m_280488_(this.f_96547_, "Illager", illagerX - 20, previewY + previewSize / 2 + labelOffset, 0xFFFFFF);
            int raiderX = this.f_96543_ / 2;
            guiGraphics.m_280509_(raiderX - previewSize / 2, previewY - previewSize / 2, raiderX + previewSize / 2, previewY + previewSize / 2, this.raiderColorPreview);
            guiGraphics.m_280488_(this.f_96547_, "Raider", raiderX - 20, previewY + previewSize / 2 + labelOffset, 0xFFFFFF);
            int spellcasterX = 3 * this.f_96543_ / 4;
            guiGraphics.m_280509_(spellcasterX - previewSize / 2, previewY - previewSize / 2, spellcasterX + previewSize / 2, previewY + previewSize / 2, this.spellcasterColorPreview);
            guiGraphics.m_280488_(this.f_96547_, "Spellcaster", spellcasterX - 30, previewY + previewSize / 2 + labelOffset, 0xFFFFFF);
            super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        }

        public void m_7379_() {
            ModConfig.SPEC.save();
            this.f_96541_.m_91152_(this.parentScreen);
        }
    }
}

