/*
 * Decompiled with CFR 0.152.
 */
package net.werdenrc5.raidcounter.client;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.registries.ForgeRegistries;
import net.werdenrc5.raidcounter.client.ClientRaiderCountData;
import net.werdenrc5.raidcounter.config.ModConfig;
import net.werdenrc5.raidcounter.util.RaiderTypeUtil;

public class HudOverlay {
    private static final Minecraft mc = Minecraft.m_91087_();
    private static final int PADDING = 2;
    private static final int BG_COLOR = Integer.MIN_VALUE;
    public static final IGuiOverlay RAID_COUNTER = (gui, guiGraphics, partialTick, width, height) -> {
        if (HudOverlay.mc.f_91066_.f_92062_ || HudOverlay.mc.f_91080_ != null) {
            return;
        }
        if (!ClientRaiderCountData.isRaidActive()) {
            return;
        }
        boolean showWaveCounter = (Boolean)ModConfig.SHOW_WAVE_COUNTER.get();
        boolean showRaiderCounter = (Boolean)ModConfig.SHOW_RAIDER_COUNTER.get();
        boolean useColorCoding = (Boolean)ModConfig.USE_COLOR_CODING.get();
        float scale = (float)((Double)ModConfig.HUD_SCALE.get()).doubleValue();
        if (!showWaveCounter && !showRaiderCounter) {
            return;
        }
        Font font = HudOverlay.mc.f_91062_;
        int lineHeight = (int)(12.0f * scale);
        if (showWaveCounter) {
            int waveNumber = ClientRaiderCountData.getWaveNumber();
            int totalWaves = ClientRaiderCountData.getTotalWaves();
            String waveText = "Wave: " + waveNumber + "/" + totalWaves;
            int centerX = width / 2;
            int waveWidth = (int)((float)font.m_92895_(waveText) * scale);
            int xOffset = (Integer)ModConfig.WAVE_COUNTER_X_OFFSET.get();
            int waveX = centerX - waveWidth / 2 + xOffset;
            int waveY = (Integer)ModConfig.WAVE_COUNTER_Y.get();
            GuiGraphics scaled = HudOverlay.applyScaling(guiGraphics, scale, waveX, waveY);
            int scaledWidth = font.m_92895_(waveText);
            Objects.requireNonNull(font);
            int scaledLineHeight = 9;
            scaled.m_280509_(-2, -2, scaledWidth + 2, scaledLineHeight + 2, Integer.MIN_VALUE);
            scaled.m_280614_(font, (Component)Component.m_237113_((String)waveText), 0, 0, 0xFFFFFF, true);
            HudOverlay.restoreScaling(guiGraphics);
        }
        if (showRaiderCounter) {
            int n;
            Map.Entry[] sortedEntries;
            int headerWidth;
            Map<String, Integer> raiders = ClientRaiderCountData.getRaiderMap();
            int x = (Integer)ModConfig.RAIDER_COUNTER_X.get();
            int y = (Integer)ModConfig.RAIDER_COUNTER_Y.get();
            int maxLineWidth = headerWidth = font.m_92895_("Active Raiders:");
            for (Map.Entry entry : sortedEntries = (Map.Entry[])raiders.entrySet().stream().sorted(Map.Entry.comparingByValue().reversed().thenComparing(Map.Entry.comparingByKey())).toArray(Map.Entry[]::new)) {
                String name = HudOverlay.getEntityName((String)entry.getKey());
                String count = ((Integer)entry.getValue()).toString();
                String prefix = HudOverlay.getRaiderTypePrefix((String)entry.getKey());
                String text = "\u2022 " + prefix + name + ": " + count;
                int lineWidth = font.m_92895_(text);
                maxLineWidth = Math.max(maxLineWidth, lineWidth);
            }
            if (raiders.isEmpty()) {
                int noRaidersWidth = font.m_92895_("There are no raiders");
                maxLineWidth = Math.max(maxLineWidth, noRaidersWidth);
            }
            int bgHeight = lineHeight;
            bgHeight += raiders.isEmpty() ? lineHeight : sortedEntries.length * lineHeight;
            GuiGraphics scaled = HudOverlay.applyScaling(guiGraphics, scale, x, y);
            int scaledMaxLineWidth = maxLineWidth;
            if (raiders.isEmpty()) {
                Objects.requireNonNull(font);
                Objects.requireNonNull(font);
                n = 9 + 9;
            } else {
                Objects.requireNonNull(font);
                int n2 = sortedEntries.length;
                Objects.requireNonNull(font);
                n = 9 + n2 * 9;
            }
            int scaledBgHeight = n;
            scaled.m_280509_(-2, -2, scaledMaxLineWidth + 2, scaledBgHeight + 2, Integer.MIN_VALUE);
            scaled.m_280614_(font, (Component)Component.m_237113_((String)"Active Raiders:"), 0, 0, 0xFFFFFF, true);
            Objects.requireNonNull(font);
            int currentY = 9;
            if (!raiders.isEmpty()) {
                for (Map.Entry entry : sortedEntries) {
                    String entityId = (String)entry.getKey();
                    String name = HudOverlay.getEntityName(entityId);
                    String count = ((Integer)entry.getValue()).toString();
                    String prefix = HudOverlay.getRaiderTypePrefix(entityId);
                    String text = "\u2022 " + prefix + name + ": " + count;
                    int color = RaiderTypeUtil.getRaiderColor(entityId, useColorCoding);
                    scaled.m_280614_(font, (Component)Component.m_237113_((String)text), 0, currentY, color, true);
                    Objects.requireNonNull(font);
                    currentY += 9;
                }
            } else {
                scaled.m_280614_(font, (Component)Component.m_237113_((String)"There are no raiders"), 0, currentY, 0xAAAAAA, true);
            }
            HudOverlay.restoreScaling(guiGraphics);
        }
    };

    private static GuiGraphics applyScaling(GuiGraphics graphics, float scale, int x, int y) {
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_((float)x, (float)y, 0.0f);
        graphics.m_280168_().m_85841_(scale, scale, 1.0f);
        return graphics;
    }

    private static void restoreScaling(GuiGraphics graphics) {
        graphics.m_280168_().m_85849_();
    }

    private static String getRaiderTypePrefix(String entityId) {
        if (!((Boolean)ModConfig.USE_COLOR_CODING.get()).booleanValue()) {
            return "";
        }
        int raiderType = RaiderTypeUtil.getRaiderType(entityId);
        return switch (raiderType) {
            case 0 -> "[I] ";
            case 1 -> "[R] ";
            case 2 -> "[S] ";
            default -> "";
        };
    }

    private static String getEntityName(String entityId) {
        ResourceLocation res = ResourceLocation.m_135820_((String)entityId);
        if (res != null) {
            EntityType type = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(res);
            if (type != null) {
                return type.m_20676_().getString();
            }
            return HudOverlay.formatEntityId(res.m_135815_());
        }
        return HudOverlay.formatEntityId(entityId);
    }

    private static String formatEntityId(String path) {
        return Arrays.stream(path.split("_")).map(word -> word.substring(0, 1).toUpperCase() + word.substring(1).toLowerCase()).collect(Collectors.joining(" "));
    }
}

