/*
 * Decompiled with CFR 0.152.
 */
package net.werdenrc5.raidcounter.network;

import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import net.werdenrc5.raidcounter.client.ClientRaiderCountData;

public class RaiderCountMessage {
    private final Map<String, Integer> raiderMap;
    private final boolean raidActive;
    private final int waveNumber;
    private final int totalWaves;

    public RaiderCountMessage(Map<String, Integer> raiderMap, boolean raidActive, int waveNumber, int totalWaves) {
        this.raiderMap = raiderMap;
        this.raidActive = raidActive;
        this.waveNumber = waveNumber;
        this.totalWaves = totalWaves;
    }

    public RaiderCountMessage(FriendlyByteBuf buf) {
        this.raiderMap = buf.m_236847_(FriendlyByteBuf::m_130277_, FriendlyByteBuf::readInt);
        this.raidActive = buf.readBoolean();
        this.waveNumber = buf.readInt();
        this.totalWaves = buf.readInt();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_236831_(this.raiderMap, FriendlyByteBuf::m_130070_, FriendlyByteBuf::writeInt);
        buf.writeBoolean(this.raidActive);
        buf.writeInt(this.waveNumber);
        buf.writeInt(this.totalWaves);
    }

    public static RaiderCountMessage decode(FriendlyByteBuf buf) {
        return new RaiderCountMessage(buf);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ClientRaiderCountData.setRaiderMap(this.raiderMap);
            ClientRaiderCountData.setRaidActive(this.raidActive);
            ClientRaiderCountData.setWaveNumber(this.waveNumber);
            ClientRaiderCountData.setTotalWaves(this.totalWaves);
        });
        ctx.get().setPacketHandled(true);
    }
}

