/*
 * Decompiled with CFR 0.152.
 */
package net.werdenrc5.raidcounter.util;

import com.mojang.text2speech.Narrator;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.SpellcasterIllager;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import net.werdenrc5.raidcounter.config.ModConfig;

public class RaiderTypeUtil {
    public static final int TYPE_ILLAGER = 0;
    public static final int TYPE_RAIDER = 1;
    public static final int TYPE_SPELLCASTER = 2;

    public static int getRaiderType(String entityId) {
        ResourceLocation res = ResourceLocation.m_135820_((String)entityId);
        if (res == null) {
            return 0;
        }
        EntityType entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(res);
        if (entityType == null) {
            return 0;
        }
        try {
            Entity entity = entityType.m_20615_((Level)Minecraft.m_91087_().f_91073_);
            if (entity != null) {
                if (entity instanceof SpellcasterIllager) {
                    return 2;
                }
                if (entity instanceof Raider && !(entity instanceof AbstractIllager)) {
                    return 1;
                }
                if (entity instanceof AbstractIllager) {
                    return 0;
                }
            }
        }
        catch (Exception e) {
            Narrator.LOGGER.debug("Error during class-based raider detection, falling back to string-based detection: {}", (Object)e.getMessage());
        }
        String path = res.m_135815_().toLowerCase();
        if (path.contains("evoker") || path.contains("illusioner")) {
            return 2;
        }
        if (path.contains("ravager") || path.contains("witch")) {
            return 1;
        }
        return 0;
    }

    public static int getRaiderColor(String entityId, boolean useColorCoding) {
        if (!useColorCoding) {
            return (Integer)ModConfig.ILLAGER_COLOR.get();
        }
        int type = RaiderTypeUtil.getRaiderType(entityId);
        Narrator.LOGGER.debug("Entity {} has type {} which maps to color {}", new Object[]{entityId, type, RaiderTypeUtil.getColorForType(type)});
        return RaiderTypeUtil.getColorForType(type);
    }

    private static int getColorForType(int type) {
        return switch (type) {
            case 1 -> (Integer)ModConfig.RAIDER_COLOR.get();
            case 2 -> (Integer)ModConfig.SPELLCASTER_COLOR.get();
            default -> (Integer)ModConfig.ILLAGER_COLOR.get();
        };
    }

    public static boolean isSpellcasterIllager(Class<?> entityClass) {
        return SpellcasterIllager.class.isAssignableFrom(entityClass);
    }

    public static boolean isRegularIllager(Class<?> entityClass) {
        return AbstractIllager.class.isAssignableFrom(entityClass) && !SpellcasterIllager.class.isAssignableFrom(entityClass);
    }

    public static boolean isNonIllagerRaider(Class<?> entityClass) {
        return Raider.class.isAssignableFrom(entityClass) && !AbstractIllager.class.isAssignableFrom(entityClass);
    }
}

