/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.gui;

import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.gui.IEContainerScreen;
import blusunrize.immersiveengineering.client.gui.SorterScreen;
import blusunrize.immersiveengineering.client.gui.info.FluidInfoArea;
import blusunrize.immersiveengineering.client.utils.GuiHelper;
import blusunrize.immersiveengineering.client.utils.IERenderTypes;
import blusunrize.immersiveengineering.common.gui.FluidSorterMenu;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;

public class FluidSorterScreen
extends IEContainerScreen<FluidSorterMenu> {
    private final List<SorterScreen.ButtonSorter> sorterButtons = new ArrayList<SorterScreen.ButtonSorter>(6);

    public FluidSorterScreen(FluidSorterMenu container, Inventory inventoryPlayer, Component title) {
        super(container, inventoryPlayer, title, FluidSorterScreen.makeTextureLocation("sorter"));
        this.f_97727_ = 244;
        this.f_97731_ = this.f_97727_ - 91;
    }

    @Override
    protected void gatherAdditionalTooltips(int mouseX, int mouseY, Consumer<Component> addLine, Consumer<Component> addGray) {
        super.gatherAdditionalTooltips(mouseX, mouseY, addLine, addGray);
        for (int side = 0; side < 6; ++side) {
            for (int i = 0; i < 8; ++i) {
                if (((FluidSorterMenu)this.f_97732_).getFilter(side, i).isEmpty() || !this.getSlotArea(side, i).m_110087_(mouseX, mouseY)) continue;
                FluidInfoArea.fillTooltip(((FluidSorterMenu)this.f_97732_).getFilter(side, i), -1, addLine);
            }
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        super.m_6375_(mouseX, mouseY, mouseButton);
        for (int side = 0; side < 6; ++side) {
            for (int i = 0; i < 8; ++i) {
                if (!this.getSlotArea(side, i).m_110087_((int)mouseX, (int)mouseY)) continue;
                ItemStack stack = ((FluidSorterMenu)this.f_97732_).m_142621_();
                if (stack.m_41619_()) {
                    this.setFluidInSlot(side, i, FluidStack.EMPTY);
                } else {
                    int finalSide = side;
                    int finalI = i;
                    FluidUtil.getFluidContained((ItemStack)stack).ifPresent(fs -> this.setFluidInSlot(finalSide, finalI, (FluidStack)fs));
                }
                return true;
            }
        }
        return false;
    }

    @Override
    protected void drawContainerBackgroundPre(@Nonnull GuiGraphics graphics, float f, int mx, int my) {
        int side;
        MultiBufferSource.BufferSource buffers = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        VertexConsumer builder = buffers.m_6299_(IERenderTypes.getGui(InventoryMenu.f_39692_));
        for (side = 0; side < 6; ++side) {
            for (int i = 0; i < 8; ++i) {
                FluidStack filter = ((FluidSorterMenu)this.f_97732_).getFilter(side, i);
                if (filter.isEmpty()) continue;
                IClientFluidTypeExtensions props = IClientFluidTypeExtensions.of((Fluid)filter.getFluid());
                TextureAtlasSprite sprite = ClientUtils.getSprite(props.getStillTexture(filter));
                Rect2i slotArea = this.getSlotArea(side, i);
                int col = props.getTintColor(filter);
                GuiHelper.drawTexturedColoredRect(builder, graphics.m_280168_(), slotArea.m_110085_(), slotArea.m_110086_(), slotArea.m_110090_(), slotArea.m_110091_(), (float)(col >> 16 & 0xFF) / 255.0f, (float)(col >> 8 & 0xFF) / 255.0f, (float)(col & 0xFF) / 255.0f, 1.0f, sprite.m_118409_(), sprite.m_118410_(), sprite.m_118411_(), sprite.m_118412_());
            }
        }
        buffers.m_109911_();
        for (side = 0; side < 6; ++side) {
            int x = this.f_97735_ + 30 + side / 2 * 58;
            int y = this.f_97736_ + 44 + side % 2 * 76;
            String s = I18n.m_118938_((String)("desc.immersiveengineering.info.blockSide." + Direction.m_122376_((int)side)), (Object[])new Object[0]).substring(0, 1);
            graphics.m_280056_(ClientUtils.font(), s, x - ClientUtils.font().m_92895_(s) / 2, y, -1429418804, true);
        }
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.m_169413_();
        this.sorterButtons.clear();
        int side = 0;
        while (side < 6) {
            int x = this.f_97735_ + 21 + side / 2 * 58;
            int y = this.f_97736_ + 3 + side % 2 * 76;
            int sideFinal = side++;
            BooleanSupplier value = () -> ((FluidSorterMenu)this.f_97732_).sortWithNBT.get()[sideFinal] != 0;
            SorterScreen.ButtonSorter b = new SorterScreen.ButtonSorter(x, y, SorterScreen.FilterBit.NBT, () -> value.getAsBoolean() ? SorterScreen.FilterBit.NBT.mask() : 0, btn -> {
                CompoundTag tag = new CompoundTag();
                tag.m_128405_("useNBT", value.getAsBoolean() ? 0 : 1);
                tag.m_128405_("side", sideFinal);
                this.sendUpdateToServer(tag);
                this.fullInit();
            });
            this.sorterButtons.add(b);
            this.m_142416_((GuiEventListener)b);
        }
    }

    public void setFluidInSlot(int side, int slot, FluidStack fluid) {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("filter_side", side);
        tag.m_128405_("filter_slot", slot);
        if (fluid != null) {
            tag.m_128365_("filter", (Tag)fluid.writeToNBT(new CompoundTag()));
        }
        this.sendUpdateToServer(tag);
    }

    protected Rect2i getSlotArea(int side, int i) {
        int x = this.f_97735_ + 4 + side / 2 * 58 + (i < 3 ? i * 18 : (i > 4 ? (i - 5) * 18 : (i == 3 ? 0 : 36)));
        int y = this.f_97736_ + 22 + side % 2 * 76 + (i < 3 ? 0 : (i > 4 ? 36 : 18));
        return new Rect2i(x, y, 16, 16);
    }
}

