/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.entities;

import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.entities.IEProjectileEntity;
import blusunrize.immersiveengineering.common.register.IEEntityTypes;
import blusunrize.immersiveengineering.common.util.IEDamageSources;
import blusunrize.immersiveengineering.common.util.Utils;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;

public class SawbladeEntity
extends IEProjectileEntity {
    private ItemStack ammo = ItemStack.f_41583_;
    private static final EntityDataAccessor<ItemStack> dataMarker_ammo = SynchedEntityData.m_135353_(SawbladeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);

    public SawbladeEntity(EntityType<SawbladeEntity> type, Level world) {
        super(type, world);
        this.f_36705_ = AbstractArrow.Pickup.ALLOWED;
    }

    public SawbladeEntity(Level world, @Nonnull LivingEntity living, float velocity, float accuracy, ItemStack ammo) {
        super((EntityType<? extends IEProjectileEntity>)((EntityType)IEEntityTypes.SAWBLADE.get()), world, living, velocity, accuracy);
        this.ammo = ammo;
        this.setAmmoSynced();
        this.f_36705_ = AbstractArrow.Pickup.ALLOWED;
        this.m_36767_((byte)3);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(dataMarker_ammo, (Object)ItemStack.f_41583_);
    }

    @Override
    @Nonnull
    protected ItemStack m_7941_() {
        return this.ammo;
    }

    public void setAmmoSynced() {
        if (!this.getAmmo().m_41619_()) {
            this.f_19804_.m_135381_(dataMarker_ammo, (Object)this.getAmmo());
        }
    }

    public ItemStack getAmmoSynced() {
        return (ItemStack)this.f_19804_.m_135370_(dataMarker_ammo);
    }

    public ItemStack getAmmo() {
        return this.ammo;
    }

    @Override
    public double getGravity() {
        return 0.005;
    }

    @Override
    public int getMaxTicksInGround() {
        return 1200;
    }

    public void m_6075_() {
        if (this.getAmmo().m_41619_() && this.m_9236_().f_46443_) {
            this.ammo = this.getAmmoSynced();
        }
        super.m_6075_();
    }

    private void damageSawblade() {
        int dmg = Math.round((float)this.getAmmo().m_41776_() * 0.05f);
        Entity shooter = this.m_19749_();
        if (this.getAmmo().m_220157_(dmg, this.m_9236_().f_46441_, shooter instanceof ServerPlayer ? (ServerPlayer)shooter : null)) {
            this.m_146870_();
        }
    }

    protected void m_8060_(BlockHitResult result) {
        super.m_8060_(result);
        this.damageSawblade();
    }

    protected void m_5790_(EntityHitResult result) {
        Entity shooter = this.m_19749_();
        Entity target = result.m_82443_();
        float damage = (float)(12.0 * (Double)IEServerConfig.TOOLS.railgun_damage.get());
        target.m_6469_(IEDamageSources.causeSawbladeDamage(this, shooter), damage);
        this.handlePiecing(target);
        this.damageSawblade();
    }

    @Override
    protected void handlePiecing(Entity target) {
        Player shooter;
        super.handlePiecing(target);
        if (this.piercedEntities.size() >= 3 && this.getShooterUUID() != null && (shooter = this.m_9236_().m_46003_(this.getShooterUUID())) != null) {
            Utils.unlockIEAdvancement(shooter, "tools/secret_ravenholm");
        }
    }

    protected boolean m_5603_(Entity target) {
        if (this.piercedEntities != null && this.piercedEntities.contains(target.m_19879_())) {
            return false;
        }
        return !target.m_5833_() && target.m_6084_() && target.m_6087_();
    }

    @Override
    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        if (!this.ammo.m_41619_()) {
            nbt.m_128365_("ammo", (Tag)this.ammo.m_41739_(new CompoundTag()));
        }
    }

    @Override
    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.ammo = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("ammo"));
    }
}

