/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.EnumMetals;
import blusunrize.immersiveengineering.api.IETags;
import blusunrize.immersiveengineering.api.tool.IElectricEquipment;
import blusunrize.immersiveengineering.common.util.IEDamageSources;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public class FaradaySuitItem
extends ArmorItem
implements IElectricEquipment {
    public static ArmorMaterial mat = new FaradayArmorMaterial();

    public FaradaySuitItem(ArmorItem.Type type) {
        super(mat, type, new Item.Properties().m_41487_(1));
    }

    @Override
    public void onStrike(ItemStack equipped, EquipmentSlot eqSlot, LivingEntity owner, Map<String, Object> cache, @Nullable DamageSource dSource, IElectricEquipment.ElectricSource eSource) {
        if (!(dSource instanceof IEDamageSources.ElectricDamageSource)) {
            return;
        }
        IEDamageSources.ElectricDamageSource dmg = (IEDamageSources.ElectricDamageSource)dSource;
        if ((double)dmg.source.level < 1.75) {
            if (cache.containsKey("faraday")) {
                cache.put("faraday", 1 << this.f_265916_.ordinal() | (Integer)cache.get("faraday"));
            } else {
                cache.put("faraday", 1 << this.f_265916_.ordinal());
            }
            if (cache.containsKey("faraday") && (Integer)cache.get("faraday") == 15) {
                dmg.dmg = 0.0f;
            }
        } else {
            dmg.dmg = (float)((double)dmg.dmg * 1.2);
            if (!(owner instanceof Player && ((Player)owner).m_150110_().f_35937_ || !equipped.m_220157_(2, ApiUtils.RANDOM_SOURCE, dmg.m_7639_() instanceof ServerPlayer ? (ServerPlayer)dmg.m_7639_() : null))) {
                owner.m_8061_(eqSlot, ItemStack.f_41583_);
            }
        }
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        return "immersiveengineering:textures/models/armor_faraday" + (slot == EquipmentSlot.LEGS ? "_legs" : "") + ".png";
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    private static class FaradayArmorMaterial
    implements ArmorMaterial {
        private FaradayArmorMaterial() {
        }

        public int m_266425_(ArmorItem.Type slotIn) {
            return switch (slotIn) {
                default -> throw new IncompatibleClassChangeError();
                case ArmorItem.Type.BOOTS -> 13;
                case ArmorItem.Type.LEGGINGS -> 15;
                case ArmorItem.Type.CHESTPLATE -> 16;
                case ArmorItem.Type.HELMET -> 11;
            };
        }

        public int m_7366_(ArmorItem.Type slotIn) {
            return switch (slotIn) {
                default -> throw new IncompatibleClassChangeError();
                case ArmorItem.Type.BOOTS, ArmorItem.Type.HELMET -> 1;
                case ArmorItem.Type.LEGGINGS -> 2;
                case ArmorItem.Type.CHESTPLATE -> 3;
            };
        }

        public int m_6646_() {
            return 0;
        }

        @Nonnull
        public SoundEvent m_7344_() {
            return SoundEvents.f_11672_;
        }

        @Nonnull
        public Ingredient m_6230_() {
            return Ingredient.m_204132_(IETags.getTagsFor((EnumMetals)EnumMetals.ALUMINUM).plate);
        }

        @Nonnull
        public String m_6082_() {
            return "immersiveengineering:faraday";
        }

        public float m_6651_() {
            return 0.0f;
        }

        public float m_6649_() {
            return 0.0f;
        }
    }
}

