/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.client.particles;

import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.utils.ColorUtil;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.minecraft.Util;
import net.minecraft.client.Timer;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Mth;

public class MagicSmokeParticle
extends TextureSheetParticle {
    public Timer timer = new Timer(20.0f, 0L);
    public int colorFrom;
    public int colorTo;

    public MagicSmokeParticle(ClientLevel clientLevel, double x, double y, double z, double xd, double yd, double zd, int colorFrom, int colorTo, float size) {
        super(clientLevel, x, y, z, xd, yd, zd);
        this.f_172258_ = 0.96f;
        this.f_107226_ = -0.1f;
        this.f_172259_ = true;
        this.f_107215_ = xd == 0.0 ? (this.f_107223_.m_188500_() * 2.0 - 1.0) / 10.0 : xd;
        this.f_107216_ = yd == 0.0 ? 0.1 + this.f_107223_.m_188500_() / 10.0 : yd;
        this.f_107217_ = zd == 0.0 ? (this.f_107223_.m_188500_() * 2.0 - 1.0) / 10.0 : zd;
        this.f_107215_ *= 0.5;
        this.f_107217_ *= 0.5;
        this.colorFrom = colorFrom;
        this.colorTo = colorTo;
        this.f_107663_ = size;
        this.f_107225_ = (int)(8.0 / ((double)clientLevel.f_46441_.m_188501_() * 0.8 + 0.2) * (double)0.3f);
        this.f_107225_ = Math.max(this.f_107225_, 1);
        this.f_107219_ = true;
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107430_;
    }

    public float m_5902_(float p_105642_) {
        return this.f_107663_ * Mth.m_14036_((float)(((float)this.f_107224_ + p_105642_) / (float)this.f_107225_ * 32.0f), (float)0.0f, (float)1.0f);
    }

    public void m_5989_() {
        super.m_5989_();
        this.timer.m_92525_(Util.m_137550_());
        int newColor = ColorUtil.ARGB.lerp(this.timer.f_92518_, this.colorFrom, this.colorTo);
        this.f_107227_ = (float)ColorUtil.ARGB.red(newColor) / 255.0f;
        this.f_107228_ = (float)ColorUtil.ARGB.green(newColor) / 255.0f;
        this.f_107229_ = (float)ColorUtil.ARGB.blue(newColor) / 255.0f;
    }

    public int m_6355_(float f) {
        return 0xF000F0;
    }

    public record Option(int colorFrom, int colorTo, int duration, float size) implements ParticleOptions
    {
        public static final Codec<Option> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("colorFrom").forGetter(Option::colorFrom), (App)Codec.INT.fieldOf("colorTo").forGetter(Option::colorTo), (App)ExtraCodecs.f_144629_.fieldOf("duration").forGetter(Option::duration), (App)Codec.FLOAT.fieldOf("size").forGetter(Option::size)).apply((Applicative)instance, Option::new));
        public static final ParticleOptions.Deserializer<Option> DESERIALIZER = new ParticleOptions.Deserializer<Option>(){

            public Option fromCommand(ParticleType<Option> p_235961_, StringReader p_235962_) throws CommandSyntaxException {
                p_235962_.expect(' ');
                int colorFrom = p_235962_.readInt();
                p_235962_.expect(' ');
                int colorTo = p_235962_.readInt();
                p_235962_.expect(' ');
                int duration = p_235962_.readInt();
                p_235962_.expect(' ');
                float size = p_235962_.readFloat();
                return new Option(colorFrom, colorTo, duration, size);
            }

            public Option fromNetwork(ParticleType<Option> p_235964_, FriendlyByteBuf p_235965_) {
                return new Option(p_235965_.readInt(), p_235965_.readInt(), p_235965_.readInt(), p_235965_.readFloat());
            }
        };

        public ParticleType<Option> m_6012_() {
            return (ParticleType)ModParticleTypes.MAGIC_SMOKE.get();
        }

        public void m_7711_(FriendlyByteBuf p_123732_) {
            p_123732_.writeInt(this.colorFrom());
            p_123732_.writeInt(this.colorTo());
            p_123732_.writeInt(this.duration());
            p_123732_.writeFloat(this.size());
        }

        public String m_5942_() {
            return String.format(Locale.ROOT, "%s %s %s %s %.2f", BuiltInRegistries.f_257034_.m_7981_(this.m_6012_()), this.colorFrom, this.colorTo, this.duration, Float.valueOf(this.size));
        }
    }

    public static class Provider
    implements ParticleProvider<Option> {
        private final SpriteSet sprite;

        public Provider(SpriteSet spriteSet) {
            this.sprite = spriteSet;
        }

        public Particle createParticle(Option option, ClientLevel clientLevel, double d, double e, double f, double g, double h, double i) {
            MagicSmokeParticle trailParticle = new MagicSmokeParticle(clientLevel, d, e, f, g, h, i, option.colorFrom(), option.colorTo(), option.size());
            trailParticle.m_108335_(this.sprite);
            trailParticle.m_107257_(option.duration());
            return trailParticle;
        }
    }
}

