/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.client.particles;

import com.Polarice3.Goety.client.particles.SparkleParticleOption;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class SparkleParticle
extends TextureSheetParticle {
    public final int particle = 16;
    private final boolean slowdown = true;
    private final SpriteSet sprite;
    public static final ParticleRenderType NORMAL_RENDER = new ParticleRenderType(){

        public void m_6505_(BufferBuilder bufferBuilder, TextureManager textureManager) {
            SparkleParticle.beginRenderCommon(bufferBuilder, textureManager);
        }

        public void m_6294_(Tesselator tessellator) {
            tessellator.m_85914_();
            SparkleParticle.endRenderCommon();
        }

        public String toString() {
            return "goety:sparkle";
        }
    };

    public SparkleParticle(ClientLevel world, double x, double y, double z, float size, float red, float green, float blue, int extraLife, SpriteSet sprite) {
        super(world, x, y, z, 0.0, 0.0, 0.0);
        this.f_107227_ = red;
        this.f_107228_ = green;
        this.f_107229_ = blue;
        this.f_107230_ = 0.75f;
        this.f_107226_ = 0.0f;
        this.f_107217_ = 0.0;
        this.f_107216_ = 0.0;
        this.f_107215_ = 0.0;
        this.f_107663_ = (this.f_107223_.m_188501_() * 0.5f + 0.5f) * 0.2f * size;
        this.f_107225_ = 3 * extraLife;
        this.m_107250_(0.01f, 0.01f);
        this.f_107209_ = x;
        this.f_107210_ = y;
        this.f_107211_ = z;
        this.sprite = sprite;
        this.m_108339_(sprite);
    }

    public float m_5902_(float partialTicks) {
        return this.f_107663_ * ((float)(this.f_107225_ - this.f_107224_) + 1.0f) / (float)this.f_107225_;
    }

    public void m_5989_() {
        this.m_108339_(this.sprite);
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        if (this.f_107224_++ >= this.f_107225_) {
            this.m_107274_();
        }
        this.f_107216_ -= 0.04 * (double)this.f_107226_;
        this.m_6257_(this.f_107215_, this.f_107216_, this.f_107217_);
        Objects.requireNonNull(this);
        this.f_107215_ *= 0.9080000019073486;
        this.f_107216_ *= 0.9080000019073486;
        this.f_107217_ *= 0.9080000019073486;
        if (this.f_107218_) {
            this.f_107215_ *= (double)0.7f;
            this.f_107217_ *= (double)0.7f;
        }
    }

    @NotNull
    public ParticleRenderType m_7556_() {
        return NORMAL_RENDER;
    }

    private static void beginRenderCommon(BufferBuilder buffer, TextureManager textureManager) {
        Minecraft.m_91087_().f_91063_.m_109154_().m_109896_();
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)1);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureAtlas.f_118260_);
        AbstractTexture tex = textureManager.m_118506_(TextureAtlas.f_118260_);
        tex.setBlurMipmap(true, false);
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85813_);
    }

    private static void endRenderCommon() {
        AbstractTexture tex = Minecraft.m_91087_().m_91097_().m_118506_(TextureAtlas.f_118260_);
        tex.restoreLastBlurMipmap();
        RenderSystem.disableBlend();
        RenderSystem.depthMask((boolean)true);
    }

    public static class Provider
    implements ParticleProvider<SparkleParticleOption> {
        private final SpriteSet sprite;

        public Provider(SpriteSet sprite) {
            this.sprite = sprite;
        }

        public Particle createParticle(SparkleParticleOption data, ClientLevel world, double x, double y, double z, double mx, double my, double mz) {
            return new SparkleParticle(world, x, y, z, data.size, data.r, data.g, data.b, data.extraLife, this.sprite);
        }
    }
}

