/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.client.particles;

import com.Polarice3.Goety.Goety;
import com.Polarice3.Goety.client.render.ModRenderType;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Optional;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.particles.ParticleGroup;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class WaterStreamParticle
extends Particle {
    public static final ParticleGroup PARTICLE_GROUP = new ParticleGroup(100);
    private static final RenderType RENDER_TYPE = ModRenderType.getWaterStream(Goety.location("textures/particle/water_stream.png"));
    public int vecCount;
    public int fadeSpeed = 10;
    public int fillSpeed = 10;
    public Vec3 origin;
    public Vec3 target;
    public double totalDistance;
    public double angle;
    protected Vec3[] bakedVecs;
    public float alphaProgression;
    private float prevAlphaProgression;
    private float prevAlpha;

    public WaterStreamParticle(ClientLevel world, double x, double y, double z, double xd, double yd, double zd) {
        super(world, x, y, z, 0.0, 0.0, 0.0);
        this.origin = new Vec3(x, y, z);
        this.target = new Vec3(xd, yd, zd);
        this.totalDistance = this.origin.m_82554_(this.target);
        this.vecCount = 64;
        this.bakedVecs = new Vec3[this.vecCount];
        this.rebakeVecs(this.totalDistance);
        this.f_107225_ = (int)((double)this.fillSpeed + this.totalDistance * 4.0);
        this.f_107226_ = 0.0f;
        this.m_107250_(1.0f, 1.0f);
    }

    protected void rebakeVecs(double totalDistance) {
        Vec3 rotateZero = new Vec3(totalDistance, 0.0, 0.0);
        for (int i = 0; i < this.vecCount; ++i) {
            float lifeAt = (float)i / (float)this.vecCount;
            float ageJump = (float)Math.sin((double)lifeAt * Math.PI);
            this.bakedVecs[i] = rotateZero.m_82490_((double)lifeAt).m_82520_(0.0, (double)ageJump * Math.max(totalDistance, 1.0), 0.0);
        }
        Vec3 vecForAngle = this.target.m_82546_(this.origin);
        this.angle = Math.atan2(vecForAngle.f_82479_, vecForAngle.f_82481_);
    }

    public boolean shouldCull() {
        return false;
    }

    public void m_5744_(VertexConsumer consumer, Camera camera, float partialTick) {
        MultiBufferSource.BufferSource multibuffersource$buffersource = Minecraft.m_91087_().m_91269_().m_110104_();
        VertexConsumer vertexconsumer = multibuffersource$buffersource.m_6299_(RENDER_TYPE);
        Vec3 cameraPos = camera.m_90583_();
        PoseStack posestack = new PoseStack();
        posestack.m_85836_();
        posestack.m_85837_(this.origin.f_82479_ - cameraPos.f_82479_, this.origin.f_82480_ - cameraPos.f_82480_, this.origin.f_82481_ - cameraPos.f_82481_);
        float f = (float)this.angle;
        posestack.m_252781_(Axis.f_252436_.m_252961_(f - 1.5707964f));
        int j = this.m_6355_(partialTick);
        float width = this.getWidth();
        float alphaLerped = this.prevAlpha + (this.f_107230_ - this.prevAlpha) * partialTick;
        float alphaProgressionLerped = this.prevAlphaProgression + (this.alphaProgression - this.prevAlphaProgression) * partialTick;
        for (int vertIndex = 0; vertIndex < this.bakedVecs.length - 1; ++vertIndex) {
            posestack.m_85836_();
            float u1 = (float)vertIndex / (float)this.bakedVecs.length;
            float u2 = u1 + 1.0f / (float)this.bakedVecs.length;
            Vec3 draw1 = this.bakedVecs[vertIndex];
            Vec3 draw2 = this.bakedVecs[vertIndex + 1];
            PoseStack.Pose posestack$pose = posestack.m_85850_();
            Matrix4f matrix4f = posestack$pose.m_252922_();
            Matrix3f matrix3f = posestack$pose.m_252943_();
            float alpha0 = this.calcAlphaForVertex(vertIndex, alphaProgressionLerped) * alphaLerped;
            float alpha1 = this.calcAlphaForVertex(vertIndex + 1, alphaProgressionLerped) * alphaLerped;
            vertexconsumer.m_252986_(matrix4f, (float)draw1.f_82479_, (float)draw1.f_82480_, (float)draw1.f_82481_ + width).m_85950_(1.0f, 1.0f, 1.0f, alpha0).m_7421_(u1, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(j).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
            vertexconsumer.m_252986_(matrix4f, (float)draw2.f_82479_, (float)draw2.f_82480_, (float)draw1.f_82481_ + width).m_85950_(1.0f, 1.0f, 1.0f, alpha1).m_7421_(u2, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(j).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
            vertexconsumer.m_252986_(matrix4f, (float)draw2.f_82479_, (float)draw2.f_82480_, (float)draw2.f_82481_ - width).m_85950_(1.0f, 1.0f, 1.0f, alpha1).m_7421_(u2, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(j).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
            vertexconsumer.m_252986_(matrix4f, (float)draw1.f_82479_, (float)draw1.f_82480_, (float)draw2.f_82481_ - width).m_85950_(1.0f, 1.0f, 1.0f, alpha0).m_7421_(u1, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(j).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
            posestack.m_85849_();
        }
        multibuffersource$buffersource.m_109911_();
        posestack.m_85849_();
    }

    protected float getWidth() {
        return 0.5f;
    }

    private float calcAlphaForVertex(int vertIndex, float alphaIn) {
        return Mth.m_14036_((float)(alphaIn - (float)vertIndex), (float)0.0f, (float)1.0f);
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107433_;
    }

    public void m_5989_() {
        super.m_5989_();
        this.prevAlpha = this.f_107230_;
        this.prevAlphaProgression = this.alphaProgression;
        int left = this.f_107225_ - this.f_107224_;
        if (left <= this.fadeSpeed) {
            this.f_107230_ = (float)left / (float)this.fadeSpeed;
        } else {
            float ageClamp = Mth.m_14036_((float)((float)this.f_107224_ / ((float)this.f_107225_ - (float)this.fillSpeed)), (float)0.0f, (float)1.0f);
            this.alphaProgression = ageClamp * (float)this.vecCount;
        }
    }

    public Optional<ParticleGroup> m_142654_() {
        return Optional.of(PARTICLE_GROUP);
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new WaterStreamParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed);
        }
    }
}

