/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.client.particles;

import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.client.particles.WindParticle;
import com.Polarice3.Goety.utils.ColorUtil;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;

public class WindShockwaveParticle
extends WindParticle {
    public float increase;

    public WindShockwaveParticle(ClientLevel world, double x, double y, double z, float red, float green, float blue, float width, float height, float increase, float startRot, int life, int ownerId) {
        super(world, x, y, z, red, green, blue, width, height, life, ownerId);
        this.increase = increase;
        this.initYRot = startRot * 360.0f;
        this.rotateAge = 10.0f + startRot * 10.0f;
    }

    @Override
    public Vec3 getOrbitPosition() {
        Vec3 position = this.getPosition();
        Vec3 vec3 = new Vec3(0.0, (double)this.height, (double)(this.width + (float)this.f_107224_ * this.increase)).m_82524_((float)Math.toRadians(this.initYRot + this.rotateAge * (float)this.f_107224_));
        return position.m_82549_(vec3);
    }

    @Override
    public float getTrailHeight() {
        return 1.0f;
    }

    public static class Option
    implements ParticleOptions {
        public static final Codec<Option> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("red").forGetter(d -> Float.valueOf(d.red)), (App)Codec.FLOAT.fieldOf("green").forGetter(d -> Float.valueOf(d.green)), (App)Codec.FLOAT.fieldOf("blue").forGetter(d -> Float.valueOf(d.blue)), (App)Codec.FLOAT.fieldOf("width").forGetter(d -> Float.valueOf(d.width)), (App)Codec.FLOAT.fieldOf("height").forGetter(d -> Float.valueOf(d.height)), (App)Codec.FLOAT.fieldOf("increase").forGetter(d -> Float.valueOf(d.increase)), (App)Codec.FLOAT.fieldOf("startYRot").forGetter(d -> Float.valueOf(d.startYRot)), (App)Codec.INT.fieldOf("life").forGetter(d -> d.life), (App)Codec.INT.fieldOf("ownerId").forGetter(d -> d.ownerId)).apply((Applicative)instance, Option::new));
        public static final ParticleOptions.Deserializer<Option> DESERIALIZER = new ParticleOptions.Deserializer<Option>(){

            public Option fromCommand(ParticleType<Option> particleTypeIn, StringReader reader) throws CommandSyntaxException {
                reader.expect(' ');
                float red = reader.readFloat();
                reader.expect(' ');
                float green = reader.readFloat();
                reader.expect(' ');
                float blue = reader.readFloat();
                reader.expect(' ');
                float width = reader.readFloat();
                reader.expect(' ');
                float height = reader.readFloat();
                reader.expect(' ');
                float increase = reader.readFloat();
                reader.expect(' ');
                float startYRot = reader.readFloat();
                reader.expect(' ');
                int life = reader.readInt();
                reader.expect(' ');
                int ownerId = reader.readInt();
                return new Option(red, green, blue, width, height, increase, startYRot, life, ownerId);
            }

            public Option fromNetwork(ParticleType<Option> particleTypeIn, FriendlyByteBuf buffer) {
                return new Option(buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readInt(), buffer.readInt());
            }
        };
        private final float red;
        private final float green;
        private final float blue;
        private final float width;
        private final float height;
        private final float increase;
        private final float startYRot;
        private final int life;
        private final int ownerId;

        public Option(ColorUtil color, float width, float height, float increase, float startYRot, int ownerId) {
            this.red = color.red();
            this.green = color.green();
            this.blue = color.blue();
            this.width = width;
            this.height = height;
            this.increase = increase;
            this.startYRot = startYRot;
            this.life = 0;
            this.ownerId = ownerId;
        }

        public Option(ColorUtil color, float width, float height, float increase, float startYRot, int life, int ownerId) {
            this.red = color.red();
            this.green = color.green();
            this.blue = color.blue();
            this.width = width;
            this.height = height;
            this.increase = increase;
            this.startYRot = startYRot;
            this.life = life;
            this.ownerId = ownerId;
        }

        public Option(float red, float green, float blue, float width, float height, float increase, float startYRot, int ownerId) {
            this.red = red;
            this.green = green;
            this.blue = blue;
            this.width = width;
            this.height = height;
            this.increase = increase;
            this.startYRot = startYRot;
            this.life = 0;
            this.ownerId = ownerId;
        }

        public Option(float red, float green, float blue, float width, float height, float increase, float startYRot, int life, int ownerId) {
            this.red = red;
            this.green = green;
            this.blue = blue;
            this.width = width;
            this.height = height;
            this.increase = increase;
            this.startYRot = startYRot;
            this.life = life;
            this.ownerId = ownerId;
        }

        public void m_7711_(FriendlyByteBuf buffer) {
            buffer.writeFloat(this.red);
            buffer.writeFloat(this.green);
            buffer.writeFloat(this.blue);
            buffer.writeFloat(this.width);
            buffer.writeFloat(this.height);
            buffer.writeFloat(this.increase);
            buffer.writeFloat(this.startYRot);
            buffer.writeInt(this.life);
            buffer.writeInt(this.ownerId);
        }

        public String m_5942_() {
            return String.format(Locale.ROOT, "%s %.2f %.2f %.2f %.2f %.2f %.2f %.2f %d %d", BuiltInRegistries.f_257034_.m_7981_(this.m_6012_()), Float.valueOf(this.red), Float.valueOf(this.green), Float.valueOf(this.blue), Float.valueOf(this.width), Float.valueOf(this.height), Float.valueOf(this.increase), Float.valueOf(this.startYRot), this.life, this.ownerId);
        }

        public ParticleType<Option> m_6012_() {
            return (ParticleType)ModParticleTypes.WIND_SHOCKWAVE.get();
        }

        public float getRed() {
            return this.red;
        }

        public float getGreen() {
            return this.green;
        }

        public float getBlue() {
            return this.blue;
        }

        public float getWidth() {
            return this.width;
        }

        public float getHeight() {
            return this.height;
        }

        public float getIncrease() {
            return this.increase;
        }

        public float getStartYRot() {
            return this.startYRot;
        }

        public int getLife() {
            return this.life;
        }

        public int getOwnerId() {
            return this.ownerId;
        }
    }

    public static class Provider
    implements ParticleProvider<Option> {
        public Provider(SpriteSet p_172490_) {
        }

        public Particle createParticle(Option typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new WindShockwaveParticle(worldIn, x, y, z, typeIn.getRed(), typeIn.getGreen(), typeIn.getBlue(), typeIn.getWidth(), typeIn.getHeight(), typeIn.getIncrease(), typeIn.getStartYRot(), typeIn.getLife(), typeIn.getOwnerId());
        }
    }
}

