/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.client.render;

import com.Polarice3.Goety.client.render.CuriosRenderer;
import com.Polarice3.Goety.client.render.ModModelLayer;
import com.Polarice3.Goety.client.render.model.DarkRobeModel;
import com.Polarice3.Goety.client.render.model.GloveModel;
import com.Polarice3.Goety.common.items.ModItems;
import com.Polarice3.Goety.config.ItemConfig;
import com.Polarice3.Goety.utils.CuriosFinder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.client.CuriosRendererRegistry;
import top.theillusivec4.curios.api.client.ICurioRenderer;

public record WearRenderer(ResourceLocation texture, HumanoidModel<LivingEntity> model) implements ICurioRenderer
{
    private ResourceLocation getTexture(LivingEntity livingEntity) {
        if (Objects.equals(this.texture, CuriosRenderer.render("necro_cape.png")) && ((Boolean)ItemConfig.NecroCapeChangeTexture.get()).booleanValue()) {
            if (CuriosFinder.hasFrostRobes(livingEntity)) {
                return CuriosRenderer.render("necro_cape_crypt.png");
            }
            if (CuriosFinder.hasAbyssRobes(livingEntity)) {
                return CuriosRenderer.render("necro_cape_abyss.png");
            }
            if (CuriosFinder.hasNetherRobe(livingEntity)) {
                return CuriosRenderer.render("necro_cape_nether.png");
            }
        }
        return this.texture;
    }

    private HumanoidModel<LivingEntity> getModel() {
        return this.model;
    }

    @Nullable
    public static WearRenderer getRenderer(ItemStack stack) {
        if (!stack.m_41619_()) {
            return CuriosRendererRegistry.getRenderer((Item)stack.m_41720_()).orElse(null);
        }
        return null;
    }

    public boolean hasCape(AbstractClientPlayer p_116618_) {
        return p_116618_.m_108555_() && !p_116618_.m_20145_() && p_116618_.m_36170_(PlayerModelPart.CAPE) && p_116618_.m_108561_() != null;
    }

    public static boolean capedRobe(ItemStack stack) {
        return stack.m_41720_() == ModItems.GRAND_ROBE.get() || stack.m_41720_() == ModItems.FROST_ROBE.get() || stack.m_41720_() == ModItems.FROST_ROBE_CRYO.get() || stack.m_41720_() == ModItems.WIND_ROBE.get() || stack.m_41720_() == ModItems.STORM_ROBE.get();
    }

    public <T extends LivingEntity, M extends EntityModel<T>> void render(ItemStack stack, SlotContext slotContext, PoseStack matrixStack, RenderLayerParent<T, M> renderLayerParent, MultiBufferSource renderTypeBuffer, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        LivingEntity livingEntity = slotContext.entity();
        HumanoidModel<LivingEntity> model = this.getModel();
        model.m_6973_(slotContext.entity(), limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        model.m_6839_(slotContext.entity(), limbSwing, limbSwingAmount, partialTicks);
        ICurioRenderer.followBodyRotations((LivingEntity)slotContext.entity(), (HumanoidModel[])new HumanoidModel[]{model});
        this.render(livingEntity, matrixStack, renderTypeBuffer, light);
        if (WearRenderer.capedRobe(stack) && livingEntity instanceof AbstractClientPlayer) {
            ItemStack itemstack;
            AbstractClientPlayer p_116618_ = (AbstractClientPlayer)livingEntity;
            if (((Boolean)ItemConfig.RobeCape.get()).booleanValue() && WearRenderer.capedRobe(stack) && !CuriosFinder.hasUndeadCape((LivingEntity)p_116618_) && !this.hasCape(p_116618_) && !p_116618_.m_20145_() && !((itemstack = p_116618_.m_6844_(EquipmentSlot.CHEST)).m_41720_() instanceof ElytraItem)) {
                matrixStack.m_85836_();
                matrixStack.m_85837_(0.0, 0.0, 0.125);
                double d0 = Mth.m_14139_((double)partialTicks, (double)p_116618_.f_36102_, (double)p_116618_.f_36105_) - Mth.m_14139_((double)partialTicks, (double)p_116618_.f_19854_, (double)p_116618_.m_20185_());
                double d1 = Mth.m_14139_((double)partialTicks, (double)p_116618_.f_36103_, (double)p_116618_.f_36106_) - Mth.m_14139_((double)partialTicks, (double)p_116618_.f_19855_, (double)p_116618_.m_20186_());
                double d2 = Mth.m_14139_((double)partialTicks, (double)p_116618_.f_36104_, (double)p_116618_.f_36075_) - Mth.m_14139_((double)partialTicks, (double)p_116618_.f_19856_, (double)p_116618_.m_20189_());
                float f = p_116618_.f_20884_ + (p_116618_.f_20883_ - p_116618_.f_20884_);
                double d3 = Mth.m_14031_((float)(f * ((float)Math.PI / 180)));
                double d4 = -Mth.m_14089_((float)(f * ((float)Math.PI / 180)));
                float f1 = (float)d1 * 10.0f;
                f1 = Mth.m_14036_((float)f1, (float)-6.0f, (float)32.0f);
                float f2 = (float)(d0 * d3 + d2 * d4) * 100.0f;
                f2 = Mth.m_14036_((float)f2, (float)0.0f, (float)150.0f);
                float f3 = (float)(d0 * d4 - d2 * d3) * 100.0f;
                f3 = Mth.m_14036_((float)f3, (float)-20.0f, (float)20.0f);
                if (f2 < 0.0f) {
                    f2 = 0.0f;
                }
                float f4 = Mth.m_14179_((float)partialTicks, (float)p_116618_.f_36099_, (float)p_116618_.f_36100_);
                f1 += Mth.m_14031_((float)(Mth.m_14179_((float)partialTicks, (float)p_116618_.f_19867_, (float)p_116618_.f_19787_) * 6.0f)) * 32.0f * f4;
                if (p_116618_.m_6047_()) {
                    f1 += 25.0f;
                    matrixStack.m_85837_(0.0, 0.1, 0.0);
                }
                matrixStack.m_252781_(Axis.f_252529_.m_252977_(6.0f + f2 / 2.0f + f1));
                matrixStack.m_252781_(Axis.f_252403_.m_252977_(f3 / 2.0f));
                matrixStack.m_252781_(Axis.f_252436_.m_252977_(180.0f - f3 / 2.0f));
                VertexConsumer vertexconsumer = renderTypeBuffer.m_6299_(RenderType.m_110458_((ResourceLocation)this.getTexture(livingEntity)));
                new DarkRobeModel(Minecraft.m_91087_().m_167973_().m_171103_(ModModelLayer.DARK_ROBE)).renderCape(matrixStack, vertexconsumer, light, OverlayTexture.f_118083_);
                matrixStack.m_85849_();
            }
        }
    }

    private void render(LivingEntity livingEntity, PoseStack matrixStack, MultiBufferSource buffer, int light) {
        RenderType renderType = this.getModel().m_103119_(this.getTexture(livingEntity));
        VertexConsumer vertexBuilder = buffer.m_6299_(renderType);
        this.getModel().m_7695_(matrixStack, vertexBuilder, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void renderFirstPersonArm(PoseStack matrixStack, MultiBufferSource buffer, int light, AbstractClientPlayer player, HumanoidArm side, boolean hasFoil) {
        if (!player.m_5833_()) {
            GloveModel model = (GloveModel)this.getModel();
            ModelPart arm = side == HumanoidArm.LEFT ? model.f_102812_ : model.f_102811_;
            model.m_8009_(false);
            arm.f_104207_ = true;
            model.f_102817_ = false;
            model.f_102608_ = 0.0f;
            model.f_102818_ = 0.0f;
            model.m_6973_((LivingEntity)player, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
            arm.f_104203_ = 0.0f;
            this.renderFirstPersonArm((LivingEntity)player, model, arm, matrixStack, buffer, light, hasFoil);
        }
    }

    private void renderFirstPersonArm(LivingEntity livingEntity, GloveModel model, ModelPart arm, PoseStack matrixStack, MultiBufferSource buffer, int light, boolean hasFoil) {
        RenderType renderType = model.m_103119_(this.getTexture(livingEntity));
        VertexConsumer builder = ItemRenderer.m_115211_((MultiBufferSource)buffer, (RenderType)renderType, (boolean)false, (boolean)hasFoil);
        arm.m_104301_(matrixStack, builder, light, OverlayTexture.f_118083_);
    }
}

