/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.client.render.model;

import com.Polarice3.Goety.client.render.animation.GraveGolemAnimations;
import com.Polarice3.Goety.common.entities.ally.undead.GraveGolem;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public class GraveGolemModel<T extends GraveGolem>
extends HierarchicalModel<T> {
    private final ModelPart root;
    private final ModelPart golem;
    private final ModelPart head;
    private final ModelPart headTop;
    private final ModelPart headJaw;
    private final ModelPart upper;
    private final ModelPart body;
    private final ModelPart graves;
    private final ModelPart leftGrave;
    private final ModelPart middleGrave;
    private final ModelPart rightGrave;
    private final ModelPart pelvis;
    private final ModelPart rightArm;
    private final ModelPart leftArm;
    private final ModelPart rightShoulder;
    private final ModelPart leftShoulder;
    private final ModelPart rightMiddle;
    private final ModelPart leftMiddle;
    private final ModelPart rightHand;
    private final ModelPart leftHand;
    private final ModelPart rightLeg;
    private final ModelPart leftLeg;

    public GraveGolemModel(ModelPart root) {
        this.root = root;
        this.golem = root.m_171324_("golem");
        this.upper = this.golem.m_171324_("upper");
        this.body = this.upper.m_171324_("body");
        this.graves = this.body.m_171324_("graves");
        this.leftGrave = this.graves.m_171324_("left_grave");
        this.middleGrave = this.graves.m_171324_("middle_grave");
        this.rightGrave = this.graves.m_171324_("right_grave");
        this.head = this.upper.m_171324_("head");
        this.headTop = this.head.m_171324_("top");
        this.headJaw = this.head.m_171324_("bottom");
        this.rightArm = this.upper.m_171324_("right_arm");
        this.leftArm = this.upper.m_171324_("left_arm");
        this.rightShoulder = this.rightArm.m_171324_("right_shoulder");
        this.leftShoulder = this.leftArm.m_171324_("left_shoulder");
        this.rightMiddle = this.rightShoulder.m_171324_("right_middle");
        this.leftMiddle = this.leftShoulder.m_171324_("left_middle");
        this.rightHand = this.rightMiddle.m_171324_("right_hand");
        this.leftHand = this.leftMiddle.m_171324_("left_hand");
        this.pelvis = this.golem.m_171324_("pelvis");
        this.rightLeg = this.golem.m_171324_("right_leg");
        this.leftLeg = this.golem.m_171324_("left_leg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition golem = partdefinition.m_171599_("golem", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition upper = golem.m_171599_("upper", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-25.5f, (float)0.0f));
        PartDefinition body = upper.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-22.5f, -60.0f, -12.0f, 45.0f, 33.0f, 24.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)25.5f, (float)0.0f));
        PartDefinition graves = body.m_171599_("graves", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-62.0f, (float)0.0f));
        PartDefinition left_grave = graves.m_171599_("left_grave", CubeListBuilder.m_171558_().m_171514_(139, 16).m_171488_(-4.5f, -7.0f, 6.0f, 9.0f, 9.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(165, 0).m_171488_(-4.5f, 0.0f, -7.5f, 9.0f, 2.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)15.0f, (float)0.0f, (float)0.0f));
        PartDefinition middle_grave = graves.m_171599_("middle_grave", CubeListBuilder.m_171558_().m_171514_(187, 14).m_171488_(-6.0f, -16.0f, 6.0f, 12.0f, 18.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(114, 0).m_171488_(-6.0f, 0.0f, -9.0f, 12.0f, 2.0f, 14.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition right_grave = graves.m_171599_("right_grave", CubeListBuilder.m_171558_().m_171514_(163, 14).m_171488_(-4.5f, -10.0f, 6.0f, 9.0f, 12.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(165, 0).m_171488_(-4.5f, 0.0f, -7.5f, 9.0f, 2.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-15.0f, (float)0.0f, (float)0.0f));
        PartDefinition tomb = body.m_171599_("tomb", CubeListBuilder.m_171558_().m_171514_(214, 29).m_171488_(-5.5f, -57.0f, 12.0f, 15.0f, 27.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(218, 62).m_171488_(-6.5f, -58.0f, 18.0f, 17.0f, 29.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.0f, (float)0.0f, (float)0.0f));
        PartDefinition head = upper.m_171599_("head", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-19.5f, (float)-10.5f));
        PartDefinition top = head.m_171599_("top", CubeListBuilder.m_171558_().m_171514_(0, 57).m_171488_(-8.0f, -15.0f, -13.5f, 16.0f, 16.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition bottom = head.m_171599_("bottom", CubeListBuilder.m_171558_().m_171514_(56, 57).m_171488_(-8.0f, 0.0f, -13.5f, 16.0f, 3.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition right_arm = upper.m_171599_("right_arm", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-24.0f, (float)-30.0f, (float)0.0f));
        PartDefinition right_shoulder = right_arm.m_171599_("right_shoulder", CubeListBuilder.m_171558_().m_171514_(80, 86).m_171488_(-20.5f, -6.75f, -9.0f, 22.0f, 18.0f, 18.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)2.25f, (float)0.0f));
        PartDefinition right_roof = right_shoulder.m_171599_("right_roof", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-8.5f, (float)-0.75f, (float)-7.5f));
        PartDefinition cube_r1 = right_roof.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(160, 101).m_171488_(-13.0f, 0.0f, 10.5f, 24.0f, 20.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r2 = right_roof.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(160, 101).m_171488_(-13.0f, -11.0f, -0.5f, 24.0f, 20.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition right_middle = right_shoulder.m_171599_("right_middle", CubeListBuilder.m_171558_().m_171514_(62, 73).m_171488_(1.0f, -1.5f, 1.5f, 5.0f, 18.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(62, 73).m_171488_(1.0f, -1.5f, -6.0f, 5.0f, 18.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(62, 73).m_171488_(-6.5f, -1.5f, -6.0f, 5.0f, 18.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(62, 73).m_171488_(-6.5f, -1.5f, 1.5f, 5.0f, 18.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-10.5f, (float)9.75f, (float)0.0f));
        PartDefinition right_hand = right_middle.m_171599_("right_hand", CubeListBuilder.m_171558_().m_171514_(138, 35).m_171488_(-9.0f, 0.0f, -9.0f, 18.0f, 15.0f, 18.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)13.5f, (float)0.0f));
        PartDefinition left_arm = upper.m_171599_("left_arm", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)24.0f, (float)-30.0f, (float)0.0f));
        PartDefinition left_shoulder = left_arm.m_171599_("left_shoulder", CubeListBuilder.m_171558_().m_171514_(0, 86).m_171488_(-1.5f, -6.75f, -9.0f, 22.0f, 18.0f, 18.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)2.25f, (float)0.0f));
        PartDefinition left_roof = left_shoulder.m_171599_("left_roof", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)10.5f, (float)-0.75f, (float)-7.5f));
        PartDefinition cube_r3 = left_roof.m_171599_("cube_r3", CubeListBuilder.m_171558_().m_171514_(160, 101).m_171488_(-13.0f, 0.0f, 10.5f, 24.0f, 20.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r4 = left_roof.m_171599_("cube_r4", CubeListBuilder.m_171558_().m_171514_(160, 101).m_171488_(-13.0f, -11.0f, -0.5f, 24.0f, 20.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition left_middle = left_shoulder.m_171599_("left_middle", CubeListBuilder.m_171558_().m_171514_(62, 73).m_171480_().m_171488_(1.5f, -1.5f, 1.5f, 5.0f, 18.0f, 5.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(62, 73).m_171480_().m_171488_(1.5f, -1.5f, -6.0f, 5.0f, 18.0f, 5.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(62, 73).m_171480_().m_171488_(-6.0f, -1.5f, -6.0f, 5.0f, 18.0f, 5.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(62, 73).m_171480_().m_171488_(-6.0f, -1.5f, 1.5f, 5.0f, 18.0f, 5.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)10.5f, (float)9.75f, (float)0.0f));
        PartDefinition left_hand = left_middle.m_171599_("left_hand", CubeListBuilder.m_171558_().m_171514_(142, 68).m_171488_(-9.0f, 0.0f, -9.0f, 18.0f, 15.0f, 18.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)13.5f, (float)0.0f));
        PartDefinition pelvis = golem.m_171599_("pelvis", CubeListBuilder.m_171558_().m_171514_(120, 122).m_171488_(-9.0f, -4.25f, -7.5f, 18.0f, 8.0f, 15.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-23.25f, (float)0.0f));
        PartDefinition right_leg = golem.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(0, 122).m_171488_(-13.5f, 1.5f, -7.5f, 15.0f, 21.0f, 15.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-7.5f, (float)-22.5f, (float)0.0f));
        PartDefinition left_leg = golem.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(60, 122).m_171488_(-1.5f, 1.5f, -7.5f, 15.0f, 21.0f, 15.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)7.5f, (float)-22.5f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)256, (int)256);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        if (!entity.m_21224_()) {
            this.animateHeadLookTarget(netHeadYaw, headPitch);
        }
        Vec3 velocity = entity.m_20184_();
        float groundSpeed = Mth.m_14116_((float)((float)(velocity.f_82479_ * velocity.f_82479_ + velocity.f_82481_ * velocity.f_82481_)));
        this.m_233381_(((GraveGolem)entity).activateAnimationState, GraveGolemAnimations.ACTIVATE, ageInTicks);
        this.m_233381_(((GraveGolem)entity).idleAnimationState, GraveGolemAnimations.IDLE, ageInTicks);
        if (((GraveGolem)entity).canAnimateMove()) {
            this.m_267799_(GraveGolemAnimations.WALK, limbSwing, limbSwingAmount, 6.0f, 20.0f);
        }
        this.m_233381_(((GraveGolem)entity).attackAnimationState, GraveGolemAnimations.SMASH, ageInTicks);
        this.m_233381_(((GraveGolem)entity).summonAnimationState, GraveGolemAnimations.SUMMON, ageInTicks);
        this.m_233381_(((GraveGolem)entity).sitAnimationState, GraveGolemAnimations.SIT, ageInTicks);
        this.m_233381_(((GraveGolem)entity).toSitAnimationState, GraveGolemAnimations.TO_SIT, ageInTicks);
        this.m_233381_(((GraveGolem)entity).toStandAnimationState, GraveGolemAnimations.TO_STAND, ageInTicks);
        this.m_233381_(((GraveGolem)entity).shootAnimationState, GraveGolemAnimations.SHOOT, ageInTicks);
        this.m_233381_(((GraveGolem)entity).belchAnimationState, GraveGolemAnimations.SPIT, ageInTicks);
        this.m_233381_(((GraveGolem)entity).deathAnimationState, GraveGolemAnimations.DEATH, ageInTicks);
    }

    private void animateHeadLookTarget(float netHeadYaw, float headPitch) {
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
    }

    public ModelPart m_142109_() {
        return this.root;
    }
}

