/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.client.render.model;

import com.Polarice3.Goety.client.render.animation.PikerAnimations;
import com.Polarice3.Goety.common.entities.hostile.illagers.Piker;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public class PikerModel<T extends Piker>
extends HierarchicalModel<T>
implements HeadedModel {
    private final ModelPart root;
    private final ModelPart illager;
    private final ModelPart head;
    private final ModelPart leftArm;
    private final ModelPart rightLeg;
    private final ModelPart leftLeg;

    public PikerModel(ModelPart root) {
        this.root = root;
        this.illager = root.m_171324_("illager");
        this.head = this.illager.m_171324_("head");
        this.leftArm = this.illager.m_171324_("left_arm");
        this.rightLeg = this.illager.m_171324_("right_leg");
        this.leftLeg = this.illager.m_171324_("left_leg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition illager = partdefinition.m_171599_("illager", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition head = illager.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -10.0f, -4.0f, 8.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition helmet = head.m_171599_("helmet", CubeListBuilder.m_171558_().m_171514_(0, 62).m_171488_(-6.0f, -29.0f, -4.0f, 10.0f, 6.0f, 10.0f, new CubeDeformation(0.0f)).m_171514_(40, 62).m_171488_(-2.0f, -30.0f, -4.0f, 2.0f, 1.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.0f, (float)18.0f, (float)-1.0f));
        PartDefinition bone = helmet.m_171599_("bone", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-2.0f, (float)3.0f, (float)-1.0f));
        PartDefinition head_r1 = bone.m_171599_("head_r1", CubeListBuilder.m_171558_().m_171514_(28, 43).m_171488_(0.5f, -3.5f, -4.0f, 0.0f, 8.0f, 10.0f, new CubeDeformation(-0.01f)), PartPose.m_171423_((float)4.0f, (float)-27.5f, (float)1.0f, (float)0.0f, (float)0.0f, (float)-1.0472f));
        PartDefinition bone2 = helmet.m_171599_("bone2", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)3.0f, (float)-1.0f));
        PartDefinition head_r2 = bone2.m_171599_("head_r2", CubeListBuilder.m_171558_().m_171514_(28, 43).m_171480_().m_171488_(-0.5f, -3.5f, -4.0f, 0.0f, 8.0f, 10.0f, new CubeDeformation(-0.01f)).m_171555_(false), PartPose.m_171423_((float)-4.0f, (float)-27.5f, (float)1.0f, (float)0.0f, (float)0.0f, (float)1.0472f));
        PartDefinition nose = head.m_171599_("nose", CubeListBuilder.m_171558_().m_171514_(24, 0).m_171488_(-1.0f, -1.0f, -6.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-2.0f, (float)0.0f));
        PartDefinition body = illager.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(16, 20).m_171488_(-4.0f, -7.5f, -3.0f, 8.0f, 12.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(0, 38).m_171488_(-4.0f, -7.5f, -3.0f, 8.0f, 18.0f, 6.0f, new CubeDeformation(0.5f)), PartPose.m_171419_((float)0.0f, (float)7.5f, (float)0.0f));
        PartDefinition right_arm = illager.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(44, 22).m_171488_(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-5.0f, (float)2.0f, (float)0.0f));
        PartDefinition spear = right_arm.m_171599_("spear", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-0.5f, (float)10.0f, (float)2.0f));
        PartDefinition bits = spear.m_171599_("bits", CubeListBuilder.m_171558_().m_171514_(0, 78).m_171488_(-0.5f, -18.0f, -18.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(2, 78).m_171488_(-0.5f, -17.0f, -17.0f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(4, 78).m_171488_(-0.5f, -16.0f, -17.0f, 1.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(9, 78).m_171488_(-0.5f, -15.0f, -16.0f, 1.0f, 1.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(10, 84).m_171488_(-0.5f, -14.0f, -16.0f, 1.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(20, 84).m_171488_(-0.5f, -13.0f, -15.0f, 1.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(0, 83).m_171488_(-0.5f, -12.0f, -13.0f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(0, 87).m_171488_(-0.5f, -12.0f, -15.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(5, 84).m_171488_(-0.5f, -8.0f, -9.0f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(5, 84).m_171488_(-0.5f, -9.0f, -10.0f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(5, 84).m_171488_(-0.5f, -10.0f, -11.0f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(5, 84).m_171488_(-0.5f, -11.0f, -12.0f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(21, 80).m_171488_(-0.5f, -7.0f, -8.0f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(29, 80).m_171488_(-0.5f, -6.0f, -7.0f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(29, 80).m_171488_(-0.5f, -5.0f, -6.0f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(30, 84).m_171488_(-0.5f, -4.0f, -5.0f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(5, 84).m_171488_(-0.5f, -3.0f, -4.0f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(5, 84).m_171488_(-0.5f, -2.0f, -3.0f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(5, 84).m_171488_(-0.5f, -1.0f, -2.0f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(5, 84).m_171488_(-0.5f, 0.0f, -1.0f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(30, 84).m_171488_(-0.5f, 4.0f, 3.0f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(29, 80).m_171488_(-0.5f, 3.0f, 2.0f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(29, 80).m_171488_(-0.5f, 2.0f, 1.0f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(21, 80).m_171488_(-0.5f, 1.0f, 0.0f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(5, 84).m_171488_(-0.5f, 8.0f, 7.0f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(5, 84).m_171488_(-0.5f, 7.0f, 6.0f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(5, 84).m_171488_(-0.5f, 6.0f, 5.0f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(5, 84).m_171488_(-0.5f, 5.0f, 4.0f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(5, 84).m_171488_(-0.5f, 9.0f, 8.0f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(5, 84).m_171488_(-0.5f, 10.0f, 9.0f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(5, 84).m_171488_(-0.5f, 11.0f, 10.0f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(5, 84).m_171488_(-0.5f, 12.0f, 11.0f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(37, 80).m_171488_(-0.5f, 13.0f, 12.0f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(0, 81).m_171488_(-0.5f, 14.0f, 13.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition left_arm = illager.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(44, 22).m_171480_().m_171488_(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)5.0f, (float)2.0f, (float)0.0f));
        PartDefinition right_leg = illager.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171480_().m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-2.0f, (float)12.0f, (float)0.0f));
        PartDefinition left_leg = illager.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.0f, (float)12.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)128);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        if (!entity.m_21224_()) {
            this.animateHeadLookTarget(netHeadYaw, headPitch);
            if (((Piker)entity).isMeleeAttacking()) {
                this.animateWalk(limbSwing, limbSwingAmount);
            }
        }
        Vec3 velocity = entity.m_20184_();
        float groundSpeed = Mth.m_14116_((float)((float)(velocity.f_82479_ * velocity.f_82479_ + velocity.f_82481_ * velocity.f_82481_)));
        if (((Piker)entity).aggressiveMode) {
            this.m_233381_(((Piker)entity).idleAnimationState, PikerAnimations.IDLE, ageInTicks);
        } else {
            this.m_233381_(((Piker)entity).idleAnimationState, PikerAnimations.IDLE_PASSIVE, ageInTicks);
        }
        if (this.f_102609_) {
            this.rightLeg.f_104203_ = -1.4137167f;
            this.rightLeg.f_104204_ = 0.31415927f;
            this.rightLeg.f_104205_ = 0.07853982f;
            this.leftLeg.f_104203_ = -1.4137167f;
            this.leftLeg.f_104204_ = -0.31415927f;
            this.leftLeg.f_104205_ = -0.07853982f;
        } else if (((Piker)entity).aggressiveMode) {
            this.m_233385_(((Piker)entity).walkAnimationState, PikerAnimations.WALK, ageInTicks, groundSpeed * 10.0f);
        } else {
            this.m_233381_(((Piker)entity).walkAnimationState, PikerAnimations.WALK_PASSIVE, ageInTicks);
            this.leftArm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 2.0f * limbSwingAmount * 0.5f;
            this.leftArm.f_104204_ = 0.0f;
            this.leftArm.f_104205_ = 0.0f;
            this.animateWalk(limbSwing, limbSwingAmount);
        }
        this.m_233381_(((Piker)entity).attackAnimationState, PikerAnimations.ATTACK, ageInTicks);
    }

    private void animateHeadLookTarget(float netHeadYaw, float headPitch) {
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
    }

    private void animateWalk(float limbSwing, float limbSwingAmount) {
        this.rightLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount * 0.5f;
        this.leftLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount * 0.5f;
    }

    public ModelPart m_5585_() {
        return this.head;
    }

    public ModelPart m_142109_() {
        return this.root;
    }
}

