/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.client.render.model;

import com.Polarice3.Goety.client.render.animation.PreacherAnimations;
import com.Polarice3.Goety.common.entities.hostile.illagers.Preacher;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class PreacherModel<T extends Preacher>
extends HierarchicalModel<T> {
    private final ModelPart root;
    private final ModelPart illager;
    private final ModelPart head;
    private final ModelPart rightLeg;
    private final ModelPart leftLeg;

    public PreacherModel(ModelPart root) {
        this.root = root;
        this.illager = root.m_171324_("illager");
        this.head = this.illager.m_171324_("head");
        this.rightLeg = this.illager.m_171324_("right_leg");
        this.leftLeg = this.illager.m_171324_("left_leg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition illager = partdefinition.m_171599_("illager", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition body = illager.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(16, 20).m_171488_(-4.0f, -11.5f, -3.0f, 8.0f, 12.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(0, 38).m_171488_(-4.0f, -11.5f, -3.0f, 8.0f, 18.0f, 6.0f, new CubeDeformation(0.5f)), PartPose.m_171419_((float)0.0f, (float)-12.5f, (float)0.0f));
        PartDefinition right_arm = body.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(40, 46).m_171488_(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-5.0f, (float)-9.5f, (float)0.0f));
        PartDefinition book = right_arm.m_171599_("book", CubeListBuilder.m_171558_().m_171514_(56, 0).m_171488_(-1.5f, 3.5f, -6.0f, 3.0f, 1.0f, 12.0f, new CubeDeformation(-0.25f)).m_171514_(100, 0).m_171488_(-1.0f, 4.0f, -5.0f, 2.0f, 1.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-1.0f, (float)0.0f));
        PartDefinition top = book.m_171599_("top", CubeListBuilder.m_171558_().m_171514_(86, 0).m_171488_(-1.5f, 0.0f, -6.0f, 1.0f, 8.0f, 12.0f, new CubeDeformation(-0.25f)).m_171514_(32, 0).m_171488_(-1.0f, 0.5f, -5.0f, 1.0f, 7.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)4.0f, (float)0.0f));
        PartDefinition bottom = book.m_171599_("bottom", CubeListBuilder.m_171558_().m_171514_(86, 0).m_171488_(0.5f, 0.0f, -6.0f, 1.0f, 8.0f, 12.0f, new CubeDeformation(-0.25f)).m_171514_(32, 0).m_171488_(0.0f, 0.5f, -5.0f, 1.0f, 7.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)4.0f, (float)0.0f));
        PartDefinition left_arm = body.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(40, 46).m_171480_().m_171488_(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)5.0f, (float)-9.5f, (float)0.0f));
        PartDefinition staff = left_arm.m_171599_("staff", CubeListBuilder.m_171558_().m_171514_(62, 31).m_171488_(-1.0f, 0.0f, -16.0f, 1.0f, 1.0f, 32.0f, new CubeDeformation(0.0f)).m_171514_(90, 57).m_171488_(-1.0f, 1.0f, -16.0f, 1.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(80, 58).m_171488_(-1.0f, 5.0f, -15.0f, 1.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.0f, (float)8.0f, (float)0.0f));
        PartDefinition head = illager.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -10.0f, -4.0f, 8.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-24.0f, (float)0.0f));
        PartDefinition hair = head.m_171599_("hair", CubeListBuilder.m_171558_().m_171514_(44, 19).m_171488_(-5.0f, -8.0f, -3.0f, 10.0f, 4.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition nose = head.m_171599_("nose", CubeListBuilder.m_171558_().m_171514_(24, 0).m_171488_(-1.0f, -1.0f, -6.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-2.0f, (float)0.0f));
        PartDefinition right_leg = illager.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.0f, (float)-12.0f, (float)0.0f));
        PartDefinition left_leg = illager.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171480_().m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)2.0f, (float)-12.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        if (!entity.m_21224_()) {
            this.animateHeadLookTarget(netHeadYaw, headPitch);
        }
        this.m_233381_(((Preacher)entity).idleAnimationState, PreacherAnimations.IDLE, ageInTicks);
        if (this.f_102609_) {
            this.rightLeg.f_104203_ = -1.4137167f;
            this.rightLeg.f_104204_ = 0.31415927f;
            this.rightLeg.f_104205_ = 0.07853982f;
            this.leftLeg.f_104203_ = -1.4137167f;
            this.leftLeg.f_104204_ = -0.31415927f;
            this.leftLeg.f_104205_ = -0.07853982f;
        } else {
            this.m_233381_(((Preacher)entity).walkAnimationState, PreacherAnimations.WALK, ageInTicks);
        }
        this.m_233381_(((Preacher)entity).healAnimationState, PreacherAnimations.HEAL, ageInTicks);
        this.animateWalk(limbSwing, limbSwingAmount);
    }

    private void animateHeadLookTarget(float netHeadYaw, float headPitch) {
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
    }

    private void animateWalk(float limbSwing, float limbSwingAmount) {
        this.rightLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount * 0.5f;
        this.leftLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount * 0.5f;
    }

    public ModelPart m_142109_() {
        return this.root;
    }
}

