/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.client.render.model;

import com.Polarice3.Goety.client.render.animation.StormCasterAnimations;
import com.Polarice3.Goety.client.render.layer.HierarchicalArmor;
import com.Polarice3.Goety.common.entities.ally.illager.StormCasterServant;
import com.Polarice3.Goety.common.entities.hostile.illagers.StormCaster;
import com.Polarice3.Goety.utils.MathHelper;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;

public class StormCasterModel<T extends LivingEntity>
extends HierarchicalModel<T>
implements HeadedModel,
HierarchicalArmor {
    private final ModelPart root;
    private final ModelPart illager;
    private final ModelPart upperBody;
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart nose;
    private final ModelPart hair;
    private final ModelPart bone;
    private final ModelPart bone2;
    private final ModelPart bone3;
    private final ModelPart right_eye;
    private final ModelPart right_pupil;
    private final ModelPart left_eye;
    private final ModelPart left_pupil;
    private final ModelPart eyebrows;
    private final ModelPart right_eyebrow;
    private final ModelPart left_eyebrow;
    private final ModelPart cape;
    private final ModelPart rightArm;
    private final ModelPart Staff;
    private final ModelPart handle;
    private final ModelPart group;
    private final ModelPart bits;
    private final ModelPart head2;
    private final ModelPart leftArm;
    private final ModelPart rightLeg;
    private final ModelPart leftLeg;

    public StormCasterModel(ModelPart root) {
        this.root = root;
        this.illager = root.m_171324_("illager");
        this.upperBody = this.illager.m_171324_("upper_body");
        this.body = this.upperBody.m_171324_("body");
        this.head = this.upperBody.m_171324_("head");
        this.nose = this.head.m_171324_("nose");
        this.hair = this.head.m_171324_("hair");
        this.bone = this.hair.m_171324_("bone");
        this.bone2 = this.hair.m_171324_("bone2");
        this.bone3 = this.hair.m_171324_("bone3");
        this.right_eye = this.head.m_171324_("right_eye");
        this.right_pupil = this.right_eye.m_171324_("right_pupil");
        this.left_eye = this.head.m_171324_("left_eye");
        this.left_pupil = this.left_eye.m_171324_("left_pupil");
        this.eyebrows = this.head.m_171324_("eyebrows");
        this.right_eyebrow = this.eyebrows.m_171324_("right_eyebrow");
        this.left_eyebrow = this.eyebrows.m_171324_("left_eyebrow");
        this.cape = this.upperBody.m_171324_("cape");
        this.rightArm = this.upperBody.m_171324_("right_arm");
        this.Staff = this.rightArm.m_171324_("Staff");
        this.handle = this.Staff.m_171324_("handle");
        this.group = this.Staff.m_171324_("group");
        this.bits = this.group.m_171324_("bits");
        this.head2 = this.Staff.m_171324_("head2");
        this.leftArm = this.upperBody.m_171324_("left_arm");
        this.rightLeg = this.illager.m_171324_("right_leg");
        this.leftLeg = this.illager.m_171324_("left_leg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition illager = partdefinition.m_171599_("illager", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)0.0f, (float)-1.0f, (float)0.0f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition upper_body = illager.m_171599_("upper_body", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)8.0f, (float)0.0f));
        PartDefinition body = upper_body.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 38).m_171488_(-4.0f, -24.0f, -3.0f, 8.0f, 18.0f, 6.0f, new CubeDeformation(0.5f)).m_171514_(16, 20).m_171488_(-4.0f, -24.0f, -3.0f, 8.0f, 12.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)16.0f, (float)0.0f));
        PartDefinition head = upper_body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -10.0f, -4.0f, 8.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-8.0f, (float)0.0f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition nose = head.m_171599_("nose", CubeListBuilder.m_171558_().m_171514_(24, 0).m_171488_(-1.0f, -1.0f, -1.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-2.0f, (float)-5.0f));
        PartDefinition hair = head.m_171599_("hair", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition bone = hair.m_171599_("bone", CubeListBuilder.m_171558_().m_171514_(46, -8).m_171488_(1.0f, -3.0f, -4.0f, 0.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-8.0f, (float)-7.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.7854f));
        PartDefinition bone2 = hair.m_171599_("bone2", CubeListBuilder.m_171558_().m_171514_(46, -8).m_171480_().m_171488_(-1.0f, -3.0f, -4.0f, 0.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)8.0f, (float)-7.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.7854f));
        PartDefinition bone3 = hair.m_171599_("bone3", CubeListBuilder.m_171558_().m_171514_(46, -8).m_171480_().m_171488_(-1.0f, -3.0f, -4.0f, 0.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)-7.0f, (float)8.0f, (float)-1.5708f, (float)-0.7854f, (float)1.5708f));
        PartDefinition right_eye = head.m_171599_("right_eye", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-2.0f, -1.0f, -0.01f, 2.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.0f, (float)-3.0f, (float)-4.0f));
        PartDefinition right_pupil = right_eye.m_171599_("right_pupil", CubeListBuilder.m_171558_().m_171514_(4, 0).m_171488_(-1.0f, -1.0f, -0.02f, 1.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition left_eye = head.m_171599_("left_eye", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(0.0f, -1.0f, -0.01f, 2.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.0f, (float)-3.0f, (float)-4.0f));
        PartDefinition left_pupil = left_eye.m_171599_("left_pupil", CubeListBuilder.m_171558_().m_171514_(4, 0).m_171488_(0.0f, -1.0f, -0.02f, 1.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition eyebrows = head.m_171599_("eyebrows", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-5.0f, (float)-4.0f));
        PartDefinition right_eyebrow = eyebrows.m_171599_("right_eyebrow", CubeListBuilder.m_171558_().m_171514_(0, 1).m_171480_().m_171488_(-1.5f, -1.0f, -0.3f, 3.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-2.35f, (float)0.1f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.1745f));
        PartDefinition left_eyebrow = eyebrows.m_171599_("left_eyebrow", CubeListBuilder.m_171558_().m_171514_(0, 1).m_171488_(-1.5f, -1.0f, -0.3f, 3.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)2.35f, (float)0.1f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.1745f));
        PartDefinition cape = upper_body.m_171599_("cape", CubeListBuilder.m_171558_().m_171514_(44, 8).m_171488_(-4.5f, -0.5f, 0.0f, 9.0f, 21.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-7.0f, (float)3.5f, (float)0.7418f, (float)0.0f, (float)-0.1309f));
        PartDefinition right_arm = upper_body.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(40, 46).m_171480_().m_171488_(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-5.0f, (float)-7.0f, (float)-1.0f, (float)-1.5272f, (float)0.0f, (float)0.0f));
        PartDefinition Staff = right_arm.m_171599_("Staff", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)-1.0f, (float)9.0f, (float)10.0f, (float)1.5708f, (float)0.0f, (float)-1.5708f));
        PartDefinition handle = Staff.m_171599_("handle", CubeListBuilder.m_171558_().m_171514_(28, 41).m_171488_(0.0f, -14.0f, 0.0f, 1.0f, 22.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition group = Staff.m_171599_("group", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition bits = group.m_171599_("bits", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r1 = bits.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(44, 38).m_171488_(1.0f, -3.0f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(44, 38).m_171488_(2.0f, -2.0f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(44, 38).m_171488_(-3.0f, 1.0f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(44, 38).m_171488_(-2.0f, 2.0f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(48, 38).m_171488_(-2.0f, 4.0f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(48, 38).m_171488_(4.0f, -2.0f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(44, 40).m_171488_(3.0f, -1.0f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(44, 38).m_171488_(3.0f, 0.0f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(48, 38).m_171488_(3.0f, 1.0f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(48, 38).m_171488_(1.0f, 1.0f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(44, 40).m_171488_(-1.0f, 3.0f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(44, 38).m_171488_(0.0f, 3.0f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(48, 38).m_171488_(1.0f, 3.0f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(48, 40).m_171488_(2.0f, 3.0f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(48, 38).m_171488_(2.0f, 2.0f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(28, 39).m_171488_(3.0f, 2.0f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(48, 38).m_171488_(3.0f, 3.0f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(28, 39).m_171488_(4.0f, 4.0f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.01f)).m_171514_(28, 39).m_171488_(4.0f, 3.0f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(48, 40).m_171488_(3.0f, 4.0f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.5f, (float)-20.0f, (float)0.5f, (float)0.0f, (float)0.0f, (float)0.7854f));
        PartDefinition head2 = Staff.m_171599_("head2", CubeListBuilder.m_171558_().m_171514_(32, 38).m_171488_(-1.0f, -21.5f, -1.0f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition left_arm = upper_body.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(40, 46).m_171488_(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)5.0f, (float)-6.0f, (float)0.0f, (float)0.1309f, (float)0.0f, (float)-0.1745f));
        PartDefinition right_leg = illager.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-2.0f, (float)12.0f, (float)0.0f, (float)0.1466f, (float)0.0f, (float)0.0f));
        PartDefinition left_leg = illager.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171480_().m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)2.0f, (float)12.0f, (float)0.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180) - MathHelper.modelDegrees(5.0f);
        if (entity instanceof StormCaster) {
            StormCaster caster = (StormCaster)entity;
            this.m_233381_(caster.idleAnimationState, StormCasterAnimations.IDLE, ageInTicks);
            this.m_233381_(caster.shockAnimationState, StormCasterAnimations.SHOCK, ageInTicks);
            this.m_233381_(caster.dischargeAnimationState, StormCasterAnimations.DISCHARGE, ageInTicks);
            this.m_233381_(caster.cloudAnimationState, StormCasterAnimations.SUMMON_CLOUD, ageInTicks);
            if (!caster.isAttacking()) {
                this.m_267799_(StormCasterAnimations.MOVE, limbSwing, limbSwingAmount, 2.5f, 20.0f);
            }
        } else if (entity instanceof StormCasterServant) {
            StormCasterServant servant = (StormCasterServant)entity;
            this.m_233381_(servant.idleAnimationState, StormCasterAnimations.IDLE, ageInTicks);
            this.m_233381_(servant.shockAnimationState, StormCasterAnimations.SHOCK, ageInTicks);
            this.m_233381_(servant.dischargeAnimationState, StormCasterAnimations.DISCHARGE, ageInTicks);
            this.m_233381_(servant.cloudAnimationState, StormCasterAnimations.SUMMON_CLOUD, ageInTicks);
            if (!servant.isAttacking()) {
                this.m_267799_(StormCasterAnimations.MOVE, limbSwing, limbSwingAmount, 2.5f, 20.0f);
            }
        }
        this.hair.f_104207_ = entity.m_6844_(EquipmentSlot.HEAD).m_41619_();
    }

    public ModelPart m_142109_() {
        return this.root;
    }

    public ModelPart m_5585_() {
        return this.head;
    }

    protected Iterable<ModelPart> headParts() {
        return ImmutableList.of((Object)this.head);
    }

    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.body, (Object)this.rightArm, (Object)this.leftArm, (Object)this.rightLeg, (Object)this.leftLeg);
    }

    @Override
    public void translateToHead(ModelPart modelPart, PoseStack poseStack) {
        this.illager.m_104299_(poseStack);
        this.upperBody.m_104299_(poseStack);
        modelPart.m_104299_(poseStack);
        poseStack.m_252880_(0.0f, -0.1f, 0.0f);
    }

    @Override
    public void translateToChest(ModelPart modelPart, PoseStack poseStack) {
        this.illager.m_104299_(poseStack);
        this.upperBody.m_104299_(poseStack);
        modelPart.m_104299_(poseStack);
        poseStack.m_252880_(0.0f, -1.5f, 0.0f);
        poseStack.m_85841_(1.05f, 1.05f, 1.05f);
    }

    @Override
    public void translateToLeg(ModelPart modelPart, PoseStack poseStack) {
        this.illager.m_104299_(poseStack);
        modelPart.m_104299_(poseStack);
    }

    @Override
    public void translateToArms(ModelPart modelPart, PoseStack poseStack) {
        this.illager.m_104299_(poseStack);
        this.upperBody.m_104299_(poseStack);
        modelPart.m_104299_(poseStack);
        poseStack.m_85841_(1.05f, 1.05f, 1.05f);
    }

    @Override
    public Iterable<ModelPart> rightHandArmors() {
        return ImmutableList.of((Object)this.rightArm);
    }

    @Override
    public Iterable<ModelPart> leftHandArmors() {
        return ImmutableList.of((Object)this.leftArm);
    }

    @Override
    public Iterable<ModelPart> rightLegPartArmors() {
        return ImmutableList.of((Object)this.rightLeg);
    }

    @Override
    public Iterable<ModelPart> leftLegPartArmors() {
        return ImmutableList.of((Object)this.leftLeg);
    }

    @Override
    public Iterable<ModelPart> bodyPartArmors() {
        return ImmutableList.of((Object)this.body);
    }

    @Override
    public Iterable<ModelPart> headPartArmors() {
        return ImmutableList.of((Object)this.head);
    }
}

